/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TableRelationPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void initialize() {
        BasedataEdit table = (BasedataEdit)this.getControl("table");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean isRoot = (Boolean)params.get("isroot");
        boolean isAddNew = (Boolean)params.get("isaddnew");
        String source = (String)params.get("source");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            this.getModel().setValue("source", (Object)source);
        }
        if (isRoot) {
            this.getModel().setValue("tabletype", (Object)"maintable");
            this.getView().setEnable(Boolean.FALSE, new String[]{"linktype"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"source"});
        } else {
            this.getModel().setValue("tabletype", (Object)"linktable");
            this.getView().setEnable(Boolean.TRUE, new String[]{"linktype"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"source"});
        }
        String sourceTable = (String)params.get("sourcetable");
        if (sourceTable != null) {
            this.getModel().setValue("sourcetable", params.get("sourcetable"));
            this.getModel().setValue("sourcetableid", params.get("sourcetableid"));
            ComboEdit linktype = (ComboEdit)this.getView().getControl("linktype");
            linktype.setMustInput(true);
        }
        if (!isAddNew) {
            String infos = (String)params.get("info");
            Map infoMap = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
            String tabletype = (String)infoMap.get("tabletype");
            String sourcetable = (String)infoMap.get("sourcetable");
            String table = (String)infoMap.get("table");
            String tablename = (String)infoMap.get("tablename");
            String linktype = (String)infoMap.get("linktype");
            String othername = (String)infoMap.get("othername");
            String sourceTableId = (String)infoMap.get("sourcetableid");
            source = (String)infoMap.get("source");
            this.getModel().setValue("tabletype", (Object)tabletype);
            this.getModel().setValue("sourcetable", (Object)sourcetable);
            this.getModel().setValue("table", (Object)table);
            this.getModel().setValue("tablename", (Object)tablename);
            this.getModel().setValue("linktype", (Object)linktype);
            this.getModel().setValue("othername", (Object)othername);
            this.getModel().setValue("sourcetableid", (Object)sourceTableId);
            this.getModel().setValue("source", (Object)source);
            this.getView().setEnable(Boolean.FALSE, new String[]{"table"});
            if (StringUtils.equals((CharSequence)tabletype, (CharSequence)"maintable")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"linktype"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"source"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        Object newValue = cd.getNewValue();
        if (StringUtils.equals((CharSequence)"table", (CharSequence)propertyName)) {
            if (newValue == null) {
                this.getModel().setValue("tablename", null);
                this.getModel().setValue("othername", null);
            } else {
                String source = (String)this.getModel().getValue("source");
                DynamicObject dataTable = (DynamicObject)newValue;
                if (StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source)) {
                    String name = dataTable.getString("number");
                    this.getModel().setValue("tablename", (Object)(name + "@PHM"));
                    this.getModel().setValue("othername", (Object)name);
                } else {
                    DynamicObject isc_metadata_schema = QueryServiceHelper.queryOne((String)"isc_metadata_schema", (String)"id,table_name", (QFilter[])new QFilter[]{new QFilter("id", "=", dataTable.getPkValue())});
                    String table_name = isc_metadata_schema.getString("table_name");
                    this.getModel().setValue("tablename", (Object)table_name);
                    String otherName = table_name;
                    if (table_name.contains("@")) {
                        otherName = table_name.split("@")[0];
                    }
                    this.getModel().setValue("othername", (Object)otherName);
                }
            }
        } else if (StringUtils.equals((CharSequence)"source", (CharSequence)propertyName)) {
            this.getModel().setValue("othername", null);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String srcCtrlKey = btn.getKey().toLowerCase();
        if ("btn_ok".equals(srcCtrlKey)) {
            String tabletype = (String)this.getModel().getValue("tabletype");
            String sourcetable = (String)this.getModel().getValue("sourcetable");
            String sourcetableid = (String)this.getModel().getValue("sourcetableid");
            DynamicObject table = (DynamicObject)this.getModel().getValue("table");
            long tableId = 0L;
            if (table == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a", (String)"TableRelationPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            tableId = (Long)table.getPkValue();
            String tablename = (String)this.getModel().getValue("tablename");
            String linktype = (String)this.getModel().getValue("linktype");
            String othername = (String)this.getModel().getValue("othername");
            String dbkey = "phm";
            if (tablename.contains("@")) {
                dbkey = tablename.split("@")[1];
            }
            if (StringUtils.isNotEmpty((CharSequence)sourcetable) && StringUtils.isEmpty((CharSequence)linktype)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"TableRelationPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)othername)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"TableRelationPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            String source = (String)this.getModel().getValue("source");
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("tabletype", tabletype);
            returnData.put("sourcetable", sourcetable);
            returnData.put("sourcetableid", sourcetableid);
            returnData.put("source", source);
            returnData.put("table", Long.toString(tableId));
            returnData.put("tablename", tablename);
            returnData.put("linktype", linktype);
            returnData.put("othername", othername);
            returnData.put("dbkey", dbkey);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            String root = (String)params.get("root");
            boolean isAddNew = (Boolean)params.get("isaddnew");
            String nodeid = (String)params.get("nodeid");
            this.checkOtherNameOnly(nodeid, root, isAddNew, othername);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void checkOtherNameOnly(String nodeid, String root, boolean isAddNew, String othername) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)root, TreeNode.class);
        HashMap<String, String> otherNameMap = new HashMap<String, String>();
        this.getOtherNameMap(rootNode, otherNameMap);
        if (isAddNew ? otherNameMap.containsValue(othername) : otherNameMap.containsValue(othername) && !StringUtils.equals((CharSequence)((CharSequence)otherNameMap.get(nodeid)), (CharSequence)othername)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u522b\u540d[", (String)"TableRelationPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + othername + ResManager.loadKDString((String)"]\u5df2\u5b58\u5728", (String)"TableRelationPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    private void getOtherNameMap(TreeNode treeNode, Map<String, String> otherNameMap) {
        List children = treeNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TreeNode child = (TreeNode)children.get(i);
            String otherName = child.getText().split(" ")[1];
            otherNameMap.put(child.getId(), otherName);
            this.getOtherNameMap(child, otherNameMap);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String source = (String)this.getModel().getValue("source");
        if (StringUtils.equals((CharSequence)"isc_metadata_schema", (CharSequence)source)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("type", "=", (Object)"TABLE"));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("table_name", "ftlike", (Object)"@"));
            String dbkey = (String)params.get("dbkey");
            if (StringUtils.isNotEmpty((CharSequence)dbkey)) {
                QFilter qfilter = new QFilter("table_name", "ftlike", (Object)dbkey.toLowerCase(Locale.ROOT)).or("table_name", "ftlike", (Object)dbkey.toUpperCase(Locale.ROOT));
                formShowParameter.getListFilterParameter().getQFilters().add(qfilter);
            }
        }
    }
}

