/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.tools.Column;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.phm.common.bizmodel.TermEnums;
import kd.mmc.phm.common.info.EigenCalModelInfo;
import kd.mmc.phm.common.info.TermEntryInfo;

public class BaseDataSetPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(BaseDataSetPlugin.class);
    private static final String BTN_TEST = "btn_test";
    private static final String BTN_VIEWSQL = "btn_viewsql";
    private static final String FIELD = "field";
    private static final String FIELD_ENTRY = "fieldentry";
    private static final String AFFRIM = "affrim";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long basetableId = (Long)formShowParameter.getCustomParam("basetableId");
        this.fillFieldsEntry(basetableId);
        String sql = (String)formShowParameter.getCustomParam("sql");
        this.getModel().setValue("sql_tag", (Object)sql);
        String storevalueTag = (String)formShowParameter.getCustomParam("storevalue_tag");
        this.constractFormData(storevalueTag);
        String fieldType = (String)formShowParameter.getCustomParam("fieldType");
        this.getPageCache().put("fieldType", fieldType);
    }

    private void constractFormData(String formData) {
        if (StringUtils.isEmpty((CharSequence)formData)) {
            return;
        }
        EigenCalModelInfo eigenCalModelInfo = (EigenCalModelInfo)JSONObject.parseObject((String)formData, EigenCalModelInfo.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        String sqlTag = eigenCalModelInfo.getSql_tag();
        this.getPageCache().put("selectRow", sqlTag);
        ArrayList termEntryList = eigenCalModelInfo.getTermentry();
        if (termEntryList == null) {
            termEntryList = new ArrayList();
        }
        TableValueSetter termEntryVs = new TableValueSetter(new String[]{"seq", FIELD, "term", "valuetype", "value", "linkterm", "leftterm", "rightterm"});
        for (int i = 0; i < termEntryList.size(); ++i) {
            TermEntryInfo termEntryInfo = (TermEntryInfo)termEntryList.get(i);
            String field = termEntryInfo.getField();
            String term = termEntryInfo.getTerm();
            String valueType = termEntryInfo.getValuetype();
            String value = termEntryInfo.getValue();
            String linkterm = termEntryInfo.getLinkterm();
            String leftterm = termEntryInfo.getLeftterm();
            String rightterm = termEntryInfo.getRightterm();
            termEntryVs.addRow(new Object[]{i, field, term, valueType, value, linkterm, leftterm, rightterm});
        }
        model.deleteEntryData("termentry");
        model.batchCreateNewEntryRow("termentry", termEntryVs);
        model.endInit();
        this.getView().updateView("termentry");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FIELD_ENTRY);
        String selectRow = this.getPageCache().get("selectRow");
        if (StringUtils.isNotBlank((CharSequence)selectRow)) {
            entryGrid.selectRows(Integer.parseInt(selectRow));
        }
    }

    private void fillFieldsEntry(Long tableId) {
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((Object)tableId, (String)"phm_datatable");
        this.getPageCache().put("tablename", dataTable.getString("number"));
        DynamicObjectCollection entryCol = dataTable.getDynamicObjectCollection("entryentity");
        TableValueSetter fieldEntryVs = new TableValueSetter(new String[]{"seq", "fieldname", "fieldtype"});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            String fieldName = entry.getString("fieldname");
            String fieldType = entry.getString("fieldtype");
            fieldEntryVs.addRow(new Object[]{i, fieldName, fieldType});
        }
        model.deleteEntryData(FIELD_ENTRY);
        model.batchCreateNewEntryRow(FIELD_ENTRY, fieldEntryVs);
        model.endInit();
        this.getView().updateView(FIELD_ENTRY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELD, BTN_TEST, BTN_VIEWSQL});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FIELD_ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (AFFRIM.equals(operateKey)) {
            try {
                this.queryTest();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.getModel().setValue("sql_tag", (Object)"");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6d4b\u8bd5\u672a\u901a\u8fc7\uff1a", (String)"BaseDataSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage());
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (AFFRIM.equals(operateKey)) {
            HashMap<String, String> returnData = new HashMap<String, String>(2);
            String sql = this.getModel().getValue("sql_tag").toString();
            returnData.put("sql", sql);
            returnData.put("storevalue_tag", this.saveFormData());
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private String saveFormData() {
        HashMap<String, Serializable> cellData = new HashMap<String, Serializable>(2);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FIELD_ENTRY);
        int selectRow = entryGrid.getSelectRows()[0];
        cellData.put("sql_tag", Integer.valueOf(selectRow));
        DynamicObjectCollection termEntryCol = this.getModel().getEntryEntity("termentry");
        ArrayList termEntryList = new ArrayList(termEntryCol.size());
        for (int i = 0; i < termEntryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)termEntryCol.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>(7);
            map.put(FIELD, entry.get(FIELD));
            map.put("term", entry.get("term"));
            map.put("valuetype", entry.get("valuetype"));
            map.put("value", entry.get("value"));
            map.put("linkterm", entry.get("linkterm"));
            map.put("leftterm", entry.get("leftterm"));
            map.put("rightterm", entry.get("rightterm"));
            termEntryList.add(map);
        }
        cellData.put("termentry", termEntryList);
        return JSONObject.toJSONString(cellData);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_TEST.equals(key)) {
            try {
                this.queryTest();
                this.getView().showMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u6d4b\u8bd5\u6210\u529f", (String)"BaseDataSetPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.getModel().setValue("sql_tag", (Object)"");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6d4b\u8bd5\u672a\u901a\u8fc7\uff1a", (String)"BaseDataSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage());
            }
        } else if (BTN_VIEWSQL.equals(key)) {
            this.viewSQL();
        }
    }

    private void viewSQL() {
        try {
            this.queryTest();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getModel().setValue("sql_tag", (Object)"");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6d4b\u8bd5\u672a\u901a\u8fc7\uff1a", (String)"BaseDataSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage());
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_largertextedit");
        showParameter.setCustomParam("fieldKey", (Object)"sql");
        showParameter.setCustomParam("largeTextValue", this.getModel().getValue("sql_tag"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void queryTest() {
        String paramSql = this.generateSQL();
        try {
            DBRoute dbRoute = DBRoute.of((String)"phm");
            this.executeQuery(dbRoute, paramSql);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u6267\u884cSQL\u5931\u8d25\uff1a%s", (String)"BaseDataSetPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        this.getModel().setValue("sql_tag", (Object)paramSql);
    }

    protected void executeQuery(DBRoute dbRoute, String sql) {
        ArrayList<Column> columnList = new ArrayList<Column>();
        this.getData(dbRoute, sql, columnList);
    }

    protected List<List<Object>> getData(DBRoute dbRoute, String sql, final List<Column> columnList) {
        List rs = null;
        try {
            rs = (List)DB.query((DBRoute)dbRoute, (String)sql, (ResultSetHandler)new ResultSetHandler<List<List<Object>>>(){

                public List<List<Object>> handle(ResultSet rs) throws Exception {
                    int i;
                    ArrayList<List<Object>> data = new ArrayList<List<Object>>(rs.getRow());
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnNumber = meta.getColumnCount();
                    for (i = 1; i <= columnNumber; ++i) {
                        Column column = new Column();
                        column.setName(meta.getColumnName(i));
                        column.setcType(meta.getColumnType(i));
                        columnList.add(column);
                    }
                    i = 0;
                    if (rs.next()) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        int index = ++i;
                        row.add(index);
                        row.add(index);
                        for (int n = 1; n <= columnNumber; ++n) {
                            row.add(rs.getObject(n) == null ? "" : rs.getObject(n));
                        }
                        data.add(row);
                    }
                    return data;
                }
            });
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a%s", (String)"BaseDataSetPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{ex.getMessage()});
        }
        return rs;
    }

    private void constractParamsSQL(StringBuilder sql) {
        sql.append("select \n");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FIELD_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u8f93\u51fa\u5b57\u6bb5", (String)"BaseDataSetPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        String fieldname = this.getModel().getValue("fieldname", selectRows[0]).toString();
        sql.append(fieldname).append('\n');
    }

    private String generateSQL() {
        StringBuilder sql = new StringBuilder();
        this.constractFieldSQL(sql);
        return sql.toString();
    }

    private void constractFromSQL(StringBuilder sql) {
        sql.append("from").append('\n');
        sql.append(this.getPageCache().get("tablename")).append('\n');
    }

    private void constractFieldSQL(StringBuilder sql) {
        this.constractParamsSQL(sql);
        this.constractFromSQL(sql);
        this.constractTermSQL(sql);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FIELD_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        String fieldname = this.getModel().getValue("fieldname", selectRows[0]).toString();
        sql.append(" order by ").append(fieldname).append('\n');
    }

    private void constractTermSQL(StringBuilder sql) {
        DynamicObjectCollection termEntrys = this.getModel().getEntryEntity("termentry");
        if (termEntrys.isEmpty()) {
            return;
        }
        sql.append("where 1=1 ").append('\n');
        String allLeftTerm = "";
        String allRightTerm = "";
        for (int i = 0; i < termEntrys.size(); ++i) {
            if (i == 0) {
                sql.append(" and ");
            }
            DynamicObject termEntry = (DynamicObject)termEntrys.get(i);
            String field = termEntry.getString(FIELD);
            String term = termEntry.getString("term");
            String value = termEntry.getString("value");
            String linkterm = termEntry.getString("linkterm");
            String leftterm = termEntry.getString("leftterm");
            String rightterm = termEntry.getString("rightterm");
            if (i == termEntrys.size() - 1 && StringUtils.isNotEmpty((CharSequence)linkterm)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u6700\u540e\u4e00\u884c\u7684\u8fde\u63a5\u6761\u4ef6\u5fc5\u987b\u4e3a\u7a7a", (String)"BaseDataSetPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)linkterm) && i != termEntrys.size() - 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"BaseDataSetPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u8fde\u63a5\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"BaseDataSetPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)field)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"BaseDataSetPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u5b57\u6bb5\u4e3a\u7a7a", (String)"BaseDataSetPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)term)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"BaseDataSetPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u6761\u4ef6\u4e3a\u7a7a", (String)"BaseDataSetPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)TermEnums.NULL.getValue(), (CharSequence)term) && !StringUtils.equals((CharSequence)TermEnums.NOTNULL.getValue(), (CharSequence)term) && StringUtils.isEmpty((CharSequence)value)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"BaseDataSetPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u503c\u4e3a\u7a7a", (String)"BaseDataSetPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (linkterm == null) {
                linkterm = "";
            }
            leftterm = this.dealLeftTerm(leftterm);
            rightterm = this.dealRightTerm(rightterm);
            allLeftTerm = allLeftTerm.concat(leftterm);
            allRightTerm = allRightTerm.concat(rightterm);
            if (StringUtils.equals((CharSequence)TermEnums.LIKE.getValue(), (CharSequence)term)) {
                sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append('\'').append('%').append(value).append('%').append('\'').append('\n').append(rightterm).append(linkterm).append('\n');
                continue;
            }
            if (StringUtils.equals((CharSequence)TermEnums.NULL.getValue(), (CharSequence)term) || StringUtils.equals((CharSequence)TermEnums.NOTNULL.getValue(), (CharSequence)term)) {
                sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append(rightterm).append(linkterm).append('\n');
                continue;
            }
            sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append('\'').append(value).append('\'').append('\n').append(rightterm).append(linkterm).append('\n');
        }
        if (allLeftTerm.trim().length() != allRightTerm.trim().length()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u548c\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u8bbe\u7f6e", (String)"BaseDataSetPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    private String conversionTerm(String term) {
        HashMap<String, String> termMap = new HashMap<String, String>(9);
        termMap.put(TermEnums.GT.getValue(), ">");
        termMap.put(TermEnums.LT.getValue(), "<");
        termMap.put(TermEnums.EQU.getValue(), "=");
        termMap.put(TermEnums.NEQ.getValue(), "!=");
        termMap.put(TermEnums.LE.getValue(), "<=");
        termMap.put(TermEnums.GE.getValue(), ">=");
        termMap.put(TermEnums.NULL.getValue(), "is null");
        termMap.put(TermEnums.NOTNULL.getValue(), "is not null");
        termMap.put(TermEnums.LIKE.getValue(), "like");
        return (String)termMap.get(term);
    }

    private String dealLeftTerm(String leftterm) {
        if ("1".equals(leftterm)) {
            return "(";
        }
        if ("2".equals(leftterm)) {
            return "((";
        }
        if ("3".equals(leftterm)) {
            return "(((";
        }
        return "";
    }

    private String dealRightTerm(String rightterm) {
        if ("-1".equals(rightterm)) {
            return ")";
        }
        if ("-2".equals(rightterm)) {
            return "))";
        }
        if ("-3".equals(rightterm)) {
            return ")))";
        }
        return "";
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (StringUtils.equals((CharSequence)FIELD, (CharSequence)key)) {
            FormShowParameter showParameter = new FormShowParameter();
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, FIELD);
            showParameter.setFormId("phm_eigencal_field");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(callBack);
            HashMap params = new HashMap(1);
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity(FIELD_ENTRY);
            List fieldsList = entryCol.stream().map(entry -> entry.getString("fieldname")).collect(Collectors.toList());
            params.put(FIELD, fieldsList);
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        EntryGrid termEntry = (EntryGrid)this.getView().getControl("termentry");
        int[] selectRows = termEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int rowIndex = selectRows[0];
        String field = (String)returnData.get(FIELD);
        this.getModel().setValue(FIELD, (Object)field, rowIndex);
    }

    public void entryRowClick(RowClickEvent evt) {
        int[] selectRows;
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)FIELD_ENTRY, (CharSequence)entryGrid.getKey()) && (selectRows = entryGrid.getSelectRows()).length > 0) {
            String fieldTypeNow;
            int selectRowNow = selectRows[0];
            String fieldType = this.getPageCache().get("fieldType");
            if (fieldType.equals(fieldTypeNow = this.getModel().getValue("fieldtype", selectRowNow).toString())) {
                this.getPageCache().put("selectRow", Integer.toString(selectRowNow));
            } else {
                String selectRow = this.getPageCache().get("selectRow");
                entryGrid.selectRows(StringUtils.isBlank((CharSequence)selectRow) ? -1 : Integer.parseInt(selectRow));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8f93\u51fa\u5b57\u6bb5\u4e0e\u9009\u62e9\u5217\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"BaseDataSetPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

