/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.base.BaseModel;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.spread.SpreadPraseUtil;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.Cell;
import kd.mmc.phm.common.spread.model.RealRowAndCol;
import kd.mmc.phm.common.util.DataEntityCacheUtil;
import kd.mmc.phm.formplugin.bizmodel.spread.AbstractTemplatePlugin;

public class BillTempEditPlugin
extends AbstractTemplatePlugin
implements BeforeF7SelectListener {
    protected static final String TOOLBARAP = "tbmain";
    protected static final String BTN_FIELDSET = "btn_fieldset";
    protected static final String BTN_PREVIEW = "btn_preview";
    protected static final String HEADSET_CLOSE = "headset_close";
    protected static final String FIEDLSET_CLOSE = "fieldset_close";
    protected static final String BTL_HEADSET = "btl_headset";
    private static final String BTN_AREASET = "btn_areaset";
    private static final String BTN_CELLSET = "btn_cellset";
    private static final String BTN_BASEDATESET = "btn_basedateset";

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (changeData.getNewValue() == null) {
            return;
        }
        if ("isenableversion".equals(name)) {
            boolean isEnableVersion = (Boolean)changeData.getNewValue();
            FieldEdit fieldEdit = (FieldEdit)this.getControl("versionrule");
            fieldEdit.setMustInput(isEnableVersion);
            if (!isEnableVersion) {
                this.getModel().setValue("versionrule", null);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit businessentity = (BasedataEdit)this.getView().getControl("billtemps");
        if (businessentity != null) {
            businessentity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit versionRule = (BasedataEdit)this.getControl("versionrule");
        versionRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String tempclassify;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String billtemptype = (String)parameter.getCustomParam("billtemptype");
        if (StringUtils.isNotEmpty((CharSequence)billtemptype)) {
            this.getModel().setValue("group", (Object)Long.valueOf(billtemptype));
        }
        if (StringUtils.isNotEmpty((CharSequence)(tempclassify = (String)parameter.getCustomParam("tempclassify")))) {
            this.getModel().setValue("tempclassify", (Object)Long.valueOf(tempclassify));
        }
    }

    private void initSpread() {
        this.getSpreadContainer().lockToolbarItems(true, this.getLockToolBarItems());
        String spreadJson = (String)this.getModel().getValue("spreadjson_tag");
        if (StringUtils.isNotEmpty((CharSequence)spreadJson)) {
            this.getSpreadContainer().rebuildSpread(spreadJson);
            this.rebuildSpread(spreadJson);
        }
    }

    protected List<String> getLockToolBarItems() {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)2);
        items.add("FrozenSheets");
        return items;
    }

    public void tableHeadSet() {
        this.getSpreadContainer().getSpreadJson("showBillTempHeadSetForm");
    }

    public void tableCloumnsSet() {
        this.getSpreadContainer().getSpreadJson("showBillTempFieldSetForm");
    }

    public void beforeBindData(EventObject e) {
        this.initSpread();
    }

    public Long getBillTempConfId() {
        return (Long)this.getModel().getValue("tempconf_id");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btl_headset": {
                this.tableHeadSet();
                break;
            }
            case "btn_fieldset": {
                this.tableCloumnsSet();
                break;
            }
            case "btn_preview": {
                this.getSpreadContainer().getSpreadJson("showPreviewForm");
                break;
            }
            case "btn_basedateset": {
                this.baseDataSet();
                break;
            }
            case "btn_areaset": {
                this.getSpreadContainer().getSpreadJson("dataAreaSet");
                break;
            }
            case "btn_cellset": {
                this.getSpreadContainer().getSpreadJson("showCellSetForm");
            }
        }
    }

    public void showCellSetForm(String spreadString) {
        String status = this.getBillTempStatus();
        BillShowParameter billShowParameter = new BillShowParameter();
        if (StringUtils.equals((CharSequence)StatusEnum.SAVE.getValue(), (CharSequence)status)) {
            String areastart;
            DynamicObject tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId());
            String string = areastart = tempConf == null ? null : tempConf.getString("areastart");
            if (areastart == null || StringUtils.isEmpty((CharSequence)areastart)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6570\u636e\u533a\u57df\u3002", (String)"BillTempEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            String areaend = tempConf.getString("areaend");
            int startCol = SpreadUtils.pos2X((String)areastart);
            int startRow = SpreadUtils.pos2Y((String)areastart);
            int endCol = SpreadUtils.pos2X((String)areaend);
            int endRow = SpreadUtils.pos2Y((String)areaend);
            Set cells = SpreadPraseUtil.getSelectCells((String)spreadString);
            if (cells == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u8981\u8bbe\u7f6e\u7684\u5355\u5143\u683c\u3002", (String)"BillTempEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder msg = new StringBuilder();
            for (Cell cell : cells) {
                int cellRow = cell.getRow();
                int cellCol = cell.getCol();
                String po = null;
                if (cellCol <= endCol && cellCol >= startCol && cellRow <= endRow && cellRow >= startRow) continue;
                po = SpreadUtils.xy2Pos((int)cellCol, (int)cellRow);
                msg.append(po).append(',');
            }
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                msg.deleteCharAt(msg.length() - 1).append(ResManager.loadKDString((String)"\u4e0d\u5728\u6570\u636e\u533a\u57df\u5185,\u8bf7\u91cd\u65b0\u9009\u53d6\u3002", (String)"BillTempEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg.toString());
                return;
            }
            billShowParameter.setCustomParam("selectCells", (Object)SerializationUtils.toJsonString((Object)cells));
        }
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u5355\u5143\u8bbe\u7f6e", (String)"BillTempEditPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        billShowParameter.setCustomParam("billTemps", this.getModel().getValue("billtemps"));
        billShowParameter.setCustomParam("status", (Object)this.getBillTempStatus());
        Long cellconfid = (Long)this.getModel().getValue("cellconf_id");
        billShowParameter.setCustomParam("phm_fixtpl_cellset", (Object)DataEntityCacheUtil.getDataEntryString((IPageCache)this.getPageCache(), (String)"phm_fixtpl_cellset", (Long)cellconfid));
        billShowParameter.setFormId("phm_fixtpl_cellset");
        StyleCss css = new StyleCss();
        css.setWidth("880px");
        css.setHeight("420px");
        billShowParameter.getOpenStyle().setInlineStyleCss(css);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_CELLSET));
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void dataAreaSet(String spreadString) {
        DynamicObject dataTemp;
        DynamicObject tempConf;
        Set cells;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("phm_dataarea");
        showParameter.setPageId(this.getView().getPageId() + "phm_dataarea");
        String status = this.getBillTempStatus();
        if (StringUtils.equals((CharSequence)StatusEnum.SAVE.getValue(), (CharSequence)status) && (cells = SpreadPraseUtil.getSelectCells((String)spreadString)) != null && cells.size() > 1) {
            List area = cells.stream().sorted(Comparator.comparing(Cell::getRow).thenComparing(Cell::getCol)).collect(Collectors.toList());
            showParameter.setCustomParam("selectArea", (Object)SerializationUtils.toJsonString((Object)Lists.newArrayList((Object[])new Cell[]{(Cell)area.get(0), (Cell)area.get(area.size() - 1)})));
        }
        if ((tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId())) != null) {
            showParameter.setCustomParam("areastart", (Object)tempConf.getString("areastart"));
            showParameter.setCustomParam("areaend", (Object)tempConf.getString("areaend"));
        }
        if ((dataTemp = this.getBillTemp()) != null) {
            showParameter.setCustomParam("dataTempNumber", (Object)dataTemp.getString("number"));
            showParameter.setCustomParam("status", (Object)dataTemp.getString("status"));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_AREASET));
        this.getView().showForm(showParameter);
    }

    private void baseDataSet() {
        DynamicObject billTempConf;
        DynamicObject billTemp = this.getBillTemp();
        DynamicObjectCollection dataTables = billTemp.getDynamicObjectCollection("datatables");
        if (dataTables == null || dataTables.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5173\u8054\u6570\u636e\u8868\u3002", (String)"BillTempEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet tableIds = Sets.newHashSetWithExpectedSize((int)2);
        if (dataTables != null && !dataTables.isEmpty()) {
            for (DynamicObject item : dataTables) {
                long id = item.getLong("fbasedataid_id");
                tableIds.add(id);
            }
        }
        DynamicObjectCollection fields = (billTempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId())) == null ? null : billTempConf.getDynamicObjectCollection("fieldentryentity");
        Long id = null;
        if (fields != null) {
            for (DynamicObject field : fields) {
                long tableId = field.getLong("datatable_id");
                if (tableId == 0L || tableIds.contains(tableId)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u66f4\u6539\u8868\u5217\u8bbe\u7f6e\u518d\u8fdb\u884c\u4e3b\u6570\u636e\u8bbe\u7f6e\u3002", (String)"BillTempEditPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject dynamicObject : fields) {
                String fieldlogic = dynamicObject.getString("fieldlogic");
                if (id != null) break;
                if (id != null || !StringUtils.equals((CharSequence)"1", (CharSequence)fieldlogic) && !StringUtils.equals((CharSequence)"4", (CharSequence)fieldlogic)) continue;
                id = dynamicObject.getLong("id");
            }
        }
        if (id == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u586b\u5199\u903b\u8f91\u4e3a\u7d22\u5f15\u9879\u6216\u624b\u5de5\u586b\u5199\u7684\u8868\u5217\u3002", (String)"BillTempEditPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter billShowParameter = this.createTempConfShowParameter(null, "basedataset", FIEDLSET_CLOSE);
        StyleCss css = new StyleCss();
        css.setWidth("400px");
        css.setHeight("350px");
        billShowParameter.getOpenStyle().setInlineStyleCss(css);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u8bbe\u7f6e", (String)"BillTempEditPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private DynamicObject getBillTemp() {
        return this.getModel().getDataEntity();
    }

    public void showPreviewForm(String spreadJson) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId("phm_datatpl_preview");
        formShowParameter.setPageId(this.getView().getPageId() + "phm_datatpl_preview");
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            formShowParameter.setCustomParam("resource", (Object)id);
        }
        Tuple realRowCol = null;
        String tempclassify = (String)this.getModel().getValue("tempclassify");
        if (StringUtils.equals((CharSequence)"3", (CharSequence)tempclassify)) {
            String endPo;
            DynamicObject tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId());
            String string = endPo = tempConf == null ? null : tempConf.getString("areaend");
            if (StringUtils.isNotEmpty((CharSequence)endPo)) {
                int row = SpreadUtils.pos2Y((String)endPo);
                int col = SpreadUtils.pos2X((String)endPo);
                realRowCol = new Tuple((Object)row, (Object)col);
            }
        } else {
            realRowCol = this.getTempConfMaxRowCol();
        }
        String convertSpreadJson = SpreadUtils.convertSpreadJson((String)spreadJson);
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, HashMap.class);
        this.getModel().setValue("spreadjson_tag", (Object)this.resetSpreadJson(spreadMap, realRowCol));
        RealRowAndCol realRowAndCol = this.getRealRowAndCol();
        this.getModel().setValue("realcol", (Object)realRowAndCol.getRealCol());
        this.getModel().setValue("realrow", (Object)realRowAndCol.getRealRow());
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String dataTemp = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{dynamicObject}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_billtemp"));
        formShowParameter.setCustomParam("dataTemp", (Object)dataTemp);
        String number = (String)this.getModel().getValue("number");
        formShowParameter.setCaption((StringUtils.isEmpty((CharSequence)number) ? "" : number + "-") + ResManager.loadKDString((String)"\u9884\u89c8", (String)"BillTempEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)HEADSET_CLOSE, (CharSequence)actionId)) {
            this.afterCloseHeadSet(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)FIEDLSET_CLOSE, (CharSequence)actionId)) {
            this.afterCloseColumnSet(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)BTN_CELLSET, (CharSequence)actionId)) {
            this.afterCloseCellSet(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)BTN_AREASET, (CharSequence)actionId)) {
            this.afterCloseAreaSet(closedCallBackEvent);
        }
    }

    private void afterCloseAreaSet(ClosedCallBackEvent closedCallBackEvent) {
        Map area = (Map)closedCallBackEvent.getReturnData();
        if (area == null) {
            return;
        }
        DynamicObject tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId());
        if (tempConf == null) {
            tempConf = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_billtemp_set"));
        }
        String areastart = (String)area.get("areastart");
        String areaend = (String)area.get("areaend");
        tempConf.set("areastart", (Object)areastart);
        tempConf.set("areaend", (Object)areaend);
        this.getModel().setValue("area", (Object)(areastart + ":" + areaend));
        DataEntityCacheUtil.storeDataEntry((IPageCache)this.getPageCache(), (DynamicObject)tempConf);
    }

    private void afterCloseCellSet(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject cellConf = (DynamicObject)closedCallBackEvent.getReturnData();
        if (cellConf == null) {
            return;
        }
        DataEntityCacheUtil.storeDataEntry((IPageCache)this.getPageCache(), (DynamicObject)cellConf);
    }

    protected void afterCloseHeadSet(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject dynamicObject = (DynamicObject)closedCallBackEvent.getReturnData();
        if (dynamicObject == null) {
            return;
        }
        DataEntityCacheUtil.storeDataEntry((IPageCache)this.getPageCache(), (DynamicObject)dynamicObject);
        DynamicObjectCollection heads = dynamicObject.getDynamicObjectCollection("headentryentity");
        List<Map<String, Object>> params = this.getCellParams(heads);
        if (params == null || params.isEmpty()) {
            return;
        }
        this.getSpreadContainer().updateCellsValue(params);
    }

    private void setDataTempConf(long id) {
        this.getModel().setValue("tempconf_id", (Object)id);
    }

    protected void afterCloseColumnSet(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject dynamicObject = (DynamicObject)closedCallBackEvent.getReturnData();
        if (dynamicObject == null) {
            return;
        }
        DataEntityCacheUtil.storeDataEntry((IPageCache)this.getPageCache(), (DynamicObject)dynamicObject);
    }

    protected List<Map<String, Object>> getCellParams(DynamicObjectCollection cellInfos) {
        if (cellInfos == null || cellInfos.isEmpty()) {
            return null;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)cellInfos.size());
        for (DynamicObject dynamicObject : cellInfos) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            param.put("r", dynamicObject.getInt("headrow"));
            param.put("c", dynamicObject.getInt("headcol"));
            param.put("v", dynamicObject.getString("headname"));
            param.put("rc", 1);
            param.put("cc", 1);
            param.put("st", Boolean.TRUE);
            param.put("pos", new int[]{1});
            params.add(param);
        }
        return params;
    }

    public String getBillTempStatus() {
        return (String)this.getModel().getValue("status");
    }

    public void showBillTempFieldSetForm(String spreadString) {
        try {
            BillShowParameter billShowParameter = this.createTempConfShowParameter(spreadString, "field", FIEDLSET_CLOSE);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
        catch (KDException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public BillShowParameter createTempConfShowParameter(String spreadString, String type, String closeAction) {
        List<Cell> cells;
        BillShowParameter billShowParameter = new BillShowParameter();
        String status = this.getBillTempStatus();
        billShowParameter.setCustomParam("status", (Object)status);
        if (StringUtils.equals((CharSequence)"A", (CharSequence)status) && StringUtils.isNotEmpty((CharSequence)spreadString) && (cells = this.getSelectCellsValue(spreadString, StringUtils.equals((CharSequence)"field", (CharSequence)type), type)) != null) {
            billShowParameter.setCustomParam("selectCells", (Object)SerializationUtils.toJsonString(cells));
        }
        if (!StringUtils.equals((CharSequence)"head", (CharSequence)type)) {
            billShowParameter.setCustomParam("dataTables", this.getModel().getValue("datatables"));
            billShowParameter.setCustomParam("billTemps", this.getModel().getValue("billtemps"));
        }
        billShowParameter.setFormId("phm_billtemp_set");
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeAction));
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCustomParam("confType", (Object)type);
        billShowParameter.setCustomParam("operate", (Object)"addnew");
        billShowParameter.setCustomParam("tempType", this.getModel().getValue("tempclassify"));
        billShowParameter.setCustomParam("sameOrg", (Object)this.isSameOrg());
        billShowParameter.setCustomParam("phm_billtemp_set", (Object)DataEntityCacheUtil.getDataEntryString((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId()));
        StyleCss css = new StyleCss();
        css.setWidth("880px");
        css.setHeight("420px");
        billShowParameter.getOpenStyle().setInlineStyleCss(css);
        billShowParameter.setCaption(StringUtils.equals((CharSequence)"field", (CharSequence)type) ? ResManager.loadKDString((String)"\u8868\u5217\u8bbe\u7f6e", (String)"BillTempEditPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : (StringUtils.equals((CharSequence)"head", (CharSequence)type) ? ResManager.loadKDString((String)"\u8868\u5934\u8bbe\u7f6e", (String)"BillTempEditPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u8bbe\u7f6e", (String)"BillTempEditPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
        return billShowParameter;
    }

    public Set<Cell> addSelectCell(Set<Cell> selectCells, String type) {
        Long tempConfId = this.getBillTempConfId();
        if (tempConfId == null || tempConfId == 0L) {
            return selectCells;
        }
        if (selectCells == null) {
            selectCells = Sets.newHashSetWithExpectedSize((int)10);
        }
        DynamicObject tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId());
        if (StringUtils.equals((CharSequence)"head", (CharSequence)type)) {
            DynamicObjectCollection heads;
            DynamicObjectCollection dynamicObjectCollection = heads = tempConf == null ? null : tempConf.getDynamicObjectCollection("headentryentity");
            if (heads == null) {
                return selectCells;
            }
            for (DynamicObject head : heads) {
                selectCells.add(new Cell(head.getString("headcellpo"), head.getInt("headrow"), head.getInt("headcol"), 0));
            }
        } else {
            DynamicObjectCollection fields;
            DynamicObjectCollection dynamicObjectCollection = fields = tempConf == null ? null : tempConf.getDynamicObjectCollection("fieldentryentity");
            if (fields == null) {
                return selectCells;
            }
            for (DynamicObject head : fields) {
                String po = head.getString("fieldcellpo");
                if (StringUtils.isEmpty((CharSequence)po)) continue;
                int rowIndex = SpreadUtils.pos2Y((String)po);
                selectCells.add(new Cell(po, rowIndex, head.getInt("cellcol"), 0));
            }
        }
        return selectCells;
    }

    private void saveOrUpdateTempConf(DynamicObject tempConf) {
        if (tempConf == null) {
            return;
        }
        long id = tempConf.getLong("id");
        if (id == 0L) {
            String number = (String)this.getModel().getValue("number");
            tempConf.set("number", (Object)number);
            tempConf.set("name", (Object)number);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tempConf});
        } else {
            this.delteEntryEntity(tempConf, "phm_billtemp_set", "headentryentity");
            this.delteEntryEntity(tempConf, "phm_billtemp_set", "fieldentryentity");
            SaveServiceHelper.update((DynamicObject)tempConf);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tempConf});
        }
        this.setDataTempConf(tempConf.getLong("id"));
        DataEntityCacheUtil.storeDataEntry((IPageCache)this.getPageCache(), (DynamicObject)tempConf);
    }

    private void saveOrUpdateTempCellConf(DynamicObject tempCellConf) {
        if (tempCellConf == null) {
            return;
        }
        long id = tempCellConf.getLong("id");
        if (id == 0L) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tempCellConf});
        } else {
            List<Long> deleteEntryIds = this.delteEntryEntity(tempCellConf, "phm_fixtpl_cellset", "cellentryentity");
            this.deleteEntryMultiBaseData(tempCellConf, "cellentryentity", "datatemps", deleteEntryIds);
            SaveServiceHelper.update((DynamicObject)tempCellConf);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tempCellConf});
        }
        this.getModel().setValue("cellconf_id", (Object)tempCellConf.getLong("id"));
        DataEntityCacheUtil.storeDataEntry((IPageCache)this.getPageCache(), (DynamicObject)tempCellConf);
    }

    private void deleteEntryMultiBaseData(DynamicObject tempCellConf, String entryName, String multiBaseName, List<Long> deleteEntryIds) {
        DynamicObjectCollection oldEntryentities;
        DynamicObjectCollection entryentities;
        DynamicObjectCollection dynamicObjectCollection = entryentities = tempCellConf == null ? null : tempCellConf.getDynamicObjectCollection(entryName);
        if (entryentities == null) {
            return;
        }
        HashSet entryIds = Sets.newHashSetWithExpectedSize((int)entryentities.size());
        String multiBaseTableName = entryentities.getDynamicObjectType().getProperty(multiBaseName).getAlias();
        DynamicObjectType rootEntityType = tempCellConf.getDynamicObjectType();
        String entityName = rootEntityType.getName();
        for (DynamicObject entry : entryentities) {
            DynamicObjectCollection multiBases = entry.getDynamicObjectCollection(multiBaseName);
            if (multiBases == null || multiBases.isEmpty()) continue;
            for (DynamicObject multiBase : multiBases) {
                long multiBaseId = multiBase.getLong("pkid");
                if (multiBaseId == 0L) continue;
                entryIds.add(multiBaseId);
            }
        }
        String routeKey = rootEntityType.getDBRouteKey();
        Long rootId = tempCellConf.getLong("id");
        ArrayList deleteMultiBaseIds = Lists.newArrayListWithCapacity((int)4);
        DBRoute dbRoute = new DBRoute(routeKey);
        DynamicObject oldTempCellConf = BusinessDataServiceHelper.loadSingle((Object)rootId, (DynamicObjectType)rootEntityType);
        DynamicObjectCollection dynamicObjectCollection2 = oldEntryentities = oldTempCellConf == null ? null : oldTempCellConf.getDynamicObjectCollection(entryName);
        if (oldEntryentities == null || oldEntryentities.isEmpty()) {
            return;
        }
        StringBuilder deleteSql = new StringBuilder("DELETE FROM ");
        deleteSql.append(multiBaseTableName).append(" WHERE fpkid IN (");
        for (DynamicObject entry : oldEntryentities) {
            DynamicObjectCollection multiBases = entry.getDynamicObjectCollection(multiBaseName);
            if (multiBases == null || multiBases.isEmpty()) continue;
            for (DynamicObject multiBase : multiBases) {
                long multiBaseId = multiBase.getLong("pkid");
                if (entryIds.contains(multiBaseId)) continue;
                deleteSql.append("?,");
                deleteMultiBaseIds.add(multiBaseId);
            }
        }
        if (deleteMultiBaseIds.size() > 0) {
            deleteSql.replace(deleteSql.length() - 1, deleteSql.length(), ")");
            DB.execute((DBRoute)dbRoute, (String)deleteSql.toString(), (Object[])deleteMultiBaseIds.toArray(new Object[deleteMultiBaseIds.size()]));
        }
        if (deleteEntryIds == null || deleteEntryIds.isEmpty()) {
            return;
        }
        deleteSql = new StringBuilder("DELETE FROM ");
        deleteSql.append(multiBaseTableName).append(" WHERE fentryid IN (");
        for (int i = 0; i < deleteEntryIds.size(); ++i) {
            deleteSql.append("?,");
        }
        deleteSql.replace(deleteSql.length() - 1, deleteSql.length(), ")");
        DB.execute((DBRoute)dbRoute, (String)deleteSql.toString(), (Object[])deleteEntryIds.toArray(new Object[deleteEntryIds.size()]));
    }

    private List<Long> delteEntryEntity(DynamicObject tempConf, String entityName, String code) {
        DynamicObjectCollection entryentities;
        DynamicObjectCollection dynamicObjectCollection = entryentities = tempConf == null ? null : tempConf.getDynamicObjectCollection(code);
        if (entryentities == null) {
            return null;
        }
        HashSet entryIds = Sets.newHashSetWithExpectedSize((int)entryentities.size());
        for (DynamicObject entry : entryentities) {
            long entryId = entry.getLong("id");
            if (entryId == 0L) continue;
            entryIds.add(entryId);
        }
        Long rootId = tempConf.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)rootId);
        String entityid = code + ".id";
        ArrayList deleteEntryIds = Lists.newArrayListWithCapacity((int)4);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)BillTempEditPlugin.class.getName(), (String)entityName, (String)entityid, (QFilter[])qFilter.toArray(), null);){
            String tableName = entryentities.getDynamicObjectType().getAlias();
            String routeKey = entryentities.getDynamicObjectType().getDBRouteKey();
            DBRoute dbRoute = new DBRoute(routeKey);
            StringBuilder deleteSql = new StringBuilder("DELETE FROM ");
            deleteSql.append(tableName).append(" WHERE FENTRYID IN (");
            for (Row row : ds) {
                Long id = row.getLong(entityid);
                if (entryIds.contains(id)) continue;
                deleteSql.append("?,");
                deleteEntryIds.add(id);
            }
            if (deleteEntryIds.size() > 0) {
                deleteSql.replace(deleteSql.length() - 1, deleteSql.length(), ")");
                DB.execute((DBRoute)dbRoute, (String)deleteSql.toString(), (Object[])deleteEntryIds.toArray(new Object[deleteEntryIds.size()]));
            }
        }
        return deleteEntryIds;
    }

    public void showBillTempHeadSetForm(String spreadString) {
        BillShowParameter billShowParameter = this.createTempConfShowParameter(spreadString, "head", HEADSET_CLOSE);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public List<Cell> getSelectCellsValue(String spreadJson, boolean isRepeat, String type) {
        Map spreadObject = SpreadPraseUtil.getSpreadObject((String)spreadJson);
        Set selectCells = SpreadPraseUtil.getSelectCells((Map)spreadObject);
        if (selectCells == null || selectCells.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u7684\u533a\u57df\u3002", (String)"BillTempEditPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return null;
        }
        this.addSelectCell(selectCells, type);
        if (selectCells.isEmpty()) {
            return new ArrayList<Cell>(0);
        }
        Map dataTable = SpreadPraseUtil.getSpreadDataTableObject((Map)spreadObject);
        if (dataTable == null) {
            return new ArrayList<Cell>(selectCells);
        }
        selectCells.forEach(c -> {
            Map row = (Map)dataTable.get(String.valueOf(c.getRow()));
            Map cell = row == null ? null : (Map)row.get(String.valueOf(c.getCol()));
            String cellValue = SpreadPraseUtil.getCellFormatValue(cell);
            c.setValue((Object)cellValue);
        });
        if (isRepeat) {
            HashSet column = Sets.newHashSetWithExpectedSize((int)selectCells.size());
            boolean hasSameColumn = false;
            for (Cell cell : selectCells) {
                if (StringUtils.isNotEmpty((CharSequence)cell.getPosition())) continue;
                if (column.contains(cell.getCol())) {
                    hasSameColumn = true;
                    break;
                }
                column.add(cell.getCol());
            }
            if (hasSameColumn) {
                throw new KDException(new ErrorCode("BillTempEdit", ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5355\u5143\u683c\u6709\u5217\u91cd\u590d\u3002", (String)"BillTempEditPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[0]);
            }
        }
        return selectCells.stream().sorted(Comparator.comparing(Cell::getRow).thenComparing(Cell::getCol)).collect(Collectors.toList());
    }

    public void actionSave(String spreadJson) {
        String convertSpreadJson = SpreadUtils.convertSpreadJson((String)spreadJson);
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, HashMap.class);
        String tempclassify = (String)this.getModel().getValue("tempclassify");
        Tuple realRowCol = null;
        DynamicObject tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId());
        Long cellConfId = (Long)this.getModel().getValue("cellconf_id");
        DynamicObject tempCellConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_fixtpl_cellset", (Long)cellConfId);
        DynamicObjectCollection dataTables = (DynamicObjectCollection)this.getModel().getValue("datatables");
        DynamicObjectCollection dataTpls = (DynamicObjectCollection)this.getModel().getValue("billtemps");
        StringBuilder tempconfMsg = null;
        StringBuilder cellconfMsg = null;
        if (StringUtils.equals((CharSequence)"3", (CharSequence)tempclassify)) {
            String endPo;
            cellconfMsg = this.checkCellConf(dataTables, dataTpls, tempCellConf);
            String string = endPo = tempConf == null ? null : tempConf.getString("areaend");
            if (StringUtils.isNotEmpty((CharSequence)endPo)) {
                int row = SpreadUtils.pos2Y((String)endPo);
                int col = SpreadUtils.pos2X((String)endPo);
                realRowCol = new Tuple((Object)row, (Object)col);
            }
        } else {
            tempconfMsg = this.checkTempConf(dataTables, dataTpls, tempConf);
            realRowCol = this.getTempConfMaxRowCol();
        }
        StringBuilder error = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)tempconfMsg)) {
            error.append((CharSequence)tempconfMsg);
        }
        if (StringUtils.isNotEmpty((CharSequence)cellconfMsg)) {
            error.append((CharSequence)cellconfMsg);
        }
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef", (String)"BillTempEditPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        convertSpreadJson = this.resetSpreadJson(spreadMap, realRowCol);
        Map sheets = (Map)spreadMap.get("sheets");
        Map sheet1 = (Map)sheets.get("Sheet1");
        Map data = sheet1 == null ? null : (Map)sheet1.get("data");
        Map dataTable = data == null ? null : (Map)data.get("dataTable");
        try (TXHandle h1 = TX.requiresNew();){
            try {
                this.resetConfCellName(dataTable, tempConf);
                this.saveOrUpdateTempConf(tempConf);
                this.saveOrUpdateTempCellConf(tempCellConf);
                RealRowAndCol realRowAndCol = this.getRealRowAndCol();
                this.getModel().setValue("spreadjson_tag", (Object)convertSpreadJson);
                this.getModel().setValue("realcol", (Object)realRowAndCol.getRealCol());
                this.getModel().setValue("realrow", (Object)realRowAndCol.getRealRow());
                this.getPageCache().put("spread", "yes");
                OperationResult operationResult = this.getView().invokeOperation(this.getView().getPageCache().get("operate"));
                this.getView().getPageCache().remove("operate");
                this.getPageCache().remove("setFlag");
                if (operationResult.isSuccess()) {
                    this.getModel().getDataEntity().getDataEntityState().setFromDatabase(true);
                    ((BillView)this.getView()).updateViewStatus();
                }
            }
            catch (Throwable e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    private StringBuilder checkCellConf(DynamicObjectCollection dataTables, DynamicObjectCollection dataTpls, DynamicObject tempConf) {
        DynamicObjectCollection cellConfs = tempConf == null ? null : tempConf.getDynamicObjectCollection("cellentryentity");
        StringBuilder errorMsg = new StringBuilder();
        if (cellConfs == null) {
            return errorMsg;
        }
        HashSet tplIds = Sets.newHashSetWithExpectedSize((int)2);
        if (dataTpls != null && !dataTpls.isEmpty()) {
            for (DynamicObject item : dataTpls) {
                long id = item.getLong("fbasedataid_id");
                tplIds.add(id);
            }
        }
        block1: for (DynamicObject cellConf : cellConfs) {
            DynamicObjectCollection dataTemps = cellConf.getDynamicObjectCollection("datatemps");
            if (dataTemps == null) continue;
            for (DynamicObject dataTemp : dataTemps) {
                long tplId = dataTemp.getLong("fbasedataid_id");
                if (tplId == 0L || tplIds.contains(tplId)) continue;
                int seq = cellConf.getInt("seq");
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5355\u5143\u8bbe\u7f6e\uff1a\u7b2c%s\u884c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u6570\u636e\u6a21\u677f\u3002\n", (String)"BillTempEditPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]), seq));
                continue block1;
            }
        }
        return errorMsg;
    }

    private StringBuilder checkTempConf(DynamicObjectCollection dataTables, DynamicObjectCollection dataTpls, DynamicObject tempConf) {
        long basetableId;
        if (tempConf == null) {
            return null;
        }
        DynamicObjectCollection fields = tempConf.getDynamicObjectCollection("fieldentryentity");
        StringBuilder errorMsg = new StringBuilder();
        HashSet tableIds = Sets.newHashSetWithExpectedSize((int)2);
        if (dataTables != null && !dataTables.isEmpty()) {
            for (DynamicObject item : dataTables) {
                long id = item.getLong("fbasedataid_id");
                tableIds.add(id);
            }
        }
        if ((basetableId = tempConf.getLong("basetable_id")) != 0L && !tableIds.contains(basetableId)) {
            errorMsg.append(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u8bbe\u7f6e\uff1a\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u4e3b\u6570\u636e\u8868\u3002\n", (String)"BillTempEditPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        if (fields == null) {
            return errorMsg;
        }
        HashSet tplIds = Sets.newHashSetWithExpectedSize((int)2);
        if (dataTpls != null && !dataTpls.isEmpty()) {
            for (DynamicObject item : dataTpls) {
                long id = item.getLong("fbasedataid_id");
                tplIds.add(id);
            }
        }
        for (DynamicObject field : fields) {
            int seq;
            long tplId = field.getLong("datatpl_id");
            long tableId = field.getLong("datatable_id");
            if (tplId != 0L && !tplIds.contains(tplId)) {
                seq = field.getInt("seq");
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u8868\u5217\u8bbe\u7f6e\uff1a\u7b2c%s\u884c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u6570\u636e\u6a21\u677f\u3002\n", (String)"BillTempEditPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]), seq));
            }
            if (tableId == 0L || tableIds.contains(tableId)) continue;
            seq = field.getInt("seq");
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u8868\u5217\u8bbe\u7f6e\uff1a\u7b2c%s\u884c\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u6570\u636e\u8868\u3002\n", (String)"BillTempEditPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]), seq));
        }
        return errorMsg;
    }

    private void resetConfCellName(Map<String, Object> dataTable, DynamicObject tempConf) {
        DynamicObjectCollection fields;
        if (tempConf == null || dataTable == null) {
            return;
        }
        DynamicObjectCollection heads = tempConf.getDynamicObjectCollection("headentryentity");
        if (heads != null && !heads.isEmpty()) {
            for (DynamicObject head : heads) {
                int row = head.getInt("headrow");
                int col = head.getInt("headcol");
                String cellValue = (String)SpreadPraseUtil.getCellValue(dataTable, (Integer)col, (Integer)row, (int)2);
                head.set("headname", (Object)cellValue);
            }
        }
        if ((fields = tempConf.getDynamicObjectCollection("fieldentryentity")) != null && !fields.isEmpty()) {
            for (DynamicObject field : fields) {
                String position = field.getString("fieldcellpo");
                int row = SpreadUtils.pos2Y((String)position);
                int col = field.getInt("cellcol");
                String cellValue = (String)SpreadPraseUtil.getCellValue(dataTable, (Integer)col, (Integer)row, (int)2);
                field.set("fieldcellname", (Object)cellValue);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) && !this.hasSetSpread()) {
            this.getView().getPageCache().put("operate", key);
            this.getSpreadContainer().getSpreadJson("actionSave");
            args.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key) && !this.hasSetSpread()) {
            if (this.confirmSubmit()) {
                this.getView().getPageCache().put("operate", "submit");
                this.getSpreadContainer().getSpreadJson("actionSave");
            }
            args.setCancel(true);
        }
    }

    private boolean confirmSubmit() {
        DynamicObjectCollection fields;
        String tempclassify = (String)this.getModel().getValue("tempclassify");
        if (StringUtils.equals((CharSequence)"3", (CharSequence)tempclassify)) {
            return true;
        }
        boolean hasComfirm = StringUtils.equals((CharSequence)"yes", (CharSequence)this.getPageCache().get("submitConfirm"));
        if (hasComfirm) {
            return true;
        }
        String msg = null;
        DynamicObject tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId());
        DynamicObjectCollection dynamicObjectCollection = fields = tempConf == null ? null : tempConf.getDynamicObjectCollection("fieldentryentity");
        if (fields == null || fields.isEmpty()) {
            msg = ResManager.loadKDString((String)"%s:\u8868\u5217\u672a\u914d\u7f6e\u3002", (String)"BillTempEditPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty(msg)) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("confirm_submit");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u63d0\u4ea4?", (String)"BillTempEditPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%s:\u8868\u5217\u672a\u914d\u7f6e\u3002", (String)"BillTempEditPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]), this.getModel().getValue("number")), MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener);
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String back = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"confirm_submit", (CharSequence)back)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("submitConfirm", "yes");
                this.getView().invokeOperation("submit");
            } else {
                this.getPageCache().remove("submitConfirm");
            }
        }
    }

    private boolean hasSetSpread() {
        return StringUtils.equals((CharSequence)"yes", (CharSequence)this.getPageCache().get("spread"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean issuccess;
        super.afterDoOperation(e);
        this.getPageCache().remove("spread");
        this.getPageCache().remove("submitConfirm");
        FormOperate operate = (FormOperate)e.getSource();
        String key = operate.getOperateKey();
        boolean bl = issuccess = e.getOperationResult() == null || e.getOperationResult().isSuccess();
        if (operate instanceof Delete && issuccess) {
            this.deleteTempConfCache();
        }
    }

    private void deleteTempConfCache() {
        DataEntityCacheUtil.deleteDataEntity((IPageCache)this.getPageCache(), (String)"phm_billtemp_set");
        DataEntityCacheUtil.deleteDataEntity((IPageCache)this.getPageCache(), (String)"phm_fixtpl_cellset");
    }

    private void copyTempConf(DynamicObject datatemp) {
        DynamicObject conf;
        DynamicObject cellConf;
        DynamicObject conf2;
        DynamicObject tempConf = datatemp.getDynamicObject("tempconf");
        if (tempConf != null && (conf2 = BusinessDataServiceHelper.loadSingle((Object)tempConf.getLong("id"), (String)"phm_billtemp_set")) != null) {
            conf2 = (DynamicObject)OrmUtils.clone((Object)conf2, (IDataEntityType)conf2.getDataEntityType(), (boolean)false, (boolean)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{conf2});
            datatemp.set("tempconf_id", (Object)conf2.getLong("id"));
        }
        if ((cellConf = datatemp.getDynamicObject("cellconf")) != null && (conf = BusinessDataServiceHelper.loadSingle((Object)cellConf.getLong("id"), (String)"phm_fixtpl_cellset")) != null) {
            conf = (DynamicObject)OrmUtils.clone((Object)conf, (IDataEntityType)conf.getDataEntityType(), (boolean)false, (boolean)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{conf});
            datatemp.set("cellconf_id", (Object)conf.getLong("id"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit resource = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = resource.getKey();
        if (StringUtils.equals((CharSequence)"billtemps", (CharSequence)key)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("publish", "=", (Object)"2"));
        } else if ("versionrule".equals(key)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("validated_time", "<=", (Object)new Date()));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        int ordinal = dataEntity.getDynamicObjectType().getProperty("tempclassify").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(ordinal, false);
        int publish = dataEntity.getDynamicObjectType().getProperty("publish").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(publish, false);
        int tempconf = dataEntity.getDynamicObjectType().getProperty("tempconf").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(tempconf, false);
        int cellconf = dataEntity.getDynamicObjectType().getProperty("cellconf").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(cellconf, false);
        int realrow = dataEntity.getDynamicObjectType().getProperty("realrow").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(realrow, false);
        int realcol = dataEntity.getDynamicObjectType().getProperty("realcol").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(realcol, false);
        int spreadjson_tag = dataEntity.getDynamicObjectType().getProperty("spreadjson_tag").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(spreadjson_tag, false);
    }

    public void afterCopyData(EventObject e) {
        BaseModel baseModel = (BaseModel)e.getSource();
        DynamicObject datatemp = baseModel.getDataEntity();
        datatemp.set("publish", (Object)"1");
        this.copyTempConf(datatemp);
    }

    public Boolean isSameOrg() {
        String createorgId;
        String useorgId = (String)this.getView().getFormShowParameter().getCustomParam("useorgId");
        if (StringUtils.equals((CharSequence)useorgId, (CharSequence)(createorgId = String.valueOf(this.getModel().getValue("createorg_id"))))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Tuple<Integer, Integer> getTempConfMaxRowCol() {
        DynamicObjectCollection fieldConfs;
        int row = 0;
        int col = 0;
        int confRow = 0;
        int confCol = 0;
        DynamicObject tempConf = DataEntityCacheUtil.getDataEntry((IPageCache)this.getPageCache(), (String)"phm_billtemp_set", (Long)this.getBillTempConfId());
        DynamicObjectCollection headConfs = tempConf == null ? null : tempConf.getDynamicObjectCollection("headentryentity");
        DynamicObjectCollection dynamicObjectCollection = fieldConfs = tempConf == null ? null : tempConf.getDynamicObjectCollection("fieldentryentity");
        if (headConfs != null && !headConfs.isEmpty()) {
            for (DynamicObject headConf : headConfs) {
                confRow = headConf.getInt("headrow");
                confCol = headConf.getInt("headcol");
                row = Math.max(row, confRow);
                col = Math.max(col, confCol);
            }
        }
        if (fieldConfs != null && !fieldConfs.isEmpty()) {
            for (DynamicObject fieldConf : fieldConfs) {
                String position = fieldConf.getString("fieldcellpo");
                confRow = SpreadUtils.pos2Y((String)position);
                confCol = fieldConf.getInt("cellcol");
                row = Math.max(row, confRow);
                col = Math.max(col, confCol);
            }
        }
        return new Tuple((Object)row, (Object)col);
    }
}

