/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.OperateParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.enums.FieldType;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.Cell;

public class BillTempTableSetPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String DATATABLE_CLOUMNLIST_CLOSE = "datatable_cloumnlist_close";
    private static final String[] FIELDS = new String[]{"fieldcellpo", "cellcol", "fieldcellname", "field"};
    private static final String[] HEADFIELDS = new String[]{"headcellpo", "headcol", "headrow", "headname"};

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldnumber", "headcelllogic", "calculateconf", "baseset"});
        BasedataEdit entity = (BasedataEdit)this.getControl("basetable");
        entity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datatable = (BasedataEdit)this.getControl("datatable");
        datatable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datatpl = (BasedataEdit)this.getControl("datatpl");
        datatpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String tempConfString = (String)billShowParameter.getCustomParam("phm_billtemp_set");
        if (StringUtils.isNotEmpty((CharSequence)tempConfString)) {
            DataEntityDeserializerOption option = new DataEntityDeserializerOption();
            option.setIncludeDataEntityState(true);
            DynamicObject tempConf = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)tempConfString, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"phm_billtemp_set"), (DataEntityDeserializerOption)option);
            this.resetTempConf(tempConf);
            BillModel model = (BillModel)this.getModel();
            model.fillReferenceData((Object[])new DynamicObject[]{tempConf}, tempConf.getDataEntityType());
            model.push((Object)tempConf);
        }
        this.initModal();
        this.cacheMainDataLineFieldSet();
    }

    private void cacheMainDataLineFieldSet() {
        String confType = (String)this.getView().getFormShowParameter().getCustomParam("confType");
        if (StringUtils.equals((CharSequence)"field", (CharSequence)confType)) {
            String value = (String)this.getModel().getValue("selectline");
            if (StringUtils.isBlank((CharSequence)value)) {
                return;
            }
            int selectLine = Integer.parseInt(value);
            DynamicObjectCollection fields = this.getModel().getEntryEntity("fieldentryentity");
            List selectLineFieldList = fields.stream().filter(x -> selectLine == x.getInt("cellcol")).collect(Collectors.toList());
            if (selectLineFieldList.size() == 0) {
                return;
            }
            DynamicObject selectLineFieldSet = (DynamicObject)selectLineFieldList.get(0);
            HashMap<String, String> selectLineFieldSetMap = new HashMap<String, String>(5);
            selectLineFieldSetMap.put("dataresource", selectLineFieldSet.getString("dataresource"));
            selectLineFieldSetMap.put("datatable", selectLineFieldSet.getString("datatable"));
            selectLineFieldSetMap.put("fieldnumber", selectLineFieldSet.getString("fieldnumber"));
            selectLineFieldSetMap.put("fieldtype", selectLineFieldSet.getString("fieldtype"));
            selectLineFieldSetMap.put("fieldlogic", selectLineFieldSet.getString("fieldlogic"));
            this.getPageCache().put("selectLineFieldSetMap", SerializationUtils.toJsonString(selectLineFieldSetMap));
        }
    }

    private void resetTempConf(DynamicObject tempConf) {
        long basetableId;
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String confType = (String)showParameter.getCustomParam("confType");
        List dataTables = (List)this.getView().getFormShowParameter().getCustomParam("dataTables");
        HashSet tableIds = Sets.newHashSetWithExpectedSize((int)2);
        if (dataTables != null && !dataTables.isEmpty()) {
            dataTables.forEach(table -> {
                Map baseDataId = (Map)table.get("fbasedataid");
                Long masterid = (Long)baseDataId.get("id");
                tableIds.add(masterid);
            });
        }
        if (StringUtils.equals((CharSequence)"basedataset", (CharSequence)confType) && (basetableId = tempConf.getLong("basetable_id")) != 0L && !tableIds.contains(basetableId)) {
            tempConf.set("basetable_id", null);
            tempConf.set("selectline", null);
            tempConf.set("selectlinetype", null);
            tempConf.set("baseset", null);
            tempConf.set("sqlset_tag", null);
        }
        DynamicObjectCollection fields = tempConf.getDynamicObjectCollection("fieldentryentity");
        if (StringUtils.equals((CharSequence)"field", (CharSequence)confType) && fields == null) {
            return;
        }
        List billtemps = (List)this.getView().getFormShowParameter().getCustomParam("billTemps");
        HashSet tplIds = Sets.newHashSetWithExpectedSize((int)2);
        if (billtemps != null && !billtemps.isEmpty()) {
            billtemps.forEach(temp -> {
                Map baseDataId = (Map)temp.get("fbasedataid");
                Long masterid = (Long)baseDataId.get("id");
                tplIds.add(masterid);
            });
        }
        for (DynamicObject field : fields) {
            long tplId = field.getLong("datatpl_id");
            long tableId = field.getLong("datatable_id");
            if (tplId != 0L && !tplIds.contains(tplId)) {
                field.set("datatpl_id", null);
                field.set("fieldformula", null);
                field.set("fieldformula_tag", null);
            }
            if (tableId == 0L || tableIds.contains(tableId)) continue;
            field.set("datatable_id", null);
            field.set("datatpl_id", null);
            field.set("fieldname", null);
            field.set("fieldnumber", null);
            field.set("startrow", null);
        }
    }

    public void afterBindData(EventObject e) {
    }

    private void initModal() {
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String status = (String)showParameter.getCustomParam("status");
        this.getModel().setValue("status", (Object)status);
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btlsave"});
        }
        String tempType = (String)showParameter.getCustomParam("tempType");
        String confType = (String)showParameter.getCustomParam("confType");
        if (StringUtils.equals((CharSequence)"head", (CharSequence)confType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldadvconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap"});
            this.createHeadEntryRow(false);
        } else if (StringUtils.equals((CharSequence)"field", (CharSequence)confType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"headadvconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap"});
            this.createFieldEntryRow();
        } else if (StringUtils.equals((CharSequence)"basedataset", (CharSequence)confType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldadvconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"headadvconap"});
            this.getSelectComboItems();
        }
    }

    private void createHeadEntryRow(boolean isNewConf) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String cells = (String)showParameter.getCustomParam("selectCells");
        if (cells == null) {
            return;
        }
        List selectCells = SerializationUtils.fromJsonStringToList((String)cells, Cell.class);
        HashMap cellSets = null;
        if (!isNewConf) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("headentryentity");
            cellSets = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
            for (DynamicObject entry : dynamicObjects) {
                int col = entry.getInt("headcol");
                int row = entry.getInt("headrow");
                int seq = entry.getInt("seq");
                Cell cell = new Cell();
                cell.setRow(row);
                cell.setCol(col);
                cell.setSeq(seq);
                cell.setValue((Object)entry.getString("headname"));
                cellSets.put(cell, cell);
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(HEADFIELDS);
        for (Cell cell : selectCells) {
            int seq;
            if (cell.getMerge() != null && cell.getMerge().booleanValue()) continue;
            Cell oldCell = cellSets == null ? null : (Cell)cellSets.get(cell);
            int n = seq = oldCell == null ? 0 : oldCell.getSeq();
            if (oldCell != null) {
                if (StringUtils.equals((CharSequence)((String)cell.getValue()), (CharSequence)((String)oldCell.getValue()))) continue;
                this.getModel().setValue("headname", cell.getValue(), seq - 1);
                continue;
            }
            String position = SpreadUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
            tvs.addRow(new Object[]{position, cell.getCol(), cell.getRow(), cell.getValue()});
        }
        model.batchCreateNewEntryRow("headentryentity", tvs);
        model.endInit();
        this.getView().updateView("headentryentity");
    }

    private void createFieldEntryRow() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String cells = (String)showParameter.getCustomParam("selectCells");
        if (cells == null) {
            return;
        }
        List selectCells = SerializationUtils.fromJsonStringToList((String)cells, Cell.class);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("fieldentryentity");
        HashMap cellMaps = Maps.newHashMapWithExpectedSize((int)selectCells.size());
        dynamicObjects.forEach(c -> {
            int col = c.getInt("cellcol");
            Cell cell = new Cell(c.getString("fieldcellpo"), 0, col, c.getInt("seq"));
            cell.setValue((Object)"fieldcellname");
            cellMaps.put(col, cell);
        });
        StringBuilder errorMsg = new StringBuilder();
        int errorCunt = 0;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(FIELDS);
        for (Cell cell : selectCells) {
            if (cell.getMerge() != null && cell.getMerge().booleanValue()) continue;
            String position = SpreadUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
            String xPos = SpreadUtils.int2pos((int)cell.getCol());
            int col = cell.getCol();
            Cell excell = (Cell)cellMaps.get(col);
            if (excell != null) {
                if (!StringUtils.equals((CharSequence)position, (CharSequence)excell.getPosition())) {
                    errorMsg.append(position).append(ResManager.loadKDString((String)":\u4e0e\u5df2\u8bbe\u7f6e\u7684\u8868\u5217\u5b58\u5728\u91cd\u590d\u5217\u3002\n", (String)"BillTempTableSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    ++errorCunt;
                    continue;
                }
                if (StringUtils.equals((CharSequence)((String)excell.getValue()), (CharSequence)((String)cell.getValue()))) continue;
                model.setValue("fieldcellname", cell.getValue(), excell.getSeq() - 1);
                continue;
            }
            tvs.addRow(new Object[]{position, col, cell.getValue(), xPos});
        }
        model.batchCreateNewEntryRow("fieldentryentity", tvs);
        model.endInit();
        this.getView().updateView("fieldentryentity");
        if (StringUtils.isNotEmpty((CharSequence)errorMsg) && errorCunt == 1) {
            this.getView().showTipNotification(errorMsg.toString());
        } else if (StringUtils.isNotEmpty((CharSequence)errorMsg) && errorCunt > 1) {
            this.getView().showMessage("", errorMsg.toString(), MessageTypes.Default);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"fieldnumber", (CharSequence)key)) {
            this.openDataTableCloumnsForm();
        } else if (StringUtils.equals((CharSequence)"headcelllogic", (CharSequence)key)) {
            this.openHeadFormluaForm();
        } else if (StringUtils.equals((CharSequence)"calculateconf", (CharSequence)key)) {
            this.openFieldFormluaForm();
        } else if (StringUtils.equals((CharSequence)"baseset", (CharSequence)key)) {
            this.openBaseDataSetForm();
        }
    }

    private void openBaseDataSetForm() {
        Object selectlinetype;
        Long basetableId = (Long)this.getModel().getValue("basetable_id");
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("phm_basedata_set");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "basedataClose"));
        listShowParameter.setCustomParam("basetableId", (Object)basetableId);
        Object baseset = this.getModel().getValue("baseset");
        Object sqlset = this.getModel().getValue("sqlset_tag");
        if (Objects.nonNull(baseset)) {
            listShowParameter.setCustomParam("sql", (Object)baseset.toString());
        }
        if (Objects.nonNull(sqlset)) {
            listShowParameter.setCustomParam("storevalue_tag", (Object)sqlset.toString());
        }
        if ((selectlinetype = this.getModel().getValue("selectlinetype")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5bf9\u9009\u62e9\u5217\u8fdb\u884c\u5b57\u6bb5\u7c7b\u578b\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"BillTempTableSetPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        listShowParameter.setCustomParam("fieldType", (Object)selectlinetype.toString());
        this.getView().showForm(listShowParameter);
    }

    private void openHeadFormluaForm() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("headentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        String targetVariable = (String)this.getModel().getValue("headcellpo", selectRow);
        String expression = (String)this.getModel().getValue("headcelllogic", selectRow);
        String headname = (String)this.getModel().getValue("headname", selectRow);
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("phm_tableheader_setting");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "headcelllogic"));
        listShowParameter.setCustomParam("targetVariable", (Object)targetVariable);
        listShowParameter.setCustomParam("expression", (Object)expression);
        listShowParameter.setCustomParam("name", (Object)headname);
        this.getView().showForm(listShowParameter);
    }

    private void openFieldFormluaForm() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        String dataResource = (String)this.getModel().getValue("dataresource", selectRow);
        String fieldtype = (String)this.getModel().getValue("fieldtype", selectRow);
        if (!"BIGINT".equals(fieldtype) && !"DECIMAL".equals(fieldtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6574\u6570\u548c\u6d6e\u70b9\u6570\u7684\u624d\u80fd\u8fdb\u884c\u8ba1\u7b97\u6761\u4ef6\u914d\u7f6e\u3002", (String)"BillTempTableSetPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)"2", (CharSequence)dataResource)) {
            this.openDataTempForluaForm(selectRow);
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)dataResource)) {
            this.openCalculateForluaForm(selectRow);
        }
    }

    private void openCalculateForluaForm(int selectRow) {
        Integer cellcol = (Integer)this.getModel().getValue("cellcol", selectRow);
        String calculateconf = (String)this.getModel().getValue("calculateconf", selectRow);
        String col = SpreadUtils.int2pos((int)cellcol);
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("phm_tplcalculate_set");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cellCalculate"));
        listShowParameter.setCustomParam("col", (Object)col);
        listShowParameter.setCustomParam("calculateconf", (Object)calculateconf);
        this.getView().showForm(listShowParameter);
    }

    private void openDataTempForluaForm(int selectRow) {
        String targetVariable = (String)this.getModel().getValue("fieldcellpo", selectRow);
        String fieldformula = (String)this.getModel().getValue("fieldformula", selectRow);
        String fieldtype = (String)this.getModel().getValue("fieldtype", selectRow);
        Object format = this.getModel().getValue("format", selectRow);
        Long sourceTempId = (Long)this.getModel().getValue("datatpl_id", selectRow);
        if (sourceTempId == null || sourceTempId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6a21\u677f\u3002", (String)"BillTempTableSetPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("phm_tableline_setting");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calculateconf"));
        listShowParameter.setCustomParam("targetline", (Object)targetVariable);
        listShowParameter.setCustomParam("expressionAll", (Object)fieldformula);
        listShowParameter.setCustomParam("targetType", (Object)fieldtype);
        listShowParameter.setCustomParam("sourceTempId", (Object)sourceTempId);
        listShowParameter.setCustomParam("format", format);
        HashMap<String, String> sourceTreeMap = new HashMap<String, String>(16);
        DynamicObjectCollection fieldentryentity = this.getModel().getEntryEntity("fieldentryentity");
        for (DynamicObject dynamicObject : fieldentryentity) {
            String fieldcellname = dynamicObject.getString("fieldcellname");
            String fieldcellpo = dynamicObject.getString("fieldcellpo");
            if (StringUtils.isBlank((CharSequence)fieldcellpo)) continue;
            String treeNodeName = fieldcellpo.trim().concat("_").concat(StringUtils.isBlank((CharSequence)fieldcellname) ? "Null" : fieldcellname.trim());
            sourceTreeMap.put(treeNodeName, fieldcellpo.trim());
        }
        listShowParameter.setCustomParam("targetTreeMap", (Object)JSONObject.toJSONString(sourceTreeMap));
        this.getView().showForm(listShowParameter);
    }

    private void openDataTableCloumnsForm() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        Long dataTableId = (Long)this.getModel().getValue("datatable_id", selectRow);
        String dataresource = (String)this.getModel().getValue("dataresource", selectRow);
        if (dataTableId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8868\u3002", (String)"BillTempTableSetPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)dataresource)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u5fc5\u987b\u4e3a\u6570\u636e\u8868\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5b57\u6bb5\u3002", (String)"BillTempTableSetPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("600px");
        css.setHeight("420px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setFormId("phm_datatable_cloumnlist");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATATABLE_CLOUMNLIST_CLOSE));
        listShowParameter.setCustomParam("dataTableId", (Object)dataTableId);
        this.getView().showForm(listShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeDatas = e.getChangeSet();
        ChangeData data = changeDatas[0];
        if (StringUtils.equals((CharSequence)"dataresource", (CharSequence)name)) {
            this.afterDataResourceChange(data);
        } else if (StringUtils.equals((CharSequence)"basetable", (CharSequence)name)) {
            this.getModel().setValue("baseset", null);
        } else if (StringUtils.equals((CharSequence)"datatable", (CharSequence)name)) {
            this.afterDataTableChange(data);
        } else if (StringUtils.equals((CharSequence)"datatpl", (CharSequence)name)) {
            this.afterDataTplChange(data);
        } else if (StringUtils.equals((CharSequence)"fieldnumber", (CharSequence)name)) {
            this.afterFieldNumberChange(data);
        } else if (StringUtils.equals((CharSequence)"calculateconf", (CharSequence)name)) {
            this.afterCalculateconfChange(data);
        } else if (StringUtils.equals((CharSequence)"fieldlogic", (CharSequence)name)) {
            this.afterFieldLogicChange(data);
        } else if (StringUtils.equals((CharSequence)"selectline", (CharSequence)name)) {
            if (data.getNewValue() == null) {
                return;
            }
            this.getModel().setValue("selectlinetype", null);
            this.getModel().setValue("basetable", null);
            this.getModel().setValue("baseset", null);
            this.getModel().setValue("sqlset_tag", null);
            DynamicObject dataTableSet = this.getBaseTableSet(data.getNewValue().toString());
            if (dataTableSet == null) {
                return;
            }
            this.getModel().setValue("selectlinetype", (Object)dataTableSet.getString("fieldtype"));
            if ("1".equals(dataTableSet.getString("fieldlogic"))) {
                this.getModel().setValue("basetable", (Object)dataTableSet.getLong("datatable_id"));
            }
        }
    }

    private void afterCalculateconfChange(ChangeData data) {
        if (data == null) {
            return;
        }
        int index = data.getRowIndex();
        String newValue = (String)data.getNewValue();
        if (StringUtils.isNotEmpty((CharSequence)newValue)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue("fieldformula", null, index);
        this.getModel().setValue("format", (Object)2, index);
        this.getModel().setValue("fieldformula_tag", null, index);
        this.getModel().endInit();
        this.getView().updateView("fieldformula", index);
        this.getView().updateView("fieldformula_tag", index);
        this.getView().updateView("format", index);
    }

    private void afterFieldLogicChange(ChangeData data) {
        if (data == null) {
            return;
        }
        int index = data.getRowIndex();
        this.getModel().beginInit();
        this.getModel().setValue("startrow", null, index);
        this.getModel().endInit();
        this.getView().updateView("startrow", index);
    }

    private DynamicObject getBaseTableSet(String data) {
        DynamicObjectCollection fieldentryentity = this.getModel().getEntryEntity("fieldentryentity");
        List fieldcellpo = fieldentryentity.stream().filter(x -> data.equals(x.getString("cellcol"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fieldcellpo)) {
            return null;
        }
        return (DynamicObject)fieldcellpo.get(0);
    }

    private void afterFieldNumberChange(ChangeData data) {
        if (data == null) {
            return;
        }
        String name = (String)data.getNewValue();
        String logic = "2";
        int index = data.getRowIndex();
        if (StringUtils.isEmpty((CharSequence)name)) {
            logic = null;
        }
        this.getModel().setValue("fieldlogic", (Object)logic, index);
    }

    private void getSelectComboItems() {
        DynamicObjectCollection fieldentryentity = this.getModel().getEntryEntity("fieldentryentity");
        ComboEdit comboEdit = (ComboEdit)this.getControl("selectline");
        ArrayList<ComboItem> selectlineData = new ArrayList<ComboItem>(fieldentryentity.size());
        for (DynamicObject dynamicObject : fieldentryentity) {
            if (!"1".equals(dynamicObject.getString("fieldlogic")) && !"4".equals(dynamicObject.getString("fieldlogic"))) continue;
            selectlineData.add(new ComboItem(new LocaleString(dynamicObject.getString("fieldcellpo").concat("(").concat(dynamicObject.getString("fieldcellname")).concat(")")), dynamicObject.getString("cellcol")));
        }
        comboEdit.setComboItems(selectlineData);
    }

    private void afterDataTplChange(ChangeData data) {
        if (data == null) {
            return;
        }
        DynamicObject table = (DynamicObject)data.getNewValue();
        Long newValue = null;
        if (table != null) {
            newValue = table.getLong("id");
        }
        int index = data.getRowIndex();
        String dataresource = (String)this.getModel().getValue("dataresource", index);
        if (!StringUtils.equals((CharSequence)"2", (CharSequence)dataresource)) {
            this.getModel().beginInit();
            this.getModel().setValue("datatpl", null, index);
            this.getModel().endInit();
            this.getView().updateView("datatpl", index);
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("calculateconf", null, index);
            this.getModel().setValue("fieldformula", null, index);
            this.getModel().setValue("format", (Object)2, index);
            this.getModel().endInit();
            this.getView().updateView("calculateconf", index);
            this.getView().updateView("fieldformula", index);
            this.getView().updateView("format", index);
        }
    }

    private void afterDataTableChange(ChangeData data) {
        if (data == null) {
            return;
        }
        DynamicObject table = (DynamicObject)data.getNewValue();
        Long newValue = null;
        if (table != null) {
            newValue = table.getLong("id");
        }
        int index = data.getRowIndex();
        String dataresource = (String)this.getModel().getValue("dataresource", index);
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)dataresource)) {
            this.getModel().beginInit();
            this.getModel().setValue("datatable", null, index);
            this.getModel().endInit();
            this.getView().updateView("datatable", index);
        } else {
            this.getModel().setValue("fieldnumber", null, index);
            this.getModel().setValue("fieldname", null, index);
        }
    }

    private void afterDataResourceChange(ChangeData data) {
        if (data == null) {
            return;
        }
        String newValue = (String)data.getNewValue();
        int index = data.getRowIndex();
        String fieldlogic = null;
        String fileType = FieldType.NVARCHAR.getValue();
        switch (newValue) {
            case "2": {
                fieldlogic = "3";
                break;
            }
            case "3": {
                fieldlogic = "4";
                break;
            }
            case "4": {
                fieldlogic = "5";
                fileType = FieldType.DECIMAL.getValue();
                break;
            }
            case "5": {
                fieldlogic = "6";
                break;
            }
        }
        this.getModel().setValue("fieldlogic", (Object)fieldlogic, index);
        this.getModel().beginInit();
        this.getModel().setValue("datatable", null, index);
        this.getModel().setValue("datatpl", null, index);
        this.getModel().setValue("calculateconf", null, index);
        this.getModel().setValue("fieldformula", null, index);
        this.getModel().setValue("format", (Object)2, index);
        this.getModel().setValue("fieldformula_tag", null, index);
        this.getModel().setValue("fieldnumber", null, index);
        this.getModel().setValue("fieldtype", (Object)fileType, index);
        this.getModel().setValue("fieldname", null, index);
        this.getModel().setValue("startrow", null, index);
        this.getModel().endInit();
        this.getView().updateView("datatable", index);
        this.getView().updateView("datatpl", index);
        this.getView().updateView("calculateconf", index);
        this.getView().updateView("fieldformula", index);
        this.getView().updateView("format", index);
        this.getView().updateView("fieldnumber", index);
        this.getView().updateView("fieldformula_tag", index);
        this.getView().updateView("fieldtype", index);
        this.getView().updateView("fieldname", index);
        this.getView().updateView("startrow", index);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionid;
        switch (actionid = closedCallBackEvent.getActionId()) {
            case "datatable_cloumnlist_close": {
                this.afterSelectTableField(closedCallBackEvent);
                break;
            }
            case "headcelllogic": {
                this.afterSetHeadLogic(closedCallBackEvent);
                break;
            }
            case "calculateconf": {
                this.afterSetFieldLogic(closedCallBackEvent);
                break;
            }
            case "basedataClose": {
                this.afterBasedataClose(closedCallBackEvent);
                break;
            }
            case "cellCalculate": {
                this.afterSetCalculate(closedCallBackEvent);
            }
        }
    }

    private void afterSetCalculate(ClosedCallBackEvent closedCallBackEvent) {
        String returnDate = (String)closedCallBackEvent.getReturnData();
        if (returnDate == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentryentity");
        int[] selectIndexRows = entryGrid.getSelectRows();
        int selectIndex = selectIndexRows[0];
        this.getModel().setValue("calculateconf", (Object)returnDate, selectIndex);
    }

    private void afterBasedataClose(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        Map dataMap = (Map)returnData;
        this.getModel().setValue("baseset", dataMap.get("sql"));
        this.getModel().setValue("sqlset_tag", dataMap.get("storevalue_tag"));
    }

    private void afterSetHeadLogic(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String[] data = (String[])returnData;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("headentryentity");
        int[] selectIndexRows = entryGrid.getSelectRows();
        int selectIndex = selectIndexRows[0];
        this.getModel().setValue("headcelllogic", (Object)data[0], selectIndex);
        this.getModel().setValue("headformula", (Object)data[1], selectIndex);
    }

    private void afterSetFieldLogic(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        Map data = (Map)returnData;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentryentity");
        int[] selectIndexRows = entryGrid.getSelectRows();
        int selectIndex = selectIndexRows[0];
        this.getModel().beginInit();
        this.getModel().setValue("fieldformula", data.get("formula"), selectIndex);
        this.getModel().setValue("format", data.get("format"), selectIndex);
        this.getModel().setValue("calculateconf", (Object)ResManager.loadKDString((String)"\u5df2\u914d\u7f6e", (String)"BillTempTableSetPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]), selectIndex);
        this.getModel().endInit();
        this.getView().updateView("fieldformula", selectIndex);
        this.getView().updateView("calculateconf", selectIndex);
        this.getView().updateView("format", selectIndex);
    }

    private void afterSelectTableField(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        DynamicObject field = (DynamicObject)returnData;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentryentity");
        int[] selectIndexRows = entryGrid.getSelectRows();
        int selectIndex = selectIndexRows[0];
        this.getModel().setValue("fieldname", (Object)field.getString("fielddescription"), selectIndex);
        this.getModel().setValue("fieldnumber", (Object)field.getString("fieldname"), selectIndex);
        this.getModel().setValue("fieldtype", (Object)field.getString("fieldtype"), selectIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"dosave", (CharSequence)key)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String confType = (String)showParameter.getCustomParam("confType");
            Boolean sameOrg = (Boolean)showParameter.getCustomParam("sameOrg");
            if (sameOrg == null || !sameOrg.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"BillTempTableSetPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            operate.getOption().setVariableValue("confType", confType);
        } else if ("deletefieldentry".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("fieldentryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Integer> selectList = new ArrayList<Integer>(selectRows.length);
            HashMap<String, String> lineToCellColPoMap = new HashMap<String, String>(selectRows.length);
            ArrayList<Integer> cellColList = new ArrayList<Integer>(selectRows.length);
            for (int selectRow : selectRows) {
                selectList.add(selectRow);
                Object fieldcellpo = this.getModel().getValue("fieldcellpo", selectRow);
                if (fieldcellpo == null) continue;
                lineToCellColPoMap.put(Integer.toString(selectRow + 1), fieldcellpo.toString());
                Object cellCol = this.getModel().getValue("cellcol", selectRow);
                cellColList.add((Integer)cellCol);
            }
            DynamicObjectCollection fieldentryentity = this.getModel().getEntryEntity("fieldentryentity");
            for (int i = 0; i < fieldentryentity.size(); ++i) {
                String expressionAll;
                if (selectList.contains(i) || StringUtils.isBlank((CharSequence)(expressionAll = ((DynamicObject)fieldentryentity.get(i)).getString("fieldformula")))) continue;
                String[] formulaSplit = expressionAll.split("&");
                String[] split = formulaSplit[3].split("\\)");
                String[] conditionFormulaSplit = split[0].split(",");
                String targetConditionCell = conditionFormulaSplit[1].trim();
                for (Map.Entry stringStringEntry : lineToCellColPoMap.entrySet()) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)stringStringEntry.getValue()), (CharSequence)targetConditionCell)) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c", (String)"BillTempTableSetPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]).concat((String)stringStringEntry.getKey()).concat(ResManager.loadKDString((String)"\u884c\u6570\u636e\u88ab\u7b2c", (String)"BillTempTableSetPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0])).concat(Integer.toString(i + 1)).concat(ResManager.loadKDString((String)"\u884c\u6570\u636e\u5f15\u7528\u3002", (String)"BillTempTableSetPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
                    args.setCancel(true);
                    return;
                }
            }
            String value = (String)this.getModel().getValue("selectline");
            if (StringUtils.isNotBlank((CharSequence)value) && cellColList.contains(Integer.parseInt(value))) {
                this.getPageCache().put("deleteMainLine", "true");
            }
        }
    }

    private boolean checkMainFieldSetChange() {
        String selectLineFieldSetMapString = this.getPageCache().get("selectLineFieldSetMap");
        if (StringUtils.isBlank((CharSequence)selectLineFieldSetMapString)) {
            return false;
        }
        Map selectLineFieldSetMap = (Map)SerializationUtils.fromJsonString((String)selectLineFieldSetMapString, Map.class);
        int selectLine = Integer.parseInt(this.getModel().getValue("selectline").toString());
        DynamicObjectCollection fields = this.getModel().getEntryEntity("fieldentryentity");
        List selectLineFieldList = fields.stream().filter(x -> selectLine == x.getInt("cellcol")).collect(Collectors.toList());
        if (selectLineFieldList.size() == 0) {
            return false;
        }
        DynamicObject selectLineFieldSet = (DynamicObject)selectLineFieldList.get(0);
        boolean dataResource = StringUtils.equals((CharSequence)((CharSequence)selectLineFieldSetMap.get("dataresource")), (CharSequence)selectLineFieldSet.getString("dataresource"));
        boolean dataTable = StringUtils.equals((CharSequence)((CharSequence)selectLineFieldSetMap.get("datatable")), (CharSequence)selectLineFieldSet.getString("datatable"));
        boolean fieldNumber = StringUtils.equals((CharSequence)((CharSequence)selectLineFieldSetMap.get("fieldnumber")), (CharSequence)selectLineFieldSet.getString("fieldnumber"));
        boolean fieldType = StringUtils.equals((CharSequence)((CharSequence)selectLineFieldSetMap.get("fieldtype")), (CharSequence)selectLineFieldSet.getString("fieldtype"));
        boolean fieldLogic = StringUtils.equals((CharSequence)((CharSequence)selectLineFieldSetMap.get("fieldlogic")), (CharSequence)selectLineFieldSet.getString("fieldlogic"));
        return !dataResource || !dataTable || !fieldNumber || !fieldType || !fieldLogic;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String action = event.getCallBackId();
        if (StringUtils.equals((CharSequence)"clearMainDataSet", (CharSequence)action) && event.getResult() == MessageBoxResult.Yes) {
            OperateParameter operateParameter = new OperateParameter("pass", (Object)Boolean.TRUE);
            this.getModel().setValue("basetable_id", null);
            this.getModel().setValue("selectline", null);
            this.getModel().setValue("selectlinetype", null);
            this.getModel().setValue("baseset", null);
            this.getModel().setValue("sqlset_tag", null);
            this.getView().invokeOperation("dosave", operateParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"dosave", (CharSequence)key) && args.getOperationResult().isSuccess()) {
            String deleteMainLine;
            String confType = operate.getOption().getVariableValue("confType");
            Map parameter = operate.getParameter();
            if (parameter.size() == 0 && StringUtils.equals((CharSequence)"field", (CharSequence)confType) && (StringUtils.isNotBlank((CharSequence)(deleteMainLine = this.getPageCache().get("deleteMainLine"))) || this.checkMainFieldSetChange())) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("clearMainDataSet", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u8bbe\u7f6e - \u9009\u62e9\u5217\u53d1\u751f\u6539\u53d8\uff0c\u5c06\u6e05\u7a7a\u4e3b\u6570\u636e\u8bbe\u7f6e", (String)"BillTempTableSetPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                return;
            }
            this.getPageCache().put("dosave", "dosave");
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            this.getView().returnDataToParent((Object)dynamicObject);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)"basetable", (CharSequence)propertyName)) {
            String selectline = this.getModel().getValue("selectline").toString();
            DynamicObject dataTableSet = this.getBaseTableSet(selectline);
            List dataTables = (List)this.getView().getFormShowParameter().getCustomParam("dataTables");
            if (dataTables == null || dataTables.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5173\u8054\u6570\u636e\u8868\u3002", (String)"BillTempTableSetPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList dataTableIds = Lists.newArrayListWithExpectedSize((int)dataTables.size());
            if (dataTableSet == null || !"1".equals(dataTableSet.getString("fieldlogic"))) {
                dataTables.forEach(table -> {
                    Map baseDataId = (Map)table.get("fbasedataid");
                    Long masterid = (Long)baseDataId.get("id");
                    dataTableIds.add(masterid);
                });
            } else {
                dataTableIds.add(dataTableSet.getLong("datatable_id"));
            }
            QFilter qFilter = new QFilter("id", "in", (Object)dataTableIds);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setFormId("bos_listf7");
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (StringUtils.equals((CharSequence)"datatable", (CharSequence)propertyName)) {
            List dataTables = (List)this.getView().getFormShowParameter().getCustomParam("dataTables");
            if (dataTables == null || dataTables.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5173\u8054\u6570\u636e\u8868\u3002", (String)"BillTempTableSetPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList dataTableIds = Lists.newArrayListWithExpectedSize((int)dataTables.size());
            dataTables.forEach(table -> {
                Map baseDataId = (Map)table.get("fbasedataid");
                Long masterid = (Long)baseDataId.get("id");
                dataTableIds.add(masterid);
            });
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setFormId("bos_listf7");
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("id", "in", (Object)dataTableIds));
        } else if (StringUtils.equals((CharSequence)"datatpl", (CharSequence)propertyName)) {
            List billtemps = (List)this.getView().getFormShowParameter().getCustomParam("billTemps");
            if (billtemps == null || billtemps.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5173\u8054\u6570\u636e\u6a21\u677f\u3002", (String)"BillTempTableSetPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList billTempIds = Lists.newArrayListWithExpectedSize((int)billtemps.size());
            billtemps.forEach(temp -> {
                Map baseDataId = (Map)temp.get("fbasedataid");
                Long masterid = (Long)baseDataId.get("id");
                billTempIds.add(masterid);
            });
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setFormId("bos_listf7");
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("id", "in", (Object)billTempIds));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String status = (String)this.getModel().getValue("status");
        if (!StringUtils.equals((CharSequence)StatusEnum.SAVE.getValue(), (CharSequence)status)) {
            e.setCheckDataChange(false);
        }
        if (StringUtils.equals((CharSequence)"dosave", (CharSequence)this.getPageCache().get("dosave"))) {
            e.setCheckDataChange(false);
            this.getPageCache().remove("dosave");
        }
    }
}

