/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.Cell;

public class DataTempCellSetEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] CELLENTRY = new String[]{"cellposition", "cellrow", "cellcol"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"calculateconf"});
        BasedataEdit datatpl = (BasedataEdit)this.getControl("datatemps");
        datatpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.buildCellConf();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeDatas = e.getChangeSet();
        ChangeData data = changeDatas[0];
        if (StringUtils.equals((CharSequence)"dataresource", (CharSequence)name)) {
            this.afterDataResourceChange(data);
        }
        if (StringUtils.equals((CharSequence)"datatemps", (CharSequence)name)) {
            this.afterDataTplChange(data);
        }
    }

    private void afterDataTplChange(ChangeData data) {
        if (data == null) {
            return;
        }
        int index = data.getRowIndex();
        this.getModel().beginInit();
        this.getModel().setValue("calculateconf", null, index);
        this.getModel().setValue("format", (Object)2, index);
        this.getModel().setValue("formula", null, index);
        this.getModel().endInit();
        this.getView().updateView("calculateconf", index);
        this.getView().updateView("format", index);
        this.getView().updateView("formula", index);
    }

    private void afterDataResourceChange(ChangeData data) {
        if (data == null) {
            return;
        }
        int index = data.getRowIndex();
        this.getModel().beginInit();
        this.getModel().setValue("datatemps", null, index);
        this.getModel().setValue("calculateconf", null, index);
        this.getModel().setValue("format", (Object)2, index);
        this.getModel().setValue("formula", null, index);
        this.getModel().endInit();
        this.getView().updateView("datatemps", index);
        this.getView().updateView("calculateconf", index);
        this.getView().updateView("format", index);
        this.getView().updateView("formula", index);
    }

    private void buildCellConf() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String tempConfString = (String)showParameter.getCustomParam("phm_fixtpl_cellset");
        if (StringUtils.isNotEmpty((CharSequence)tempConfString)) {
            DataEntityDeserializerOption option = new DataEntityDeserializerOption();
            option.setIncludeDataEntityState(true);
            DynamicObject tempCellConf = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)tempConfString, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"phm_fixtpl_cellset"), (DataEntityDeserializerOption)option);
            this.resetTempCellConf(tempCellConf);
            BillModel model = (BillModel)this.getModel();
            model.fillReferenceData((Object[])new DynamicObject[]{tempCellConf}, tempCellConf.getDataEntityType());
            model.push((Object)tempCellConf);
        }
        String cells = (String)showParameter.getCustomParam("selectCells");
        String status = (String)showParameter.getCustomParam("status");
        this.getModel().setValue("status", (Object)status);
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btlsave"});
        }
        if (cells == null) {
            return;
        }
        List selectCells = SerializationUtils.fromJsonStringToList((String)cells, Cell.class);
        selectCells = selectCells.stream().sorted(Comparator.comparing(Cell::getRow).thenComparing(Cell::getCol)).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("cellentryentity");
        HashSet oldCells = null;
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            oldCells = Sets.newHashSetWithExpectedSize((int)dynamicObjects.size());
            for (DynamicObject dynamicObject : dynamicObjects) {
                oldCells.add(new Cell(dynamicObject.getInt("cellrow"), dynamicObject.getInt("cellcol")));
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(CELLENTRY);
        for (Cell cell : selectCells) {
            boolean hasSameCell = oldCells == null ? false : oldCells.contains(cell);
            if (hasSameCell) continue;
            String position = SpreadUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
            tvs.addRow(new Object[]{position, cell.getRow(), cell.getCol()});
        }
        model.batchCreateNewEntryRow("cellentryentity", tvs);
        model.endInit();
        this.getView().updateView("cellentryentity");
    }

    private void resetTempCellConf(DynamicObject tempCellConf) {
        DynamicObjectCollection cellConfs = tempCellConf.getDynamicObjectCollection("cellentryentity");
        if (cellConfs == null) {
            return;
        }
        List billtemps = (List)this.getView().getFormShowParameter().getCustomParam("billTemps");
        HashSet tplIds = Sets.newHashSetWithExpectedSize((int)2);
        if (billtemps != null && !billtemps.isEmpty()) {
            billtemps.forEach(temp -> {
                Map baseDataId = (Map)temp.get("fbasedataid");
                Long masterid = (Long)baseDataId.get("id");
                tplIds.add(masterid);
            });
        }
        for (DynamicObject cellConf : cellConfs) {
            DynamicObjectCollection dataTemps = cellConf.getDynamicObjectCollection("datatemps");
            if (dataTemps == null) continue;
            for (DynamicObject dataTemp : dataTemps) {
                long tplId = dataTemp.getLong("fbasedataid_id");
                if (tplId == 0L || tplIds.contains(tplId)) continue;
                cellConf.set("datatemps", null);
                cellConf.set("calculateconf", null);
                cellConf.set("format", null);
                cellConf.set("formula", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)"datatemps", (CharSequence)propertyName)) {
            List billtemps = (List)this.getView().getFormShowParameter().getCustomParam("billTemps");
            if (billtemps == null || billtemps.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5173\u8054\u6570\u636e\u6a21\u677f\u3002", (String)"DataTempCellSetEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList billTempIds = Lists.newArrayListWithExpectedSize((int)billtemps.size());
            billtemps.forEach(temp -> {
                Map baseDataId = (Map)temp.get("fbasedataid");
                Long masterid = (Long)baseDataId.get("id");
                billTempIds.add(masterid);
            });
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setFormId("bos_listf7");
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("id", "in", (Object)billTempIds));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"calculateconf", (CharSequence)key)) {
            this.openCellCalculateForm();
        }
    }

    private void openCellCalculateForm() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("cellentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        DynamicObjectCollection dataTemps = (DynamicObjectCollection)this.getModel().getValue("datatemps", selectRow);
        if (dataTemps == null || dataTemps.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6a21\u677f\u3002", (String)"DataTempCellSetEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList dataTempIds = Lists.newArrayListWithExpectedSize((int)dataTemps.size());
        for (DynamicObject dataTemp : dataTemps) {
            dataTempIds.add(dataTemp.getLong("fbasedataid_id"));
        }
        String cellPosition = (String)this.getModel().getValue("cellposition", selectRow);
        String calculateConf = (String)this.getModel().getValue("calculateconf", selectRow);
        int format = (Integer)this.getModel().getValue("format", selectRow);
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("phm_datatemp_cellset");
        listShowParameter.setCustomParam("cellPosition", (Object)cellPosition);
        listShowParameter.setCustomParam("calculateConf", (Object)calculateConf);
        listShowParameter.setCustomParam("dataTempIds", (Object)dataTempIds);
        listShowParameter.setCustomParam("format", (Object)format);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calculateconf"));
        this.getView().showForm(listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionid = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"calculateconf", (CharSequence)actionid)) {
            this.afterSetCalculate(closedCallBackEvent);
        }
    }

    private void afterSetCalculate(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("cellentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        this.getModel().setValue("calculateconf", returnData.get("calculateconf"), selectRow);
        this.getModel().setValue("format", returnData.get("format"), selectRow);
        this.getModel().setValue("formula", returnData.get("formula"), selectRow);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"dosave", (CharSequence)key) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getPageCache().put("dosave", "dosave");
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity(true));
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String status = (String)this.getModel().getValue("status");
        if (!StringUtils.equals((CharSequence)StatusEnum.SAVE.getValue(), (CharSequence)status)) {
            e.setCheckDataChange(false);
        }
        if (StringUtils.equals((CharSequence)"dosave", (CharSequence)this.getPageCache().get("dosave"))) {
            e.setCheckDataChange(false);
            this.getPageCache().remove("dosave");
        }
    }
}

