/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.StatusEnum;

public class PersonalWorkStationPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String LIST = "entryentity";
    private static final String RESOURCEID = "resid";
    private static final String RESOURCENUMBER = "resnumber";
    private static final String RESOURCENAME = "resname";
    private static final String CREATEORG = "createorg";
    private static final String BIZTYPE = "biztype";
    private static final String BILLTEMPTYPE = "billtemptype";
    private static final String SEAT = "seat";
    private static final String ROLE = "role";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String DATATABLES = "datatables";
    private static final String BILLTEMPS = "billtemps";
    private static final String LIST_PANEL = "flexpanelap1";
    private static final String BILL_PANEL = "multrptpanel";
    private static final String FLOATMENUAP = "floatmenuap";
    private static final String SHOWLIST = "treepanelswitchrpt";
    private static final String LISTTOOLBAR = "toolbarap";
    private static final String PAGEID = "pageid";
    private static final String REPORTTAB = "reporttab";
    private static final String BAROPEN = "baropen";
    private static final String BARREFRESH = "barrefresh";
    private static final String BARVIEWROLE = "barviewrole";
    private static final String BAR_VIEWHISTORY = "barviewhistory";
    private static final String VERSIONRULE = "versionrule";
    private static final String KEY_ALGO = "PersonalWorkStationPlugin.";
    private static final String VERSION_NUMBER = "versionnumber";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        EntryGrid list = (EntryGrid)this.getView().getControl(LIST);
        list.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{SHOWLIST});
        this.addItemClickListeners(new String[]{LISTTOOLBAR});
    }

    public void afterCreateNewData(EventObject e) {
        this.showList();
        List<Map<String, Object>> datasList = this.getResByUser();
        this.constractListDatas(datasList);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "treepanelswitchrpt": {
                this.showList();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "baropen": {
                EntryGrid list = (EntryGrid)this.getView().getControl(LIST);
                int[] selectList = list.getSelectRows();
                this.openPages(selectList);
                break;
            }
            case "barrefresh": {
                List<Map<String, Object>> datasList = this.getResByUser();
                this.constractListDatas(datasList);
                break;
            }
            case "barviewrole": {
                this.viewRoles();
                break;
            }
            case "barviewhistory": {
                this.viewHistory();
                break;
            }
        }
    }

    private void viewHistory() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PersonalWorkStationPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object resourceId = this.getModel().getValue(RESOURCEID, selectRows[0]);
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"phm_filldata_history", (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "viewHistory");
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
        filters.add(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("template", "=", (Object)Long.parseLong(String.valueOf(resourceId))));
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        this.openPages(new int[]{rowIndex});
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "closeTabs": {
                this.closeTab(e);
                List<Map<String, Object>> datasList = this.getResByUser();
                this.constractListDatas(datasList);
                break;
            }
            case "viewHistory": {
                this.openHistoryPages(e);
                break;
            }
        }
    }

    private void closeTab(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        if (returnData == null) {
            return;
        }
        String pageId = (String)returnData.get("pageId");
        List<String> openTabKeys = this.removeFromOpenTabKeys(pageId);
        if (openTabKeys.isEmpty()) {
            this.showList();
        } else {
            Tab reporttab = (Tab)this.getControl(REPORTTAB);
            reporttab.activeTab(openTabKeys.get(openTabKeys.size() - 1));
        }
    }

    private void constractListDatas(List<Map<String, Object>> datasList) {
        if (datasList.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(LIST);
        HashMap<String, Object> pageMap = new HashMap<String, Object>(8);
        for (int i = 0; i < datasList.size(); ++i) {
            Map<String, Object> map = datasList.get(i);
            String pageId = this.getView().getPageId() + map.get(RESOURCEID);
            List roleList = (List)map.get(ROLE);
            List dataTableList = (List)map.get(DATATABLES);
            List billTempsList = (List)map.get(BILLTEMPS);
            this.getModel().createNewEntryRow(LIST);
            this.getModel().setValue(RESOURCEID, map.get(RESOURCEID), i);
            this.getModel().setValue(RESOURCENUMBER, map.get(RESOURCENUMBER), i);
            this.getModel().setValue(RESOURCENAME, map.get(RESOURCENAME), i);
            this.getModel().setValue(VERSION_NUMBER, map.get(VERSION_NUMBER), i);
            this.getModel().setValue(CREATEORG, map.get(CREATEORG), i);
            this.getModel().setValue(BIZTYPE, map.get(BIZTYPE), i);
            this.getModel().setValue(BILLTEMPTYPE, map.get(BILLTEMPTYPE), i);
            this.getModel().setValue(SEAT, map.get(SEAT), i);
            this.getModel().setValue(CTRLSTRATEGY, map.get(CTRLSTRATEGY), i);
            this.getModel().setValue(VERSIONRULE, map.get(VERSIONRULE), i);
            if (roleList != null) {
                this.getModel().setValue(ROLE, (Object)roleList.toArray(new Object[0]), i);
            }
            if (dataTableList != null) {
                this.getModel().setValue(DATATABLES, (Object)dataTableList.toArray(new Object[0]), i);
            }
            if (billTempsList != null) {
                this.getModel().setValue(BILLTEMPS, (Object)billTempsList.toArray(new Object[0]), i);
            }
            this.getModel().setValue(PAGEID, (Object)pageId, i);
            pageMap.put(pageId, map.get(RESOURCEID));
        }
        this.cachePageIdToRes(pageMap);
    }

    private void showList() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BILL_PANEL, FLOATMENUAP});
        this.getView().setVisible(Boolean.TRUE, new String[]{LIST_PANEL});
    }

    private void showBill() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BILL_PANEL, FLOATMENUAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{LIST_PANEL});
    }

    private List<String> cacheAllOpenTabKeys(String key) {
        String allOpenTabKeys = this.getPageCache().get("openTabKeys");
        ArrayList<String> allOpenTabKeyList = new ArrayList(8);
        if (StringUtils.isNotEmpty((CharSequence)allOpenTabKeys)) {
            allOpenTabKeyList = (List)SerializationUtils.fromJsonString((String)allOpenTabKeys, List.class);
        }
        if (!allOpenTabKeyList.contains(key)) {
            allOpenTabKeyList.add(key);
            this.getPageCache().put("openTabKeys", SerializationUtils.toJsonString(allOpenTabKeyList));
        }
        return allOpenTabKeyList;
    }

    private List<String> getAllOpenTabKeys() {
        String allOpenTabKeys = this.getPageCache().get("openTabKeys");
        List<String> allOpenTabKeyList = new ArrayList<String>(8);
        if (StringUtils.isNotEmpty((CharSequence)allOpenTabKeys)) {
            allOpenTabKeyList = (List)SerializationUtils.fromJsonString((String)allOpenTabKeys, List.class);
        }
        return allOpenTabKeyList;
    }

    private List<String> removeFromOpenTabKeys(String key) {
        String allOpenTabKeys = this.getPageCache().get("openTabKeys");
        ArrayList<String> allOpenTabKeyList = new ArrayList(8);
        if (StringUtils.isNotEmpty((CharSequence)allOpenTabKeys)) {
            allOpenTabKeyList = (List)SerializationUtils.fromJsonString((String)allOpenTabKeys, List.class);
        }
        allOpenTabKeyList.remove(key);
        this.getPageCache().put("openTabKeys", SerializationUtils.toJsonString(allOpenTabKeyList));
        return allOpenTabKeyList;
    }

    private void cachePageIdToRes(Map<String, Object> pageMap) {
        this.getPageCache().put("pageToRes", SerializationUtils.toJsonString(pageMap));
    }

    private Map<String, Object> getPageIdToRes() {
        Map<String, Object> pageMap = new HashMap<String, Object>(8);
        String pageToRes = this.getPageCache().get("pageToRes");
        if (StringUtils.isNotEmpty((CharSequence)pageToRes)) {
            pageMap = (Map)SerializationUtils.fromJsonString((String)pageToRes, Map.class);
        }
        return pageMap;
    }

    private void viewRoles() {
        FormShowParameter formShowParam = new FormShowParameter();
        formShowParam.setFormId("phm_viewselefrole");
        formShowParam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParam);
    }

    private List<Map<String, Object>> getResByUser() {
        ArrayList<Map<String, Object>> datasList = new ArrayList<Map<String, Object>>(8);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        ArrayList<Object> roleList = new ArrayList<Object>(8);
        DynamicObjectCollection roleUser = QueryServiceHelper.query((String)"phm_role_user", (String)"id,roleid", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        for (DynamicObject obj : roleUser) {
            Object roleId = obj.get("roleid");
            roleList.add(roleId);
        }
        QFilter[] roleFilters = new QFilter[]{new QFilter("id", "in", roleList), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")};
        DynamicObjectCollection roleCol = QueryServiceHelper.query((String)"phm_role", (String)"id,entryentity2.resources,name", (QFilter[])roleFilters);
        HashMap<Object, Object> resToRoleMap = new HashMap<Object, Object>(8);
        ArrayList<Object> resList = new ArrayList<Object>(8);
        for (DynamicObject role : roleCol) {
            Object resources = role.get("entryentity2.resources");
            DynamicObject[] roles = resToRoleMap.computeIfAbsent(resources, k -> new ArrayList(8));
            roles.add(role.get("id"));
            resToRoleMap.put(resources, roles);
            resList.add(resources);
        }
        QFilter[] resFilters = new QFilter[]{new QFilter("id", "in", resList), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("publish", "=", (Object)"2")};
        DynamicObject[] resCol = BusinessDataServiceHelper.load((String)"phm_billtemp", (String)"id,number,name,biztype.id,group.id,datatables,billtemps,createorg.id,ctrlstrategy,versionrule.id", (QFilter[])resFilters);
        ArrayList dateTempIds = Lists.newArrayListWithExpectedSize((int)resCol.length);
        for (DynamicObject dynamicObject : resCol) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put(RESOURCEID, dynamicObject.get("id"));
            map.put(RESOURCENUMBER, dynamicObject.get("number"));
            map.put(RESOURCENAME, dynamicObject.get("name"));
            map.put(BIZTYPE, dynamicObject.get("biztype.id"));
            map.put(BILLTEMPTYPE, dynamicObject.get("group.id"));
            map.put(CREATEORG, dynamicObject.get("createorg.id"));
            map.put(DATATABLES, dynamicObject.get(DATATABLES));
            map.put(BILLTEMPS, dynamicObject.get(BILLTEMPS));
            map.put(CTRLSTRATEGY, dynamicObject.get(CTRLSTRATEGY));
            map.put(VERSIONRULE, dynamicObject.get("versionrule.id"));
            map.put(ROLE, resToRoleMap.get(dynamicObject.get("id")));
            ArrayList<Object> dataTableList = new ArrayList<Object>(8);
            DynamicObjectCollection dataTables = dynamicObject.getDynamicObjectCollection(DATATABLES);
            for (DynamicObject dataTable : dataTables) {
                dataTableList.add(dataTable.get(2));
            }
            map.put(DATATABLES, dataTableList);
            ArrayList<Object> billTempList = new ArrayList<Object>(8);
            DynamicObjectCollection billTemps = dynamicObject.getDynamicObjectCollection(BILLTEMPS);
            for (DynamicObject billTemp : billTemps) {
                billTempList.add(billTemp.get(2));
            }
            map.put(BILLTEMPS, billTempList);
            datasList.add((Map<String, Object>)map);
            dateTempIds.add(dynamicObject.getPkValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter("creator", "=", (Object)userId), new QFilter("template", "in", (Object)dateTempIds), new QFilter("template.isenableversion", "=", (Object)Character.valueOf('1'))};
        HashMap<Long, String> dateTemp2Number = new HashMap<Long, String>(16);
        Throwable throwable = null;
        try (DataSet dataSet = ORM.create().queryDataSet("PersonalWorkStationPlugin.getVersionNumber", "phm_filldata_history", "number, template", filters, "createtime desc, modifytime desc");){
            for (Row row : dataSet) {
                dateTemp2Number.putIfAbsent(row.getLong(1), row.getString(0));
            }
        }
        catch (Throwable map) {
            Throwable throwable2 = map;
            throw map;
        }
        for (Map map : datasList) {
            Long templateId = map.getOrDefault(RESOURCEID, 0L);
            map.put(VERSION_NUMBER, dateTemp2Number.getOrDefault(templateId, ""));
        }
        return datasList;
    }

    private void openPages(int[] rowList) {
        Set<Object> unavailableIds = this.validateVersionRule(rowList);
        if (unavailableIds.size() == rowList.length) {
            return;
        }
        for (int rowIndex : rowList) {
            String pageId = (String)this.getModel().getValue(PAGEID, rowIndex);
            String resname = (String)this.getModel().getValue(RESOURCENAME, rowIndex);
            ArrayList<Object> roleList = new ArrayList<Object>(8);
            DynamicObjectCollection roleCol = (DynamicObjectCollection)this.getModel().getValue(ROLE, rowIndex);
            for (DynamicObject role : roleCol) {
                roleList.add(role.get(2));
            }
            Object seat = this.getModel().getValue(SEAT, rowIndex);
            this.showBill();
            List<String> list = this.getAllOpenTabKeys();
            if (list.contains(pageId)) {
                Tab reporttab = (Tab)this.getControl(REPORTTAB);
                reporttab.activeTab(pageId);
                continue;
            }
            Map<String, Object> pageMap = this.getPageIdToRes();
            Object resource = pageMap.get(pageId);
            if (unavailableIds.contains(resource)) continue;
            FormShowParameter formShowParam = this.createFormShowParameter(pageId, "phm_workstation_bill");
            formShowParam.setCustomParam("resource", resource);
            formShowParam.setCustomParam(ROLE, roleList);
            formShowParam.setCustomParam(SEAT, seat);
            formShowParam.setCustomParam("versionNumber", this.getModel().getValue(VERSION_NUMBER, rowIndex));
            long versionRuleId = 0L;
            DynamicObject versionRule = (DynamicObject)this.getModel().getValue(VERSIONRULE, rowIndex);
            if (versionRule != null) {
                versionRuleId = (Long)versionRule.getPkValue();
            }
            formShowParam.setCustomParam("versionRule", (Object)versionRuleId);
            formShowParam.setCaption(resname);
            this.getView().showForm(formShowParam);
            this.cacheAllOpenTabKeys(pageId);
        }
    }

    private void openHistoryPages(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
        List<String> list = this.getAllOpenTabKeys();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            String pageId = this.getView().getPageId() + primaryKeyValue;
            if (list.contains(pageId)) {
                Tab reporttab = (Tab)this.getControl(REPORTTAB);
                reporttab.activeTab(pageId);
                continue;
            }
            FormShowParameter formShowParam = this.createFormShowParameter(pageId, "phm_workstation_bill_his");
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(LIST);
            String resname = (String)this.getModel().getValue(RESOURCENAME, entryCurrentRowIndex);
            formShowParam.setCustomParam("resource", primaryKeyValue);
            formShowParam.setCaption(resname);
            this.getView().showForm(formShowParam);
            this.cacheAllOpenTabKeys(pageId);
        }
        this.showBill();
    }

    private Set<Object> validateVersionRule(int[] rowList) {
        ArrayList<String> tipNotifications = new ArrayList<String>();
        ArrayList resourceIds = Lists.newArrayListWithExpectedSize((int)rowList.length);
        for (int rowIndex : rowList) {
            resourceIds.add(Long.parseLong((String)this.getModel().getValue(RESOURCEID, rowIndex)));
        }
        QFilter[] filters = new QFilter[]{new QFilter("isenableversion", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", (Object)resourceIds)};
        Date now = new Date();
        HashSet<Object> unavailableIds = new HashSet<Object>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)KEY_ALGO, (String)"phm_billtemp", (String)"id, number, versionrule.status, versionrule.enable, versionrule.validated_time", (QFilter[])filters, null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                String status = row.getString(2);
                String enable = row.getString(3);
                Date startTime = row.getDate(4);
                if (!EnableEnum.ENABLE.getValue().equals(enable)) {
                    unavailableIds.add(row.get(0));
                    tipNotifications.add(String.format(ResManager.loadKDString((String)"%s\uff1a \u5f15\u7528\u7684\u7248\u672c\u89c4\u5219\u672a\u542f\u7528\uff0c \u8bf7\u5148\u542f\u7528\u518d\u64cd\u4f5c\u3002", (String)"PersonalWorkStationPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]), row.getString(1)));
                    continue;
                }
                if (!StatusEnum.AUDIT.getValue().equals(status)) {
                    unavailableIds.add(row.get(0));
                    tipNotifications.add(String.format(ResManager.loadKDString((String)"%s\uff1a \u5f15\u7528\u7684\u7248\u672c\u89c4\u5219\u672a\u5ba1\u6838\uff0c \u8bf7\u5148\u5ba1\u6838\u518d\u64cd\u4f5c\u3002", (String)"PersonalWorkStationPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]), row.getString(1)));
                    continue;
                }
                if (now.compareTo(startTime) >= 0) continue;
                unavailableIds.add(row.get(0));
                tipNotifications.add(String.format(ResManager.loadKDString((String)"%s\uff1a \u5f15\u7528\u7684\u7248\u672c\u89c4\u5219\u672a\u751f\u6548\uff0c \u8bf7\u5148\u786e\u8ba4\u751f\u6548\u72b6\u6001\u518d\u64cd\u4f5c\u3002", (String)"PersonalWorkStationPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]), row.getString(1)));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (tipNotifications.size() == 1) {
            this.getView().showTipNotification((String)tipNotifications.get(0));
        } else if (tipNotifications.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (String tipNotification : tipNotifications) {
                sb.append(tipNotification).append('\n');
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u7248\u672c\u89c4\u5219\u6821\u9a8c", (String)"PersonalWorkStationPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
        }
        return unavailableIds;
    }

    private FormShowParameter createFormShowParameter(String pageId, String formId) {
        FormShowParameter formShowParam = new FormShowParameter();
        formShowParam.setPageId(pageId);
        formShowParam.setFormId(formId);
        formShowParam.getOpenStyle().setTargetKey(REPORTTAB);
        formShowParam.getOpenStyle().setShowType(ShowType.NewTabPage);
        formShowParam.setParentFormId(this.getView().getFormShowParameter().getFormId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeTabs");
        formShowParam.setCloseCallBack(closeCallBack);
        return formShowParam;
    }
}

