/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.CellArea;
import kd.mmc.phm.common.util.datatemp.FixTempConfigParse;
import kd.mmc.phm.formplugin.bizmodel.spread.AbstractSpreadPlugin;
import kd.mmc.phm.formplugin.bizmodel.spread.SpreadDataModel;

public class RegularTempCellSettingPlugin
extends AbstractSpreadPlugin
implements TabSelectListener,
SearchEnterListener,
TreeNodeClickListener {
    private static final String ROOTID = "root";
    private static final String PRE_GROUP = "group_";
    private static final String PRE_FUNC = "func_";
    private static final String KEY_SEARCH = "searchap1";
    private static final String KEY_FUNCTREE = "functree1";
    private static final String CACHEKEY_FUNCS = "functions";
    private static final String CACHEKEY_FUNCID = "funcId";
    private static final String KEY_FUNCNAME = "funcname1";
    private static final String KEY_FUNCDESC = "funcdesc1";
    private static final String KEY_RETURNTYPE = "returntype1";
    private static final String CELL = "cell";
    private static final String FORMULA = "formula";
    private static final String CALCULATECONF = "calculateconf";
    private static final String FORMAT = "format";
    private static final String SELECTCELL = "selectcell";
    private static final String TABAP = "tabap";
    private static final String NUMBERTOID = "numberToId";
    private static final String IDTOSPREAD = "idToSpread";
    private static final String IDTONUMBER = "idToNumber";
    private static final String SELECTTEMP = "selectTemp";

    public void afterCreateNewData(EventObject e) {
        Object templateIds = this.getView().getFormShowParameter().getCustomParam("dataTempIds");
        Object cell = this.getView().getFormShowParameter().getCustomParam("cellPosition");
        Object formula = this.getView().getFormShowParameter().getCustomParam("calculateConf");
        Object format = this.getView().getFormShowParameter().getCustomParam(FORMAT);
        HashMap<String, String> numberToId = new HashMap<String, String>(8);
        HashMap<Long, String> idToSpread = new HashMap<Long, String>(8);
        HashMap<Object, Object> idToNumberAndName = new HashMap<Object, Object>(8);
        HashMap<Long, String> idToNumber = new HashMap<Long, String>(8);
        if (templateIds != null) {
            List templateIdList = (List)SerializationUtils.fromJsonString((String)templateIds.toString(), List.class);
            DynamicObjectCollection dataTemps = QueryServiceHelper.query((String)"phm_billtemp", (String)"id,number,name,spreadjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)templateIdList)});
            for (DynamicObject dataTemp : dataTemps) {
                String number = dataTemp.getString("number");
                long id = dataTemp.getLong("id");
                String name = dataTemp.getString("name");
                String spreadJson = dataTemp.getString("spreadjson_tag");
                numberToId.put(Long.toString(id), number);
                idToSpread.put(id, spreadJson);
                idToNumberAndName.put(id, number + name);
                idToNumber.put(id, number);
            }
            this.getView().getPageCache().put(NUMBERTOID, SerializationUtils.toJsonString(numberToId));
            this.getView().getPageCache().put(IDTOSPREAD, SerializationUtils.toJsonString(idToSpread));
            this.getView().getPageCache().put(IDTONUMBER, SerializationUtils.toJsonString(idToNumber));
        }
        if (cell != null) {
            Label cellLabel = (Label)this.getControl(CELL);
            cellLabel.setText(cell.toString());
        }
        this.getModel().setValue(FORMULA, formula);
        this.getModel().setValue(FORMAT, format);
        this.initTab(idToNumberAndName);
        this.initSpreadControl();
        this.initFunctionFlex();
    }

    private void initTab(Map<Object, Object> idToNumberAndName) {
        TabAp tabap = new TabAp();
        tabap.setKey(TABAP);
        tabap.setName(new LocaleString(TABAP));
        tabap.setGrow(0);
        tabap.setCanSlide(true);
        int row = 0;
        String firstKey = null;
        for (Map.Entry<Object, Object> entry : idToNumberAndName.entrySet()) {
            String pageKey = entry.getKey().toString();
            if (row == 0) {
                firstKey = pageKey;
            }
            String pageName = entry.getValue().toString();
            TabPageAp page = new TabPageAp();
            page.setKey(pageKey);
            page.setName(new LocaleString(pageName));
            tabap.getItems().add(page);
            ++row;
        }
        if (firstKey != null) {
            Tab tabAp = (Tab)this.getControl(TABAP);
            tabAp.activeTab(firstKey);
            Map features = tabap.createControl();
            this.getView().updateControlMetadata(TABAP, features);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        TreeView funcTree = (TreeView)this.getControl(KEY_FUNCTREE);
        funcTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView selectCell = (TreeView)this.getControl(SELECTCELL);
        selectCell.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    protected String getSpreadKey() {
        return "spreadap";
    }

    @Override
    protected SpreadDataModel getSpreadDataModelService() {
        return new SpreadDataModel(this, this.getSpreadKey()){

            @Override
            public void cellIsLocked(SpreadEvent event) {
                Spread spread = (Spread)event.getSource();
                SpreadPostDataInfo data = spread.getPostDataInfo();
                LinkedHashMap invokeParams = data.getInvokeParams();
                if (invokeParams == null) {
                    return;
                }
                LinkedHashMap value = (LinkedHashMap)invokeParams.get("values");
                if (value == null) {
                    return;
                }
                Object r = value.get("r");
                Object c = value.get("c");
                if (r == null || c == null) {
                    return;
                }
                String pos = SpreadUtils.xy2Pos((int)Integer.parseInt(c.toString()), (int)Integer.parseInt(r.toString()));
                String selectTemp = RegularTempCellSettingPlugin.this.getView().getPageCache().get(RegularTempCellSettingPlugin.SELECTTEMP);
                String selectCell = selectTemp + '.' + pos;
                TreeNode treeNode = new TreeNode("", selectCell, pos);
                TreeView selectCellTree = (TreeView)RegularTempCellSettingPlugin.this.getControl(RegularTempCellSettingPlugin.SELECTCELL);
                selectCellTree.deleteAllNodes();
                selectCellTree.addNode(treeNode);
            }
        };
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                String formula = (String)this.getModel().getValue(FORMULA);
                String numberToIdStr = this.getPageCache().get(NUMBERTOID);
                Map numberToId = new HashMap(8);
                if (StringUtils.isNotEmpty((CharSequence)numberToIdStr)) {
                    numberToId = (Map)SerializationUtils.fromJsonString((String)numberToIdStr, Map.class);
                }
                String hideFormula = FixTempConfigParse.validitionFormat((String)formula, numberToId);
                Object format = this.getModel().getValue(FORMAT);
                HashMap<String, Object> returnData = new HashMap<String, Object>(8);
                returnData.put(CALCULATECONF, formula);
                returnData.put(FORMAT, format);
                returnData.put(FORMULA, hideFormula);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = String.valueOf(evt.getNodeId());
        if (KEY_FUNCTREE.equals(treeView.getKey())) {
            if (nodeId.startsWith(PRE_FUNC)) {
                nodeId = nodeId.substring(PRE_FUNC.length());
                FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
                for (FunctionType functionType : functionTypes.getFunctionTypes()) {
                    if (!nodeId.equals(functionType.getId())) continue;
                    String def = functionType.getDef();
                    def = def.replaceAll("number\\[\\]", " ");
                    this.insertExpression(treeView.getKey(), def);
                }
            }
        } else if (SELECTCELL.equals(treeView.getKey())) {
            this.insertExpression(treeView.getKey(), nodeId);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        IPageCache pageCache;
        String funcId;
        String nodeId = String.valueOf(evt.getNodeId());
        if (nodeId.startsWith(PRE_FUNC) && !StringUtils.equals((CharSequence)(funcId = nodeId.substring(PRE_FUNC.length())), (CharSequence)(pageCache = this.getPageCache()).get(CACHEKEY_FUNCID))) {
            this.showFuncInfo(funcId);
            pageCache.put(CACHEKEY_FUNCID, funcId);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode treeNode;
        int i;
        String searchText = searchEnterEvent.getText();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        int beginIndex = 0;
        if (focusNodeId != null && !ROOTID.equals(focusNodeId)) {
            for (TreeNode funcTreeNode : funcTreeNodes) {
                ++beginIndex;
                if (!focusNodeId.equals(funcTreeNode.getParentid()) && !focusNodeId.equals(funcTreeNode.getId())) continue;
                break;
            }
        }
        for (i = beginIndex; i < funcTreeNodes.size(); ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
        for (i = 0; i < beginIndex; ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return null;
        }
        ArrayList<String> searchList = new ArrayList<String>();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String text = funcTreeNode.getText();
            if (!this.containsIgnoreCase(text, searchText)) continue;
            searchList.add(text);
        }
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String id = funcTreeNode.getId();
            if (!this.containsIgnoreCase(id, searchText)) continue;
            searchList.add(id.substring(PRE_FUNC.length()));
        }
        return searchList;
    }

    private List<TreeNode> getFuncTreeNodes() {
        IPageCache pageCache = this.getPageCache();
        String str = pageCache.get(CACHEKEY_FUNCS);
        return StringUtils.isBlank((CharSequence)str) ? Collections.emptyList() : SerializationUtils.fromJsonStringToList((String)str, TreeNode.class);
    }

    private boolean isSearchNode(TreeNode treeNode, String searchText) {
        return this.containsIgnoreCase(treeNode.getText(), searchText) || this.containsIgnoreCase(treeNode.getId().substring(PRE_FUNC.length()), searchText);
    }

    private boolean containsIgnoreCase(String str, String searchStr) {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)searchStr)) {
            return false;
        }
        return str.toLowerCase().contains(searchStr.toLowerCase());
    }

    private void initSpreadControl() {
        List defaultHiddenMenuItems = SpreadUtils.getDefaultHiddenMenuItems();
        defaultHiddenMenuItems.add("copy");
        defaultHiddenMenuItems.add("cut");
        defaultHiddenMenuItems.add("pasteOptions");
        defaultHiddenMenuItems.add("filter");
        defaultHiddenMenuItems.add("sort");
        defaultHiddenMenuItems.add("insertComment");
        defaultHiddenMenuItems.add("pasteAll");
        defaultHiddenMenuItems.add("pasteFormula");
        defaultHiddenMenuItems.add("pasteValues");
        defaultHiddenMenuItems.add("pasteFormatting");
        defaultHiddenMenuItems.add("pasteValuesFormatting");
        defaultHiddenMenuItems.add("pasteFormulaFormatting");
        List defaultLockToolbarItems = SpreadUtils.getDefaultLockToolbarItems();
        this.getSpreadContainer().lockToolbarItems(true, defaultLockToolbarItems);
        this.getSpreadContainer().hideContextMenuItems(defaultHiddenMenuItems, true);
        this.getSpreadContainer().closeToolbar();
        CellArea cellArea = new CellArea();
        cellArea.setR(0);
        cellArea.setC(0);
        cellArea.setCc(1000);
        cellArea.setRc(1000);
        this.getSpreadContainer().lockCell(cellArea);
    }

    private void initFunctionFlex() {
        TreeNode groupNode;
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8\u51fd\u6570", (String)"RegularTempCellSettingPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        root.setIsOpened(true);
        FunctionTypes commonFuncs = FunctionTypes.getCommonFuncs();
        List functionGroups = commonFuncs.getFunctionGroups();
        functionGroups = functionGroups.stream().filter(functionGroup -> "Set".equals(functionGroup.getId())).collect(Collectors.toList());
        functionGroups.sort(Comparator.comparingInt(FunctionGroup::getSeq));
        LinkedHashMap groupId2TreeNode = Maps.newLinkedHashMapWithExpectedSize((int)functionGroups.size());
        for (FunctionGroup functionGroup2 : functionGroups) {
            if (!functionGroup2.isVisible()) continue;
            TreeNode groupNode2 = new TreeNode();
            String string = functionGroup2.getId();
            groupNode2.setId(PRE_GROUP + string);
            groupNode2.setText(functionGroup2.getName().getLocaleValue());
            groupNode2.setParentid(ROOTID);
            groupId2TreeNode.put(string, groupNode2);
        }
        List functionTypes = commonFuncs.getFunctionTypes();
        ArrayList funcTreeNodes = Lists.newArrayListWithExpectedSize((int)functionTypes.size());
        functionTypes.sort(Comparator.comparingInt(FunctionType::getSeq));
        for (FunctionType functionType : functionTypes) {
            groupNode = (TreeNode)groupId2TreeNode.get(functionType.getGroupId());
            if (groupNode == null || "group_Set".equals(groupNode.getId()) && !Arrays.asList("sum", "min", "max", "avg").contains(functionType.getId().trim())) continue;
            TreeNode funcNode = new TreeNode();
            funcNode.setId(PRE_FUNC + functionType.getId());
            funcNode.setText(functionType.getName().getLocaleValue());
            funcNode.setParentid(groupNode.getId());
            groupNode.addChild(funcNode);
            funcTreeNodes.add(funcNode);
        }
        for (Map.Entry entry : groupId2TreeNode.entrySet()) {
            groupNode = (TreeNode)entry.getValue();
            if (groupNode.getChildren().isEmpty()) continue;
            root.addChild(groupNode);
        }
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        treeView.addNode(root);
        this.getPageCache().put(CACHEKEY_FUNCS, SerializationUtils.toJsonString((Object)funcTreeNodes));
    }

    private void setFormulaValue(Object c, Object r) {
        String pos = SpreadUtils.xy2Pos((int)Integer.parseInt(c.toString()), (int)Integer.parseInt(r.toString()));
        String expression = (String)this.getModel().getValue(FORMULA);
        int cursorIndex = pos.length();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            expression = pos;
        } else {
            int textPos = this.getCursorIndex(KEY_FUNCTREE, expression);
            expression = this.insertCharacter(expression, pos, textPos);
            cursorIndex = textPos + pos.length();
        }
        this.setCursorIndex(cursorIndex);
        this.getModel().setValue(FORMULA, (Object)expression);
    }

    private void showFuncInfo(String funcId) {
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        for (FunctionType functionType : functionTypes.getFunctionTypes()) {
            if (!funcId.equals(functionType.getId())) continue;
            this.setFuncInfo(functionType.getDef(), ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1a", (String)"RegularTempCellSettingPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + functionType.getReturnType());
            this.getModel().setValue(KEY_FUNCDESC, (Object)this.analyzingDesc(functionType.getDesc().getLocaleValue()));
        }
    }

    private void setFuncInfo(String funcName, String returnType) {
        ((Label)this.getControl(KEY_FUNCNAME)).setText(funcName);
        ((Label)this.getControl(KEY_RETURNTYPE)).setText(returnType);
    }

    private String analyzingDesc(String desc) {
        ArrayList<String> descLines = new ArrayList<String>(10);
        String temp = desc;
        int index = temp.indexOf("\\n");
        while (index > 0) {
            descLines.add(temp.substring(0, index));
            temp = index < temp.length() - 2 ? temp.substring(index + 2) : "";
            index = temp.indexOf("\\n");
        }
        if (StringUtils.isNotBlank((CharSequence)temp)) {
            descLines.add(temp);
        }
        return StringUtils.join((Object[])descLines.toArray(), (char)'\n');
    }

    private void insertExpression(String controlKey, String insertStr) {
        IDataModel model = this.getModel();
        String text = (String)model.getValue(FORMULA);
        String expression = this.getExpression(controlKey, text, insertStr);
        model.setValue(FORMULA, (Object)expression);
    }

    private String getExpression(String controlKey, String text, String insertStr) {
        int cursorIndex;
        String expression = text;
        if (StringUtils.isBlank((CharSequence)text)) {
            expression = insertStr;
            cursorIndex = insertStr.length();
        } else {
            int pos = this.getCursorIndex(controlKey, text);
            expression = this.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        this.setCursorIndex(cursorIndex);
        return expression;
    }

    private int getCursorIndex(String controlKey, String text) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Object viewState = proxy.getViewState(controlKey);
        if (viewState instanceof Map) {
            Map map = (Map)viewState;
            Object focusResult = map.get("focus");
            if (focusResult instanceof Map) {
                Map focusMap = (Map)focusResult;
                return focusMap.getOrDefault(FORMULA, text.length());
            }
            return map.getOrDefault(controlKey, text.length());
        }
        return text.length();
    }

    private String insertCharacter(String expression, String insertStr, int pos) {
        int length = expression.length();
        if (length < pos) {
            pos = length;
        }
        StringBuilder sb = new StringBuilder(expression);
        sb.insert(pos, insertStr);
        return sb.toString();
    }

    private void setCursorIndex(int cursorIndex) {
        LinkedHashMap cursorMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        cursorMap.put("ctrlKey", FORMULA);
        cursorMap.put("cursorIndex", cursorIndex);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", (Object)cursorMap);
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        String idToNumberStr = this.getView().getPageCache().get(IDTONUMBER);
        String idToSpreadStr = this.getView().getPageCache().get(IDTOSPREAD);
        if (StringUtils.isNotEmpty((CharSequence)idToNumberStr)) {
            Map idToNumber = (Map)SerializationUtils.fromJsonString((String)idToNumberStr, Map.class);
            String selectTempNumber = (String)idToNumber.get(tabKey);
            this.getView().getPageCache().put(SELECTTEMP, selectTempNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)idToSpreadStr)) {
            Map idToSpread = (Map)SerializationUtils.fromJsonString((String)idToSpreadStr, Map.class);
            String spreadJson = (String)idToSpread.get(tabKey);
            this.getSpreadContainer().rebuildSpread(spreadJson);
        }
        CellArea cellArea = new CellArea();
        cellArea.setR(0);
        cellArea.setC(0);
        cellArea.setCc(1000);
        cellArea.setRc(1000);
        this.getSpreadContainer().lockCell(cellArea);
    }
}

