/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.mmc.phm.common.util.datatemp.FormulaParseUtils;

public class TableHeaderSettingPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final String ROOTID = "root";
    private static final String PRE_GROUP = "group_";
    private static final String PRE_FUNC = "func_";
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_TARGET = "target";
    private static final String KEY_FUNCTREE = "functree";
    private static final String KEY_PREDEFINETREE = "predefinetree";
    private static final String KEY_FUNCNAME = "funcname";
    private static final String KEY_FUNCDESC = "funcdesc";
    private static final String KEY_RETURNTYPE = "returntype";
    private static final String KEY_FORMULA = "formula";
    private static final String KEY_BTNOK = "btnok";
    private static final String CACHEKEY_FUNCS = "functions";
    private static final String CACHEKEY_FUNCID = "funcId";
    private static final HashSet<String> OPERATION_LIST = Sets.newHashSet((Object[])new String[]{"(", ")", "STRING", "CONCAT", "NOW", "YEAR", "MONTH", "DAY", "GetCurrUserId", ",", "+"});

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        model.setValue(KEY_TARGET, formShowParameter.getCustomParam("targetVariable"));
        String expression = (String)this.getView().getFormShowParameter().getCustomParam("expression");
        model.setValue(KEY_FORMULA, (Object)expression);
        this.initFuncTree();
        this.initPredefineTree();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFuncInfo(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51fd\u6570", (String)"TableHeaderSettingPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), "");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        TreeView funcTree = (TreeView)this.getControl(KEY_FUNCTREE);
        funcTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView abilityTree = (TreeView)this.getControl(KEY_PREDEFINETREE);
        abilityTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (KEY_BTNOK.equals(key)) {
            this.validateAndReturnData();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        IPageCache pageCache;
        String funcId;
        String nodeId = String.valueOf(evt.getNodeId());
        if (nodeId.startsWith(PRE_FUNC) && !StringUtils.equals((CharSequence)(funcId = nodeId.substring(PRE_FUNC.length())), (CharSequence)(pageCache = this.getPageCache()).get(CACHEKEY_FUNCID))) {
            this.showFuncInfo(funcId);
            pageCache.put(CACHEKEY_FUNCID, funcId);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = String.valueOf(evt.getNodeId());
        if (KEY_PREDEFINETREE.equals(treeView.getKey())) {
            this.insertExpression(treeView.getKey(), nodeId);
        } else if (nodeId.startsWith(PRE_FUNC)) {
            nodeId = nodeId.substring(PRE_FUNC.length());
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            for (FunctionType functionType : functionTypes.getFunctionTypes()) {
                if (!nodeId.equals(functionType.getId())) continue;
                String def = functionType.getDef();
                def = def.replaceAll("str\\[\\]", " ");
                def = def.replaceAll("obj", " ");
                def = def.replaceAll("dateTime", " ");
                this.insertExpression(treeView.getKey(), def);
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode treeNode;
        int i;
        String searchText = searchEnterEvent.getText();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        int beginIndex = 0;
        if (focusNodeId != null && !ROOTID.equals(focusNodeId)) {
            for (TreeNode funcTreeNode : funcTreeNodes) {
                ++beginIndex;
                if (!focusNodeId.equals(funcTreeNode.getParentid()) && !focusNodeId.equals(funcTreeNode.getId())) continue;
                break;
            }
        }
        for (i = beginIndex; i < funcTreeNodes.size(); ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
        for (i = 0; i < beginIndex; ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return null;
        }
        ArrayList<String> searchList = new ArrayList<String>();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String text = funcTreeNode.getText();
            if (!this.containsIgnoreCase(text, searchText)) continue;
            searchList.add(text);
        }
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String id = funcTreeNode.getId();
            if (!this.containsIgnoreCase(id, searchText)) continue;
            searchList.add(id.substring(PRE_FUNC.length()));
        }
        return searchList;
    }

    private void validateAndReturnData() {
        IFormView view = this.getView();
        String expression = (String)this.getModel().getValue(KEY_FORMULA);
        String formula = "";
        ArrayList formulaList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            expression = expression.replaceAll("\u201c", "\"").replaceAll("\u201d", "\"").replaceAll("\u2018", "'").replaceAll("\u2019", "'");
            FormulaParseUtils.getFormulaList((String)expression, formulaList, OPERATION_LIST, (boolean)true);
        }
        for (String value : formulaList) {
            String key;
            if (OPERATION_LIST.contains(value)) {
                key = value;
            } else if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
                key = value;
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u91cf\uff1a\"", (String)"TableHeaderSettingPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]).concat(value).concat(ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u66f4\u6539\u3002", (String)"TableHeaderSettingPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
                return;
            }
            formula = formula.concat(key);
        }
        try {
            FormulaEngine.extractVariables((String)formula);
        }
        catch (FormulaException formulaException) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a ", (String)"TableHeaderSettingPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (formulaException.getCause() == null ? formulaException.getMessage() : formulaException.getCause().getMessage()));
            return;
        }
        catch (Exception exception) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a ", (String)"TableHeaderSettingPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + exception.getMessage());
            return;
        }
        try {
            FormulaEngine.execExcelFormula((String)formula);
        }
        catch (Exception e) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a ", (String)"TableHeaderSettingPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage());
            return;
        }
        view.returnDataToParent((Object)new String[]{expression, formula});
        view.close();
    }

    private void insertExpression(String controlKey, String insertStr) {
        IDataModel model = this.getModel();
        String text = (String)model.getValue(KEY_FORMULA);
        String expression = this.getExpression(controlKey, text, insertStr);
        model.setValue(KEY_FORMULA, (Object)expression);
    }

    private String getExpression(String controlKey, String text, String insertStr) {
        int cursorIndex;
        String expression = text;
        if (StringUtils.isBlank((CharSequence)text)) {
            expression = insertStr;
            cursorIndex = insertStr.length();
        } else {
            int pos = this.getCursorIndex(controlKey, text);
            expression = this.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        this.setCursorIndex(cursorIndex);
        return expression;
    }

    private String insertCharacter(String expression, String insertStr, int pos) {
        int length = expression.length();
        if (length < pos) {
            pos = length;
        }
        StringBuilder sb = new StringBuilder(expression);
        sb.insert(pos, insertStr);
        return sb.toString();
    }

    private int getCursorIndex(String controlKey, String text) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Object viewState = proxy.getViewState(controlKey);
        if (viewState instanceof Map) {
            Map map = (Map)viewState;
            Object focusResult = map.get("focus");
            if (focusResult instanceof Map) {
                Map focusMap = (Map)focusResult;
                return focusMap.getOrDefault(KEY_FORMULA, text.length());
            }
            return map.getOrDefault(KEY_FORMULA, text.length());
        }
        return text.length();
    }

    private void setCursorIndex(int cursorIndex) {
        LinkedHashMap cursorMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        cursorMap.put("ctrlKey", KEY_FORMULA);
        cursorMap.put("cursorIndex", cursorIndex);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", (Object)cursorMap);
    }

    private void showFuncInfo(String funcId) {
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        for (FunctionType functionType : functionTypes.getFunctionTypes()) {
            if (!funcId.equals(functionType.getId())) continue;
            this.setFuncInfo(functionType.getDef(), ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1a", (String)"TableHeaderSettingPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + functionType.getReturnType());
            this.getModel().setValue(KEY_FUNCDESC, (Object)this.analyzingDesc(functionType.getDesc().getLocaleValue()));
        }
    }

    private boolean isSearchNode(TreeNode treeNode, String searchText) {
        return this.containsIgnoreCase(treeNode.getText(), searchText) || this.containsIgnoreCase(treeNode.getId().substring(PRE_FUNC.length()), searchText);
    }

    private boolean containsIgnoreCase(String str, String searchStr) {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)searchStr)) {
            return false;
        }
        return str.toLowerCase().contains(searchStr.toLowerCase());
    }

    private List<TreeNode> getFuncTreeNodes() {
        IPageCache pageCache = this.getPageCache();
        String str = pageCache.get(CACHEKEY_FUNCS);
        return StringUtils.isBlank((CharSequence)str) ? Collections.emptyList() : SerializationUtils.fromJsonStringToList((String)str, TreeNode.class);
    }

    private void initFuncTree() {
        TreeNode groupNode;
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8\u51fd\u6570", (String)"TableHeaderSettingPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        root.setIsOpened(true);
        FunctionTypes commonFuncs = FunctionTypes.getCommonFuncs();
        List functionGroups = commonFuncs.getFunctionGroups();
        functionGroups.removeIf(functionGroup -> "Common".equals(functionGroup.getId()) || "NullJudge".equals(functionGroup.getId()) || "Math".equals(functionGroup.getId()) || "Set".equals(functionGroup.getId()));
        functionGroups.sort(Comparator.comparingInt(FunctionGroup::getSeq));
        LinkedHashMap groupId2TreeNode = Maps.newLinkedHashMapWithExpectedSize((int)functionGroups.size());
        for (FunctionGroup functionGroup2 : functionGroups) {
            if (!functionGroup2.isVisible()) continue;
            TreeNode groupNode2 = new TreeNode();
            String string = functionGroup2.getId();
            groupNode2.setId(PRE_GROUP + string);
            groupNode2.setText(functionGroup2.getName().getLocaleValue());
            groupNode2.setParentid(ROOTID);
            groupId2TreeNode.put(string, groupNode2);
        }
        List functionTypes = commonFuncs.getFunctionTypes();
        ArrayList funcTreeNodes = Lists.newArrayListWithExpectedSize((int)functionTypes.size());
        functionTypes.sort(Comparator.comparingInt(FunctionType::getSeq));
        for (FunctionType functionType : functionTypes) {
            groupNode = (TreeNode)groupId2TreeNode.get(functionType.getGroupId());
            if (groupNode == null || "group_DateTime".equals(groupNode.getId()) && !Arrays.asList("NOW", "YEAR", "MONTH", "DAY").contains(functionType.getId().trim()) || "group_String".equals(groupNode.getId()) && !"CONCAT".equals(functionType.getId()) && !"STRING".equals(functionType.getId())) continue;
            TreeNode funcNode = new TreeNode();
            funcNode.setId(PRE_FUNC + functionType.getId());
            funcNode.setText(functionType.getName().getLocaleValue());
            funcNode.setParentid(groupNode.getId());
            groupNode.addChild(funcNode);
            funcTreeNodes.add(funcNode);
        }
        for (Map.Entry entry : groupId2TreeNode.entrySet()) {
            groupNode = (TreeNode)entry.getValue();
            if (groupNode == null || groupNode.getChildren() == null) continue;
            root.addChild(groupNode);
        }
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        treeView.addNode(root);
        this.getPageCache().put(CACHEKEY_FUNCS, SerializationUtils.toJsonString((Object)funcTreeNodes));
    }

    private void initPredefineTree() {
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"TableHeaderSettingPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        TreeNode str2 = new TreeNode(ROOTID, ResManager.loadKDString((String)"\"\u5e74\"", (String)"TableHeaderSettingPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e74", (String)"TableHeaderSettingPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.addChild(str2);
        TreeNode str3 = new TreeNode(ROOTID, ResManager.loadKDString((String)"\"\u6708\"", (String)"TableHeaderSettingPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6708", (String)"TableHeaderSettingPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.addChild(str3);
        TreeNode str4 = new TreeNode(ROOTID, ResManager.loadKDString((String)"\"\u65e5\"", (String)"TableHeaderSettingPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e5", (String)"TableHeaderSettingPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.addChild(str4);
        TreeView treeView = (TreeView)this.getControl(KEY_PREDEFINETREE);
        treeView.addNode(root);
    }

    private void setFuncInfo(String funcName, String returnType) {
        ((Label)this.getControl(KEY_FUNCNAME)).setText(funcName);
        ((Label)this.getControl(KEY_RETURNTYPE)).setText(returnType);
    }

    private String analyzingDesc(String desc) {
        ArrayList<String> descLines = new ArrayList<String>(10);
        String temp = desc;
        int index = temp.indexOf("\\n");
        while (index > 0) {
            descLines.add(temp.substring(0, index));
            temp = index < temp.length() - 2 ? temp.substring(index + 2) : "";
            index = temp.indexOf("\\n");
        }
        if (StringUtils.isNotBlank((CharSequence)temp)) {
            descLines.add(temp);
        }
        return StringUtils.join((Object[])descLines.toArray(), (char)'\n');
    }
}

