/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.FireFocusEvent;
import kd.bos.form.control.events.InputFocusListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.phm.common.util.datatemp.FormulaParseUtils;
import kd.mmc.phm.common.util.datatemp.FormulaValiditionUtils;

public class TableLineSettingPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener,
InputFocusListener {
    private static final Log logger = LogFactory.getLog(TableLineSettingPlugin.class);
    private static final String ROOTID = "root";
    private static final String PRE_GROUP = "group_";
    private static final String PRE_FUNC = "func_";
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_TARGETLINE = "targetline";
    private static final String KEY_TARGETTYPE = "targetType";
    private static final String KEY_SOURCETEMPID = "sourceTempId";
    private static final String KEY_FUNCTREE = "functree";
    private static final String KEY_SOURCELINETREE = "sourcelinetree";
    private static final String KEY_TARGETLINETREE = "targetlinetree";
    private static final String KEY_FUNCNAME = "funcname";
    private static final String KEY_FUNCDESC = "funcdesc";
    private static final String KEY_RETURNTYPE = "returntype";
    private static final String KEY_FORMULA = "formula";
    private static final String KEY_CONDITION = "condition";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTN_CLEAR = "btn_clear";
    private static final String CACHEKEY_FUNCS = "functions";
    private static final String CACHEKEY_FUNCID = "funcId";
    private static final String KEY_SUM = "sum";
    private static final String KEY_EQUAL = "equal";
    private static final String FORMAT = "format";
    private static final String SOURCE_TREE_MAP = "sourceTreeMap";
    private static final String TARGET_TREE_MAP = "targetTreeMap";
    private static final String SOURCE_TYPE_MAP = "sourceTypeMap";
    private static final String EDIT_CONTROL_AP = "editControlAp";
    private static final Set<String> OPERATION_LIST = Sets.newHashSet((Object[])new String[]{",", "+", "-", "*", "/"});

    public void initialize() {
        super.initialize();
        TextEdit formula = (TextEdit)this.getControl(KEY_FORMULA);
        formula.addInputFocusListener((InputFocusListener)this);
        TextEdit condition = (TextEdit)this.getControl(KEY_CONDITION);
        condition.addInputFocusListener((InputFocusListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        model.setValue(FORMAT, formShowParameter.getCustomParam(FORMAT));
        model.setValue(KEY_TARGETLINE, formShowParameter.getCustomParam(KEY_TARGETLINE));
        this.getPageCache().put(KEY_TARGETTYPE, (String)formShowParameter.getCustomParam(KEY_TARGETTYPE));
        String expressionAll = (String)this.getView().getFormShowParameter().getCustomParam("expressionAll");
        if (StringUtils.isNotBlank((CharSequence)expressionAll)) {
            String[] split = expressionAll.split("&");
            model.setValue(KEY_FORMULA, (Object)split[0]);
            model.setValue(KEY_CONDITION, (Object)split[2]);
        }
        this.initFuncTree();
        Long sourceTempId = (Long)formShowParameter.getCustomParam(KEY_SOURCETEMPID);
        Map targetTreeMap = (Map)JSONObject.parseObject((String)((String)formShowParameter.getCustomParam(TARGET_TREE_MAP)), Map.class);
        this.initLineTree(sourceTempId);
        this.initTargetLineTree(targetTreeMap);
        this.getPageCache().put(EDIT_CONTROL_AP, KEY_CONDITION);
    }

    private void initTargetLineTree(Map<String, String> targetTreeMap) {
        if (targetTreeMap == null) {
            return;
        }
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"TableLineSettingPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>(targetTreeMap.size());
        for (Map.Entry<String, String> stringStringEntry : targetTreeMap.entrySet()) {
            childs.add(new TreeNode(ROOTID, stringStringEntry.getKey(), stringStringEntry.getKey()));
        }
        root.setChildren(childs);
        TreeView treeView = (TreeView)this.getControl(KEY_TARGETLINETREE);
        treeView.addNode(root);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFuncInfo(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51fd\u6570", (String)"TableLineSettingPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]), "");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        TreeView funcTree = (TreeView)this.getControl(KEY_FUNCTREE);
        funcTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView sourceLineTree = (TreeView)this.getControl(KEY_SOURCELINETREE);
        sourceLineTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView targetLineTree = (TreeView)this.getControl(KEY_TARGETLINETREE);
        targetLineTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTN_CLEAR});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (KEY_BTNOK.equals(key)) {
            this.validateAndReturnData();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        IPageCache pageCache;
        String funcId;
        String nodeId = String.valueOf(evt.getNodeId());
        if (nodeId.startsWith(PRE_FUNC) && !StringUtils.equals((CharSequence)(funcId = nodeId.substring(PRE_FUNC.length())), (CharSequence)(pageCache = this.getPageCache()).get(CACHEKEY_FUNCID))) {
            this.showFuncInfo(funcId);
            pageCache.put(CACHEKEY_FUNCID, funcId);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        String editControlAp = this.getPageCache().get(EDIT_CONTROL_AP);
        if (StringUtils.isBlank((CharSequence)editControlAp)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u9009\u62e9\u7f16\u8f91\u6846\u5728\u8fdb\u884c\u64cd\u4f5c", (String)"TableLineSettingPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = String.valueOf(evt.getNodeId());
        if (KEY_SOURCELINETREE.equals(treeView.getKey())) {
            this.insertExpression(treeView.getKey(), nodeId, editControlAp);
        } else if (KEY_TARGETLINETREE.equals(treeView.getKey())) {
            if (KEY_FORMULA.equals(editControlAp)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5143\u5217\u53ea\u80fd\u7528\u4e8e\u6761\u4ef6\u8868\u8fbe\u5f0f", (String)"TableLineSettingPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.insertExpression(treeView.getKey(), nodeId, editControlAp);
        } else if (nodeId.startsWith(PRE_FUNC)) {
            if (KEY_EQUAL.equals(nodeId = nodeId.substring(PRE_FUNC.length()))) {
                if (KEY_CONDITION.equals(editControlAp)) {
                    this.insertExpression(treeView.getKey(), "equal( )", editControlAp);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u51fd\u6570\u53ea\u80fd\u7528\u4e8e\u6761\u4ef6\u8868\u8fbe\u5f0f", (String)"TableLineSettingPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
            } else if (KEY_SUM.equals(nodeId)) {
                if (KEY_CONDITION.equals(editControlAp)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u5408\u51fd\u6570\u53ea\u80fd\u7528\u4e8e\u6570\u5b66\u8868\u8fbe\u5f0f", (String)"TableLineSettingPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.insertExpression(treeView.getKey(), "sum( )", editControlAp);
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode treeNode;
        int i;
        String searchText = searchEnterEvent.getText();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        int beginIndex = 0;
        if (focusNodeId != null && !ROOTID.equals(focusNodeId)) {
            for (TreeNode funcTreeNode : funcTreeNodes) {
                ++beginIndex;
                if (!focusNodeId.equals(funcTreeNode.getParentid()) && !focusNodeId.equals(funcTreeNode.getId())) continue;
                break;
            }
        }
        for (i = beginIndex; i < funcTreeNodes.size(); ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
        for (i = 0; i < beginIndex; ++i) {
            treeNode = funcTreeNodes.get(i);
            if (!this.isSearchNode(treeNode, searchText)) continue;
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
            treeView.treeNodeClick("", treeNode.getId());
            return;
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return null;
        }
        ArrayList<String> searchList = new ArrayList<String>();
        List<TreeNode> funcTreeNodes = this.getFuncTreeNodes();
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String text = funcTreeNode.getText();
            if (!this.containsIgnoreCase(text, searchText)) continue;
            searchList.add(text);
        }
        for (TreeNode funcTreeNode : funcTreeNodes) {
            String id = funcTreeNode.getId();
            if (!this.containsIgnoreCase(id, searchText)) continue;
            searchList.add(id.substring(PRE_FUNC.length()));
        }
        return searchList;
    }

    private void validateAndReturnData() {
        BigDecimal format = (BigDecimal)this.getModel().getValue(FORMAT);
        if (BigDecimal.ZERO.compareTo(format) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c0f\u6570\u70b9\u7cbe\u786e\u4f4d\u6570\u9700\u5f55\u5165\u6b63\u6574\u6570\u3002", (String)"TableLineSettingPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String expression = (String)this.getModel().getValue(KEY_FORMULA);
        String condition = (String)this.getModel().getValue(KEY_CONDITION);
        if (StringUtils.isBlank((CharSequence)expression) || StringUtils.isBlank((CharSequence)condition)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u548c\u6570\u5b66\u8868\u8fbe\u5f0f\u9700\u5168\u90e8\u5f55\u5165\u3002", (String)"TableLineSettingPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String conditionFormula = "";
        String[] conditionStr = condition.split(",");
        Map sourceTreeMap = (Map)JSONObject.parseObject((String)this.getPageCache().get(SOURCE_TREE_MAP), Map.class);
        Map targetTreeMap = (Map)JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam(TARGET_TREE_MAP)), Map.class);
        try {
            String[] split = condition.split("equal\\(");
            String[] split1 = split[1].trim().split(",");
            String obj1 = split1[0].trim();
            boolean endFlag = split1[1].trim().endsWith(")");
            if (!endFlag) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\u3002", (String)"TableLineSettingPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            String obj2 = split1[1].trim().substring(0, split1[1].trim().length() - 1).trim();
            if (!sourceTreeMap.containsKey(obj1)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e2d\u5173\u8054\u6a21\u677f\u5217\uff1a\"", (String)"TableLineSettingPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]).concat(obj1).concat(ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u66f4\u6539\u3002", (String)"TableLineSettingPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
                return;
            }
            String value = sourceTreeMap.get(obj1).toString();
            conditionFormula = conditionFormula + conditionStr[0].replace(obj1, value) + ",";
            if (!targetTreeMap.containsKey(obj2)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e2d\u76ee\u6807\u6a21\u677f\u5217\uff1a\"", (String)"TableLineSettingPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]).concat(obj2).concat(ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u66f4\u6539\u3002", (String)"TableLineSettingPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
                return;
            }
            value = targetTreeMap.get(obj2).toString();
            conditionFormula = conditionFormula + conditionStr[1].replace(obj2, value);
        }
        catch (Exception e) {
            logger.info("phm\u8868\u5217\u8bbe\u7f6e\u6761\u4ef6\u8868\u8fbe\u5f0f:".concat(e.getMessage()));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\u3002", (String)"TableLineSettingPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String formula = this.validitionFormat(expression, sourceTreeMap);
        String concat = expression.concat("&").concat(formula).concat("&").concat(condition).concat("&").concat(conditionFormula);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put(KEY_FORMULA, concat);
        returnMap.put(FORMAT, format.intValue());
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    private String validitionFormat(String expression, Map sourceTreeMap) {
        String[] variables;
        boolean endFlag;
        String[] split = expression.split("sum\\(");
        String formula = "sum(";
        try {
            endFlag = split[1].trim().endsWith(")");
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b66\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\u3002", (String)"TableLineSettingPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        if (!endFlag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b66\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\u3002", (String)"TableLineSettingPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        String obj = split[1].trim().substring(0, split[1].trim().length() - 1).trim();
        ArrayList formulaList = new ArrayList();
        FormulaParseUtils.getFormulaList((String)obj, formulaList, OPERATION_LIST, (boolean)true);
        for (String value : formulaList) {
            String key;
            if (OPERATION_LIST.contains(value)) {
                key = value;
            } else if (FormulaValiditionUtils.isNumber((String)value)) {
                key = value;
            } else if (sourceTreeMap.containsKey(value)) {
                key = sourceTreeMap.get(value).toString();
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b66\u8868\u8fbe\u5f0f\u4e2d\u5173\u8054\u6a21\u677f\u5217\uff1a\"", (String)"TableLineSettingPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]).concat(obj).concat(ResManager.loadKDString((String)"\"\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u66f4\u6539\u3002", (String)"TableLineSettingPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
            }
            formula = formula.concat(key);
        }
        formula = formula.concat(")");
        try {
            variables = FormulaEngine.extractVariables((String)formula);
        }
        catch (FormulaException formulaException) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b66\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a ", (String)"TableLineSettingPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (formulaException.getCause() == null ? formulaException.getMessage() : formulaException.getCause().getMessage()));
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b66\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a ", (String)"TableLineSettingPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + exception.getMessage());
        }
        Map sourceTypeMap = (Map)JSONObject.parseObject((String)this.getPageCache().get(SOURCE_TYPE_MAP), Map.class);
        for (String variable : variables) {
            if (this.getPageCache().get(KEY_TARGETTYPE).equals(sourceTypeMap.get(variable))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5143\u5217\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0e\u6570\u5b66\u8868\u8fbe\u5f0f\u4e2d\u9009\u62e9\u7684", (String)"TableLineSettingPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]).concat(variable).concat(ResManager.loadKDString((String)"\u5217\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"TableLineSettingPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
        }
        return formula;
    }

    private void insertExpression(String controlKey, String insertStr, String editControlAp) {
        IDataModel model = this.getModel();
        String text = (String)model.getValue(editControlAp);
        String expression = this.getExpression(controlKey, text, insertStr, editControlAp);
        model.setValue(editControlAp, (Object)expression);
    }

    private String getExpression(String controlKey, String text, String insertStr, String editControlAp) {
        int cursorIndex;
        String expression = text;
        if (StringUtils.isBlank((CharSequence)text)) {
            expression = insertStr;
            cursorIndex = insertStr.length();
        } else {
            int pos = this.getCursorIndex(controlKey, text, editControlAp);
            expression = this.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        this.setCursorIndex(cursorIndex, editControlAp);
        return expression;
    }

    private String insertCharacter(String expression, String insertStr, int pos) {
        int length = expression.length();
        if (length < pos) {
            pos = length;
        }
        StringBuilder sb = new StringBuilder(expression);
        sb.insert(pos, insertStr);
        return sb.toString();
    }

    private int getCursorIndex(String controlKey, String text, String editControlAp) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Object viewState = proxy.getViewState(controlKey);
        if (viewState instanceof Map) {
            Map map = (Map)viewState;
            Object focusResult = map.get("focus");
            if (focusResult instanceof Map) {
                Map focusMap = (Map)focusResult;
                return focusMap.getOrDefault(editControlAp, text.length());
            }
            return map.getOrDefault(editControlAp, text.length());
        }
        return text.length();
    }

    private void setCursorIndex(int cursorIndex, String ctrlKey) {
        LinkedHashMap cursorMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        cursorMap.put("ctrlKey", ctrlKey);
        cursorMap.put("cursorIndex", cursorIndex);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", (Object)cursorMap);
    }

    private void showFuncInfo(String funcId) {
        if (KEY_EQUAL.equals(funcId)) {
            this.setFuncInfo("equal(obj1\uff0cobj2)", ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1aobj[]", (String)"TableLineSettingPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(KEY_FUNCDESC, (Object)(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u83b7\u53d6\u6ee1\u8db3\u6761\u4ef6\u7684\u6240\u6709\u6570\u636e \n", (String)"TableLineSettingPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aequal(obj1,obj2) \n", (String)"TableLineSettingPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aobj1, \u4f5c\u4e3a\u6761\u4ef6\u7684\u5173\u8054\u6a21\u7248\u5355\u5143\u5217\uff0cobj2, \u4f5c\u4e3a\u6761\u4ef6\u7684\u76ee\u6807\u6a21\u7248\u5355\u5143\u5217  \n", (String)"TableLineSettingPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1aequal(\u5173\u8054\u6a21\u7248\u5355\u5143\u5217\uff0c\u76ee\u6807\u6a21\u7248\u5355\u5143\u5217) \u8fd4\u56de \u5173\u8054\u5355\u5143\u5217\u4e0e\u76ee\u6807\u5355\u5143\u5217\u8be5\u884c\u503c\u76f8\u7b49\u7684\u6240\u6709\u6570\u636e", (String)"TableLineSettingPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
        } else if (KEY_SUM.equals(funcId)) {
            this.setFuncInfo("sum(obj)", ResManager.loadKDString((String)"\u8fd4\u56de\u503c\uff1anumber", (String)"TableLineSettingPlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(KEY_FUNCDESC, (Object)(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u5408\u8ba1\u7b26\u5408\u6761\u4ef6\u8868\u8fbe\u5f0f\u7684\u6240\u6709\u6570\u636e\u8be5\u5217\u4e4b\u548c \n", (String)"TableLineSettingPlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1asum(obj) \n", (String)"TableLineSettingPlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aobj, \u5408\u8ba1\u7684\u5173\u8054\u6a21\u7248\u5355\u5143\u5217  \n", (String)"TableLineSettingPlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1asum(\u5173\u8054\u6a21\u7248\u5355\u5143\u5217) \u8fd4\u56de \u7b26\u5408\u6761\u4ef6\u8868\u8fbe\u5f0f\u7684\u6240\u6709\u5173\u8054\u6a21\u7248\u6570\u636e\u8be5\u5355\u5143\u5217\u4e4b\u548c", (String)"TableLineSettingPlugin_26", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
        }
    }

    private boolean isSearchNode(TreeNode treeNode, String searchText) {
        return this.containsIgnoreCase(treeNode.getText(), searchText) || this.containsIgnoreCase(treeNode.getId().substring(PRE_FUNC.length()), searchText);
    }

    private boolean containsIgnoreCase(String str, String searchStr) {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)searchStr)) {
            return false;
        }
        return str.toLowerCase().contains(searchStr.toLowerCase());
    }

    private List<TreeNode> getFuncTreeNodes() {
        IPageCache pageCache = this.getPageCache();
        String str = pageCache.get(CACHEKEY_FUNCS);
        return StringUtils.isBlank((CharSequence)str) ? Collections.emptyList() : SerializationUtils.fromJsonStringToList((String)str, TreeNode.class);
    }

    private void initFuncTree() {
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8\u51fd\u6570", (String)"TableLineSettingPlugin_27", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        root.setIsOpened(true);
        LinkedHashMap groupId2TreeNode = Maps.newLinkedHashMapWithExpectedSize((int)2);
        TreeNode treeNode = new TreeNode();
        String groupId = "Set";
        treeNode.setId(PRE_GROUP + groupId);
        treeNode.setText(ResManager.loadKDString((String)"\u96c6\u5408\u51fd\u6570", (String)"TableLineSettingPlugin_28", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        treeNode.setParentid(ROOTID);
        groupId2TreeNode.put(groupId, treeNode);
        TreeNode conditionTreeNode = new TreeNode();
        String conditionGroupId = KEY_CONDITION;
        conditionTreeNode.setId(PRE_GROUP + conditionGroupId);
        conditionTreeNode.setText(ResManager.loadKDString((String)"\u6761\u4ef6\u51fd\u6570", (String)"TableLineSettingPlugin_29", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        conditionTreeNode.setParentid(ROOTID);
        groupId2TreeNode.put(conditionGroupId, conditionTreeNode);
        ArrayList funcTreeNodes = Lists.newArrayListWithExpectedSize((int)2);
        TreeNode sumGroupNode = (TreeNode)groupId2TreeNode.get(groupId);
        TreeNode funcNode = new TreeNode();
        funcNode.setId("func_sum");
        funcNode.setText(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TableLineSettingPlugin_30", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        funcNode.setParentid(treeNode.getId());
        sumGroupNode.addChild(funcNode);
        funcTreeNodes.add(funcNode);
        TreeNode conditionGroupNode = (TreeNode)groupId2TreeNode.get(conditionGroupId);
        TreeNode conditionFuncNode = new TreeNode();
        conditionFuncNode.setId("func_equal");
        conditionFuncNode.setText(ResManager.loadKDString((String)"\u7b49\u503c\u8fc7\u6ee4", (String)"TableLineSettingPlugin_31", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        conditionFuncNode.setParentid(conditionTreeNode.getId());
        conditionGroupNode.addChild(conditionFuncNode);
        funcTreeNodes.add(conditionFuncNode);
        for (Map.Entry entry : groupId2TreeNode.entrySet()) {
            TreeNode groupNode = (TreeNode)entry.getValue();
            if (groupNode.getChildren().isEmpty()) continue;
            root.addChild(groupNode);
        }
        TreeView treeView = (TreeView)this.getControl(KEY_FUNCTREE);
        treeView.addNode(root);
        this.getPageCache().put(CACHEKEY_FUNCS, SerializationUtils.toJsonString((Object)funcTreeNodes));
    }

    private void initLineTree(Long tempId) {
        TreeNode root = new TreeNode("", ROOTID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"TableLineSettingPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        ORM orm = ORM.create();
        long tempConfigId = 0L;
        QFilter[] tempFilters = new QFilter[]{new QFilter("id", "=", (Object)tempId)};
        try (DataSet dataSet = orm.queryDataSet("phm_queryBilltemp", "phm_billtemp", "tempconf", tempFilters);){
            for (Row row : dataSet) {
                tempConfigId = row.getLong(0);
            }
        }
        QFilter[] configFilters = new QFilter[]{new QFilter("id", "=", (Object)tempConfigId)};
        DataSet dataSet = orm.queryDataSet("phm_queryBilltempSet", "phm_billtemp_set", "fieldentryentity.fieldcellpo fieldcellpo, fieldentryentity.fieldcellname name, fieldentryentity.fieldtype type, fieldentryentity.cellcol cellcol", configFilters);
        Object object = null;
        try {
            ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
            Map sourceTreeMap = (Map)JSONObject.parseObject((String)this.getPageCache().get(SOURCE_TREE_MAP), Map.class);
            sourceTreeMap = sourceTreeMap == null ? new HashMap(10) : sourceTreeMap;
            Map sourceTypeMap = (Map)JSONObject.parseObject((String)this.getPageCache().get(SOURCE_TYPE_MAP), Map.class);
            sourceTypeMap = sourceTypeMap == null ? new HashMap(10) : sourceTypeMap;
            for (Row row : dataSet) {
                if (StringUtils.isBlank((CharSequence)row.getString(0))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6765\u6e90\u6a21\u7248\u8868\u5217\u672a\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"TableLineSettingPlugin_32", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String treeNodeName = row.getString(0).trim().concat("_").concat(StringUtils.isBlank((CharSequence)row.getString(1)) ? "Null" : row.getString(1).trim());
                childs.add(new TreeNode(ROOTID, treeNodeName, treeNodeName));
                sourceTreeMap.put(treeNodeName, row.getString(0).trim());
                sourceTypeMap.put(row.getString(0).trim(), row.getString(2).trim());
            }
            this.getPageCache().put(SOURCE_TREE_MAP, JSONObject.toJSONString((Object)sourceTreeMap));
            this.getPageCache().put(SOURCE_TYPE_MAP, JSONObject.toJSONString((Object)sourceTypeMap));
            root.setChildren(childs);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        TreeView treeView = (TreeView)this.getControl(KEY_SOURCELINETREE);
        treeView.addNode(root);
    }

    private void setFuncInfo(String funcName, String returnType) {
        ((Label)this.getControl(KEY_FUNCNAME)).setText(funcName);
        ((Label)this.getControl(KEY_RETURNTYPE)).setText(returnType);
    }

    public void inputFocus(FireFocusEvent fireFocusEvent) {
        TextEdit textEdit = (TextEdit)fireFocusEvent.getSource();
        this.getPageCache().put(EDIT_CONTROL_AP, textEdit.getKey());
    }
}

