/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.tools.Column;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.enums.FieldType;
import kd.mmc.phm.common.info.BillColumnInfo;
import kd.mmc.phm.common.info.BillHeadInfo;
import kd.mmc.phm.common.info.DataAreaInfo;
import kd.mmc.phm.common.info.DataTempColumnInfo;
import kd.mmc.phm.common.info.FormulaColumnInfo;
import kd.mmc.phm.common.info.IndexCol;
import kd.mmc.phm.common.info.IndexColumnInfo;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.Cell;
import kd.mmc.phm.common.spread.model.CellBorderStyle;
import kd.mmc.phm.common.spread.model.CellStyle;
import kd.mmc.phm.common.spread.model.FormulaCell;
import kd.mmc.phm.common.util.VersionRuleUtils;
import kd.mmc.phm.common.util.datatemp.TableLineConfigUnits;
import kd.mmc.phm.formplugin.bizmodel.billtemp.DataTempPreviewPlugin;
import kd.mmc.phm.formplugin.bizmodel.spread.AbstractReportPlugin;
import kd.mmc.phm.formplugin.bizmodel.spread.SpreadDataModel;

public class WorkStationBillPlugin
extends AbstractReportPlugin {
    private static final Log log = LogFactory.getLog(WorkStationBillPlugin.class);
    protected static final String algoKey = "WorkStationBillPlugin.";
    protected static final String RESOURCENUMBER = "resnumber";
    protected static final String RESOURCENAME = "resname";
    protected static final String CREATEORG = "createorg";
    protected static final String BIZTYPE = "biztype";
    protected static final String BILLTEMPTYPE = "billtemptype";
    protected static final String SEAT = "seat";
    protected static final String ROLE = "role";
    protected static final String CTRLSTRATEGY = "ctrlstrategy";
    protected static final String DATATABLES = "datatables";
    protected static final String BILLTEMPS = "billtemps";
    protected static final String ENTITY_HISTORY = "phm_filldata_history";
    protected static final String ENTITY_TEMP = "phm_billtemp";
    protected static final String RESOURCE = "resource";
    protected static final String SPREADJSON_TAG = "spreadjson_tag";
    protected static final String ISHISTORY = "isHistory";
    protected static final String REALROW = "realrow";
    protected static final String REALCOL = "realcol";
    protected static final String TEMPLATETYPE = "templateType";
    protected static final String CELLCONFID = "cellConfid";
    protected static final String CREATOR = "creator";
    protected static final String CREATETIME = "createtime";
    protected static final String MODIFIER = "modifier";
    protected static final String MODIFYTIME = "modifytime";
    protected static final String VERSIONNUMBER = "versionnumber";
    protected static final String VERSIONRULE = "versionrule";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"floatmenuap"});
    }

    @Override
    protected String getSpreadKey() {
        return "spreadap";
    }

    @Override
    protected SpreadDataModel getSpreadDataModelService() {
        return new SpreadDataModel(this, this.getSpreadKey()){

            @Override
            public void updateCellValue(SpreadEvent event) {
                super.updateCellValue(event);
                SpreadPostDataInfo postData = event.getPostData();
                List values = postData.getValues();
                for (LinkedHashMap value : values) {
                    if (!WorkStationBillPlugin.this.validatData(value)) continue;
                    WorkStationBillPlugin.this.updateIndexCells(value);
                    if (!(this.plugin instanceof DataTempPreviewPlugin)) {
                        WorkStationBillPlugin.this.updateDataTempCells(value);
                    }
                    WorkStationBillPlugin.this.appendNewOneRow(value);
                }
            }

            @Override
            public void askExecute(SpreadEvent event) {
                LinkedHashMap invokeParams = event.getPostData().getInvokeParams();
                if (invokeParams == null || invokeParams.isEmpty()) {
                    return;
                }
                String method = (String)invokeParams.get("method");
                Object data = invokeParams.get("data");
                if (data instanceof List) {
                    String str;
                    List list = (List)data;
                    if (StringUtils.equals((CharSequence)"deleteRow", (CharSequence)method)) {
                        str = WorkStationBillPlugin.this.getView().getPageCache().get(WorkStationBillPlugin.REALROW);
                        int realRow = 0;
                        if (StringUtils.isNotEmpty((CharSequence)str)) {
                            realRow = Integer.parseInt(str);
                        }
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            int row = (Integer)iterator.next();
                            if (row >= realRow) continue;
                            WorkStationBillPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u5305\u62ec\u6a21\u677f\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WorkStationBillPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    super.askExecute(event);
                    str = WorkStationBillPlugin.this.getView().getPageCache().get("rowCount");
                    if (StringUtils.isNotEmpty((CharSequence)str)) {
                        int rowCount = Integer.parseInt(str);
                        WorkStationBillPlugin.this.getView().getPageCache().put("rowCount", Integer.toString(rowCount - list.size()));
                    }
                } else {
                    super.askExecute(event);
                }
            }
        };
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject billTemp = this.getDataTemp();
        DynamicObject tempSetting = this.getTempSetting(billTemp.getLong("tempconf_id"));
        this.resolveDataTemp(tempSetting);
        this.showDatas(billTemp);
        this.updateHeadInfo();
        this.lockHeadCells();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "floatmenuitemap": {
                this.clickFloatShowOrHide();
                break;
            }
            case "save": {
                this.getSpreadContainer().getSpreadJson("actionSave");
                break;
            }
            case "submit": {
                this.getSpreadContainer().getSpreadJson("actionSubmit");
                break;
            }
            case "audit": {
                this.getSpreadContainer().getSpreadJson("actionAudit");
                break;
            }
            case "unsubmit": {
                this.actionUnSubmit();
                break;
            }
        }
    }

    @Override
    public void appendRows(int count) {
        super.appendRows(count);
        int rowIndex = this.getRowCount();
        ArrayList<Cell> cells = new ArrayList<Cell>(8);
        List<?> dataTempColumnInfoList = this.getListFromCache(DataTempColumnInfo.class);
        List<?> indexColumnInfoList = this.getListFromCache(IndexColumnInfo.class);
        List<?> formulaColumnInfoList = this.getListFromCache(FormulaColumnInfo.class);
        ArrayList<FormulaCell> formulaCellList = new ArrayList<FormulaCell>(8);
        int newRowCount = rowIndex + count;
        for (int i = rowIndex; i < newRowCount; ++i) {
            for (DataTempColumnInfo dataTempColumnInfo : dataTempColumnInfoList) {
                IndexCol output = dataTempColumnInfo.getOutput();
                Cell cell = new Cell(i, output.getCol());
                cells.add(cell);
            }
            for (IndexColumnInfo indexColumnInfo : indexColumnInfoList) {
                List indexValueList = indexColumnInfo.getIndexValueCols();
                for (IndexCol indexValue : indexValueList) {
                    Cell cell = new Cell(i, indexValue.getCol());
                    cells.add(cell);
                }
            }
            for (FormulaColumnInfo formulaColumnInfo : formulaColumnInfoList) {
                String formula = formulaColumnInfo.getFormula();
                IndexCol formulaCol = formulaColumnInfo.getFormulaCol();
                Cell cell = new Cell(i, formulaCol.getCol());
                cells.add(cell);
                FormulaCell formulaCell = new FormulaCell(i, formulaCol.getCol(), formula);
                formulaCellList.add(formulaCell);
            }
        }
        this.lockCells(cells);
        this.getSpreadContainer().setFormula(formulaCellList);
        this.getView().getPageCache().put("rowCount", Integer.toString(newRowCount));
    }

    public void actionSave(String spreadJson) {
        Set noPassCol;
        String noPass = this.getView().getPageCache().get("NOPASS");
        if (StringUtils.isNotEmpty((CharSequence)noPass) && (noPassCol = (Set)SerializationUtils.fromJsonString((String)noPass, Set.class)).size() != 0) {
            throw new KDBizException(noPassCol.toString() + ResManager.loadKDString((String)"\u516c\u5f0f\u8ba1\u7b97\u51fa\u9519\u3002", (String)"WorkStationBillPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Object templateId = this.getView().getFormShowParameter().getCustomParam(RESOURCE);
        String convertSpreadJson = SpreadUtils.convertSpreadJson((String)spreadJson);
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, HashMap.class);
        convertSpreadJson = this.resetSpreadJson(spreadMap);
        this.saveHistory(convertSpreadJson, templateId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"WorkStationBillPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    public void actionSubmit(String spreadJson) {
        Set noPassCol;
        String noPass = this.getView().getPageCache().get("NOPASS");
        if (StringUtils.isNotEmpty((CharSequence)noPass) && (noPassCol = (Set)SerializationUtils.fromJsonString((String)noPass, Set.class)).size() != 0) {
            throw new KDBizException(noPassCol.toString() + ResManager.loadKDString((String)"\u516c\u5f0f\u8ba1\u7b97\u51fa\u9519\u3002", (String)"WorkStationBillPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Object templateId = this.getView().getFormShowParameter().getCustomParam(RESOURCE);
        long historyId = (Long)this.getModel().getValue("history");
        String convertSpreadJson = SpreadUtils.convertSpreadJson((String)spreadJson);
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, HashMap.class);
        convertSpreadJson = this.resetSpreadJson(spreadMap);
        if (historyId == 0L) {
            DynamicObject dynamicObject = this.newDynamicObject(convertSpreadJson, templateId);
            dynamicObject.set("status", (Object)StatusEnum.SUBMIT.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.setHistortyId(dynamicObject.getLong("id"));
            this.getModel().setValue(VERSIONNUMBER, dynamicObject.get("number"));
            this.getModel().setValue(CREATOR, dynamicObject.get(CREATOR));
            this.getModel().setValue(CREATETIME, dynamicObject.get(CREATETIME));
        } else {
            DynamicObject dynamicObject = this.getUpdateDynamicObject(convertSpreadJson, historyId);
            dynamicObject.set("status", (Object)StatusEnum.SUBMIT.getValue());
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            this.getModel().setValue(MODIFIER, dynamicObject.get(MODIFIER));
            this.getModel().setValue(MODIFYTIME, dynamicObject.get(MODIFYTIME));
        }
        this.setStatus(StatusEnum.SUBMIT.getValue());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"WorkStationBillPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    protected void actionUnSubmit() {
        long historyId = (Long)this.getModel().getValue("history");
        QFilter qFilter = new QFilter("id", "=", (Object)historyId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_HISTORY, (String)"id,status", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7684\u3002", (String)"WorkStationBillPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String stauts = dynamicObject.getString("status");
        if (!StringUtils.equals((CharSequence)"B", (CharSequence)stauts)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7684\u3002", (String)"WorkStationBillPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        dynamicObject = this.getUpdateDynamicObject(null, historyId);
        dynamicObject.set("status", (Object)StatusEnum.SAVE.getValue());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        this.setStatus(StatusEnum.SAVE.getValue());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"WorkStationBillPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    public void actionAudit(String spreadJson) {
        long historyId = (Long)this.getModel().getValue("history");
        QFilter qFilter = new QFilter("id", "=", (Object)historyId);
        DynamicObject history = QueryServiceHelper.queryOne((String)ENTITY_HISTORY, (String)"id,status", (QFilter[])qFilter.toArray());
        if (history == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7684\u3002", (String)"WorkStationBillPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String stauts = history.getString("status");
        if (!StringUtils.equals((CharSequence)"B", (CharSequence)stauts)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7684\u3002", (String)"WorkStationBillPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)historyId, (String)ENTITY_HISTORY);
        dynamicObject.set(MODIFIER, (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set(MODIFYTIME, (Object)new Date());
        dynamicObject.set("status", (Object)StatusEnum.AUDIT.getValue());
        try (TXHandle h1 = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                this.setStatus(StatusEnum.AUDIT.getValue());
            }
            catch (Exception e) {
                h1.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"WorkStationBillPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"WorkStationBillPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.getSpreadContainer().rebuildSpread(dynamicObject.getString(SPREADJSON_TAG));
    }

    protected void saveHistory(String spreadJson, Object templateId) {
        long historyId = (Long)this.getModel().getValue("history");
        if (historyId == 0L) {
            DynamicObject dynamicObject = this.newDynamicObject(spreadJson, templateId);
            dynamicObject.set("status", (Object)StatusEnum.SAVE.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.setHistortyId(dynamicObject.getLong("id"));
            this.getModel().setValue(VERSIONNUMBER, dynamicObject.get("number"));
            this.getModel().setValue(CREATOR, dynamicObject.get(CREATOR));
            this.getModel().setValue(CREATETIME, dynamicObject.get(CREATETIME));
        } else {
            DynamicObject dynamicObject = this.getUpdateDynamicObject(spreadJson, historyId);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            this.getModel().setValue(MODIFIER, dynamicObject.get(MODIFIER));
            this.getModel().setValue(MODIFYTIME, dynamicObject.get(MODIFYTIME));
        }
        this.getModel().setValue("status", (Object)"A");
    }

    protected DynamicObject getUpdateDynamicObject(String spreadJson, long historyId) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_HISTORY), (Object)historyId);
        dynamicObject.set(SPREADJSON_TAG, (Object)spreadJson);
        dynamicObject.set(MODIFIER, (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set(MODIFYTIME, (Object)new Date());
        return dynamicObject;
    }

    protected DynamicObject newDynamicObject(String spreadJson, Object templateId) {
        long versionRuleId;
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_HISTORY));
        dynamicObject.set("template", templateId);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", templateId)};
        long templateVersionRuleId = 0L;
        try (DataSet dataSet = ORM.create().queryDataSet("WorkStationBillPlugin.queryTemplate", ENTITY_TEMP, "createorg, ctrlstrategy, versionrule", filters, null, 1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                dynamicObject.set(CREATEORG, row.get(0));
                dynamicObject.set(CTRLSTRATEGY, row.get(1));
                templateVersionRuleId = row.getLong(2);
            }
        }
        dynamicObject.set("number", (Object)String.valueOf(templateId));
        dynamicObject.set("name", (Object)String.valueOf(templateId));
        dynamicObject.set(SPREADJSON_TAG, (Object)spreadJson);
        dynamicObject.set("enable", (Object)EnableEnum.ENABLE.getValue());
        dynamicObject.set(CREATOR, (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set(CREATETIME, (Object)new Date());
        Object useGlobalObj = this.getView().getFormShowParameter().getCustomParam("globalrule");
        if (useGlobalObj != null) {
            Object processVersionRuleIdObj = this.getView().getFormShowParameter().getCustomParam("versionRule");
            long processVersionRuleId = Long.parseLong(String.valueOf(processVersionRuleIdObj));
            boolean useGlobal = (Boolean)useGlobalObj;
            versionRuleId = !useGlobal && templateVersionRuleId != 0L ? templateVersionRuleId : processVersionRuleId;
        } else {
            versionRuleId = templateVersionRuleId;
        }
        if (versionRuleId != 0L) {
            try {
                dynamicObject.set(VERSIONRULE, (Object)versionRuleId);
                this.fillNumberByRule(dynamicObject, versionRuleId);
                dynamicObject.set("name", (Object)dynamicObject.getString("number"));
            }
            catch (KDBizException exception) {
                log.warn(exception.getMessage(), (Throwable)exception);
                this.getView().showErrorNotification(exception.getMessage());
            }
        }
        return dynamicObject;
    }

    private void fillNumberByRule(DynamicObject history, long versionRuleId) {
        DynamicObject versionRule = BusinessDataServiceHelper.loadSingle((Object)versionRuleId, (String)"phm_versionrule");
        Tuple tuple = VersionRuleUtils.computePeriod((DynamicObject)versionRule);
        Date previousTime = (Date)tuple.item1;
        Date nextTime = (Date)tuple.item2;
        history.set("starttime", (Object)previousTime);
        history.set("endtime", (Object)nextTime);
        history.set("number", (Object)VersionRuleUtils.getNumber((DynamicObject)versionRule, (Date)previousTime, (Date)nextTime));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String pageId = this.getView().getPageId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pageId", pageId);
        this.getView().returnDataToParent(map);
    }

    protected void clickFloatShowOrHide() {
        String isShow = this.getPageCache().get("isFieldsShow");
        if (StringUtils.equals((CharSequence)"false", (CharSequence)isShow)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pagedimspanel"});
            this.getPageCache().put("isFieldsShow", "true");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagedimspanel"});
            this.getPageCache().put("isFieldsShow", "false");
        }
    }

    protected void showDatas(DynamicObject billTemp) {
        Object role = this.getView().getFormShowParameter().getCustomParam(ROLE);
        if (role != null) {
            List list = SerializationUtils.fromJsonStringToList((String)role.toString(), Object.class);
            this.getModel().setValue(ROLE, (Object)list.toArray());
        }
        Object seat = this.getView().getFormShowParameter().getCustomParam(SEAT);
        String spreadJson = billTemp.getString(SPREADJSON_TAG);
        if (StringUtils.isNotEmpty((CharSequence)spreadJson)) {
            this.getSpreadContainer().rebuildSpread(spreadJson);
        }
        this.buildSpreadByTemplate(billTemp);
        this.getModel().setValue(RESOURCENUMBER, billTemp.get("number"));
        this.getModel().setValue(RESOURCENAME, billTemp.get("name"));
        this.getModel().setValue(CREATEORG, billTemp.get(CREATEORG));
        this.getModel().setValue(BIZTYPE, billTemp.get(BIZTYPE));
        this.getModel().setValue(BILLTEMPTYPE, billTemp.get("group"));
        this.getModel().setValue(CTRLSTRATEGY, billTemp.get(CTRLSTRATEGY));
        this.getModel().setValue(DATATABLES, billTemp.get(DATATABLES));
        this.getModel().setValue(BILLTEMPS, billTemp.get(BILLTEMPS));
        Object versionRule = this.getView().getFormShowParameter().getCustomParam("versionRule");
        Object versionNumber = this.getView().getFormShowParameter().getCustomParam("versionNumber");
        this.getModel().setValue(VERSIONRULE, versionRule);
        this.getModel().setValue(VERSIONNUMBER, versionNumber);
        String isHistory = this.getView().getPageCache().get(ISHISTORY);
        if (StringUtils.equals((CharSequence)"true", (CharSequence)isHistory)) {
            String modifyTime;
            String modifier;
            String createTime;
            String creator = this.getView().getPageCache().get(CREATOR);
            if (StringUtils.isNotEmpty((CharSequence)creator)) {
                this.getModel().setValue(CREATOR, (Object)Long.parseLong(creator));
            }
            if (StringUtils.isNotEmpty((CharSequence)(createTime = this.getView().getPageCache().get(CREATETIME)))) {
                this.getModel().setValue(CREATETIME, SerializationUtils.fromJsonString((String)createTime, Date.class));
            }
            if (StringUtils.isNotEmpty((CharSequence)(modifier = this.getView().getPageCache().get(MODIFIER)))) {
                this.getModel().setValue(MODIFIER, (Object)Long.parseLong(modifier));
            }
            if (StringUtils.isNotEmpty((CharSequence)(modifyTime = this.getView().getPageCache().get(MODIFYTIME)))) {
                this.getModel().setValue(MODIFYTIME, SerializationUtils.fromJsonString((String)modifyTime, Date.class));
            }
        }
    }

    protected DynamicObject getDataTemp() {
        Object resourceId = this.getView().getFormShowParameter().getCustomParam(RESOURCE);
        if (resourceId == null) {
            return null;
        }
        DynamicObject dataTemp = BusinessDataServiceHelper.loadSingle((Object)resourceId, (String)ENTITY_TEMP);
        QFilter qFilter = new QFilter("template", "=", resourceId);
        qFilter.and(new QFilter(CREATOR, "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
        DynamicObject[] dataTemps = BusinessDataServiceHelper.load((String)ENTITY_HISTORY, (String)"id,status,spreadjson_tag,createtime,creator.id,modifier.id,modifytime", (QFilter[])qFilter.toArray(), (String)"createtime desc, modifytime desc");
        if (dataTemps != null && dataTemps.length != 0) {
            DynamicObject history = dataTemps[0];
            boolean useHistory = true;
            if (dataTemp.getBoolean("isenableversion")) {
                boolean isNew;
                Date createTime = history.getDate(CREATETIME);
                Tuple tuple = VersionRuleUtils.computePeriod((DynamicObject)dataTemp.getDynamicObject(VERSIONRULE));
                boolean bl = isNew = !createTime.before((Date)tuple.item2) || !createTime.after((Date)tuple.item1);
                if (log.isInfoEnabled()) {
                    log.info("[VersionRuleUtils] \u5224\u65ad\u662f\u5426\u5f00\u59cb\u65b0\u7684\u5468\u671f--> createTime: {}, isNew: {}", (Object)createTime, (Object)isNew);
                }
                if (isNew) {
                    useHistory = false;
                    history.set("status", (Object)StatusEnum.AUDIT.getValue());
                    SaveServiceHelper.update((DynamicObject)history);
                    this.setStatus("A");
                }
            }
            if (useHistory) {
                this.setStatus(history.getString("status"));
                this.setHistortyId(history.getLong("id"));
                String spreadjson_tag = history.getString(SPREADJSON_TAG);
                dataTemp.set(SPREADJSON_TAG, (Object)spreadjson_tag);
                Map sheetData = SpreadUtils.getSheetData((String)spreadjson_tag);
                Object rowCount = sheetData.get("rowCount");
                if (rowCount != null) {
                    dataTemp.set(REALROW, sheetData.get("rowCount"));
                }
                this.getView().getPageCache().put(ISHISTORY, "true");
                this.getView().getPageCache().put(CREATOR, history.getString("creator.id"));
                this.getView().getPageCache().put(CREATETIME, SerializationUtils.toJsonString((Object)history.getDate(CREATETIME)));
                this.getView().getPageCache().put(MODIFIER, history.getString("modifier.id"));
                this.getView().getPageCache().put(MODIFYTIME, SerializationUtils.toJsonString((Object)history.getString(MODIFYTIME)));
            }
        } else {
            this.setStatus("A");
        }
        this.getView().getPageCache().put(REALCOL, dataTemp.getString(REALCOL));
        this.getView().getPageCache().put(REALROW, dataTemp.getString(REALROW));
        this.getView().getPageCache().put("rowCount", dataTemp.getString(REALROW));
        String templateType = dataTemp.getString("tempclassify");
        this.getView().getPageCache().put(TEMPLATETYPE, templateType);
        this.getView().getPageCache().put(CELLCONFID, dataTemp.getString("cellconf_id"));
        return dataTemp;
    }

    public void setHistortyId(long id) {
        this.getModel().setValue("history", (Object)id);
    }

    public void setStatus(String status) {
        this.getModel().setValue("status", (Object)status);
    }

    protected DynamicObject getTempSetting(long tempConfId) {
        if (tempConfId == 0L) {
            return null;
        }
        DynamicObject tempSetObj = BusinessDataServiceHelper.loadSingle((Object)tempConfId, (String)"phm_billtemp_set");
        return tempSetObj;
    }

    protected void resolveDataTemp(DynamicObject tempSetObj) {
        if (tempSetObj == null) {
            return;
        }
        List<BillHeadInfo> billHeadList = this.resolveHeadSetting(tempSetObj);
        List<BillColumnInfo> billColumnList = this.resolveColumnSetting(tempSetObj);
        List<DataAreaInfo> dataAreaInfoList = this.resolveDataAreaSetting(tempSetObj);
        this.getPageCache().put(BillHeadInfo.class.getName(), SerializationUtils.toJsonString(billHeadList));
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u7f13\u5b58\u8868\u5934\u8bbe\u7f6e\u96c6\u5408\uff1a" + SerializationUtils.toJsonString(billHeadList));
        this.getPageCache().put(BillColumnInfo.class.getName(), SerializationUtils.toJsonString(billColumnList));
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u7f13\u5b58\u8868\u5217\u8bbe\u7f6e\u96c6\u5408\uff1a" + SerializationUtils.toJsonString(billColumnList));
        this.getPageCache().put(DataAreaInfo.class.getName(), SerializationUtils.toJsonString(dataAreaInfoList));
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u7f13\u5b58\u6570\u636e\u533a\u57df\u8bbe\u7f6e\u96c6\u5408\uff1a" + SerializationUtils.toJsonString(dataAreaInfoList));
    }

    protected List<BillHeadInfo> resolveHeadSetting(DynamicObject tempSetObj) {
        DynamicObjectCollection collection = tempSetObj.getDynamicObjectCollection("headentryentity");
        ArrayList<BillHeadInfo> billHeadList = new ArrayList<BillHeadInfo>(8);
        for (DynamicObject obj : collection) {
            BillHeadInfo billHeadInfo = new BillHeadInfo();
            int headCol = obj.getInt("headcol");
            int headRow = obj.getInt("headrow");
            String formula = obj.getString("headformula");
            String headCellLogic = obj.getString("headcelllogic");
            billHeadInfo.setHeadCol(headCol);
            billHeadInfo.setHeadRow(headRow);
            billHeadInfo.setHeadFormula(formula);
            billHeadInfo.setHeadCellLogic(headCellLogic);
            billHeadList.add(billHeadInfo);
        }
        return billHeadList;
    }

    protected List<BillColumnInfo> resolveColumnSetting(DynamicObject tempSetObj) {
        DynamicObjectCollection collection = tempSetObj.getDynamicObjectCollection("fieldentryentity");
        ArrayList<BillColumnInfo> list = new ArrayList<BillColumnInfo>();
        for (DynamicObject obj : collection) {
            DynamicObject dataTemp;
            String dataResource = obj.getString("dataresource");
            String refid = "0";
            if (StringUtils.equals((CharSequence)"1", (CharSequence)dataResource)) {
                DynamicObject dataTable = obj.getDynamicObject("datatable");
                if (dataTable != null) {
                    refid = dataTable.getString("id");
                }
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)dataResource) && (dataTemp = obj.getDynamicObject("datatpl")) != null) {
                refid = dataTemp.getString("id");
            }
            BillColumnInfo info = new BillColumnInfo();
            info.setFieldCellPo(obj.getString("fieldcellpo"));
            info.setCellCol(obj.getInt("cellcol"));
            info.setField(obj.getString("field"));
            info.setFieldCellName(obj.getString("fieldcellname"));
            info.setDataResource(obj.getString("dataresource"));
            info.setRefId(refid);
            info.setFieldNumber(obj.getString("fieldnumber"));
            info.setFieldName(obj.getString("fieldname"));
            info.setFieldType(obj.getString("fieldtype"));
            info.setFieldLogic(obj.getString("fieldlogic"));
            info.setStartRow(obj.getInt("startrow"));
            info.setCalculateConf(obj.getString("calculateconf"));
            info.setFieldFormula(obj.getString("fieldformula"));
            info.setFormat(obj.getInt("format"));
            list.add(info);
        }
        this.dealColumnInfoByIndex(list);
        this.dealColumnInfoByDataTemp(list);
        this.dealColumnInfoByFormula(list);
        return list;
    }

    private List<DataAreaInfo> resolveDataAreaSetting(DynamicObject tempSetObj) {
        String areaStart = tempSetObj.getString("areastart");
        String areaEnd = tempSetObj.getString("areaend");
        int startRow = 0;
        int startCol = 0;
        int endRow = 200;
        int endCol = 200;
        if (StringUtils.isNotEmpty((CharSequence)areaStart)) {
            startRow = SpreadUtils.pos2Y((String)areaStart);
            startCol = SpreadUtils.pos2X((String)areaStart);
        }
        if (StringUtils.isNotEmpty((CharSequence)areaEnd)) {
            endRow = SpreadUtils.pos2Y((String)areaEnd);
            endCol = SpreadUtils.pos2X((String)areaEnd);
        }
        DataAreaInfo dataAreaInfo = new DataAreaInfo(new Cell(startRow, startCol), new Cell(endRow, endCol));
        ArrayList<DataAreaInfo> dataAreaInfoList = new ArrayList<DataAreaInfo>(8);
        dataAreaInfoList.add(dataAreaInfo);
        return dataAreaInfoList;
    }

    protected void lockHeadCells() {
        List<?> billHeadList = this.getListFromCache(BillHeadInfo.class);
        ArrayList<Cell> cells = new ArrayList<Cell>(8);
        for (BillHeadInfo billHeadInfo : billHeadList) {
            Cell cell = new Cell(billHeadInfo.getHeadRow(), billHeadInfo.getHeadCol());
            cells.add(cell);
        }
        List<?> billColumnList = this.getListFromCache(BillColumnInfo.class);
        for (BillColumnInfo billColumnInfo : billColumnList) {
            String fieldCellPo = billColumnInfo.getFieldCellPo();
            Cell cell = new Cell(SpreadUtils.pos2Y((String)fieldCellPo), billColumnInfo.getCellCol());
            cells.add(cell);
        }
        this.getSpreadContainer().lockCell(cells);
    }

    protected void dealColumnInfoByIndex(List<BillColumnInfo> list) {
        IndexCol indexCol;
        IndexColumnInfo indexColumnInfo;
        String table;
        DynamicObject dataTable;
        String fieldLogic;
        String dataResource;
        ArrayList<IndexColumnInfo> indexColumnInfoList = new ArrayList<IndexColumnInfo>();
        for (BillColumnInfo billColumnInfo : list) {
            dataResource = billColumnInfo.getDataResource();
            fieldLogic = billColumnInfo.getFieldLogic();
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)dataResource) || !StringUtils.equals((CharSequence)"1", (CharSequence)fieldLogic) || (dataTable = QueryServiceHelper.queryOne((String)"phm_datatable", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billColumnInfo.getRefId()))})) == null) continue;
            table = dataTable.getString("number");
            indexColumnInfo = this.findIndexColumnInfoByTable(indexColumnInfoList, table);
            ArrayList<IndexCol> indexCols = indexColumnInfo.getIndexCols();
            if (indexCols == null) {
                indexCols = new ArrayList<IndexCol>(8);
            }
            indexCol = new IndexCol(billColumnInfo.getCellCol(), billColumnInfo.getFieldNumber(), billColumnInfo.getFieldType());
            indexCols.add(indexCol);
            indexColumnInfo.setStartRow(billColumnInfo.getStartRow() - 1);
            indexColumnInfo.setTable(table);
            indexColumnInfo.setIndexCols(indexCols);
        }
        for (BillColumnInfo billColumnInfo : list) {
            dataResource = billColumnInfo.getDataResource();
            fieldLogic = billColumnInfo.getFieldLogic();
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)dataResource) || !StringUtils.equals((CharSequence)"2", (CharSequence)fieldLogic) || (dataTable = QueryServiceHelper.queryOne((String)"phm_datatable", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billColumnInfo.getRefId()))})) == null) continue;
            table = dataTable.getString("number");
            indexColumnInfo = this.findIndexColumnInfoByTable(indexColumnInfoList, table);
            ArrayList<IndexCol> indexValueCols = indexColumnInfo.getIndexValueCols();
            if (indexValueCols == null) {
                indexValueCols = new ArrayList<IndexCol>(8);
            }
            indexCol = new IndexCol(billColumnInfo.getCellCol(), billColumnInfo.getFieldNumber(), billColumnInfo.getFieldType());
            indexValueCols.add(indexCol);
            indexColumnInfo.setIndexValueCols(indexValueCols);
        }
        this.getPageCache().put(IndexColumnInfo.class.getName(), SerializationUtils.toJsonString(indexColumnInfoList));
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u7f13\u5b58\u7d22\u5f15\u96c6\u5408\uff1a" + SerializationUtils.toJsonString(indexColumnInfoList));
    }

    protected void dealColumnInfoByDataTemp(List<BillColumnInfo> list) {
        ArrayList<DataTempColumnInfo> dataTempColumnInfoList = new ArrayList<DataTempColumnInfo>(8);
        for (BillColumnInfo billColumnInfo : list) {
            String formula;
            String dataResource = billColumnInfo.getDataResource();
            int cellCol = billColumnInfo.getCellCol();
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)dataResource) || StringUtils.isEmpty((CharSequence)(formula = billColumnInfo.getFieldFormula()))) continue;
            try {
                Object templateId = this.getView().getFormShowParameter().getCustomParam(RESOURCE);
                if (templateId == null) {
                    return;
                }
                String[] inputColStr = TableLineConfigUnits.parseFormula((String)formula, (Long)Long.parseLong(templateId.toString()));
                DataTempColumnInfo dataTempColumnInfo = new DataTempColumnInfo();
                dataTempColumnInfo.setFormula(formula);
                dataTempColumnInfo.setStartRow(billColumnInfo.getStartRow());
                dataTempColumnInfo.setSourceTempId(billColumnInfo.getRefId());
                dataTempColumnInfo.setInput(new IndexCol(Integer.parseInt(inputColStr[0]), "", inputColStr[1]));
                dataTempColumnInfo.setOutput(new IndexCol(billColumnInfo.getCellCol(), billColumnInfo.getFieldNumber(), billColumnInfo.getFieldType()));
                dataTempColumnInfo.setFormat(billColumnInfo.getFormat());
                dataTempColumnInfoList.add(dataTempColumnInfo);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("RESOLVE_SETTING_EXC", ResManager.loadKDString((String)"\u89e3\u6790\u6570\u636e\u6a21\u677f\u8bbe\u7f6e\u7b2c %s \u5217\u516c\u5f0f  %s \u65f6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u914d\u7f6e", (String)"WorkStationBillPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{cellCol + 1, formula});
            }
        }
        this.getView().getPageCache().put(DataTempColumnInfo.class.getName(), SerializationUtils.toJsonString(dataTempColumnInfoList));
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u7f13\u5b58\u6a21\u677f\u5217\u96c6\u5408\uff1a" + SerializationUtils.toJsonString(dataTempColumnInfoList));
    }

    protected void dealColumnInfoByFormula(List<BillColumnInfo> list) {
        ArrayList<FormulaColumnInfo> formulaColumnInfoList = new ArrayList<FormulaColumnInfo>(8);
        for (BillColumnInfo billColumnInfo : list) {
            String dataResource = billColumnInfo.getDataResource();
            int cellCol = billColumnInfo.getCellCol();
            if (!StringUtils.equals((CharSequence)"4", (CharSequence)dataResource)) continue;
            int startRow = billColumnInfo.getStartRow();
            String fieldFormula = billColumnInfo.getCalculateConf();
            FormulaColumnInfo formulaColumnInfo = new FormulaColumnInfo();
            formulaColumnInfo.setStartRow(startRow);
            formulaColumnInfo.setFormulaCol(new IndexCol(cellCol, "", ""));
            formulaColumnInfo.setFormula('=' + fieldFormula);
            formulaColumnInfoList.add(formulaColumnInfo);
        }
        this.getView().getPageCache().put(FormulaColumnInfo.class.getName(), SerializationUtils.toJsonString(formulaColumnInfoList));
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u7f13\u5b58\u516c\u5f0f\u5217\u96c6\u5408\uff1a" + SerializationUtils.toJsonString(formulaColumnInfoList));
    }

    protected IndexColumnInfo findIndexColumnInfoByTable(List<IndexColumnInfo> indexColumnInfoList, String table) {
        IndexColumnInfo newInfo = new IndexColumnInfo();
        for (IndexColumnInfo info : indexColumnInfoList) {
            if (!StringUtils.equals((CharSequence)table, (CharSequence)info.getTable())) continue;
            return info;
        }
        indexColumnInfoList.add(newInfo);
        return newInfo;
    }

    protected List<?> getListFromCache(Class<?> type) {
        List list = new ArrayList(8);
        String str = this.getView().getPageCache().get(type.getName());
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            list = SerializationUtils.fromJsonStringToList((String)str, type);
        }
        return list;
    }

    protected Object getInfoByColAndRow(Object c, Object r, Class<?> type) {
        block5: {
            String givenR;
            String givenC;
            block4: {
                givenC = c.toString();
                givenR = r.toString();
                if (type != IndexColumnInfo.class) break block4;
                List<?> list = this.getListFromCache(IndexColumnInfo.class);
                for (IndexColumnInfo indexColumnInfo : list) {
                    List indexCols = indexColumnInfo.getIndexCols();
                    int startRow = indexColumnInfo.getStartRow();
                    if (!IndexColumnInfo.isIndexCol((List)indexCols, (int)Integer.parseInt(givenC)) || Integer.parseInt(givenR) < startRow) continue;
                    return indexColumnInfo;
                }
                break block5;
            }
            if (type == DataTempColumnInfo.class) {
                List<?> list = this.getListFromCache(DataTempColumnInfo.class);
                ArrayList<DataTempColumnInfo> returnList = new ArrayList<DataTempColumnInfo>();
                for (DataTempColumnInfo dataTempColumnInfo : list) {
                    int startRow = dataTempColumnInfo.getStartRow();
                    IndexCol input = dataTempColumnInfo.getInput();
                    int col = input.getCol();
                    if (Integer.parseInt(givenR) < startRow || Integer.parseInt(givenC) != col) continue;
                    returnList.add(dataTempColumnInfo);
                }
                return returnList;
            }
            if (type != BillColumnInfo.class) break block5;
            List<?> list = this.getListFromCache(BillColumnInfo.class);
            for (BillColumnInfo billColumnInfo : list) {
                int col = billColumnInfo.getCellCol();
                if (Integer.parseInt(givenC) != col) continue;
                return billColumnInfo;
            }
        }
        return null;
    }

    protected List<List<Object>> queryData(DBRoute dbRoute, String sql, final List<Column> columnList) {
        List rs = null;
        try {
            rs = (List)DB.query((DBRoute)dbRoute, (String)sql, (ResultSetHandler)new ResultSetHandler<List<List<Object>>>(){

                public List<List<Object>> handle(ResultSet rs) throws Exception {
                    int i;
                    ArrayList<List<Object>> data = new ArrayList<List<Object>>(rs.getRow());
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnNumber = meta.getColumnCount();
                    ArrayList columnNameList = new ArrayList(8);
                    ArrayList columnTypeList = new ArrayList(8);
                    for (i = 1; i <= columnNumber; ++i) {
                        Column column = new Column();
                        column.setName(meta.getColumnName(i));
                        column.setcType(meta.getColumnType(i));
                        columnList.add(column);
                    }
                    data.add(columnNameList);
                    data.add(columnTypeList);
                    i = 0;
                    while (rs.next()) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        int index = ++i;
                        for (int n = 1; n <= columnNumber; ++n) {
                            row.add(rs.getObject(n) == null ? "" : rs.getObject(n));
                        }
                        data.add(row);
                    }
                    return data;
                }
            });
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a%s", (String)"WorkStationBillPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{ex});
        }
        return rs;
    }

    protected Map<Object, List<Object>> transformMap(List<IndexCol> indexValueList) {
        HashMap<Object, List<Object>> afterMap = new HashMap<Object, List<Object>>(8);
        for (IndexCol indexValue : indexValueList) {
            int col = indexValue.getCol();
            String field = indexValue.getField();
            ArrayList<Integer> list = (ArrayList<Integer>)afterMap.get(field);
            if (list == null) {
                list = new ArrayList<Integer>(8);
            }
            list.add(col);
            afterMap.put(field, list);
        }
        return afterMap;
    }

    protected void updateIndexCells(LinkedHashMap<String, Object> value) {
        Object c = value.get("c");
        Object r = value.get("r");
        Object v = value.get("v");
        IndexColumnInfo info = (IndexColumnInfo)this.getInfoByColAndRow(c, r, IndexColumnInfo.class);
        if (info == null) {
            return;
        }
        String sql = this.constractQuerySql(info, c, r, v);
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3SQL\u8bed\u53e5\uff1a" + sql);
        ArrayList<Column> columnList = new ArrayList<Column>(8);
        Map<Object, List<Object>> transMap = this.transformMap(info.getIndexValueCols());
        if (transMap.isEmpty()) {
            return;
        }
        List<List<Object>> resultList = this.queryData(new DBRoute("phm"), sql, columnList);
        ArrayList<Cell> indeValueCellList = new ArrayList<Cell>(8);
        if (resultList == null || resultList.size() == 2) {
            List indexValueList = info.getIndexValueCols();
            for (IndexCol indexValue : indexValueList) {
                Cell cell = new Cell(Integer.parseInt(r.toString()), indexValue.getCol(), null);
                indeValueCellList.add(cell);
            }
        } else {
            for (List<Object> list : resultList) {
                for (int i = 0; i < list.size(); ++i) {
                    Object vvv = list.get(i);
                    Column column = (Column)columnList.get(i);
                    String name = column.getName();
                    List cols = transMap.getOrDefault(name, Collections.emptyList());
                    for (Object col : cols) {
                        Cell ce = new Cell(Integer.parseInt(r.toString()), Integer.parseInt(col.toString()), vvv);
                        indeValueCellList.add(ce);
                    }
                }
            }
        }
        this.getSpreadContainer().updateCellValue(indeValueCellList);
    }

    protected void updateDataTempCells(LinkedHashMap<String, Object> value) {
        Object c = value.get("c");
        Object r = value.get("r");
        Object v = value.get("v");
        ArrayList<Cell> cellList = new ArrayList<Cell>(8);
        this.getAllUpdateDataTempCells(r, c, v, cellList);
        if (!cellList.isEmpty()) {
            this.getSpreadContainer().updateCellValue(cellList);
        }
    }

    protected void getAllUpdateDataTempCells(Object r, Object c, Object v, List<Cell> cellList) {
        List dataTempColumnInfoList = (List)this.getInfoByColAndRow(c, r, DataTempColumnInfo.class);
        if (dataTempColumnInfoList.isEmpty()) {
            return;
        }
        for (DataTempColumnInfo dataTempColumnInfo : dataTempColumnInfoList) {
            String formula = dataTempColumnInfo.getFormula();
            String sourceTempId = dataTempColumnInfo.getSourceTempId();
            int format = dataTempColumnInfo.getFormat();
            IndexCol output = dataTempColumnInfo.getOutput();
            IndexCol input = dataTempColumnInfo.getInput();
            if (!StringUtils.isNotEmpty((CharSequence)formula) || !StringUtils.isNotEmpty((CharSequence)sourceTempId) || output == null) continue;
            try {
                BigDecimal result = null;
                if (v != null && StringUtils.isNotEmpty((CharSequence)v.toString())) {
                    Long processHistoryId = (Long)this.getView().getFormShowParameter().getCustomParam("processHistoryId");
                    Long nodeEntryId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeEntryId");
                    result = TableLineConfigUnits.execute((Object)v, (String)input.getType(), (Long)Long.parseLong(sourceTempId), (String)formula, (Long)processHistoryId, (Long)nodeEntryId, (int)format);
                }
                Cell cell = new Cell(Integer.parseInt(r.toString()), output.getCol(), result);
                cellList.add(cell);
                this.getAllUpdateDataTempCells(r, output.getCol(), result, cellList);
                log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\uff1a\u5904\u7406\u516c\u5f0f\u5355\u5143\u683c" + SerializationUtils.toJsonString((Object)cell) + "\uff1bDataTempColumnInfo\uff1a" + SerializationUtils.toJsonString((Object)dataTempColumnInfo) + ResManager.loadKDString((String)"\uff1b\u8ba1\u7b97\u7ed3\u679c\u4e3a\uff1a", (String)"WorkStationBillPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + SerializationUtils.toJsonString((Object)result));
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("EXECUTE_FORMULA_EXC", ResManager.loadKDString((String)"\u6267\u884c\u7b2c %s \u5217\u516c\u5f0f\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"WorkStationBillPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{output.getCol() + 1});
            }
        }
    }

    protected String constractQuerySql(IndexColumnInfo info, Object c, Object r, Object v) {
        String type;
        String table = info.getTable();
        List indexValueList = info.getIndexValueCols();
        List indexList = info.getIndexCols();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (IndexCol indexValue : indexValueList) {
            sql.append(indexValue.getField()).append(", ");
        }
        sql.delete(sql.length() - 2, sql.length() - 1);
        sql.append(" FROM ");
        sql.append(table);
        sql.append(" WHERE ");
        for (IndexCol indexCol : indexList) {
            type = indexCol.getType();
            if (Integer.parseInt(c.toString()) == indexCol.getCol()) continue;
            Object value = this.getCellValue(r, indexCol.getCol());
            sql.append(indexCol.getField());
            sql.append(" = ");
            if (StringUtils.equals((CharSequence)FieldType.NVARCHAR.getValue(), (CharSequence)type)) {
                sql.append(" '");
            }
            if (StringUtils.equals((CharSequence)FieldType.BIGINT.getValue(), (CharSequence)type) || StringUtils.equals((CharSequence)FieldType.DECIMAL.getValue(), (CharSequence)type)) {
                if (StringUtils.isEmpty((CharSequence)value.toString())) {
                    value = 0;
                }
            } else if (StringUtils.equals((CharSequence)FieldType.DATETIME.getValue(), (CharSequence)type) && StringUtils.isEmpty((CharSequence)value.toString())) {
                value = "null";
            }
            sql.append(value);
            if (StringUtils.equals((CharSequence)FieldType.NVARCHAR.getValue(), (CharSequence)type)) {
                sql.append("' ");
            }
            sql.append(" and ");
        }
        for (IndexCol indexCol : indexList) {
            type = indexCol.getType();
            if (Integer.parseInt(c.toString()) != indexCol.getCol()) continue;
            sql.append(indexCol.getField());
            sql.append(" = ");
            if (StringUtils.equals((CharSequence)FieldType.NVARCHAR.getValue(), (CharSequence)type)) {
                sql.append(" '");
            }
            sql.append(v);
            if (!StringUtils.equals((CharSequence)FieldType.NVARCHAR.getValue(), (CharSequence)type)) continue;
            sql.append("' ");
        }
        this.getSpreadContainer().getSpreadJson("cacheSpreadJsonString");
        return sql.toString();
    }

    protected Object getCellValue(Object r, Object c) {
        String spreadJson = this.getView().getPageCache().get(SPREADJSON_TAG);
        if (StringUtils.isEmpty((CharSequence)spreadJson)) {
            return "";
        }
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)spreadJson, Map.class);
        Map sheetsMap = (Map)((Map)spreadMap.get("sheets")).get("Sheet1");
        if (sheetsMap == null) {
            return "";
        }
        Map dataMap = (Map)((Map)sheetsMap.get("data")).get("dataTable");
        if (dataMap == null) {
            return "";
        }
        Map rowDataMap = (Map)dataMap.get(r.toString());
        if (rowDataMap == null) {
            return "";
        }
        Map colDataMap = (Map)rowDataMap.get(c.toString());
        if (colDataMap == null) {
            return "";
        }
        return colDataMap.get("value") == null ? "" : colDataMap.get("value");
    }

    protected int getRowCount() {
        String rowCount = this.getView().getPageCache().get("rowCount");
        if (StringUtils.isEmpty((CharSequence)rowCount)) {
            return 0;
        }
        return Integer.parseInt(rowCount);
    }

    public String cacheSpreadJsonString(String spreadJson) {
        this.getView().getPageCache().put(SPREADJSON_TAG, SpreadUtils.convertSpreadJson((String)spreadJson));
        return spreadJson;
    }

    protected void updateHeadInfo() {
        String isHistory = this.getView().getPageCache().get(ISHISTORY);
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)isHistory)) {
            List<?> billHeadList = this.getListFromCache(BillHeadInfo.class);
            ArrayList<Cell> cellList = new ArrayList<Cell>(8);
            for (BillHeadInfo billHeadInfo : billHeadList) {
                int row = billHeadInfo.getHeadRow();
                int col = billHeadInfo.getHeadCol();
                String formula = billHeadInfo.getHeadFormula();
                if (StringUtils.isEmpty((CharSequence)formula)) continue;
                Object newValue = FormulaEngine.execExcelFormula((String)formula);
                Cell cell = new Cell(row, col, newValue);
                cellList.add(cell);
            }
            this.getSpreadContainer().updateCellValue(cellList);
        }
    }

    protected boolean validatData(LinkedHashMap<String, Object> value) {
        String noPass;
        Object c = value.get("c");
        Object r = value.get("r");
        Object v = value.get("v");
        BillColumnInfo billColumnInfo = (BillColumnInfo)this.getInfoByColAndRow(c, r, BillColumnInfo.class);
        if (billColumnInfo == null) {
            return true;
        }
        if (v == null) {
            return true;
        }
        String fieldType = billColumnInfo.getFieldType();
        String regex = "^-?[1-9]\\d*$";
        switch (fieldType) {
            case "BIGINT": {
                regex = "^-?[0-9]\\d*$";
                break;
            }
            case "DATETIME": {
                regex = "(?<=\\/OADate\\().*?(?=\\)/)";
                break;
            }
            case "DECIMAL": {
                regex = "-?[0-9]+\\.?[0-9]*";
                break;
            }
            default: {
                return true;
            }
        }
        Pattern pattern = Pattern.compile(regex);
        String fieldLogic = billColumnInfo.getFieldLogic();
        String pos = SpreadUtils.xy2Pos((int)Integer.parseInt(c.toString()), (int)Integer.parseInt(r.toString()));
        if (!pattern.matcher(v.toString()).matches()) {
            if (StringUtils.equals((CharSequence)"5", (CharSequence)fieldLogic)) {
                String noPass2 = this.getView().getPageCache().get("NOPASS");
                Set<String> noPassCol = new HashSet<String>(8);
                if (StringUtils.isNotEmpty((CharSequence)noPass2)) {
                    noPassCol = (Set)SerializationUtils.fromJsonString((String)noPass2, Set.class);
                }
                noPassCol.add(pos);
                this.getView().getPageCache().put("NOPASS", SerializationUtils.toJsonString(noPassCol));
                return true;
            }
            this.getView().showTipNotification(pos + ResManager.loadKDString((String)"\u5355\u5143\u683c\u586b\u5199\u5185\u5bb9\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8868\u5217\u8bbe\u7f6e\u7c7b\u578b\u4e3a", (String)"WorkStationBillPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + FieldType.forValue((String)fieldType).getName() + ResManager.loadKDString((String)"\uff1b\u503c\u4e3a", (String)"WorkStationBillPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + v);
            return false;
        }
        if (StringUtils.equals((CharSequence)"5", (CharSequence)fieldLogic) && StringUtils.isNotEmpty((CharSequence)(noPass = this.getView().getPageCache().get("NOPASS")))) {
            Set noPassCol = (Set)SerializationUtils.fromJsonString((String)noPass, Set.class);
            noPassCol.remove(pos);
            this.getView().getPageCache().put("NOPASS", SerializationUtils.toJsonString((Object)noPassCol));
        }
        return true;
    }

    protected void lockCells(List<Cell> cells) {
        CellStyle style = new CellStyle();
        CellBorderStyle bl = new CellBorderStyle();
        ArrayList<String> blc = new ArrayList<String>(8);
        blc.add("#D4D4D4");
        ArrayList<String> bls = new ArrayList<String>(8);
        bls.add("thin");
        bl.setBlc(blc);
        bl.setBls(bls);
        style.setBkc("#E2E7EF");
        style.setL(Boolean.TRUE);
        style.setBl(bl);
        this.getSpreadContainer().setCellStyle(cells, style);
    }

    protected void appendNewOneRow(LinkedHashMap<String, Object> value) {
        Object r;
        Object c = value.get("c");
        IndexColumnInfo indexColumnInfo = (IndexColumnInfo)this.getInfoByColAndRow(c, r = value.get("r"), IndexColumnInfo.class);
        if (indexColumnInfo == null) {
            return;
        }
        String templateType = this.getView().getPageCache().get(TEMPLATETYPE);
        if (StringUtils.equals((CharSequence)"1", (CharSequence)templateType)) {
            List<Object> rowList = new ArrayList(8);
            String rowListStr = this.getView().getPageCache().get("rowList");
            if (StringUtils.isNotEmpty((CharSequence)rowListStr)) {
                rowList = (List)SerializationUtils.fromJsonString((String)rowListStr, List.class);
            }
            if (!rowList.contains(r)) {
                this.appendRows(1);
                rowList.add(r);
                this.getView().getPageCache().put("rowList", SerializationUtils.toJsonString(rowList));
            }
        }
    }
}

