/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.billtemp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.phm.common.info.DataTempColumnInfo;
import kd.mmc.phm.common.info.FormulaColumnInfo;
import kd.mmc.phm.common.info.IndexCol;
import kd.mmc.phm.common.info.IndexColumnInfo;
import kd.mmc.phm.common.spread.model.Cell;
import kd.mmc.phm.common.spread.model.FormulaCell;
import kd.mmc.phm.common.util.datatemp.FixTempConfigParse;
import kd.mmc.phm.common.util.datatemp.MultiTempConfigParse;
import kd.mmc.phm.formplugin.bizmodel.billtemp.WorkStationBillPlugin;

public class WorkStationMultiBillPlugin
extends WorkStationBillPlugin {
    private static final Log log = LogFactory.getLog(WorkStationMultiBillPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isHistory = this.getView().getPageCache().get("isHistory");
        String templateType = this.getView().getPageCache().get("templateType");
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)isHistory) && StringUtils.equals((CharSequence)"2", (CharSequence)templateType)) {
            this.initMultiBillDatas();
        } else if (!StringUtils.equals((CharSequence)"true", (CharSequence)isHistory) && StringUtils.equals((CharSequence)"3", (CharSequence)templateType)) {
            this.initRegularBillDatas();
        }
    }

    protected void initMultiBillDatas() {
        Object resourceId = this.getView().getFormShowParameter().getCustomParam("resource");
        if (resourceId == null) {
            return;
        }
        String realrow = this.getView().getPageCache().get("realrow");
        if (StringUtils.isEmpty((CharSequence)realrow)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        Map datas = new HashMap(8);
        try {
            Long procesHistoryId = (Long)this.getView().getFormShowParameter().getCustomParam("processHistoryId");
            Long nodeEntryId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeEntryId");
            datas = MultiTempConfigParse.getDataBytempId((Long)Long.parseLong(resourceId.toString()), (Long)procesHistoryId, (Long)nodeEntryId, (Long)RequestContext.get().getOrgId());
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("RESOLVE_DATAS_EXC", ResManager.loadKDString((String)"\u52a0\u8f7d\u591a\u884c\u6a21\u677f\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"WorkStationMultiBillPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u591a\u884c\u6a21\u677f\u67e5\u8be2\u6570\u636e\u5b8c\u6bd5\uff1a" + SerializationUtils.toJsonString(datas));
        List cells = (List)datas.get("cellList");
        int endRow = (Integer)datas.get("endRow");
        int startRow = (Integer)datas.get("startRow");
        long endTime = System.currentTimeMillis();
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u591a\u884c\u6a21\u677f\u67e5\u8be2\u6570\u636e\u5b8c\u6bd5\uff1a\u8017\u65f6" + (endTime - startTime) + "\u6beb\u79d2");
        this.getSpreadContainer().appendRows(endRow - Integer.parseInt(realrow));
        this.getSpreadContainer().updateCellValue(cells);
        List<?> dataTempColumnInfoList = this.getListFromCache(DataTempColumnInfo.class);
        List<?> indexColumnInfoList = this.getListFromCache(IndexColumnInfo.class);
        List<?> formulaColumnInfoList = this.getListFromCache(FormulaColumnInfo.class);
        ArrayList<FormulaCell> formulaCellList = new ArrayList<FormulaCell>(8);
        for (int rowIndex = startRow; rowIndex <= endRow; ++rowIndex) {
            for (DataTempColumnInfo dataTempColumnInfo : dataTempColumnInfoList) {
                IndexCol output = dataTempColumnInfo.getOutput();
                Cell cell = new Cell(rowIndex, output.getCol());
                cells.add(cell);
            }
            for (IndexColumnInfo indexColumnInfo : indexColumnInfoList) {
                List indexValueList = indexColumnInfo.getIndexValueCols();
                for (IndexCol indexValue : indexValueList) {
                    Cell cell = new Cell(rowIndex, indexValue.getCol());
                    cells.add(cell);
                }
            }
            for (FormulaColumnInfo formulaColumnInfo : formulaColumnInfoList) {
                String formula = formulaColumnInfo.getFormula();
                IndexCol formulaCol = formulaColumnInfo.getFormulaCol();
                FormulaCell formulaCell = new FormulaCell(rowIndex, formulaCol.getCol(), formula);
                formulaCellList.add(formulaCell);
            }
        }
        this.lockCells(cells);
        this.getSpreadContainer().setFormula(formulaCellList);
    }

    protected void initRegularBillDatas() {
        String cellConfId = this.getView().getPageCache().get("cellConfid");
        if (StringUtils.isEmpty((CharSequence)cellConfId) || StringUtils.equals((CharSequence)"0", (CharSequence)cellConfId)) {
            return;
        }
        Long procesHistoryId = (Long)this.getView().getFormShowParameter().getCustomParam("processHistoryId");
        Long nodeEntryId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeEntryId");
        List cells = FixTempConfigParse.getDataByCellConfId((Long)Long.parseLong(cellConfId), (Long)procesHistoryId, (Long)nodeEntryId, (Long)RequestContext.get().getOrgId());
        log.warn("---\u5355\u5143\u4e1a\u52a1\u6267\u884c\u4e2d\u5fc3\u56fa\u5b9a\u6a21\u677f\u83b7\u53d6\u6570\u636e\uff1a" + SerializationUtils.toJsonString((Object)cells));
        if (cells != null) {
            this.getSpreadContainer().updateCellValue(cells);
            this.lockCells(cells);
        }
    }
}

