/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.eigen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.bizmodel.ValueTypeEnums;
import kd.mmc.phm.common.enums.BizModelCalcStatus;
import kd.mmc.phm.common.enums.ExecutionStatus;
import kd.mmc.phm.common.enums.VType;
import kd.mmc.phm.common.util.DBUtils;
import kd.mmc.phm.common.util.DataTableCompareUtils;
import kd.mmc.phm.common.util.PHMServiceUtils;
import kd.mmc.phm.common.util.ShowFormUtils;

public class EigenValueCalcPlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(EigenValueCalcPlugin.class);
    private static final String ALGO_KEY = "EigenValueCalcPlugin.";
    private static final String TBMAIN = "tbmain";
    private static final String VALUETYPE = "valuetype";
    private static final String PROGRESS_CALC = "progressbarap";
    private static final String BTN_CALC = "btn_calc";
    private static final String BTN_SAVE_RESULT = "btn_saveresult";
    private static final String BTN_PREVIEW = "btn_preview";
    private static final String CACHEKEY_PROGRESS = "progress";
    private static final String CACHEKEY_RESULT = "result";
    private static final String CACHEKEY_SAVEDENTRYIDCOLL = "savedEntryIdColl";
    private static final String CACHEKEY_SOURCE = "source";
    private static final String CACHEKEY_LOADDINGMSG = "loadingMsg";
    private static final String CACHEKEY_MSG = "message";
    private static final String CACHEKEY_MSG_TITLE = "title";
    private static final String CACHEKEY_TIP = "tip";
    private static final String CACHEKEY_STATUS = "status";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TBMAIN});
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_CALC);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_CALC.equals(itemKey)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            boolean hasQueryType = collection.stream().anyMatch(dynamicObject -> ValueTypeEnums.QUERY.getValue().equals(dynamicObject.getString(VALUETYPE)));
            if (!hasQueryType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\u3002\u6682\u65f6\u53ea\u652f\u6301\u503c\u7c7b\u578b\u4e3a\u67e5\u8be2\u7684\u5206\u5f55\u884c\u53c2\u4e0e\u8ba1\u7b97", (String)"EigenValueCalcPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (BTN_SAVE_RESULT.equals(itemKey)) {
            String selectEntryRowId;
            Integer selectRow = this.commonValidate(evt, ResManager.loadKDString((String)"\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c", (String)"EigenValueCalcPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            if (selectRow == null) {
                return;
            }
            Set<String> selectEntryRowIdCache = this.getSelectEntryRowIdCache();
            if (selectEntryRowIdCache.contains(selectEntryRowId = this.getModel().getEntryRowEntity("entryentity", selectRow.intValue()).getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u5931\u8d25\u3002\u5f53\u524d\u5206\u5f55\u884c\u5df2\u4fdd\u5b58\u8fc7\u8ba1\u7b97\u7ed3\u679c, \u4e0d\u80fd\u91cd\u590d\u4fdd\u5b58, \u8bf7\u91cd\u65b0\u8ba1\u7b97\u518d\u64cd\u4f5c", (String)"EigenValueCalcPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (BTN_PREVIEW.equals(itemKey)) {
            this.commonValidate(evt, ResManager.loadKDString((String)"\u7ed3\u679c\u9884\u89c8", (String)"EigenValueCalcPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    private Integer commonValidate(BeforeItemClickEvent evt, String prefix) {
        String cacheJson = this.getPageCache().getBigObject(CACHEKEY_RESULT);
        if (StringUtils.isBlank((CharSequence)cacheJson)) {
            this.getView().showTipNotification(prefix + ResManager.loadKDString((String)"\u5931\u8d25\u3002\u8bf7\u5148\u8ba1\u7b97\u518d\u64cd\u4f5c", (String)"EigenValueCalcPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return null;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(prefix + ResManager.loadKDString((String)"\u5931\u8d25\u3002\u8bf7\u9009\u62e9\u503c\u7c7b\u578b\u4e3a\u67e5\u8be2\u7684\u5206\u5f55\u884c\u518d\u64cd\u4f5c", (String)"EigenValueCalcPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return null;
        }
        int selectRow = selectRows[0];
        String valueType = (String)this.getModel().getValue(VALUETYPE, selectRow);
        if (!ValueTypeEnums.QUERY.getValue().equals(valueType)) {
            this.getView().showTipNotification(prefix + ResManager.loadKDString((String)"\u5931\u8d25\u3002\u8bf7\u9009\u62e9\u503c\u7c7b\u578b\u4e3a\u67e5\u8be2\u7684\u5206\u5f55\u884c\u518d\u64cd\u4f5c", (String)"EigenValueCalcPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return null;
        }
        return selectRow;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_CALC.equals(itemKey)) {
            this.startCalc();
        } else if (BTN_SAVE_RESULT.equals(itemKey)) {
            this.startSaveResult();
        } else if (BTN_PREVIEW.equals(itemKey)) {
            this.preview();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (returnData != null && BTN_SAVE_RESULT.equals(event.getActionId()) && StringUtils.equals((CharSequence)StatusEnum.AUDIT.getValue(), (CharSequence)returnData.toString())) {
            String selectEntryRowId = this.getSelectEntryRowId();
            this.putSelectEntryRowIdToCache(selectEntryRowId);
        }
    }

    private void preview() {
        String selectEntryRowId = this.getSelectEntryRowId();
        Map<String, Object> params = this.getCalcResult(selectEntryRowId);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_eigenvalue_preview", params, null, (ShowType)ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void startSaveResult() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
        String selectEntryRowId = entryRowEntity.getPkValue().toString();
        QFilter[] filters = new QFilter[]{new QFilter("eigenvalueentryid", "=", (Object)Long.parseLong(selectEntryRowId))};
        long dataTableId = 0L;
        try (DataSet dataSet = ORM.create().queryDataSet("EigenValueCalcPlugin.saveResult", "phm_eigenvalue_releation", "datatable", filters, null, 1);){
            if (dataSet.hasNext()) {
                dataTableId = dataSet.next().getLong(0);
            }
        }
        Map<String, Object> calcResult = this.getCalcResult(selectEntryRowId);
        if (dataTableId == 0L) {
            this.showDataTableForm(selectEntryRowId, calcResult);
        } else {
            this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5206\u6790...", (String)"EigenValueCalcPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0])), 0);
            long finalDataTableId = dataTableId;
            ThreadPools.executeOnceIncludeRequestContext((String)"PHM-Eigenvalue-Calc", () -> this.incrementInsertData(finalDataTableId, calcResult, entryRowEntity.getString("valuename")));
            IPageCache pageCache = this.getPageCache();
            pageCache.put(CACHEKEY_SOURCE, BTN_SAVE_RESULT);
            this.clearSaveResultCache(pageCache);
            this.openProgress();
        }
    }

    private void incrementInsertData(long dataTableId, Map<String, Object> calcResult, String valueName) {
        DynamicObject dataTable = ORM.create().queryOne("phm_datatable", new QFilter("id", "=", (Object)dataTableId).toArray());
        String tableName = dataTable.getString("number");
        DynamicObjectCollection collection = dataTable.getDynamicObjectCollection("entryentity");
        int dataTableFieldSize = collection.size();
        int dataTableFieldMax = dataTableFieldSize - 1;
        List sortedColLabels = (List)calcResult.get("sortedColLabels");
        int colCount = sortedColLabels.size();
        if (dataTableFieldSize != colCount) {
            this.setFailTip(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u5931\u8d25\u3002\u6570\u636e\u8868[%s]\u5b57\u6bb5\u4e2a\u6570[%d]\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5b57\u6bb5\u4e2a\u6570[%d]\u4e0d\u76f8\u7b49, \u8bf7\u5148\u5220\u9664\u6570\u636e\u8868\u518d\u64cd\u4f5c", (String)"EigenValueCalcPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]), tableName, dataTableFieldSize, colCount));
            return;
        }
        int primaryKeyIndex = 0;
        String primaryKey = "";
        StringBuilder errorMsgSb = new StringBuilder();
        StringBuilder insertSqlSb = new StringBuilder();
        StringBuilder updateSqlSb = new StringBuilder();
        HashSet<String> fieldNameSet = new HashSet<String>();
        for (DynamicObject dynamicObject : collection) {
            String fieldName = dynamicObject.getString("fieldname").toUpperCase();
            fieldNameSet.add(fieldName);
            if (!dynamicObject.getBoolean("primarykey")) continue;
            primaryKey = fieldName;
        }
        List upperSortedColLabels = sortedColLabels.stream().map(String::toUpperCase).collect(Collectors.toList());
        HashMap<String, Integer> field2Index = new HashMap<String, Integer>(16);
        insertSqlSb.append("INSERT INTO ").append(tableName).append(" (");
        updateSqlSb.append("UPDATE ").append(tableName).append(" SET ");
        int j = 0;
        for (int i = 0; i < dataTableFieldSize; ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            String fieldName = dynamicObject.getString("fieldname").toUpperCase();
            String sortedColLabel = (String)upperSortedColLabels.get(i);
            if (!fieldNameSet.contains(sortedColLabel)) {
                errorMsgSb.append(ResManager.loadKDString((String)"\u503c\u540d\u79f0", (String)"EigenValueCalcPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append('[').append(valueName).append(']').append(ResManager.loadKDString((String)"\u5206\u5f55\u8ba1\u7b97\u7ed3\u679c\u5b57\u6bb5\u540d", (String)"EigenValueCalcPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append('[').append(sortedColLabel).append(']').append(ResManager.loadKDString((String)"\u5728\u6570\u636e\u8868", (String)"EigenValueCalcPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append('[').append(tableName).append(']').append(ResManager.loadKDString((String)"\u4e2d\u4e0d\u5b58\u5728", (String)"EigenValueCalcPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append("\r\n");
            }
            if (dynamicObject.getBoolean("primarykey")) {
                primaryKeyIndex = upperSortedColLabels.indexOf(fieldName);
                continue;
            }
            field2Index.put(fieldName, j++);
            insertSqlSb.append(fieldName).append(',');
            updateSqlSb.append(fieldName).append("=?,");
        }
        insertSqlSb.append(primaryKey).append(") VALUES (");
        for (int j2 = 0; j2 < dataTableFieldSize; ++j2) {
            insertSqlSb.append('?');
            if (j2 == dataTableFieldMax) {
                insertSqlSb.append(')');
                break;
            }
            insertSqlSb.append(',');
        }
        updateSqlSb.deleteCharAt(updateSqlSb.length() - 1);
        updateSqlSb.append(" WHERE ").append(primaryKey).append("=?");
        if (StringUtils.isBlank((CharSequence)primaryKey)) {
            this.setFailTip(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u5931\u8d25\u3002\u6570\u636e\u8868[%s]\u627e\u4e0d\u5230\u4e3b\u952e\u5b57\u6bb5\u540d", (String)"EigenValueCalcPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]), tableName));
            return;
        }
        if (errorMsgSb.length() != 0) {
            this.setFailMessage(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u5931\u8d25\u3002\u6570\u636e\u8868[%s]\u5b58\u5728\u5b57\u6bb5\u540d\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5b57\u6bb5\u540d\u4e0d\u76f8\u7b49", (String)"EigenValueCalcPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]), tableName), errorMsgSb.toString());
            return;
        }
        Map datas = (Map)calcResult.get("datas");
        List rows = (List)datas.get("rows");
        if (rows.isEmpty()) {
            this.setFailTip(ResManager.loadKDString((String)"\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u5931\u8d25\u3002\u8ba1\u7b97\u7ed3\u679c\u4e2d\u6570\u636e\u4e3a\u7a7a", (String)"EigenValueCalcPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList primaryValues = Lists.newArrayListWithExpectedSize((int)rows.size());
        for (List row : rows) {
            primaryValues.add(row.get(primaryKeyIndex));
        }
        boolean referenced = DataTableCompareUtils.validateRef((String)tableName);
        Map primary2Value = !referenced ? Collections.emptyMap() : DataTableCompareUtils.getExistedValue((String)tableName, (String)primaryKey, (List)primaryValues);
        HashSet<String> modifyFields = new HashSet<String>();
        Set existedPrimaryValues = referenced ? primary2Value.keySet() : this.getExistedPrimaryValues(tableName, primaryKey, errorMsgSb, primaryValues);
        int existedPrimaryValuesSize = existedPrimaryValues.size();
        int insertValueSize = rows.size() - existedPrimaryValuesSize;
        ArrayList insertValues = Lists.newArrayListWithExpectedSize((int)insertValueSize);
        ArrayList updateValues = Lists.newArrayListWithExpectedSize((int)existedPrimaryValuesSize);
        Map colTypes = (Map)calcResult.get("colTypes");
        for (List row : rows) {
            Object primaryValue = row.get(primaryKeyIndex);
            String primaryValueStr = String.valueOf(primaryValue);
            boolean forUpdate = existedPrimaryValues.contains(primaryValueStr);
            Object[] value = new Object[dataTableFieldSize];
            for (int i = 0; i < dataTableFieldSize; ++i) {
                boolean equals;
                Map map;
                if (i == primaryKeyIndex) continue;
                Object rowData = row.get(i);
                String fieldName = (String)sortedColLabels.get(i);
                String colType = (String)colTypes.get(fieldName);
                if (rowData instanceof Long && VType.TIMESTAMP.name().equals(colType)) {
                    rowData = new Date((Long)rowData);
                }
                value[field2Index.getOrDefault((Object)fieldName.toUpperCase(), Integer.valueOf((int)0)).intValue()] = rowData;
                if (!referenced || !forUpdate || modifyFields.contains(fieldName) || (map = (Map)primary2Value.get(primaryValueStr)) == null) continue;
                Object oldValue = map.get(fieldName);
                if (VType.DECIMAL.name().equals(colType)) {
                    BigDecimal newDecimal = rowData == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(rowData));
                    equals = ((BigDecimal)oldValue).compareTo(newDecimal) == 0;
                } else {
                    equals = Objects.equals(oldValue, rowData);
                }
                if (equals) continue;
                modifyFields.add(fieldName);
            }
            value[dataTableFieldMax] = primaryValue;
            if (forUpdate) {
                updateValues.add(value);
                continue;
            }
            insertValues.add(value);
        }
        primary2Value.clear();
        String insertSql = insertSqlSb.toString();
        if (!insertValues.isEmpty()) {
            this.setProgressLoading(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u5f85\u63d2\u5165\u6570\u636e[%d]\u6761", (String)"EigenValueCalcPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]), insertValues.size()), 50);
            DBUtils.executeBatch((String)insertSql, (List)insertValues);
        }
        if (!updateValues.isEmpty()) {
            this.setProgressLoading(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u5f85\u66f4\u65b0\u6570\u636e[%d]\u6761", (String)"EigenValueCalcPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]), existedPrimaryValuesSize), 75);
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    DBUtils.executeBatch((String)updateSqlSb.toString(), (List)updateValues);
                    DataTableCompareUtils.saveDifferenceInfo((String)tableName, modifyFields);
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    String message = String.format(ResManager.loadKDString((String)"\u6267\u884cSQL\u8bed\u53e5\u65f6\u51fa\u73b0\u5f02\u5e38: %s", (String)"EigenValueCalcPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]), exception.getMessage());
                    this.setErrorTip(message);
                    log.error(message, (Throwable)exception);
                    if (txHandle != null) {
                        if (var34_37 != null) {
                            try {
                                txHandle.close();
                            }
                            catch (Throwable throwable) {
                                var34_37.addSuppressed(throwable);
                            }
                        } else {
                            txHandle.close();
                        }
                    }
                    return;
                }
            }
        }
        this.setCompleted(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\u6210\u529f\u3002\u63d2\u5165\u6570\u636e[%d]\u6761, \u66f4\u65b0\u6570\u636e[%d]\u6761", (String)"EigenValueCalcPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]), insertValues.size(), existedPrimaryValuesSize));
    }

    private Set<String> getExistedPrimaryValues(String tableName, String primaryKey, StringBuilder sb, List<Object> primaryValues) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sb.setLength(0);
        sb.append("select ").append(primaryKey).append(" from ").append(tableName).append(" where ");
        sqlBuilder.append(sb.toString(), new Object[0]);
        sqlBuilder.appendIn(primaryKey, primaryValues);
        return (Set)DB.query((DBRoute)DBRoute.of((String)"phm"), (SqlBuilder)sqlBuilder, resultSet -> {
            HashSet<String> existedPrimaryValues = new HashSet<String>(10);
            while (resultSet.next()) {
                existedPrimaryValues.add(resultSet.getString(1));
            }
            return existedPrimaryValues;
        });
    }

    private void showDataTableForm(String selectEntryRowId, Map<String, Object> calcResult) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)(calcResult.size() + 2));
        params.put("createorg", this.getModel().getValue("createorg_id"));
        params.put("entryId", selectEntryRowId);
        params.putAll(calcResult);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_SAVE_RESULT);
        BillShowParameter billShowParameter = ShowFormUtils.assembleShowBillParam((String)"phm_datatable", null, (Map)params, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        OpenStyle openStyle = billShowParameter.getOpenStyle();
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("600px");
        styleCss.setWidth("1200px");
        openStyle.setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, Object> getCalcResult(String selectEntryRowId) {
        String cacheJson = this.getPageCache().getBigObject(CACHEKEY_RESULT);
        Map result = (Map)SerializationUtils.fromJsonString((String)cacheJson, HashMap.class);
        return (Map)result.get(selectEntryRowId);
    }

    private String getSelectEntryRowId() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        return this.getModel().getEntryRowEntity("entryentity", selectRows[0]).getPkValue().toString();
    }

    private void putSelectEntryRowIdToCache(String selectEntryRowId) {
        Set<String> savedEntryIdColl = this.getSelectEntryRowIdCache();
        savedEntryIdColl.add(selectEntryRowId);
        this.getPageCache().put(CACHEKEY_SAVEDENTRYIDCOLL, SerializationUtils.toJsonString(savedEntryIdColl));
    }

    private Set<String> getSelectEntryRowIdCache() {
        String savedEntryIdCollJson = this.getPageCache().get(CACHEKEY_SAVEDENTRYIDCOLL);
        return StringUtils.isBlank((CharSequence)savedEntryIdCollJson) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)savedEntryIdCollJson, HashSet.class);
    }

    private void startCalc() {
        this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u51c6\u5907\u8ba1\u7b97", (String)"EigenValueCalcPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0])), 0);
        DynamicObject model = this.getModel().getDataEntity(true);
        PHMServiceUtils.startCalc((DynamicObject)model);
        IPageCache pageCache = this.getPageCache();
        pageCache.remove(CACHEKEY_SAVEDENTRYIDCOLL);
        pageCache.removeBigObject(CACHEKEY_RESULT);
        pageCache.put(CACHEKEY_SOURCE, BTN_CALC);
        this.openProgress();
    }

    private void openProgress() {
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_CALC);
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u8ba1\u7b97", (String)"EigenValueCalcPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        progressBar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        IPageCache pageCache = this.getPageCache();
        String source = pageCache.get(CACHEKEY_SOURCE);
        if (BTN_CALC.equals(source)) {
            this.jdugeCalcStatus(progressEvent);
        } else {
            this.jdugeSaveResultStatus(progressEvent);
        }
    }

    private void jdugeSaveResultStatus(ProgressEvent progressEvent) {
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        int executionStatus = this.getExecutionStatus();
        if (ExecutionStatus.COMPLETED.getValue() == executionStatus) {
            this.putSelectEntryRowIdToCache(this.getSelectEntryRowId());
            this.getView().showSuccessNotification(this.getTip());
            progressBar.stop();
            this.getView().hideLoading();
        } else if (ExecutionStatus.FAILED.getValue() == executionStatus) {
            String tip = this.getTip();
            if (tip == null) {
                this.showMessage();
            } else {
                this.getView().showErrorNotification(tip);
            }
            progressBar.stop();
            this.getView().hideLoading();
        } else if (ExecutionStatus.ERROR.getValue() == executionStatus) {
            this.getView().showErrMessage(this.getTip(), ResManager.loadKDString((String)"\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"EigenValueCalcPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            progressBar.stop();
            this.getView().hideLoading();
        } else {
            this.showProgressLoading();
        }
    }

    private int getExecutionStatus() {
        String status = this.getPageCache().get(CACHEKEY_STATUS);
        return status == null ? ExecutionStatus.EXECUTING.getValue() : Integer.parseInt(status);
    }

    private void setErrorTip(String tip) {
        this.setTip(ExecutionStatus.ERROR, tip);
    }

    private void setFailTip(String tip) {
        this.setTip(ExecutionStatus.FAILED, tip);
    }

    private void setFailMessage(String title, String message) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put(CACHEKEY_STATUS, String.valueOf(ExecutionStatus.FAILED.getValue()));
        pageCache.put(CACHEKEY_MSG_TITLE, title);
        pageCache.put(CACHEKEY_MSG, message);
        pageCache.remove(CACHEKEY_TIP);
    }

    private void setCompleted(String tip) {
        this.setTip(ExecutionStatus.COMPLETED, tip);
    }

    private void setTip(ExecutionStatus executionStatus, String tip) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put(CACHEKEY_STATUS, String.valueOf(executionStatus.getValue()));
        pageCache.put(CACHEKEY_TIP, tip);
    }

    private String getTip() {
        return this.getPageCache().get(CACHEKEY_TIP);
    }

    private void showMessage() {
        IPageCache pageCache = this.getPageCache();
        this.getView().showMessage(pageCache.get(CACHEKEY_MSG_TITLE), pageCache.get(CACHEKEY_MSG), MessageTypes.Default);
    }

    private void setProgressLoading(String msg, int progress) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put(CACHEKEY_LOADDINGMSG, msg);
        pageCache.put(CACHEKEY_PROGRESS, String.valueOf(progress));
    }

    private void showProgressLoading() {
        IPageCache pageCache = this.getPageCache();
        String message = pageCache.get(CACHEKEY_LOADDINGMSG);
        message = StringUtils.isBlank((CharSequence)message) ? ResManager.loadKDString((String)"\u6b63\u5728\u5206\u6790...", (String)"EigenValueCalcPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : message;
        String progressStr = pageCache.get(CACHEKEY_PROGRESS);
        int progress = StringUtils.isBlank((CharSequence)progressStr) ? 0 : Integer.parseInt(progressStr);
        this.getView().showProgressLoading(new LocaleString(message), progress);
    }

    private void clearSaveResultCache(IPageCache pageCache) {
        pageCache.remove(CACHEKEY_LOADDINGMSG);
        pageCache.remove(CACHEKEY_MSG);
        pageCache.remove(CACHEKEY_MSG_TITLE);
        pageCache.remove(CACHEKEY_TIP);
        pageCache.remove(CACHEKEY_STATUS);
        pageCache.remove(CACHEKEY_PROGRESS);
    }

    private void jdugeCalcStatus(ProgressEvent progressEvent) {
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        String modelId = this.getModel().getDataEntity().getPkValue().toString();
        HashMap statusMap = PHMServiceUtils.queryLatestStatus((String)modelId);
        String calcStatus = (String)statusMap.get(CACHEKEY_STATUS);
        BizModelCalcStatus bizModelCalcStatus = BizModelCalcStatus.fromValue((String)calcStatus);
        switch (bizModelCalcStatus) {
            case STARTED: {
                this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u5f00\u59cb\u8fd0\u884c", (String)"EigenValueCalcPlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0])), 0);
                break;
            }
            case CALCULATING: {
                int progress = this.getProgress(statusMap);
                this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(progress));
                this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u8fd0\u884c", (String)"EigenValueCalcPlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0])), progress);
                progressEvent.setProgress(progress);
                break;
            }
            case FINISHED: {
                progressEvent.setProgress(100);
                progressBar.stop();
                this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u8fd0\u884c\u5b8c\u6210", (String)"EigenValueCalcPlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0])), 100);
                String snapshotKey = PHMServiceUtils.start2CreateSnapshot((String)modelId, null);
                Map snapshotStatus = PHMServiceUtils.querySnapshotStatus((String)modelId, (String)snapshotKey);
                try {
                    while (BizModelCalcStatus.CALCULATING.getValue().equals(snapshotStatus.get("sscp"))) {
                        Thread.sleep(1000L);
                        snapshotStatus = PHMServiceUtils.querySnapshotStatus((String)modelId, (String)snapshotKey);
                    }
                }
                catch (InterruptedException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("SLEEP_INTERRUPTED", ResManager.loadKDString((String)"\u7ebf\u7a0b\u4f11\u7720\u88ab\u6253\u65ad", (String)"EigenValueCalcPlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[0]);
                }
                Map result = PHMServiceUtils.queryResRuntimeDatas((String)modelId, (String)snapshotKey);
                this.getPageCache().putBigObject(CACHEKEY_RESULT, SerializationUtils.toJsonString((Object)result));
                this.getView().hideLoading();
                break;
            }
            case CRUSHED: {
                progressBar.stop();
                this.getView().hideLoading();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u8ba1\u7b97\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"EigenValueCalcPlugin_26", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case UNSTART: {
                this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u542f\u52a8", (String)"EigenValueCalcPlugin_27", (String)"mmc-phm-formplugin", (Object[])new Object[0])), 0);
                break;
            }
            case UNREGIST: {
                progressBar.stop();
                this.getView().hideLoading();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u672a\u6ce8\u518c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"EigenValueCalcPlugin_28", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            default: {
                this.getView().hideLoading();
            }
        }
    }

    private int getProgress(HashMap<String, Serializable> statusMap) {
        int progress = (Integer)statusMap.get(CACHEKEY_PROGRESS);
        String cacheProgressStr = this.getPageCache().get(CACHEKEY_PROGRESS);
        if (StringUtils.isNotBlank((CharSequence)cacheProgressStr)) {
            int cacheProgress = Integer.parseInt(cacheProgressStr);
            int newProgress = cacheProgress + 10;
            progress = progress > cacheProgress ? progress : (newProgress >= 100 ? 90 : newProgress);
        }
        return progress;
    }
}

