/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.eigen;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.mmc.phm.common.enums.VType;

public class EigenValuePreviewPlugin
extends AbstractFormPlugin {
    private static final ThreadLocal<SimpleDateFormat> DATETIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.isEmpty()) {
            return;
        }
        EntryAp entryAp = this.createDynamicEntryAp(formShowParameter);
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)2);
        entryMap.put("id", "entryentity");
        entryMap.put("columns", entryAp.createControl().get("columns"));
        e.getItems().add(entryMap);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.isEmpty()) {
            return;
        }
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("CloneNotSupported", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        JSONArray sortedColLabels = (JSONArray)customParams.get("sortedColLabels");
        for (Object sortedColLabel : sortedColLabels) {
            String key = sortedColLabel.toString();
            TextProp textProp = new TextProp();
            textProp.setName(key);
            textProp.setDisplayName(new LocaleString(key));
            textProp.setDbIgnore(true);
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        e.setNewEntityType(newMainType);
        this.addItmes(view, formShowParameter);
    }

    public void createNewData(BizDataEventArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.isEmpty()) {
            return;
        }
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        JSONArray sortedColLabels = (JSONArray)customParams.get("sortedColLabels");
        JSONObject colTypes = (JSONObject)customParams.get("colTypes");
        JSONObject datas = (JSONObject)customParams.get("datas");
        JSONArray rows = datas.getJSONArray("rows");
        for (Object row : rows) {
            JSONArray rowData = (JSONArray)row;
            DynamicObject dynamicObject = collection.addNew();
            int sortedColLabelsSize = sortedColLabels.size();
            for (int i = 0; i < sortedColLabelsSize; ++i) {
                Object sortedColLabel = sortedColLabels.get(i);
                String sortedColLabelStr = sortedColLabel.toString();
                dynamicObject.set(sortedColLabelStr, this.convertValue(rowData, sortedColLabelStr, colTypes, i));
            }
        }
        e.setDataEntity((Object)dataEntity);
    }

    private Object convertValue(JSONArray data, String sortedColLabelStr, JSONObject colTypes, int index) {
        Object value = data.get(index);
        if (value instanceof Long) {
            String colType = colTypes.getString(sortedColLabelStr);
            if (VType.TIMESTAMP.name().equals(colType)) {
                value = DATETIME_FORMAT.get().format(new Date((Long)value));
            }
        } else if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
        }
        return value;
    }

    private void addItmes(IFormView view, FormShowParameter formShowParameter) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        EntryAp entryAp = this.createDynamicEntryAp(formShowParameter);
        List newItems = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control item : newItems) {
            item.setView(view);
        }
        List items = entryGrid.getItems();
        items.clear();
        items.addAll(newItems);
    }

    private EntryAp createDynamicEntryAp(FormShowParameter formShowParameter) {
        String entityId = MetadataDao.getIdByNumber((String)formShowParameter.getFormId(), (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        EntryAp entryAp = null;
        for (ControlAp item : formmeta.getItems()) {
            if (!"entryentity".equals(item.getKey())) continue;
            entryAp = (EntryAp)item;
            break;
        }
        if (entryAp == null) {
            entryAp = new EntryAp();
            entryAp.setKey("entryentity");
        }
        List sortedColLabels = (List)formShowParameter.getCustomParam("sortedColLabels");
        List items = entryAp.getItems();
        for (String sortedColLabel : sortedColLabels) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId(sortedColLabel);
            entryFieldAp.setKey(sortedColLabel);
            entryFieldAp.setName(new LocaleString(sortedColLabel));
            TextField textField = new TextField();
            textField.setId(sortedColLabel);
            textField.setKey(sortedColLabel);
            entryFieldAp.setField((Field)textField);
            items.add(entryFieldAp);
        }
        return entryAp;
    }
}

