/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.spread;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.orm.util.CollectionUtils;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.spread.model.RealRowAndCol;
import kd.mmc.phm.common.util.GZIPUtils;
import kd.mmc.phm.formplugin.bizmodel.spread.SpreadContainer;
import kd.mmc.phm.formplugin.bizmodel.spread.SpreadDataModel;

public abstract class AbstractSpreadPlugin
extends AbstractFormPlugin {
    private static final String CACHEKEY_REALROWADNCOL = "realRowAndCol";
    private SpreadContainer spreadContainer;

    public void initialize() {
        super.initialize();
        this.initSpreadService();
    }

    private void initSpreadService() {
        this.getView().addService(ISpreadAction.class, (Object)this.getSpreadDataModelService());
    }

    protected SpreadDataModel getSpreadDataModelService() {
        return new SpreadDataModel(this, this.getSpreadKey());
    }

    protected abstract String getSpreadKey();

    protected SpreadContainer getSpreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.getView(), this.getSpreadKey());
        }
        return this.spreadContainer;
    }

    protected RealRowAndCol getRealRowAndCol() {
        String cacheStr = this.getPageCache().get(CACHEKEY_REALROWADNCOL);
        return StringUtils.isBlank((CharSequence)cacheStr) ? new RealRowAndCol() : (RealRowAndCol)SerializationUtils.fromJsonString((String)cacheStr, RealRowAndCol.class);
    }

    private void cacheRealRowAndCol(RealRowAndCol realRowAndCol) {
        this.getPageCache().put(CACHEKEY_REALROWADNCOL, SerializationUtils.toJsonString((Object)realRowAndCol));
    }

    protected String resetSpreadJson(String spreadJson) {
        String convertSpreadJson = SpreadUtils.convertSpreadJson((String)spreadJson);
        Map spreadMap = (Map)SerializationUtils.fromJsonString((String)convertSpreadJson, Map.class);
        return this.resetSpreadJson(spreadMap, null);
    }

    protected String resetSpreadJson(Map<String, Object> spreadMap) {
        return this.resetSpreadJson(spreadMap, null);
    }

    protected String resetSpreadJson(Map<String, Object> spreadMap, Tuple<Integer, Integer> realRowCol) {
        if (CollectionUtils.isEmpty(spreadMap)) {
            return null;
        }
        Map sheets = (Map)spreadMap.get("sheets");
        Map sheetMap = (Map)sheets.get("Sheet1");
        Map<Integer, Map<Integer, Tuple<Integer, Integer>>> rowSpanMap = this.getRowSpanMap(sheetMap);
        Map data = (Map)sheetMap.get("data");
        Map rowMap = data.getOrDefault("dataTable", Collections.emptyMap());
        if (rowMap.isEmpty()) {
            return "base64" + GZIPUtils.compress((String)SerializationUtils.toJsonString(spreadMap));
        }
        RealRowAndCol realRowAndCol = new RealRowAndCol();
        for (Map.Entry rowEntry : rowMap.entrySet()) {
            int row = Integer.parseInt((String)rowEntry.getKey());
            Map colMap = (Map)rowEntry.getValue();
            for (Map.Entry colEntry : colMap.entrySet()) {
                int col = Integer.parseInt((String)colEntry.getKey());
                Map cellMap = (Map)colEntry.getValue();
                Map<Integer, Tuple<Integer, Integer>> spanColMap = rowSpanMap.get(row);
                if (cellMap.get("value") == null || !StringUtils.isNotBlank((CharSequence)cellMap.get("value").toString())) continue;
                if (spanColMap == null) {
                    realRowAndCol.calcRow(row);
                    realRowAndCol.calcCol(col);
                    continue;
                }
                Tuple<Integer, Integer> tuple = spanColMap.get(col);
                if (tuple != null) {
                    realRowAndCol.calcRow(((Integer)tuple.item1).intValue());
                    realRowAndCol.calcCol(((Integer)tuple.item2).intValue());
                    continue;
                }
                realRowAndCol.calcRow(row);
                realRowAndCol.calcCol(col);
            }
        }
        if (realRowCol != null) {
            if (realRowAndCol.getCol() < (Integer)realRowCol.item2) {
                realRowAndCol.calcCol(((Integer)realRowCol.item2).intValue());
            }
            if (realRowAndCol.getRow() < (Integer)realRowCol.item1) {
                realRowAndCol.calcRow(((Integer)realRowCol.item1).intValue());
            }
        }
        this.cacheRealRowAndCol(realRowAndCol);
        sheetMap.put("rowCount", realRowAndCol.getRealRow());
        sheetMap.put("columnCount", realRowAndCol.getRealCol());
        return "base64" + GZIPUtils.compress((String)SerializationUtils.toJsonString(spreadMap));
    }

    private Map<Integer, Map<Integer, Tuple<Integer, Integer>>> getRowSpanMap(Map<String, Object> sheetMap) {
        List spans = sheetMap.getOrDefault("spans", Collections.emptyList());
        HashMap<Integer, Map<Integer, Tuple<Integer, Integer>>> rowSpanMap = new HashMap<Integer, Map<Integer, Tuple<Integer, Integer>>>();
        for (Map span : spans) {
            int spanRow = (Integer)span.get("row");
            int spanRowCount = (Integer)span.get("rowCount");
            int spanMaxRow = spanRow + spanRowCount - 1;
            int spanCol = (Integer)span.get("col");
            int spanColCount = (Integer)span.get("colCount");
            int spanMaxCol = spanCol + spanColCount - 1;
            Map colSpanMap = rowSpanMap.computeIfAbsent(spanRow, k -> new HashMap());
            colSpanMap.put(spanCol, Tuple.create((Object)spanMaxRow, (Object)spanMaxCol));
        }
        return rowSpanMap;
    }
}

