/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel.spread;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.mmc.phm.common.spread.model.Cell;
import kd.mmc.phm.common.spread.model.CellArea;
import kd.mmc.phm.common.spread.model.CellStyle;
import kd.mmc.phm.common.spread.model.FormulaCell;

public class SpreadContainer {
    private final String key;
    private final IClientViewProxy clientViewProxy;

    public SpreadContainer(IFormView view, String key) {
        this.clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        this.key = key;
    }

    public void getSpreadJson(String pluginMethodName) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("callback", "invokeAction");
        params.put("invokemethod", pluginMethodName);
        this.clientViewProxy.invokeControlMethod(this.key, "getSpreadJson", new Object[]{params});
    }

    public void rebuildSpread(String spreadJson) {
        this.clientViewProxy.invokeControlMethod(this.key, "setSpreadJson", new Object[]{spreadJson});
    }

    public void addContextMenuItems(List<Tuple<String, String>> tuples) {
        if (tuples == null || tuples.isEmpty()) {
            return;
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("callback", "invokeAction");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)tuples.size());
        for (Tuple<String, String> tuple : tuples) {
            HashMap itemMap = Maps.newHashMapWithExpectedSize((int)3);
            itemMap.put("name", tuple.item1);
            itemMap.put("text", tuple.item2);
            itemMap.put("workArea", Lists.newArrayList((Object[])new String[]{"viewport"}));
            items.add(itemMap);
        }
        params.put("items", items);
        this.clientViewProxy.invokeControlMethod(this.key, "addContextMenuItems", new Object[]{params});
    }

    public void setCellStyle(List<Cell> cells, CellStyle cellStyle) {
        if (CollectionUtils.isEmpty(cells) || cellStyle == null) {
            return;
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList range = Lists.newArrayListWithExpectedSize((int)cells.size());
        for (Cell cell : cells) {
            HashMap rangeMap = Maps.newHashMapWithExpectedSize((int)4);
            rangeMap.put("r", cell.getRow());
            rangeMap.put("c", cell.getCol());
            rangeMap.put("rc", 1);
            rangeMap.put("cc", 1);
            range.add(rangeMap);
        }
        params.put("range", range);
        params.put("style", cellStyle);
        this.clientViewProxy.invokeControlMethod(this.key, "setCellStyle", new Object[]{Lists.newArrayList((Object[])new Map[]{params})});
    }

    public void updateCellValue(List<Cell> cells) {
        if (CollectionUtils.isEmpty(cells)) {
            return;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)cells.size());
        for (Cell cell : cells) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)3);
            param.put("r", cell.getRow());
            param.put("c", cell.getCol());
            param.put("v", cell.getValue());
            params.add(param);
        }
        this.clientViewProxy.invokeControlMethod(this.key, "updataValue", new Object[]{params});
    }

    public void updateCellsValue(List<Map<String, Object>> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.key, "updataValue", new Object[]{params});
    }

    public void lockToolbarItems(boolean lock, List<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            return;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)names.size());
        for (String name : names) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)2);
            param.put("isLock", lock);
            param.put("name", name);
            params.add(param);
        }
        this.clientViewProxy.invokeControlMethod(this.key, "lockToolbarItems", new Object[]{params});
    }

    public void appendRows(int count) {
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("count", count);
        this.clientViewProxy.invokeControlMethod(this.key, "appendRows", new Object[]{params});
    }

    public void appendCols(int count) {
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("count", count);
        this.clientViewProxy.invokeControlMethod(this.key, "appendCols", new Object[]{params});
    }

    public void lockCell(List<Cell> cells) {
        if (CollectionUtils.isEmpty(cells)) {
            return;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)cells.size());
        for (Cell cell : cells) {
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            param.put("r", cell.getRow());
            param.put("c", cell.getCol());
            param.put("rc", 1);
            param.put("cc", 1);
            params.add(param);
        }
        this.clientViewProxy.invokeControlMethod(this.key, "lockCell", new Object[]{params});
    }

    public void lockCell(CellArea cellArea) {
        if (cellArea == null) {
            return;
        }
        this.clientViewProxy.invokeControlMethod(this.key, "lockCell", new Object[]{Lists.newArrayList((Object[])new CellArea[]{cellArea})});
    }

    public void closeToolbar() {
        this.clientViewProxy.invokeControlMethod(this.key, "closeToolbar", new Object[]{Collections.emptyMap()});
    }

    public void lockSheet() {
        this.clientViewProxy.invokeControlMethod(this.key, "lockSheet", new Object[]{Collections.emptyMap()});
    }

    public void hideContextMenuItems(List<String> menuItems, boolean isHide) {
        if (CollectionUtils.isEmpty(menuItems)) {
            return;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)menuItems.size());
        for (String menuItem : menuItems) {
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("name", menuItem);
            param.put("isHide", isHide);
            params.add(param);
        }
        this.clientViewProxy.invokeControlMethod(this.key, "hideContextMenuItems", new Object[]{params});
    }

    public void setFormula(List<FormulaCell> cells) {
        this.clientViewProxy.invokeControlMethod(this.key, "setFormula", new Object[]{cells});
    }
}

