/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.command;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.info.DetailGridInfo;
import kd.mmc.phm.common.info.DetailParamInfo;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.common.util.ShowFormUtils;

public class AbstractDetailEntryGridPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String INFO = "info";
    private static final String BACK = "back";
    private static final String DATE_TYPE = "TIMESTAMP";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BACK});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(formShowParameter);
        EntryAp entryAp = this.createDynamicEntryAp(detailParamInfo, formShowParameter.getFormId());
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)2);
        entryMap.put("id", ENTRYENTITY);
        entryMap.put("columns", entryAp.createControl().get("columns"));
        e.getItems().add(entryMap);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode(this.getPluginName(), exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(formShowParameter);
        this.registerProperty(entryType, detailParamInfo);
        e.setNewEntityType(newMainType);
        EntryAp entryAp = this.createDynamicEntryAp(detailParamInfo, formShowParameter.getFormId());
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        List items = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control item : items) {
            item.setView(this.getView());
            entryGrid.getItems().add(item);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
        JSONObject data = (JSONObject)detailParamInfo.getData();
        if (Objects.nonNull(data)) {
            JSONObject datas = data.getJSONObject("datas");
            JSONArray colNames = data.getJSONArray("sortedColLabels");
            HashMap seqMap = Maps.newHashMapWithExpectedSize((int)colNames.size());
            for (int i = 0; i < colNames.size(); ++i) {
                seqMap.put(colNames.getString(i), i);
            }
            JSONObject colTypes = data.getJSONObject("colTypes");
            JSONArray rows = datas.getJSONArray("rows");
            DynamicObject detailFieldSet = this.getDetailFieldSet(detailParamInfo.getBizModelId(), detailParamInfo.getComponentId());
            Map<String, String> fieldNames = this.getNameFromDetailSet(detailFieldSet, detailParamInfo.isDrilling());
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject entryRow = entryRows.addNew();
                for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
                    String name = entry.getKey();
                    String vTypeName = colTypes.getString(name);
                    Object value = rows.getJSONArray(i).get(((Integer)seqMap.get(name)).intValue());
                    if (StringUtils.equals((CharSequence)DATE_TYPE, (CharSequence)vTypeName)) {
                        if (value instanceof Number) {
                            value = new Date(((Number)value).longValue());
                        } else {
                            if (value != null) {
                                throw new KDBizException(new ErrorCode("UNKNOWN_DATE_CLASS", value.getClass().getName()), new Object[0]);
                            }
                            value = new Date();
                        }
                        value = THREAD_LOCAL.get().format(value);
                    } else if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                    }
                    entryRow.set(name, value);
                }
            }
        }
        e.setDataEntity((Object)dataEntity);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
        DetailGridInfo detailGridInfo = detailParamInfo.getDetailGridInfo();
        if (!detailParamInfo.isDrilling()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BACK});
        }
        if (Objects.nonNull(detailGridInfo)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
            entryGrid.setRowBackcolor(detailGridInfo.getBackColor(), IntStream.range(0, entryRowCount).toArray());
            entryGrid.setPageRows(detailGridInfo.getPageRow());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BACK, (CharSequence)control.getKey())) {
            DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
            detailParamInfo.setDrilling(false);
            detailParamInfo.setData(detailParamInfo.getDetailData());
            this.reload(detailParamInfo);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        try {
            DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
            String bizModelId = detailParamInfo.getBizModelId().toString();
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u94bb\u53d6\u4e2d...", (String)"AbstractDetailEntryGridPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
            Serializable value = null;
            HashMap<String, String> filterParams = new HashMap<String, String>(2);
            String filterValue = this.getModel().getValue(fieldName, rowIndex).toString();
            String resultId = "drilling-" + detailParamInfo.getComponentId();
            String drillingIdFilterId = "drilling-" + detailParamInfo.getComponentId() + "\u0000" + fieldName;
            filterParams.put(drillingIdFilterId, filterValue);
            String keyTmp = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"start2CreateSnapshot", (Object[])new Object[]{bizModelId, filterParams});
            HashMap status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{bizModelId, keyTmp});
            while ("B".equals(status.get("sscp"))) {
                Thread.sleep(1000L);
                status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{bizModelId, keyTmp});
            }
            Object resData = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryResRuntimeDatas", (Object[])new Object[]{bizModelId, keyTmp});
            if (resData instanceof Map) {
                Map datas = (Map)resData;
                value = (Serializable)datas.get(resultId);
            }
            detailParamInfo.setDrilling(true);
            detailParamInfo.setDetailData(detailParamInfo.getData());
            detailParamInfo.setData(value);
            this.reload(detailParamInfo);
        }
        catch (Exception ex) {
            this.getView().hideLoading();
            throw new KDBizException(ex.getMessage());
        }
    }

    private void reload(DetailParamInfo detailParamInfo) {
        IFormView view = this.getView();
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)1);
        customParams.put(INFO, detailParamInfo);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)view.getEntityId(), (Map)customParams, null, (ShowType)ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("detail_panel");
        IFormView parentView = view.getParentView();
        parentView.showForm(formShowParameter);
        view.sendFormAction(parentView);
    }

    private EntryAp createDynamicEntryAp(DetailParamInfo detailParamInfo, String formId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(ENTRYENTITY);
        String entityId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        for (ControlAp ap : formmeta.getItems()) {
            if (!StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)ap.getKey())) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        JSONObject data = (JSONObject)detailParamInfo.getData();
        DetailGridInfo detailGridInfo = detailParamInfo.getDetailGridInfo();
        if (Objects.isNull(data)) {
            return entryAp;
        }
        DynamicObject detailFieldSet = this.getDetailFieldSet(detailParamInfo.getBizModelId(), detailParamInfo.getComponentId());
        Set<String> relationField = this.getRelationFields(detailFieldSet);
        Map<String, String> fieldNames = this.getNameFromDetailSet(detailFieldSet, detailParamInfo.isDrilling());
        for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
            String key = entry.getKey();
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId(key);
            entryFieldAp.setKey(key);
            entryFieldAp.setName(new LocaleString(entry.getValue()));
            entryFieldAp.setForeColor(detailGridInfo.getFontColor());
            entryFieldAp.setFontSize(detailGridInfo.getFontSize());
            if (!detailParamInfo.isDrilling() && relationField.contains(key)) {
                entryFieldAp.setHyperlink(true);
            }
            TextField textField = new TextField();
            textField.setId(key);
            textField.setKey(key);
            entryFieldAp.setField((Field)textField);
            if (entryAp == null) continue;
            entryAp.getItems().add(entryFieldAp);
        }
        return entryAp;
    }

    private void registerProperty(EntryType entryType, DetailParamInfo detailParamInfo) {
        JSONObject data = (JSONObject)detailParamInfo.getData();
        if (Objects.nonNull(data)) {
            DynamicObject detailFieldSet = this.getDetailFieldSet(detailParamInfo.getBizModelId(), detailParamInfo.getComponentId());
            Map<String, String> fieldNames = this.getNameFromDetailSet(detailFieldSet, detailParamInfo.isDrilling());
            for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
                TextProp textProp = new TextProp();
                textProp.setName(entry.getKey());
                textProp.setDisplayName(new LocaleString(entry.getValue()));
                textProp.setDbIgnore(true);
                entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
            }
        }
    }

    private DynamicObject getDetailFieldSet(Object bizModelId, String componentId) {
        DynamicObject fieldSetData = null;
        try (DataSet dataSet = DesignerUtils.queryComponent((Object)bizModelId, (String)componentId);){
            if (dataSet.hasNext()) {
                Map properties = (Map)SerializationUtils.fromJsonString((String)dataSet.next().getString("data_tag"), HashMap.class);
                String dataJson = (String)properties.get("field_set_data_tag");
                if (StringUtils.isNotBlank((CharSequence)dataJson)) {
                    Object[] fieldSets = DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
                    fieldSetData = (DynamicObject)fieldSets[0];
                }
            } else {
                String dataJson;
                QFilter filter = new QFilter("componentid", "=", (Object)componentId);
                QFilter[] filters = new QFilter[]{filter};
                DynamicObject detailFieldSet = QueryServiceHelper.queryOne((String)"phm_bizmodel_detail", (String)"field_set_data_tag", (QFilter[])filters);
                if (Objects.nonNull(detailFieldSet) && StringUtils.isNotBlank((CharSequence)(dataJson = detailFieldSet.getString("field_set_data_tag")))) {
                    Object[] fieldSets = DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
                    fieldSetData = (DynamicObject)fieldSets[0];
                }
            }
            DynamicObject dynamicObject = fieldSetData;
            return dynamicObject;
        }
    }

    private Map<String, String> getNameFromDetailSet(DynamicObject detailFieldSet, boolean isDrilling) {
        LinkedHashMap<String, String> fieldNameMap = new LinkedHashMap<String, String>(16);
        if (Objects.nonNull(detailFieldSet)) {
            String prefix = isDrilling ? "drilling" : "field";
            DynamicObjectCollection entryColls = detailFieldSet.getDynamicObjectCollection(prefix + "_entryentity");
            for (DynamicObject entryData : entryColls) {
                fieldNameMap.put(entryData.getString(prefix + "_name"), entryData.getString(prefix + "_alias"));
            }
        }
        return fieldNameMap;
    }

    private Set<String> getRelationFields(DynamicObject detailFieldSet) {
        HashSet<String> relationFields = new HashSet<String>();
        if (Objects.nonNull(detailFieldSet)) {
            DynamicObjectCollection entryentity = detailFieldSet.getDynamicObjectCollection("drilling_entryentity");
            for (DynamicObject entry : entryentity) {
                String relationField = entry.getString("drilling_relation");
                if (!StringUtils.isNotBlank((CharSequence)relationField)) continue;
                relationFields.add(relationField);
            }
        }
        return relationFields;
    }

    private DetailParamInfo getDetailParamInfo(FormShowParameter formShowParameter) {
        Object paramInfo = formShowParameter.getCustomParam(INFO);
        return paramInfo instanceof JSONObject ? (DetailParamInfo)JSONObject.toJavaObject((JSON)((JSONObject)paramInfo), DetailParamInfo.class) : (DetailParamInfo)paramInfo;
    }
}

