/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.command;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.SeatUtils;

public class ConditionPlugin
extends AbstractFormPlugin {
    private static final String DATA = "data";
    private static final String BTNOK = "btnok";
    private static final String ENTRYENTITY = "entryentity";
    private static final String EMPTY = "EMPTY";

    public void afterCreateNewData(EventObject e) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(DATA);
        if (Objects.isNull(customParam)) {
            return;
        }
        Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)customParam.toString(), (DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObject echoDataEntity = (DynamicObject)deserialize[0];
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set(ENTRYENTITY, (Object)echoDataEntity.getDynamicObjectCollection(ENTRYENTITY));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String cachePageId = this.getView().getParentView().getFormShowParameter().getParentPageId();
        List eigens = ComponentUtil.getAllComponentInfoByType((String)cachePageId, (ComponentType)ComponentType.EIGENVALUE);
        List comboItems = eigens.stream().map(componentInfo -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(componentInfo.getComponentId());
            comboItem.setCaption(new LocaleString((String)componentInfo.getProperties().get("name")));
            return comboItem;
        }).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getControl("condition_field");
        comboEdit.setComboItems(comboItems);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount != 0) {
            this.getModel().setValue("logical_symbol", (Object)EMPTY, entryRowCount - 1);
            this.getView().setEnable(Boolean.FALSE, entryRowCount - 1, new String[]{"logical_symbol"});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
        int rowIndex = rowDataEntity.getRowIndex();
        if (rowIndex != 0) {
            this.getModel().setValue("logical_symbol", null, rowIndex - 1);
            this.getView().setEnable(Boolean.TRUE, rowIndex - 1, new String[]{"logical_symbol"});
        }
        this.getModel().setValue("logical_symbol", (Object)EMPTY, rowIndex);
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"logical_symbol"});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount == 0) {
            return;
        }
        this.getModel().setValue("logical_symbol", (Object)EMPTY, entryRowCount - 1);
        this.getView().setEnable(Boolean.FALSE, entryRowCount - 1, new String[]{"logical_symbol"});
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        int lastRowIndex = entryRowCount - 1;
        boolean includeLastRow = Arrays.stream(rowIndexs).anyMatch(rowIndex -> rowIndex == lastRowIndex);
        if (includeLastRow) {
            this.disableLastAndEnablePenultimate(lastRowIndex);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        int lastRowIndex = entryRowCount - 1;
        boolean includePenultimateRow = Arrays.stream(rowIndexs).anyMatch(rowIndex -> rowIndex == lastRowIndex - 1);
        if (includePenultimateRow) {
            this.disableLastAndEnablePenultimate(lastRowIndex);
        }
    }

    private void disableLastAndEnablePenultimate(int lastRowIndex) {
        this.getModel().setValue("logical_symbol", (Object)EMPTY, lastRowIndex);
        this.getView().setEnable(Boolean.FALSE, lastRowIndex, new String[]{"logical_symbol"});
        this.getModel().setValue("logical_symbol", null, lastRowIndex - 1);
        this.getView().setEnable(Boolean.TRUE, lastRowIndex - 1, new String[]{"logical_symbol"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (StringUtils.equals((CharSequence)BTNOK, (CharSequence)operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            boolean success = SeatUtils.executeCondition((DynamicObjectCollection)entryEntity);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String json = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dataEntity}, (DynamicObjectType)dataEntity.getDynamicObjectType());
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            params.put(DATA, json);
            params.put("success", success);
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }
}

