/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.command;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.util.SeatUtils;
import kd.mmc.phm.common.util.ShowFormUtils;

public class MessageBodyPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String EXAMPLE = "example";
    private static final String TYPE = "type";
    private static final String EIGENVALUE = "eigenvalue";
    private static final String VALUE = "value";
    private static final String BTNOK = "btnok";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("data");
        if (Objects.isNull(customParam)) {
            return;
        }
        Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)customParam.toString(), (DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObject echoDataEntity = (DynamicObject)deserialize[0];
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set(ENTRYENTITY, (Object)echoDataEntity.getDynamicObjectCollection(ENTRYENTITY));
        this.modifyExampleText();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.modifyExampleText();
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        this.modifyExampleText();
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        this.modifyExampleText();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (StringUtils.equals((CharSequence)TYPE, (CharSequence)name)) {
            String newValue = (String)changeData.getNewValue();
            boolean isEigenvalue = StringUtils.equals((CharSequence)EIGENVALUE, (CharSequence)newValue);
            int rowIndex = changeData.getRowIndex();
            if (isEigenvalue) {
                this.getModel().setValue(VALUE, (Object)ResManager.loadKDString((String)"\u53cc\u51fb\u7ef4\u62a4", (String)"MessageBodyPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), rowIndex);
                this.setCellForeColor(rowIndex, "#bbbbbb");
            } else {
                this.setCellForeColor(rowIndex, "#333333");
            }
        }
        this.modifyExampleText();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        String type = (String)this.getModel().getValue(TYPE, row);
        if (StringUtils.equals((CharSequence)VALUE, (CharSequence)fieldKey) && StringUtils.equals((CharSequence)EIGENVALUE, (CharSequence)type)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EIGENVALUE);
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
            FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
            customParams.put("bizModelPageId", parentShowParameter.getParentPageId());
            customParams.put("bizModelId", parentShowParameter.getCustomParam("bizModelId"));
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_action_eigenvalue", (Map)customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)EIGENVALUE) && returnData instanceof Map) {
            Map returnMap = (Map)returnData;
            this.getModel().setValue(VALUE, returnMap.get("action_eigenvalue"));
            this.getModel().setValue(EIGENVALUE, returnMap.get("eigencomponent"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTNOK, (CharSequence)control.getKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
            StringBuilder msg = new StringBuilder();
            StringBuilder example = new StringBuilder();
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String type = dynamicObject.getString(TYPE);
                String value = dynamicObject.getString(VALUE);
                if (StringUtils.equals((CharSequence)EIGENVALUE, (CharSequence)type) && StringUtils.isBlank((CharSequence)dynamicObject.getString(EIGENVALUE))) {
                    msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u5206\u5f55\u7b2c", (String)"MessageBodyPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c: \u503c", (String)"MessageBodyPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                String text = StringUtils.equals((CharSequence)EIGENVALUE, (CharSequence)type) && StringUtils.isBlank((CharSequence)value) ? ResManager.loadKDString((String)"\u7279\u5f81\u503c", (String)"MessageBodyPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : dynamicObject.getString(VALUE);
                example.append(text);
            }
            if (msg.length() != 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5fc5\u5f55\u6821\u9a8c", (String)"MessageBodyPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
                return;
            }
            String json = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dataEntity}, (DynamicObjectType)this.getModel().getDataEntityType());
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put(EXAMPLE, example.toString());
            params.put("data", json);
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private void setCellForeColor(int rowIndex, String foreColor) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(VALUE);
        cellStyle.setRow(rowIndex);
        cellStyle.setForeColor(foreColor);
        entryGrid.setCellStyle(Collections.singletonList(cellStyle));
    }

    private void modifyExampleText() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        String text = SeatUtils.getText((DynamicObjectCollection)entryEntity, (boolean)false);
        Label label = (Label)this.getControl(EXAMPLE);
        label.setText(text);
    }
}

