/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.command;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.phm.common.command.SeatEnum;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.SeatUtils;
import kd.mmc.phm.common.util.ShowFormUtils;

public class SeatConfigEditPlugin
extends AbstractBillPlugIn
implements CellClickListener {
    public void afterLoadData(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        Object veidooSceneId = this.getView().getFormShowParameter().getCustomParam("veidooSceneId");
        if (Objects.nonNull(veidooSceneId)) {
            this.getModel().setValue("veidooScene_id", veidooSceneId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            IDataModel model = this.getModel();
            StringBuilder msg = new StringBuilder();
            String seatValue = (String)model.getValue("seat");
            if (StringUtils.isBlank((CharSequence)seatValue)) {
                msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \"\u5e2d\u4f4d\"\n", (String)"SeatConfigEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection msgEntry = model.getEntryEntity("message_entry");
            for (int i = 0; i < msgEntry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)msgEntry.get(i);
                if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("message_show"))) continue;
                msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u6d88\u606f\u914d\u7f6e\u7b2c", (String)"SeatConfigEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c: \u6d88\u606f\u6b63\u6587\n", (String)"SeatConfigEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection opTextEntry = model.getEntryEntity("optext_entry");
            if (!opTextEntry.isEmpty()) {
                int eigenvalueCount = 0;
                for (int i = 0; i < opTextEntry.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)opTextEntry.get(i);
                    String type = dynamicObject.getString("type");
                    if (!StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)type)) continue;
                    ++eigenvalueCount;
                    if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("eigenvalue"))) continue;
                    msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u64cd\u4f5c\u6587\u672c\u7b2c", (String)"SeatConfigEditPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c: \u503c\n", (String)"SeatConfigEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                if (eigenvalueCount != 1) {
                    msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u52a0 \u64cd\u4f5c\u6587\u672c\u4e2d\u7c7b\u578b\u4e3a\u7279\u5f81\u503c\u7684\u8bb0\u5f55\n", (String)"SeatConfigEditPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                } else {
                    String radioValue = (String)this.getModel().getValue("radiogroup");
                    if (StringUtils.equals((CharSequence)"b", (CharSequence)radioValue)) {
                        DynamicObjectCollection relationEntry;
                        String operation;
                        Object bizObject = this.getModel().getValue("bizobject");
                        if (Objects.isNull(bizObject)) {
                            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \"\u4e1a\u52a1\u5bf9\u8c61\"\n", (String)"SeatConfigEditPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        }
                        if (StringUtils.isBlank((CharSequence)(operation = (String)this.getModel().getValue("operation")))) {
                            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \"\u64cd\u4f5c\u65b9\u5f0f\"\n", (String)"SeatConfigEditPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        }
                        if ((relationEntry = this.getModel().getEntryEntity("relation_entry")).isEmpty()) {
                            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \"\u5b57\u6bb5\u5173\u7cfb\"\n", (String)"SeatConfigEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        } else {
                            for (int i = 0; i < relationEntry.size(); ++i) {
                                DynamicObject relationObj = (DynamicObject)relationEntry.get(i);
                                if (StringUtils.isBlank((CharSequence)relationObj.getString("detailfield"))) {
                                    msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u5b57\u6bb5\u5173\u7cfb\u7b2c", (String)"SeatConfigEditPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c: \u660e\u7ec6\u5b57\u6bb5\n", (String)"SeatConfigEditPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                                }
                                if (!StringUtils.isBlank((CharSequence)relationObj.getString("billfield"))) continue;
                                msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u5b57\u6bb5\u5173\u7cfb\u7b2c", (String)"SeatConfigEditPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c: \u5355\u636e\u5b57\u6bb5\n", (String)"SeatConfigEditPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                            }
                        }
                    } else {
                        DynamicObjectCollection paramEntry;
                        String api = (String)this.getModel().getValue("url");
                        if (StringUtils.isBlank((CharSequence)api)) {
                            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \"API\u5730\u5740\"\n", (String)"SeatConfigEditPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        }
                        if ((paramEntry = this.getModel().getEntryEntity("param_entry")).isEmpty()) {
                            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \"\u53c2\u6570\u5206\u5f55\"\n", (String)"SeatConfigEditPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        } else {
                            for (int i = 0; i < paramEntry.size(); ++i) {
                                DynamicObject paramObj = (DynamicObject)paramEntry.get(i);
                                if (!StringUtils.isBlank((CharSequence)paramObj.getString("param"))) continue;
                                msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u53c2\u6570\u5206\u5f55\u7b2c", (String)"SeatConfigEditPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c: \u53c2\u6570\n", (String)"SeatConfigEditPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                }
            }
            if (msg.length() != 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c", (String)"SeatConfigEditPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.getView().returnDataToParent((Object)dataEntity);
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit msgShowEdit = (TextEdit)this.getControl("message_show");
        msgShowEdit.addButtonClickListener((ClickListener)this);
        TextEdit condiShowEdit = (TextEdit)this.getControl("condition_show");
        condiShowEdit.addButtonClickListener((ClickListener)this);
        EntryGrid opTextEntry = (EntryGrid)this.getControl("optext_entry");
        opTextEntry.addCellClickListener((CellClickListener)this);
        EntryGrid paramEntry = (EntryGrid)this.getControl("param_entry");
        paramEntry.addCellClickListener((CellClickListener)this);
        Button button = (Button)this.getControl("btnok");
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"message_show", (CharSequence)key) || StringUtils.equals((CharSequence)"condition_show", (CharSequence)key)) {
            String formId;
            String fieldKey;
            TextEdit textEdit = (TextEdit)control;
            int row = this.getModel().getEntryCurrentRowIndex(textEdit.getEntryKey());
            if (StringUtils.equals((CharSequence)"message_show", (CharSequence)key)) {
                fieldKey = "messagebody";
                formId = "phm_message_body";
            } else {
                fieldKey = "condition";
                formId = "phm_condition";
            }
            String data = (String)this.getModel().getValue(fieldKey + "_tag", row);
            HashMap params = null;
            if (StringUtils.isNotBlank((CharSequence)data)) {
                params = Maps.newHashMapWithExpectedSize((int)1);
                params.put("data", data);
            }
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)formId, (Map)params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, fieldKey), (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equals((CharSequence)"value", (CharSequence)name)) {
            this.modifyExampleText();
        } else if (StringUtils.equals((CharSequence)"bizobject", (CharSequence)name)) {
            this.updateBizObjectRelationCombo();
        } else if (StringUtils.equals((CharSequence)"radiogroup", (CharSequence)name)) {
            this.setMustInputStatus();
        } else if (StringUtils.equals((CharSequence)"message_show", (CharSequence)name) && StringUtils.isBlank((Object)changeData.getNewValue())) {
            this.getModel().setValue("messagebody", null);
            this.getModel().setValue("messagebody_tag", null);
        } else if (StringUtils.equals((CharSequence)"condition_show", (CharSequence)name) && StringUtils.isBlank((Object)changeData.getNewValue())) {
            this.getModel().setValue("condition", null);
            this.getModel().setValue("condition_tag", null);
        } else if (StringUtils.equals((CharSequence)"type", (CharSequence)name)) {
            String newValue = (String)changeData.getNewValue();
            boolean isEigenvalue = StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)newValue);
            if (isEigenvalue) {
                this.getModel().setValue("value", (Object)ResManager.loadKDString((String)"\u53cc\u51fb\u7ef4\u62a4", (String)"SeatConfigEditPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]), rowIndex);
                this.setCellForeColor("optext_entry", "value", rowIndex, "#bbbbbb");
            } else {
                this.setCellForeColor("optext_entry", "value", rowIndex, "#333333");
            }
            this.updateTypeCombo(!isEigenvalue);
            this.modifyExampleText();
        } else if (StringUtils.equals((CharSequence)"paramtype", (CharSequence)name)) {
            String newValue = (String)changeData.getNewValue();
            boolean fromDetail = StringUtils.equals((CharSequence)"D", (CharSequence)newValue);
            if (fromDetail) {
                this.getModel().setValue("paramsource", (Object)ResManager.loadKDString((String)"\u53cc\u51fb\u7ef4\u62a4", (String)"SeatConfigEditPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]), rowIndex);
                this.setCellForeColor("param_entry", "paramsource", rowIndex, "#bbbbbb");
            } else {
                this.setCellForeColor("param_entry", "paramsource", rowIndex, "#333333");
            }
        }
    }

    private void setCellForeColor(String entryKey, String fieldKey, int rowIndex, String foreColor) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setRow(rowIndex);
        cellStyle.setForeColor(foreColor);
        entryGrid.setCellStyle(Collections.singletonList(cellStyle));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateSeatCombo();
        this.updateEigenRelationCombo();
        this.updateBizObjectRelationCombo();
        this.setMustInputStatus();
        this.modifyExampleText();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void updateEigenRelationCombo() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("optext_entry");
        entryentity.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)dynamicObject.getString("type"))).map(dynamicObject -> dynamicObject.getString("eigenvalue")).findFirst().ifPresent(eigenvalueId -> {
            this.updateTypeCombo(false);
            this.updateDetailFieldCombo((String)eigenvalueId);
        });
    }

    private void updateBizObjectRelationCombo() {
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue("bizobject");
        this.updateOperationCombo(bizObject);
        this.updateBillFieldCombo(bizObject);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"optext_entry", (CharSequence)e.getEntryProp().getName())) {
            for (int rowIndex : e.getRowIndexs()) {
                String type = (String)this.getModel().getValue("type", rowIndex);
                if (!StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)type)) continue;
                this.getPageCache().remove("detailName");
                this.updateTypeCombo(true);
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"optext_entry", (CharSequence)e.getEntryProp().getName())) {
            this.modifyExampleText();
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        if (StringUtils.equals((CharSequence)"optext_entry", (CharSequence)e.getEntryProp().getName())) {
            this.modifyExampleText();
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        if (StringUtils.equals((CharSequence)"optext_entry", (CharSequence)e.getEntryProp().getName())) {
            this.modifyExampleText();
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String source;
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if (StringUtils.equals((CharSequence)"value", (CharSequence)fieldKey)) {
            String type = (String)this.getModel().getValue("type", row);
            if (StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)type)) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "eigenvalue");
                HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
                FormShowParameter currentParamter = this.getView().getFormShowParameter();
                customParams.put("bizModelPageId", currentParamter.getParentPageId());
                customParams.put("bizModelId", currentParamter.getCustomParam("bizModelId"));
                FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_action_eigenvalue", (Map)customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
                this.getView().showForm(formShowParameter);
            }
        } else if (StringUtils.equals((CharSequence)"paramsource", (CharSequence)fieldKey) && StringUtils.equals((CharSequence)"D", (CharSequence)(source = (String)this.getModel().getValue("paramtype", row)))) {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("detailName", this.getPageCache().get("detailName"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "paramsource");
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_detail_field", params, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        switch (actionId) {
            case "messagebody": {
                this.fillMsgBody(returnData);
                break;
            }
            case "condition": {
                this.fillCondition(returnData);
                break;
            }
            case "eigenvalue": {
                this.fillEigenvalue(returnData);
                break;
            }
            case "paramsource": {
                this.fillParamSource(returnData);
                break;
            }
        }
    }

    private void fillParamSource(Object returnData) {
        if (returnData instanceof Tuple) {
            IDataModel model = this.getModel();
            Tuple tuple = (Tuple)returnData;
            model.setValue("paramvalue", tuple.item1);
            model.setValue("paramsource", tuple.item2);
            int rowIndex = model.getEntryCurrentRowIndex("param_entry");
            this.setCellForeColor("param_entry", "paramsource", rowIndex, "#333333");
        }
    }

    private void fillEigenvalue(Object returnData) {
        if (returnData instanceof Map) {
            IDataModel model = this.getModel();
            Map returnMap = (Map)returnData;
            model.setValue("value", returnMap.get("action_eigenvalue"));
            String eigenvalueId = (String)returnMap.get("eigencomponent");
            model.setValue("eigenvalue", (Object)eigenvalueId);
            this.updateDetailFieldCombo(eigenvalueId);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("optext_entry");
            this.setCellForeColor("optext_entry", "value", rowIndex, "#333333");
            DynamicObjectCollection entryEntity = model.getEntryEntity("relation_entry");
            entryEntity.forEach(dynamicObject -> dynamicObject.set("detailfield", null));
            this.getView().updateView("relation_entry");
        }
    }

    private void setMustInputStatus() {
        String radioValue = (String)this.getModel().getValue("radiogroup");
        boolean isBillOperate = StringUtils.equals((CharSequence)"b", (CharSequence)radioValue);
        this.setMustInput(isBillOperate, "bizobject", "operation", "detailfield", "billfield");
        this.setMustInput(!isBillOperate, "url", "param");
        this.setEntryMustInput(isBillOperate, "relation_entry");
        this.setEntryMustInput(!isBillOperate, "param_entry");
    }

    private void setEntryMustInput(boolean value, String entryentity) {
        EntryProp entryProp = (EntryProp)this.getModel().getProperty(entryentity);
        entryProp.setEntryMustInput(value);
    }

    private void setMustInput(boolean value, String ... keys) {
        for (String key : keys) {
            Control control = this.getControl(key);
            if (!(control instanceof FieldEdit)) continue;
            FieldEdit fieldEdit = (FieldEdit)control;
            fieldEdit.setMustInput(value);
            IDataEntityProperty property = fieldEdit.getProperty();
            if (property instanceof FieldProp) {
                ((FieldProp)property).setMustInput(value);
                continue;
            }
            if (!(property instanceof BasedataProp)) continue;
            ((BasedataProp)property).setMustInput(value);
        }
    }

    private void updateBillFieldCombo(DynamicObject bizObject) {
        List comboItems;
        if (Objects.isNull(bizObject)) {
            comboItems = Collections.emptyList();
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.getString("number"));
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            comboItems = properties.stream().filter(property -> !(property instanceof EntryProp) && StringUtils.isNotBlank((Object)property.getDisplayName())).map(property -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(property.getName());
                comboItem.setCaption(property.getDisplayName());
                return comboItem;
            }).collect(Collectors.toList());
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("billfield");
        comboEdit.setComboItems(comboItems);
    }

    private void updateOperationCombo(DynamicObject bizObject) {
        List comboItems;
        if (Objects.isNull(bizObject)) {
            comboItems = Collections.emptyList();
        } else {
            List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)bizObject.getPkValue().toString());
            comboItems = dataEntityOperate.stream().filter(operationMeta -> {
                String operationType = (String)operationMeta.get("type");
                return OperationTypeCache.isEntityOperation((String)operationType);
            }).map(operationMeta -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(LocaleString.fromMap((Map)((Map)operationMeta.get("name"))));
                comboItem.setValue((String)operationMeta.get("key"));
                return comboItem;
            }).collect(Collectors.toList());
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("operation");
        comboEdit.setComboItems(comboItems);
    }

    private void updateDetailFieldCombo(String eigenvalueId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List componentInfos = ComponentUtil.getDetailFromEigenvalue((String)formShowParameter.getParentPageId(), (String)eigenvalueId);
        if (!componentInfos.isEmpty()) {
            Object bizModelId = formShowParameter.getCustomParam("bizModelId");
            Map nameMap = ComponentUtil.getNameFromDetailSet((Object)bizModelId, (String)((ComponentInfo)componentInfos.get(0)).getComponentId());
            this.getPageCache().put("detailName", SerializationUtils.toJsonString((Object)nameMap));
            List comboItems = nameMap.entrySet().stream().map(entry -> new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey())).collect(Collectors.toList());
            ComboEdit comboEdit = (ComboEdit)this.getControl("detailfield");
            comboEdit.setComboItems(comboItems);
        }
    }

    private void updateTypeCombo(boolean showEigenvalue) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("type");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        ComboItem comboItem1 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6587\u672c", (String)"SeatConfigEditPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0])), "text");
        comboItems.add(comboItem1);
        ComboItem comboItem2 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7279\u5f81\u503c", (String)"SeatConfigEditPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0])), "eigenvalue");
        comboItem2.setItemVisible(showEigenvalue);
        comboItems.add(comboItem2);
        comboEdit.setComboItems(comboItems);
    }

    private void updateSeatCombo() {
        Object seatComboData = this.getView().getFormShowParameter().getCustomParam("seatValue");
        JSONArray seatSet = Objects.isNull(seatComboData) ? new JSONArray() : (JSONArray)seatComboData;
        List comboItems = Arrays.stream(SeatEnum.values()).filter(seatEnum -> seatEnum != SeatEnum.OTHER && !seatSet.contains((Object)seatEnum.getValue())).map(seatEnum -> new ComboItem(new LocaleString(seatEnum.getName()), seatEnum.getValue())).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getControl("seat");
        comboEdit.setComboItems(comboItems);
    }

    private void fillCondition(Object returnData) {
        if (returnData instanceof Map) {
            Map params = (Map)returnData;
            IDataModel model = this.getModel();
            model.setValue("condition_show", (Object)ResManager.loadKDString((String)"\u5df2\u914d\u7f6e", (String)"SeatConfigEditPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            model.setValue("condition_tag", params.get("data"));
            model.setValue("success", params.get("success"));
        }
    }

    private void fillMsgBody(Object returnData) {
        if (returnData instanceof Map) {
            IDataModel model = this.getModel();
            Map params = (Map)returnData;
            model.setValue("message_show", params.get("example"));
            model.setValue("messagebody", params.get("example"));
            model.setValue("messagebody_tag", params.get("data"));
        }
    }

    private void modifyExampleText() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("optext_entry");
        String text = SeatUtils.getText((DynamicObjectCollection)entryEntity, (boolean)false);
        Label label = (Label)this.getControl("example");
        label.setText(text);
    }
}

