/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.command;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.HttpClientUtils;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.command.SeatConfiguration;
import kd.mmc.phm.common.command.SeatEnum;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.info.DetailParamInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.common.util.EigenValueUtils;
import kd.mmc.phm.common.util.JsonUtil;
import kd.mmc.phm.common.util.SeatUtils;
import kd.mmc.phm.common.util.ShowFormUtils;

public class VeidooSceneEditPlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(VeidooSceneEditPlugin.class);
    private static final String BIZMODEL = "bizmodel";
    private static final String ADVCONAP = "advconap";
    private static final String FLEX_COMPUTE = "flex_compute";
    private static final String PROGRESS = "progress";
    private static final String DESIGNER_GRAPH = "customcontrolap";
    private static final String DESIGNER_SEAT = "seat_customcontrol";
    private static final String ENTRYFORM = "phm_seat_entrygrid";
    private static final String DETAIL_PANEL = "detail_panel";
    private static final String PROGRESS_COMPUTE = "progress_compute";
    private static final String PROGRESS_REFRESH = "progress_refresh";
    private static final String CACHE_SEATID = "seatId";
    private static final String CACHE_TIMED_COUNT = "timedCount";
    private static final String CACHE_ISTIMEDREFRESH = "isTimedRefresh";
    private static final String CACHE_PROGRESS = "progress";
    private static final String ADD = "add";
    private static final String EDIT = "edit";
    private static final String DELETE = "delete";
    private static final String BTN_CLOSE = "btn_close";
    private static final String TOOLBARAP = "toolbarap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DATE_TYPE = "TIMESTAMP";
    public static final String PAGESTATUS = "pagestatus";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public void afterLoadData(EventObject e) {
        long bizModelId = (Long)this.getModel().getValue("bizmodel_id");
        Map componentInfoMap = DesignerUtils.wrapperComponentInfo((long)bizModelId);
        Map<String, ComponentInfo> newComponentInfoMap = componentInfoMap.entrySet().stream().filter(entry -> {
            ComponentInfo componentInfo = (ComponentInfo)entry.getValue();
            if (componentInfo.getComponentType() == ComponentType.EIGENVALUE) {
                Map properties = componentInfo.getProperties();
                String value = "";
                String valueType = (String)properties.get("valuetype");
                if (StringUtils.equals((CharSequence)"cal", (CharSequence)valueType)) {
                    value = (String)properties.get("value_tag");
                } else if (StringUtils.equals((CharSequence)"query", (CharSequence)valueType)) {
                    value = (String)properties.get("storevalue_tag");
                }
                List paramsColList = EigenValueUtils.getParamsColList((String)value);
                return paramsColList.size() <= 1;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.getPageCache().put("componentInfo", JsonUtil.toJsonString(newComponentInfoMap));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar computeProgress = (ProgressBar)this.getControl(PROGRESS_COMPUTE);
        computeProgress.addProgressListener((ProgresssListener)this);
        ProgressBar refreshProgress = (ProgressBar)this.getControl(PROGRESS_REFRESH);
        refreshProgress.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{ADD, EDIT, DELETE});
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)BTN_CLOSE, (CharSequence)evt.getItemKey())) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
                HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"VeidooSceneEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"VeidooSceneEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5e2d\u4f4d\u53d1\u751f\u66f4\u6539\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"VeidooSceneEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBack, (Map)btnNameMaps);
            } else {
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object customParam = this.getView().getParentView().getFormShowParameter().getCustomParam(PAGESTATUS);
        if (this.isRun() || OperationStatus.VIEW.toString().equals(customParam)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "seat_toolbarap"});
        }
        AdvContainer advContainer = (AdvContainer)this.getControl(ADVCONAP);
        advContainer.setCollapse(true);
        this.getView().setVisible(Boolean.FALSE, new String[]{ADVCONAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_COMPUTE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "add": {
                this.addSeat();
                break;
            }
            case "edit": {
                this.editSeat();
                break;
            }
            case "delete": {
                this.deleteSeat();
                break;
            }
        }
    }

    private void addSeat() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        Object veidooSceneId = this.getModel().getDataEntity().getPkValue();
        params.put("veidooSceneId", veidooSceneId);
        Object bizModelId = this.getModel().getValue("bizmodel_id");
        params.put("bizModelId", bizModelId);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        Set seatSet = entryEntity.stream().filter(dynamicObject -> Objects.nonNull(dynamicObject.getDynamicObject("seatconfig"))).map(dynamicObject -> {
            DynamicObject seatConfig = dynamicObject.getDynamicObject("seatconfig");
            return seatConfig.getString("seat");
        }).collect(Collectors.toSet());
        params.put("seatValue", seatSet);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_seat_config", (Map)params, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void editSeat() {
        String seatId = this.getPageCache().get(CACHE_SEATID);
        if (StringUtils.isBlank((CharSequence)seatId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5e2d\u4f4d\u8fdb\u884c\u7f16\u8f91", (String)"VeidooSceneEditPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        Object bizModelId = this.getModel().getValue("bizmodel_id");
        params.put("bizModelId", bizModelId);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        Set seatSet = entryEntity.stream().filter(dynamicObject -> {
            DynamicObject seatConfig = dynamicObject.getDynamicObject("seatconfig");
            return Objects.nonNull(seatConfig) && !StringUtils.equals((CharSequence)seatId, (CharSequence)seatConfig.getPkValue().toString());
        }).map(dynamicObject -> dynamicObject.getDynamicObject("seatconfig").getString("seat")).collect(Collectors.toSet());
        params.put("seatValue", seatSet);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EDIT);
        BillShowParameter formShowParameter = ShowFormUtils.assembleShowBillParam((String)"phm_seat_config", (Object)Long.parseLong(seatId), (Map)params, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void deleteSeat() {
        String seatId = this.getPageCache().get(CACHE_SEATID);
        if (StringUtils.isBlank((CharSequence)seatId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5e2d\u4f4d\u8fdb\u884c\u5220\u9664", (String)"VeidooSceneEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("deleteSeatConfirm", (IFormPlugin)this);
        String confirmMessage = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u5e2d\u4f4d\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u5e2d\u4f4d\u5417\uff1f", (String)"VeidooSceneEditPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (StringUtils.equals((CharSequence)"deleteSeatConfirm", (CharSequence)callBackId) && result == MessageBoxResult.Yes) {
            String seatId = this.getPageCache().get(CACHE_SEATID);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            entryEntity.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)seatId, (CharSequence)dynamicObject.getString("seatconfig_id"))).map(dynamicObject -> dynamicObject.getInt("seq")).findFirst().ifPresent(seq -> this.getModel().deleteEntryRow(ENTRYENTITY, seq - 1));
            this.notifyDesigner(DESIGNER_SEAT, "deleteSeat", seatId);
            this.getPageCache().remove(CACHE_SEATID);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"phm_seat_config"), (Object[])new Object[]{Long.parseLong(seatId)});
        } else if (StringUtils.equals((CharSequence)"continue_close", (CharSequence)callBackId) && result == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        if (StringUtils.equals((CharSequence)ADD, (CharSequence)actionId)) {
            this.dealSeatAddition(returnData);
        } else if (StringUtils.equals((CharSequence)EDIT, (CharSequence)actionId)) {
            this.dealSeatEdition(returnData);
        }
    }

    private void dealSeatAddition(Object returnData) {
        if (returnData instanceof DynamicObject) {
            DynamicObject seatConfig = (DynamicObject)returnData;
            int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.dealSeatReturnData("addSeat", seatConfig, newEntryRow);
        }
    }

    private void dealSeatEdition(Object returnData) {
        if (returnData instanceof DynamicObject) {
            DynamicObject seatConfig = (DynamicObject)returnData;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            Optional<Integer> optional = entryEntity.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)seatConfig.getPkValue().toString(), (CharSequence)dynamicObject.getString("seatconfig_id"))).map(dynamicObject -> dynamicObject.getInt("seq")).findFirst();
            optional.ifPresent(seq -> this.dealSeatReturnData("editSeat", seatConfig, seq - 1));
        }
    }

    private void dealSeatReturnData(String action, DynamicObject seatConfig, int entryRow) {
        this.getModel().setValue("seatconfig", (Object)seatConfig, entryRow);
        SeatConfiguration seatConfiguration = this.wrapperSeatConfiguration(seatConfig, this.isRun());
        this.notifyDesigner(DESIGNER_SEAT, action, seatConfiguration);
    }

    private SeatConfiguration wrapperSeatConfiguration(DynamicObject seatConfig, boolean running) {
        Map<String, Object> formatEigenvalue = this.getFormatEigenvalue();
        MainEntityType msgBodyDt = EntityMetadataCache.getDataEntityType((String)"phm_message_body");
        Function<DynamicObject, String> textFunction = dynamicObject -> {
            if (running) {
                String json = dynamicObject.getString("messagebody_tag");
                if (StringUtils.isBlank((CharSequence)json)) {
                    return "";
                }
                Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)json, (DynamicObjectType)msgBodyDt);
                DynamicObject messageBody = (DynamicObject)deserialize[0];
                DynamicObjectCollection entryentity = messageBody.getDynamicObjectCollection(ENTRYENTITY);
                String text = SeatUtils.getText((DynamicObjectCollection)entryentity, (boolean)true);
                Object[] values = entryentity.stream().filter(msgDynamicObject -> StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)msgDynamicObject.getString("type"))).map(msgDynamicObject -> {
                    String eigenvalueId = msgDynamicObject.getString("eigenvalue");
                    return formatEigenvalue.get(eigenvalueId);
                }).toArray();
                return String.format(text, values);
            }
            return dynamicObject.getString("messagebody");
        };
        DynamicObjectCollection msgEntry = seatConfig.getDynamicObjectCollection("message_entry");
        List msg = msgEntry.stream().filter(dynamicObject -> {
            if (running) {
                return dynamicObject.getBoolean("enable") && dynamicObject.getBoolean("success") && !formatEigenvalue.isEmpty();
            }
            return true;
        }).map(textFunction).collect(Collectors.toList());
        DynamicObjectCollection entryentity = seatConfig.getDynamicObjectCollection("optext_entry");
        String opText = SeatUtils.getText((DynamicObjectCollection)entryentity, (boolean)running);
        if (running) {
            if (formatEigenvalue.isEmpty()) {
                opText = "";
            } else {
                List values = entryentity.stream().filter(msgDynamicObject -> StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)msgDynamicObject.getString("type"))).map(msgDynamicObject -> {
                    String eigenvalueId = msgDynamicObject.getString("eigenvalue");
                    return formatEigenvalue.get(eigenvalueId);
                }).collect(Collectors.toList());
                if (!values.isEmpty()) {
                    opText = String.format(opText, values.get(0));
                }
            }
        }
        SeatConfiguration seatConfiguration = new SeatConfiguration();
        seatConfiguration.setId(seatConfig.getPkValue().toString());
        String seatValue = seatConfig.getString("seat");
        String seatName = SeatEnum.fromValue((String)seatValue).getName();
        seatConfiguration.setTitle(seatName);
        seatConfiguration.setMsg(msg);
        seatConfiguration.setOperation(opText);
        return seatConfiguration;
    }

    private Map<String, Object> getFormatEigenvalue() {
        if (this.isRun()) {
            String dataJson = this.getPageCache().get("data");
            Map result = (Map)JSON.parseObject((String)dataJson, HashMap.class);
            Object bizModelId = this.getModel().getValue("bizmodel_id");
            return DesignerUtils.getFormatEigenvalue((Map)result, (Object)bizModelId);
        }
        return new HashMap<String, Object>(16);
    }

    private void showOrRun() {
        Object bizModelId = this.getModel().getValue("bizmodel_id");
        DynamicObject bizModel = BusinessDataServiceHelper.loadSingle((Object)bizModelId, (String)"phm_bizmodel");
        if (Objects.isNull(bizModel)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u4e3a\u7a7a, \u65e0\u6cd5\u8fdb\u884c\u8ba1\u7b97", (String)"VeidooSceneEditPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String resId = bizModelId.toString();
        Date modifyTime = bizModel.getDate("modifytime");
        QFilter[] filters = new QFilter[]{new QFilter(BIZMODEL, "=", bizModelId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"phm_bizmodel_calclog", (String)"start_time", (QFilter[])filters, (String)"start_time desc", (int)1);){
            boolean rerun = false;
            Date startTime = null;
            if (dataSet.hasNext()) {
                startTime = dataSet.next().getDate(0);
                if (modifyTime.after(startTime)) {
                    rerun = true;
                }
            } else {
                rerun = true;
            }
            if (log.isInfoEnabled()) {
                log.info("\u4e1a\u52a1\u6a21\u578b\u662f\u5426\u9700\u8981\u91cd\u65b0\u8ba1\u7b97:rerun: {}, bizModelId: {}, existed: {}, modifyTime: {}, startTime: {}", new Object[]{rerun, bizModelId, dataSet.hasNext(), modifyTime, startTime});
            }
            if (rerun) {
                this.run(bizModel);
                return;
            }
        }
        HashMap snapshot = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"getLatestSnapshotByUser", (Object[])new Object[]{resId});
        if (log.isInfoEnabled()) {
            log.info("\u4e1a\u52a1\u6a21\u578b\u7528\u6237\u5feb\u7167\u4fe1\u606f: {}, resId: {}", (Object)snapshot, (Object)resId);
        }
        if (Objects.isNull(snapshot)) {
            Map statusInfo = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryLatestStatus", (Object[])new Object[]{resId});
            if (log.isInfoEnabled()) {
                log.info("\u4e1a\u52a1\u6a21\u578b\u8ba1\u7b97\u72b6\u6001\uff1a {}, resId: {}", (Object)statusInfo, (Object)resId);
                log.info("\u65e0\u5feb\u7167\u4fe1\u606f, \u91cd\u65b0\u8ba1\u7b97, resId: {}", (Object)resId);
            }
            this.run(bizModel);
        } else {
            this.show();
        }
    }

    private void show() {
        this.show(null);
    }

    private void show(String snapshotKey) {
        Object result;
        String resId = this.getModel().getValue("bizmodel_id").toString();
        if (Objects.isNull(snapshotKey)) {
            result = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"getLatestSnapshotByUser", (Object[])new Object[]{resId});
        } else {
            HashMap status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{resId, snapshotKey});
            while ("B".equals(status.get("sscp"))) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new KDBizException(new ErrorCode("VeidooSceneEditPlugin.show(java.lang.String)", ResManager.loadKDString((String)"\u67e5\u8be2\u5feb\u7167\u7b49\u5f85\u5f02\u5e38", (String)"VeidooSceneEditPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e});
                }
                status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{resId, snapshotKey});
            }
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"saveModelSnapshot", (Object[])new Object[]{resId, RequestContext.get().getUserId(), null});
            result = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryResRuntimeDatas", (Object[])new Object[]{resId, snapshotKey});
        }
        if (result instanceof Map) {
            Map datas = (Map)result;
            this.showEigenvalue(datas);
            this.getPageCache().put("data", JSON.toJSONString((Object)datas));
            String isTimedRefresh = this.getPageCache().get(CACHE_ISTIMEDREFRESH);
            if (StringUtils.isBlank((CharSequence)isTimedRefresh)) {
                ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_REFRESH);
                progressBar.start();
            }
            this.refreshSeat(datas);
        }
    }

    private void refreshSeat(Map<String, Serializable> data) {
        Map<Long, DynamicObject> dynamicObjectMap = this.loadSeatConfig();
        MainEntityType conditionDt = EntityMetadataCache.getDataEntityType((String)"phm_condition");
        StringBuilder errorMsg = new StringBuilder();
        dynamicObjectMap.forEach((k, seatConfig) -> {
            String seatName = SeatEnum.fromValue((String)seatConfig.getString("seat")).getName();
            DynamicObjectCollection msgEntry = seatConfig.getDynamicObjectCollection("message_entry");
            for (int i = 0; i < msgEntry.size(); ++i) {
                DynamicObject msgDynamicObject = (DynamicObject)msgEntry.get(i);
                String conditionJson = msgDynamicObject.getString("condition_tag");
                if (StringUtils.isBlank((CharSequence)conditionJson)) continue;
                Object[] conditionObjs = DynamicObjectSerializeUtil.deserialize((String)conditionJson, (DynamicObjectType)conditionDt);
                DynamicObject conditionObj = (DynamicObject)conditionObjs[0];
                DynamicObjectCollection conditionEntry = conditionObj.getDynamicObjectCollection(ENTRYENTITY);
                String returnData = SeatUtils.executeCondition((DynamicObjectCollection)conditionEntry, (Map)data);
                boolean success = StringUtils.equals((CharSequence)"1", (CharSequence)returnData);
                if (StringUtils.equals((CharSequence)"-1", (CharSequence)returnData)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"%s -> \u6d88\u606f\u5206\u5f55\u7b2c%d\u884c\u6761\u4ef6 -> \u6267\u884c\u5931\u8d25%n", (String)"VeidooSceneEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]), seatName, i + 1));
                }
                msgDynamicObject.set("success", (Object)success);
            }
        });
        if (errorMsg.length() != 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6761\u4ef6\u6267\u884c\u5931\u8d25", (String)"VeidooSceneEditPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]), errorMsg.toString(), MessageTypes.Default);
        }
        this.initSeatDesigner(dynamicObjectMap);
    }

    private Map<Long, DynamicObject> loadSeatConfig() {
        Map<Long, DynamicObject> result;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            result = Collections.emptyMap();
        } else {
            Object[] seatConfigIds = entryEntity.stream().map(dynamicObject -> dynamicObject.get("seatconfig_id")).toArray();
            DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])seatConfigIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_seat_config"));
            result = Arrays.stream(objects).collect(Collectors.toMap(dynamicObject -> (Long)dynamicObject.getPkValue(), dynamicObject -> dynamicObject));
        }
        return result;
    }

    private void showEigenvalue(Map<String, Serializable> datas) {
        Object bizModelId = this.getModel().getValue("bizmodel_id");
        Map formatEigenvalue = DesignerUtils.getFormatEigenvalue(datas, (Object)bizModelId);
        String singleJson = JSONObject.toJSONString((Object)formatEigenvalue);
        this.notifyDesigner(DESIGNER_GRAPH, "showEigenvalue", singleJson);
    }

    private void run(DynamicObject bizModel) {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_COMPUTE});
        this.getPageCache().remove("data");
        String resId = bizModel.getPkValue().toString();
        HashMap result = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"getLatestSnapshotByUser", (Object[])new Object[]{resId});
        if (result != null) {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"cancelModelSnapshot", (Object[])new Object[]{resId, RequestContext.get().getUserId()});
        }
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"startCalc", (Object[])new Object[]{bizModel});
        ProgressBar computeProgress = (ProgressBar)this.getControl(PROGRESS_COMPUTE);
        computeProgress.setPercent(0, ResManager.loadKDString((String)"\u8ba1\u7b97\u8fdb\u5ea6", (String)"VeidooSceneEditPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        computeProgress.start();
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        switch (eventName) {
            case "clear": {
                this.clearDesigner(e.getKey());
                break;
            }
            case "init": {
                this.initSeatDesigner();
                this.importXml();
                break;
            }
            case "afterImportGraphXml": {
                this.showOrRun();
                break;
            }
            case "showDetail": {
                this.showDetail(eventArgs);
                break;
            }
            case "click": {
                this.getPageCache().put(CACHE_SEATID, eventArgs);
                break;
            }
            case "confirm": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u529f\u80fd\u6682\u672a\u5b9e\u73b0", (String)"VeidooSceneEditPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void executeOperate(String seatId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        Optional<DynamicObject> optional = entryEntity.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)seatId, (CharSequence)dynamicObject.getString("seatconfig_id"))).map(dynamicObject -> dynamicObject.getDynamicObject("seatconfig")).findFirst();
        optional.ifPresent(seatConfig -> {
            DynamicObjectCollection relationEntry = seatConfig.getDynamicObjectCollection("relation_entry");
            DynamicObjectCollection paramEntry = seatConfig.getDynamicObjectCollection("param_entry");
            if (relationEntry.isEmpty() && paramEntry.isEmpty()) {
                return;
            }
            DynamicObjectCollection entryentity = seatConfig.getDynamicObjectCollection("optext_entry");
            Optional<String> eigenvaleuIdOptional = entryentity.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)dynamicObject.getString("type"))).map(dynamicObject -> dynamicObject.getString("eigenvalue")).findFirst();
            eigenvaleuIdOptional.ifPresent(eigenvalueId -> {
                List componentInfos;
                String json = this.getPageCache().get("data");
                Map result = (Map)JSON.parseObject((String)json, HashMap.class);
                JSONObject data = (JSONObject)result.get(((ComponentInfo)(componentInfos = ComponentUtil.getDetailFromEigenvalue((String)this.getView().getPageId(), (String)eigenvalueId)).get(0)).getComponentId());
                if (Objects.isNull(data)) {
                    return;
                }
                JSONObject datas = data.getJSONObject("datas");
                JSONArray colNames = data.getJSONArray("sortedColLabels");
                HashMap seqMap = Maps.newHashMapWithExpectedSize((int)colNames.size());
                for (int i = 0; i < colNames.size(); ++i) {
                    seqMap.put(colNames.getString(i), i);
                }
                JSONObject colTypes = data.getJSONObject("colTypes");
                JSONArray rows = datas.getJSONArray("rows");
                if (StringUtils.equals((CharSequence)"b", (CharSequence)seatConfig.getString("radiogroup"))) {
                    DynamicObject bizObject = seatConfig.getDynamicObject("bizobject");
                    String entityNumber = bizObject.getString("number");
                    String operationKey = seatConfig.getString("operation");
                    QFilter[] filters = (QFilter[])relationEntry.stream().map(dynamicObject -> {
                        String detailFieldName = dynamicObject.getString("detailfield");
                        List<Object> values = this.getDetailValue(seqMap, colTypes, rows, detailFieldName);
                        return new QFilter(dynamicObject.getString("billfield"), "in", values);
                    }).toArray(QFilter[]::new);
                    List ids = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])filters, null, (int)-1);
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                    this.getView().showOperationResult(operationResult);
                } else {
                    log.info("\u51c6\u5907\u6267\u884cAPI\u63a5\u53e3");
                    String url = seatConfig.getString("url");
                    try {
                        Map<String, Object> body = paramEntry.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"F", (CharSequence)dynamicObject.getString("paramtype"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("param"), dynamicObject -> dynamicObject.get("paramsource")));
                        Map<String, String> detailFieldMap = paramEntry.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)"D", (CharSequence)dynamicObject.getString("paramtype"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("param"), dynamicObject -> dynamicObject.getString("paramvalue")));
                        if (detailFieldMap.isEmpty()) {
                            String post = HttpClientUtils.postjson((String)url, null, (String)SerializationUtils.toJsonString(body));
                            log.info("API\u8fd4\u56de\u7ed3\u679c------> " + post);
                        } else {
                            for (Object row : rows) {
                                JSONArray jsonArray = (JSONArray)row;
                                for (Map.Entry<String, String> entry : detailFieldMap.entrySet()) {
                                    Object value = this.formatValue(seqMap, colTypes, entry.getValue(), jsonArray);
                                    body.put(entry.getKey(), value);
                                }
                                String post = HttpClientUtils.postjson((String)url, null, (String)SerializationUtils.toJsonString(body));
                                log.info("API\u8fd4\u56de\u7ed3\u679c------> " + post);
                            }
                        }
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"VeidooSceneEditPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    }
                    catch (Exception e) {
                        log.error("\u6267\u884c\u5931\u8d25", (Throwable)e);
                        throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25:", (String)"VeidooSceneEditPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage());
                    }
                }
            });
        });
    }

    private List<Object> getDetailValue(Map<String, Integer> seqMap, JSONObject colTypes, JSONArray rows, String detailFieldName) {
        ArrayList<Object> values = new ArrayList<Object>(rows.size());
        for (Object row : rows) {
            JSONArray jsonArray = (JSONArray)row;
            Object value = this.formatValue(seqMap, colTypes, detailFieldName, jsonArray);
            values.add(value);
        }
        return values;
    }

    private Object formatValue(Map<String, Integer> seqMap, JSONObject colTypes, String detailFieldName, JSONArray jsonArray) {
        String vTypeName = colTypes.getString(detailFieldName);
        Object value = jsonArray.get(seqMap.get(detailFieldName).intValue());
        if (StringUtils.equals((CharSequence)DATE_TYPE, (CharSequence)vTypeName)) {
            if (value instanceof Number) {
                value = new Date(((Number)value).longValue());
            } else {
                if (value != null) {
                    throw new KDBizException(new ErrorCode("UNKNOWN_DATE_CLASS", value.getClass().getName()), new Object[0]);
                }
                value = new Date();
            }
            value = THREAD_LOCAL.get().format(value);
        } else if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
        }
        return value;
    }

    private void initSeatDesigner() {
        boolean running = this.isRun();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        List seatConfigurationList = entryEntity.stream().filter(dynamicObject -> Objects.nonNull(dynamicObject.get("seatconfig"))).map(dynamicObject -> {
            DynamicObject seatConfig = dynamicObject.getDynamicObject("seatconfig");
            return this.wrapperSeatConfiguration(seatConfig, running);
        }).collect(Collectors.toList());
        HashMap data = Maps.newHashMapWithExpectedSize((int)3);
        data.put("action", "render");
        data.put("returnData", seatConfigurationList);
        data.put("isRun", running);
        this.notifyDesigner(DESIGNER_SEAT, data);
    }

    private void initSeatDesigner(Map<Long, DynamicObject> dynamicObjectMap) {
        boolean running = this.isRun();
        List seatConfigurationList = dynamicObjectMap.values().stream().map(dynamicObject -> this.wrapperSeatConfiguration((DynamicObject)dynamicObject, running)).collect(Collectors.toList());
        HashMap data = Maps.newHashMapWithExpectedSize((int)3);
        data.put("action", "render");
        data.put("returnData", seatConfigurationList);
        data.put("isRun", running);
        this.notifyDesigner(DESIGNER_SEAT, data);
    }

    private void importXml() {
        Object bizModelId = this.getModel().getValue("bizmodel_id");
        QFilter[] filters = new QFilter("id", "=", bizModelId).toArray();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"phm_bizmodel", (String)"xml_tag", (QFilter[])filters, null);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap params = Maps.newHashMapWithExpectedSize((int)3);
                params.put("action", "import");
                params.put("returnData", row.getString("xml_tag"));
                params.put("running", this.isRun());
                this.notifyDesigner(DESIGNER_GRAPH, params);
            }
        }
    }

    private void showDetail(String eventArgs) {
        String json = this.getPageCache().get("data");
        if (StringUtils.isBlank((CharSequence)json)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u5c1a\u672a\u5b8c\u6210, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"VeidooSceneEditPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map result = (Map)JSON.parseObject((String)json, HashMap.class);
        List componentInfos = ComponentUtil.getDetailFromEigenvalue((String)this.getView().getPageId(), (String)eventArgs);
        AdvContainer advContainer = (AdvContainer)this.getControl(ADVCONAP);
        advContainer.setCollapse(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{ADVCONAP});
        Serializable data = null;
        String detailKey = "";
        ComponentInfo componentInfo = null;
        if (!componentInfos.isEmpty()) {
            componentInfo = (ComponentInfo)componentInfos.get(0);
            detailKey = componentInfo.getComponentId();
            data = (Serializable)result.get(detailKey);
        }
        DetailParamInfo detailParamInfo = new DetailParamInfo();
        detailParamInfo.setDrilling(false);
        detailParamInfo.setData(data);
        detailParamInfo.setComponentId(detailKey);
        detailParamInfo.setBizModelId(this.getModel().getValue("bizmodel_id"));
        detailParamInfo.setDrilling(false);
        detailParamInfo.setDetailGridInfo(DesignerUtils.wrapperDetailGridInfo((ComponentInfo)componentInfo));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(ENTRYFORM);
        formShowParameter.setHasRight(true);
        formShowParameter.setCustomParam("info", (Object)detailParamInfo);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(DETAIL_PANEL);
        this.getView().showForm(formShowParameter);
    }

    private void notifyDesigner(String designerKey, String action, Object returnData) {
        CustomControl designer = (CustomControl)this.getControl(designerKey);
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("action", action);
        params.put("returnData", returnData);
        designer.setData((Object)params);
    }

    private void notifyDesigner(String designerKey, Map<String, Object> data) {
        CustomControl designer = (CustomControl)this.getControl(designerKey);
        designer.setData(data);
    }

    private void clearDesigner(String designerKey) {
        CustomControl designer = (CustomControl)this.getControl(designerKey);
        designer.setData(null);
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        String key = progressBar.getKey();
        if (StringUtils.equals((CharSequence)PROGRESS_COMPUTE, (CharSequence)key)) {
            String resId = this.getModel().getValue("bizmodel_id").toString();
            Map statusObj = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryLatestStatus", (Object[])new Object[]{resId});
            int progress = (Integer)statusObj.get("progress");
            String cacheProgressStr = this.getPageCache().get("progress");
            if (StringUtils.isNotBlank((CharSequence)cacheProgressStr)) {
                int cacheProgress = Integer.parseInt(cacheProgressStr);
                int newProgress = cacheProgress + 10;
                progress = progress > cacheProgress ? progress : (newProgress >= 100 ? 90 : newProgress);
            }
            Label label = (Label)this.getControl("progress");
            switch (statusObj.get("status").toString()) {
                case "A": {
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u5f00\u59cb\u8fd0\u884c", (String)"VeidooSceneEditPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "B": {
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u8ba1\u7b97\u4e2d(", (String)"VeidooSceneEditPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + progress + "%)");
                    progressEvent.setProgress(progress);
                    break;
                }
                case "C": {
                    progressEvent.setProgress(100);
                    progressBar.stop();
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u8fd0\u884c\u5b8c\u6210", (String)"VeidooSceneEditPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    String snapshotKey = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"start2CreateSnapshot", (Object[])new Object[]{resId, null});
                    this.show(snapshotKey);
                    break;
                }
                case "D": {
                    progressBar.stop();
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u8fd0\u884c\u51fa\u9519", (String)"VeidooSceneEditPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u8ba1\u7b97\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"VeidooSceneEditPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "E": {
                    progressBar.stop();
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u672a\u542f\u52a8", (String)"VeidooSceneEditPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u672a\u542f\u52a8\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"VeidooSceneEditPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "F": {
                    progressBar.stop();
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u672a\u6ce8\u518c", (String)"VeidooSceneEditPlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u672a\u6ce8\u518c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"VeidooSceneEditPlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u72b6\u6001\u672a\u77e5\u9519\u8bef", (String)"VeidooSceneEditPlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u72b6\u6001\u672a\u77e5\u9519\u8bef\uff0c\u8fd0\u7b97\u505c\u6b62", (String)"VeidooSceneEditPlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    progressBar.stop();
                    break;
                }
            }
        } else {
            int timeCount;
            String timedCountStr = this.getPageCache().get(CACHE_TIMED_COUNT);
            int n = timeCount = StringUtils.isBlank((CharSequence)timedCountStr) ? 1 : Integer.parseInt(timedCountStr) + 1;
            if (timeCount == 5) {
                Object bizModelId = this.getModel().getValue("bizmodel_id");
                DynamicObject bizModel = BusinessDataServiceHelper.loadSingle((Object)bizModelId, (String)"phm_bizmodel");
                if (Objects.isNull(bizModel)) {
                    return;
                }
                this.getPageCache().put(CACHE_ISTIMEDREFRESH, "true");
                this.getPageCache().remove(CACHE_TIMED_COUNT);
                this.run(bizModel);
                this.initSeatDesigner();
            } else {
                this.getPageCache().put(CACHE_TIMED_COUNT, String.valueOf(timeCount));
            }
        }
    }

    private boolean isRun() {
        Object runningParam = this.getView().getFormShowParameter().getCustomParam("running");
        return Objects.nonNull(runningParam) && (Boolean)runningParam != false;
    }
}

