/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.tpl;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.mmc.phm.common.CronStruct;
import kd.mmc.phm.common.basemanager.MonthEnum;
import kd.mmc.phm.common.basemanager.ScheduleConsts;
import kd.mmc.phm.common.basemanager.WeekEnum;
import kd.mmc.phm.common.enums.RepeatMode;
import kd.mmc.phm.common.errorcode.PHMErrorCode;
import kd.mmc.phm.common.util.CronTriggerUtils;

public class ScheduleTemplatePlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabSelectEvent -> {
            String key = tabSelectEvent.getTabKey();
            if (StringUtils.equals((CharSequence)"tabdatepage", (CharSequence)key)) {
                this.getModel().setValue("combdorw", (Object)RepeatMode.DAY);
            } else if (StringUtils.equals((CharSequence)"tabweekpage", (CharSequence)key)) {
                this.getModel().setValue("combdorw", (Object)RepeatMode.WEEK);
            }
        });
    }

    public void afterLoadData(EventObject e) {
        this.resetViewBySchedule();
    }

    private void resetViewBySchedule() {
        String repeatMode;
        this.adjustByRepeatMode();
        Object comNo = this.getModel().getValue("comno");
        Object comWeek = this.getModel().getValue("comweek");
        Tab tab = (Tab)this.getControl("tabap");
        String comBdOrw = (String)this.getModel().getValue("combdorw");
        if (StringUtils.equals((CharSequence)comBdOrw, (CharSequence)RepeatMode.WEEK.getValue())) {
            tab.activeTab("tabweekpage");
        }
        if (StringUtils.equals((CharSequence)(repeatMode = (String)this.getModel().getValue("repeatmode")), (CharSequence)RepeatMode.MONTH.getValue())) {
            this.getModel().setValue("comnobyweek", comNo);
            this.getModel().setValue("comweekbyweek", comWeek);
        } else if (StringUtils.equals((CharSequence)repeatMode, (CharSequence)RepeatMode.YEAR.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"comnobymonth", "comweekbymonth"});
            this.getModel().setValue("comnobymonth", comNo);
            this.getModel().setValue("comweekbymonth", comWeek);
        }
        this.adjustByCron();
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("validated_time", (Object)new Date());
        this.resetViewBySchedule();
        this.getModel().setValue("txtdesc", (Object)this.genDesc());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"txtdesc", (CharSequence)name) || StringUtils.equals((CharSequence)"plan", (CharSequence)name)) {
            return;
        }
        if ("cyclenum".equals(name)) {
            String repeatMode = (String)this.getModel().getValue("repeatmode");
            int cyclenum = (Integer)newValue;
            if (cyclenum > 12 && RepeatMode.MONTH.getValue().equals(repeatMode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5468\u671f\u4e3a\u201c\u6708\u201c\u65f6\uff0c\u6267\u884c\u9891\u7387\u4e0d\u80fd\u8d85\u8fc712", (String)"ScheduleTemplatePlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(name, changeData.getOldValue());
            }
        }
        if (name.startsWith("comnoby") || name.startsWith("comweekby")) {
            this.getModel().setValue("comno", this.getModel().getValue(name.replace("comweek", "comno")));
            this.getModel().setValue("comweek", this.getModel().getValue(name.replace("comno", "comweek")));
            String comNo = (String)this.getModel().getValue("comno");
            String comWeek = (String)this.getModel().getValue("comweek");
            if (name.endsWith("bymonth")) {
                this.getModel().setValue("ckbyweek", (Object)(StringUtils.isNotBlank((CharSequence)comNo) && StringUtils.isNotBlank((CharSequence)comWeek) ? 1 : 0));
            }
        }
        if (StringUtils.equals((CharSequence)"repeatmode", (CharSequence)name)) {
            this.adjustByRepeatMode();
        }
        this.adjustByMonth(name);
        this.getModel().setValue("txtdesc", (Object)this.genDesc());
    }

    private void adjustByMonth(String name) {
        boolean isMonth = false;
        for (String propMonth : ScheduleConsts.CKMONTH) {
            if (!StringUtils.equals((CharSequence)propMonth, (CharSequence)name)) continue;
            isMonth = true;
            break;
        }
        if (isMonth) {
            boolean changeMonth = false;
            for (String month : ScheduleConsts.CKMONTH) {
                boolean selected = (Boolean)this.getModel().getValue(month);
                if (!selected) continue;
                changeMonth = true;
                break;
            }
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comnobymonth"});
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comweekbymonth"});
        }
    }

    private CronStruct getCronStruct(Calendar startTime, RepeatMode repeatModeEnum) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        CronStruct cron = new CronStruct();
        if (status.equals((Object)OperationStatus.ADDNEW) || RepeatMode.NONE == repeatModeEnum) {
            cron = CronStruct.init((Calendar)startTime);
        } else {
            String cronExp = (String)this.getModel().getValue("plan");
            if (StringUtils.isNotEmpty((CharSequence)cronExp)) {
                cron = CronStruct.parse((String)cronExp);
            }
        }
        cron.setMinutes(String.valueOf(startTime.get(12)));
        return cron;
    }

    private List<String> computeFireTimes(String cronExp, Date startDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            List dates = CronTriggerUtils.computeFireTimes((String)cronExp, (Date)startDate, (int)5);
            ArrayList result = Lists.newArrayListWithExpectedSize((int)5);
            for (Date date : dates) {
                result.add(dateFormat.format(date));
            }
            return result;
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, PHMErrorCode.bizException, new Object[]{ResManager.loadKDString((String)"\u8bbe\u7f6eCron\u8868\u8fbe\u5f0f\u5931\u8d25: ", (String)"ScheduleTemplatePlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + exception.getMessage()});
        }
    }

    private void adjustByRepeatMode() {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", "flexphour"});
        formView.setEnable(Boolean.TRUE, new String[]{"cyclenum"});
        switch (repeatMode) {
            case "mi": 
            case "d": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexphour"});
                break;
            }
            case "h": {
                formView.setVisible(Boolean.FALSE, new String[]{"flexphour"});
                break;
            }
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek", "flexphour"});
                this.getModel().setValue("cyclenum", (Object)1);
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday", "flexphour"});
                break;
            }
            case "y": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths", "flexphour"});
                this.getModel().setValue("cyclenum", (Object)1);
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
            case "n": {
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
        }
    }

    private void adjustByCron() {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        String cron = (String)this.getModel().getValue("plan");
        if (RepeatMode.NONE.getValue().equals(repeatMode)) {
            Calendar startTime = this.getStartTime();
            CronStruct cronExpr = this.getCronStruct(startTime, RepeatMode.forValue((String)repeatMode));
            cron = cronExpr.toString();
        }
        if (StringUtils.isBlank((CharSequence)cron)) {
            return;
        }
        String[] crons = cron.split(" ");
        if (crons.length < 6) {
            return;
        }
        String hourCron = crons[2];
        String dayCron = crons[3];
        if (StringUtils.isNotBlank((CharSequence)hourCron) && !StringUtils.equalsIgnoreCase((CharSequence)"h", (CharSequence)repeatMode)) {
            Stream.iterate(0, x -> {
                x = x + 1;
                return x;
            }).limit(24L).forEachOrdered(h -> {
                String hour = h < 10 ? "ckhour_0" + h : "ckhour_" + h;
                this.getModel().setValue(hour, (Object)"0");
            });
            if (!StringUtils.equals((CharSequence)"*", (CharSequence)hourCron)) {
                String[] hours = hourCron.split(",");
                Arrays.stream(hours).forEach(x -> {
                    String hour = Integer.parseInt(x) < 10 ? "ckhour_0" + x : "ckhour_" + x;
                    this.getModel().setValue(hour, (Object)"1");
                });
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dayCron) && StringUtils.equals((CharSequence)"L", (CharSequence)dayCron)) {
            this.getModel().setValue("cklastday", (Object)"1");
            ScheduleConsts.CKDATE.forEach(x -> this.getModel().setValue(x, (Object)"0"));
        }
    }

    private String genDesc() {
        int cycleNum = (Integer)this.getModel().getValue("cyclenum");
        if (cycleNum <= 0) {
            return "";
        }
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        RepeatMode repeatModeEnum = RepeatMode.forValue((String)repeatMode);
        Calendar startTime = this.getStartTime();
        CronStruct cron = this.getCronStruct(startTime, repeatModeEnum);
        StringBuilder descBuf = cron.getDescBuf();
        descBuf.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"ScheduleTemplatePlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        String startTimeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(startTime.getTime());
        descBuf.append(startTimeStr).append(ResManager.loadKDString((String)"\u8d77\uff0c", (String)"ScheduleTemplatePlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        switch (repeatModeEnum) {
            case NONE: {
                descBuf.setLength(0);
                descBuf.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"ScheduleTemplatePlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case MINUTE: {
                this.repeatByHour(cron, repeatMode);
                descBuf.append('\u6bcf').append(cycleNum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d\u3002 ", (String)"ScheduleTemplatePlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                if (cycleNum > 1) {
                    cron.setMinutes("0/" + cycleNum);
                } else {
                    cron.setMinutes("*");
                }
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case HOUR: {
                if (cycleNum > 23) {
                    cycleNum = 23;
                    this.getModel().setValue("cyclenum", (Object)23);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u65f6\u91cd\u590d", (String)"ScheduleTemplatePlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                String hours = "0/" + cycleNum;
                cron.setHours(hours);
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                descBuf.append('\u6bcf').append(cycleNum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d\u3002 ", (String)"ScheduleTemplatePlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case DAY: {
                descBuf.append('\u6bcf').append(cycleNum).append('\u5929');
                if (cycleNum > 1) {
                    String day = String.valueOf(startTime.get(5));
                    cron.setDayOfMonth(day + "/" + cycleNum);
                } else {
                    cron.setDayOfMonth("*");
                }
                this.repeatByHour(cron, repeatMode);
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ScheduleTemplatePlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case WEEK: {
                descBuf.append('\u6bcf').append(cycleNum).append('\u5468');
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setYear(null);
                this.repeatByWeek(cron);
                this.repeatByHour(cron, repeatMode);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ScheduleTemplatePlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case MONTH: {
                descBuf.append('\u6bcf').append(cycleNum).append('\u6708');
                if (cycleNum > 1) {
                    String month = String.valueOf(startTime.get(2) + 1);
                    cron.setMonth(month + "/" + cycleNum);
                } else {
                    cron.setMonth("*");
                }
                cron.setYear(null);
                this.repeatByMonthDay(cron);
                this.repeatByHour(cron, repeatMode);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ScheduleTemplatePlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case YEAR: {
                descBuf.append('\u6bcf').append(cycleNum).append('\u5e74');
                cron.setYear(null);
                this.repeatByMonthly(cron);
                this.repeatByHour(cron, repeatMode);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ScheduleTemplatePlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        this.getModel().setValue("plan", (Object)cron.toString());
        if (!StringUtils.equals((CharSequence)"n", (CharSequence)repeatMode)) {
            descBuf.append('\n').append(ResManager.loadKDString((String)"\u9884\u8ba1\u6700\u8fd1\u4e94\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"ScheduleTemplatePlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append('\n');
            List<String> times = this.computeFireTimes(cron.toString(), startTime.getTime());
            for (String time : times) {
                descBuf.append(time).append('\uff0c').append('\n');
            }
            descBuf.delete(descBuf.length() - 2, descBuf.length());
        }
        return descBuf.toString();
    }

    private void repeatByHour(CronStruct cron, String repeatMode) {
        String cronExpStr;
        IDataModel dataModel = this.getView().getModel();
        StringBuilder cronExp = new StringBuilder();
        StringBuilder cronDesc = new StringBuilder();
        Stream.iterate(0, x -> {
            x = x + 1;
            return x;
        }).limit(24L).forEachOrdered(h -> {
            String hour = h < 10 ? "ckhour_0" + h : "ckhour_" + h;
            boolean checked = (Boolean)dataModel.getValue(hour);
            if (checked) {
                cronExp.append(h).append(',');
                cronDesc.append(h).append(ResManager.loadKDString((String)"\u65f6\uff0c", (String)"ScheduleTemplatePlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        });
        if (cronExp.length() > 0) {
            cronExpStr = cronExp.substring(0, cronExp.length() - 1);
        } else {
            String string = cronExpStr = "mi".equals(repeatMode) ? "*" : cron.getHours();
        }
        if (cronDesc.length() > 0) {
            cron.getDescBuf().append(cronDesc.substring(0, cronDesc.length() - 1));
        }
        cron.setHours(cronExpStr);
    }

    private void repeatByMonthly(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"ScheduleTemplatePlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        StringBuilder months = new StringBuilder();
        StringBuilder descBuf = cron.getDescBuf();
        MonthEnum[] values = MonthEnum.values();
        for (int i = 0; i < ScheduleConsts.CKMONTH.size(); ++i) {
            if (!((Boolean)dataModel.getValue((String)ScheduleConsts.CKMONTH.get(i))).booleanValue()) continue;
            descBuf.append(conStr).append(values[i].getName());
            conStr = ",";
            months.append(values[i].getValue()).append(',');
        }
        if (months.length() == 0) {
            months.append(this.getStartTime().get(2) + 1);
        } else {
            String substring = months.substring(0, months.length() - 1);
            months.setLength(0);
            months.append(substring);
        }
        cron.setMonth(months.toString());
        if (((Boolean)dataModel.getValue("ckbyweek")).booleanValue()) {
            this.repeatByNoWeek(cron);
        }
    }

    private void repeatByMonthDay(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String byDayOrWeek = (String)dataModel.getValue("combdorw");
        if (StringUtils.equals((CharSequence)byDayOrWeek, (CharSequence)"d")) {
            this.setCronByMonthDay(cron);
        } else if (StringUtils.equals((CharSequence)byDayOrWeek, (CharSequence)"w")) {
            this.repeatByNoWeek(cron);
        }
    }

    private void setCronByMonthDay(CronStruct cron) {
        StringBuilder days = new StringBuilder();
        int conStr = 30340;
        if (((Boolean)this.getModel().getValue("cklastday")).booleanValue()) {
            cron.getDescBuf().append((char)conStr).append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"ScheduleTemplatePlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            days.append('L').append(',');
        } else {
            for (int i = 0; i < ScheduleConsts.CKDATE.size(); ++i) {
                if (!((Boolean)this.getModel().getValue((String)ScheduleConsts.CKDATE.get(i))).booleanValue()) continue;
                cron.getDescBuf().append((char)conStr).append(i + 1).append('\u65e5');
                conStr = 44;
                days.append(i + 1).append(',');
            }
        }
        if (days.length() == 0) {
            if (StringUtils.isBlank((CharSequence)cron.getDayOfMonth())) {
                days.append(this.getStartTime().get(5));
            } else {
                days.append(cron.getDayOfMonth());
            }
        } else {
            String subString = days.substring(0, days.length() - 1);
            days.setLength(0);
            days.append(subString);
        }
        cron.setDayOfMonth(days.toString());
        if (!StringUtils.equals((CharSequence)"?", (CharSequence)days.toString())) {
            cron.setDayOfWeek("?");
        }
    }

    private void repeatByNoWeek(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String no = (String)dataModel.getValue("comno");
        String noWeek = (String)dataModel.getValue("comweek");
        if (no == null || noWeek == null) {
            return;
        }
        StringBuilder descBuf = cron.getDescBuf();
        this.setDescByNoWeek(no, noWeek, descBuf);
        this.setPlanByNoWeek(cron, no, noWeek);
    }

    private void setPlanByNoWeek(CronStruct cron, String no, String noWeek) {
        boolean inWeek;
        boolean bl = inWeek = no.compareTo("1") >= 0 && no.compareTo("5") <= 0;
        if (noWeek.compareTo("1") >= 0 && noWeek.compareTo("8") < 0) {
            if (inWeek) {
                cron.setDayOfWeek(noWeek + "#" + no);
            } else if (no.equals("L")) {
                cron.setDayOfWeek(noWeek + "L");
            }
            cron.setDayOfMonth("?");
        } else if (StringUtils.equals((CharSequence)noWeek, (CharSequence)"8")) {
            if (inWeek) {
                cron.setDayOfMonth(no);
            } else if (no.equals("L")) {
                cron.setDayOfMonth("1L");
            }
            cron.setDayOfWeek("?");
        } else if (noWeek.equals("9")) {
            if (inWeek) {
                String workday = String.valueOf(Integer.parseInt(no) + 1);
                cron.setDayOfWeek(workday + "#" + no);
            } else if (no.equals("L")) {
                cron.setDayOfWeek("6L");
            }
            cron.setDayOfMonth("?");
        }
    }

    private void setDescByNoWeek(String no, String noWeek, StringBuilder descBuf) {
        switch (no) {
            case "1": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"ScheduleTemplatePlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"ScheduleTemplatePlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"ScheduleTemplatePlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"ScheduleTemplatePlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"ScheduleTemplatePlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "L": {
                descBuf.append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"ScheduleTemplatePlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        switch (noWeek) {
            case "1": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"ScheduleTemplatePlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"ScheduleTemplatePlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"ScheduleTemplatePlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"ScheduleTemplatePlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"ScheduleTemplatePlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "6": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"ScheduleTemplatePlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "7": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"ScheduleTemplatePlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "8": {
                descBuf.append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"ScheduleTemplatePlugin_26", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "9": {
                descBuf.append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"ScheduleTemplatePlugin_27", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void repeatByWeek(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"ScheduleTemplatePlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        StringBuilder descBuf = cron.getDescBuf();
        StringBuilder weekDays = new StringBuilder();
        WeekEnum[] values = WeekEnum.values();
        for (int i = 0; i < ScheduleConsts.CKWEEK.size(); ++i) {
            if (!((Boolean)dataModel.getValue((String)ScheduleConsts.CKWEEK.get(i))).booleanValue()) continue;
            descBuf.append(conStr).append(values[i].getName());
            conStr = ",";
            weekDays.append(values[i].getValue()).append(',');
        }
        if (weekDays.length() == 0) {
            weekDays.append(this.getStartTime().get(7));
        } else {
            String subString = weekDays.substring(0, weekDays.length() - 1);
            weekDays.setLength(0);
            weekDays.append(subString);
        }
        cron.setDayOfMonth("?");
        cron.setDayOfWeek(weekDays.toString());
    }

    private Calendar getStartTime() {
        Date startTime = (Date)this.getModel().getValue("validated_time");
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        } else {
            this.getModel().setValue("validated_time", (Object)crStartTime.getTime());
        }
        return crStartTime;
    }
}

