/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.domian.process.MainDataUpateParam;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.serviece.flow.FlowDefineService;
import kd.mmc.phm.common.util.EntryUtils;
import kd.mmc.phm.common.util.ScheduleUtils;
import kd.mmc.phm.common.util.ShowFormUtils;
import kd.mmc.phm.common.util.basedata.RoleUtils;
import kd.mmc.phm.common.util.process.TaskProgressUtil;
import kd.mmc.phm.mservice.process.ProcessResourceDataTableUpdate;

public class BusinessProcessPlugin
extends AbstractTreeListPlugin
implements HyperLinkClickListener,
AfterSearchClickListener,
AfterBindDataListener {
    private static final String TOOLBAR_HISTORY = "toolbarap1";
    private static final String FILTERCONTAINER_HISTORY = "filtercontainerap1";
    private static final String CACHEKEY_PARENT = "_parent";
    private static final String CACHEKEY_CHILD = "_child";
    private static final String CACHEKEY_FILTER = "filter";
    private static final String OP_START = "start";
    private static final String MILEPOSTSTAR = "milepoststar";
    private static final String OP_FINISH = "finish";
    private static final String OP_UPDATE = "update";
    private static final String OP_ACTIVATION = "activation";
    private static final String OP_UNACTIVATE = "unactivate";
    private static final String OP_PROCESSCOPY = "processcopy";
    private static final String OP_PROCESSDELETE = "processdelete";
    private static final String DATAUPDATE = "dataupdate";
    private static final String[] fields = new String[]{"id", "number", "status", "createtime", "exceptiondesc", "pid", "flow", "startype"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if ("milepost".equals(formShowParameter.getCustomParam("type"))) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u91cc\u7a0b\u7891", (String)"BusinessProcessPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u7a0b", (String)"BusinessProcessPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINER_HISTORY);
        filterContainer.setBillFormId("phm_process_history");
        filterContainer.addAfterBindDataListener((AfterBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"first", "pageup", "pagedown", "last"});
        this.addItemClickListeners(new String[]{TOOLBAR_HISTORY});
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINER_HISTORY);
        filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
    }

    public void click(SearchClickEvent searchClickEvent) {
        FilterContainer filterContainer = (FilterContainer)searchClickEvent.getSource();
        List filters = searchClickEvent.getFilterParameter().getQFilters();
        filters.addAll(searchClickEvent.getFastQFilters());
        this.cacheFilters(filters);
        this.refreshHistory(filters);
    }

    public void afterBindData(AfterBindDataEvent afterBindDataEvent) {
        FilterContainer filterContainer = (FilterContainer)afterBindDataEvent.getSource();
        List filters = filterContainer.getContext().getClientQueryFilterParameter().getQFilters();
        this.cacheFilters(filters);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            if (!fieldEdit.getFieldKey().equals("flow")) continue;
            if (!this.isMilepost()) {
                fieldEdit.setVisible("flow", false);
                continue;
            }
            fieldEdit.setVisible("flow", true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.addCustomQFilter(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        e.addCustomQFilter(new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()));
        QFilter filter = null;
        if (!this.isMilepost()) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            QFilter userFilter = new QFilter("flowleader.fbasedataid", "=", (Object)userId);
            List flowDefineIds = QueryServiceHelper.queryPrimaryKeys((String)"phm_flow_define", (QFilter[])new QFilter("flownodeentryentity.resourcesubentryentity.role.fbasedataid", "in", (Object)RoleUtils.listRoleByUser((long)userId)).toArray(), null, (int)-1);
            QFilter roleFilter = new QFilter("id", "in", (Object)flowDefineIds);
            QFilter qf = new QFilter("milepost.userliable.id", "=", (Object)userId).or(new QFilter("flownodeentryentity.resourcesubentryentity.depersonliable.fbasedataid", "=", (Object)userId)).or(new QFilter("flownodeentryentity.personliable.id", "=", (Object)userId)).or(new QFilter("flownodeentryentity.resourcesubentryentity.superior.fbasedataid", "=", (Object)userId));
            List taskDepersonliableSup = QueryServiceHelper.queryPrimaryKeys((String)"phm_flow_define", (QFilter[])new QFilter[]{qf}, null, (int)-1);
            QFilter taskDepersonliableSupFilter = new QFilter("id", "in", (Object)taskDepersonliableSup);
            QFilter waringuser = new QFilter("waringuser.fbasedataid", "=", (Object)userId).and("task_status", "=", (Object)"5");
            QFilter overduecyuser = new QFilter("overduecyuser.fbasedataid", "=", (Object)userId).and("task_status", "=", (Object)"3");
            QFilter seriousoverdueuser = new QFilter("seriousoverdueuser.fbasedataid", "=", (Object)userId).and("task_status", "=", (Object)"4");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"phm_process_task", (String)"task_processhistory.process", (QFilter[])new QFilter[]{waringuser.or(overduecyuser).or(seriousoverdueuser)});
            ArrayList<Long> flowIdList = new ArrayList<Long>();
            for (DynamicObject dynamicObject : query) {
                flowIdList.add(dynamicObject.getLong("task_processhistory.process"));
            }
            QFilter qFilter_abnormal = new QFilter("id", "in", flowIdList);
            filter = userFilter.or(roleFilter).or(taskDepersonliableSupFilter).or(qFilter_abnormal);
        }
        e.addCustomQFilter(filter);
    }

    public void afterBindData(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setMulti(false);
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo != null) {
            billList.selectRows(currentSelectedRowInfo.getRowKey());
        } else {
            billList.selectRows(0);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (OP_FINISH.equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6d41\u7a0b\u624b\u5de5\u7ec8\u6b62\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u7ed3\u675f\u8be5\u6d41\u7a0b\u5417\uff1f", (String)"BusinessProcessPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OP_FINISH, (IFormPlugin)this));
        } else if ("manualupdate".equals(itemKey)) {
            this.manualUpdateProcess();
        } else if (OP_PROCESSCOPY.equals(itemKey)) {
            this.copyProcess();
        } else if (OP_PROCESSDELETE.equals(itemKey)) {
            this.deleteProcess();
        } else if (DATAUPDATE.equals(itemKey)) {
            this.updatePorcessData();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("pagedown".equals(key)) {
            int currentPage = (Integer)this.getModel().getValue("currentpage");
            this.getModel().setValue("currentpage", (Object)(currentPage + 1));
        } else if ("pageup".equals(key)) {
            int currentPage = (Integer)this.getModel().getValue("currentpage");
            this.getModel().setValue("currentpage", (Object)(currentPage - 1));
        } else if ("first".equals(key)) {
            this.getModel().setValue("currentpage", (Object)1);
        } else if ("last".equals(key)) {
            String totalPageStr = this.getPageCache().get("totalpage");
            this.getModel().setValue("currentpage", (Object)Integer.parseInt(totalPageStr));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String totalPageStr = this.getPageCache().get("totalpage");
        if (totalPageStr == null) {
            return;
        }
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)(this.getView().getPageId() + CACHEKEY_PARENT));
        String name = e.getProperty().getName();
        int currentPage = (Integer)this.getModel().getValue("currentpage");
        if ("currentpage".equals(name)) {
            int totalPage;
            if (!StringUtils.isEmpty((CharSequence)totalPageStr) && currentPage > (totalPage = Integer.parseInt(totalPageStr))) {
                this.getModel().setValue("currentpage", (Object)totalPage);
                return;
            }
        } else {
            int targetPage = 1;
            this.getModel().setValue("currentpage", (Object)targetPage);
            if (currentPage != targetPage) {
                return;
            }
        }
        this.getModel().deleteEntryData("treeentryentity");
        this.createNewEntryData(cacheDataSet, Algo.getCacheDataSet((String)(this.getView().getPageId() + CACHEKEY_CHILD)), currentPage);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (OP_ACTIVATION.equals(operateKey) || OP_UNACTIVATE.equals(operateKey)) {
            formOperate.getOption().setVariableValue("validateProcessOwner", "true");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if (OP_START.equals(operateKey)) {
            this.refreshHistory();
        } else if (MILEPOSTSTAR.equals(operateKey)) {
            this.refreshMeilpostHistory(this.getFilters());
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        BillList billList = (BillList)evt.getSource();
        if (currentListSelectedRow == null) {
            this.clearHistory();
        } else {
            String entityId = billList.getEntityId();
            if ("phm_showmilepost".equals(entityId)) {
                this.refreshMeilpostHistory(this.getFilters());
            } else {
                this.refreshHistory();
            }
        }
    }

    private void refreshMeilpostHistory(List<QFilter> filters) {
        long historyId = this.clearHistory();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        filters.add(new QFilter("milepost", "=", selectedRow.getPrimaryKeyValue()));
        filters.add(new QFilter("startype", "=", (Object)"2"));
        this.isClickStar(filters);
        this.queryAndRefresh(historyId, filters);
    }

    private void isClickStar(List<QFilter> filters) {
        filters.add(new QFilter("status", "!=", (Object)"completed"));
        boolean exists = QueryServiceHelper.exists((String)"phm_process_history", (QFilter[])filters.toArray(new QFilter[0]));
        if (exists) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{MILEPOSTSTAR});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{MILEPOSTSTAR});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treeentryentity", evt.getRowIndex());
        Object historyId = entryRowEntity.getPkValue();
        if ("number".equals(fieldName)) {
            this.showProcessMonitorForm(historyId);
        } else {
            this.showCalcLogForm(historyId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("refreshHistory".equals(actionId)) {
            this.refreshHistory();
        } else if (DATAUPDATE.equals(actionId)) {
            this.dataTableUpdate(event);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent args) {
        super.confirmCallBack(args);
        if (OP_FINISH.equals(args.getCallBackId()) && args.getResult() == MessageBoxResult.Yes) {
            this.finishProcessByHand();
        }
    }

    private boolean isMilepost() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return "milepost".equals(formShowParameter.getCustomParam("type"));
    }

    private void cacheFilters(List<QFilter> filters) {
        List filterStrs = filters.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
        this.getPageCache().put(CACHEKEY_FILTER, SerializationUtils.toJsonString(filterStrs));
    }

    private List<QFilter> getFilters() {
        String filterStr = this.getPageCache().get(CACHEKEY_FILTER);
        if (StringUtils.isEmpty((CharSequence)filterStr)) {
            return new ArrayList<QFilter>();
        }
        List filterStrs = (List)SerializationUtils.fromJsonString((String)filterStr, List.class);
        return filterStrs.stream().map(QFilter::fromSerializedString).collect(Collectors.toList());
    }

    private void showCalcLogForm(Object historyId) {
        BillList processList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRow = processList.getCurrentSelectedRowInfo();
        Long processId = (Long)currentSelectedRow.getPrimaryKeyValue();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        QFilter[] filters = new QFilter[]{new QFilter("history", "=", historyId)};
        List logIds = QueryServiceHelper.queryPrimaryKeys((String)"phm_process_calclog", (QFilter[])filters, null, (int)1);
        if (CollectionUtils.isEmpty((Collection)logIds)) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        boolean isLeader = FlowDefineService.isFlowDefineLeader((Long)userId, (Long)processId);
        if (!isLeader) {
            List roleIds = RoleUtils.listRoleByUser((long)userId);
            showParameter.getListFilterParameter().setFilter(new QFilter("roles.fbasedataid", "in", (Object)roleIds));
        }
        showParameter.setBillFormId("phm_process_calclog");
        showParameter.getListFilterParameter().setFilter(new QFilter("history", "=", historyId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setHasRight(true);
        showParameter.setLookUp(false);
        showParameter.setFormId("bos_listf7");
        showParameter.setShowTitle(true);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setMultiSelect(false);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showProcessMonitorForm(Object historyId) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refreshHistory");
        BillShowParameter formShowParameter = ShowFormUtils.assembleShowBillParam((String)"phm_process_history", (Object)historyId, null, (CloseCallBack)closeCallBack, (ShowType)ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u7a0b\u76d1\u63a7", (String)"BusinessProcessPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        String rootPageId = TaskProgressUtil.getRootPageId((IFormView)this.getView(), null);
        formShowParameter.setPageId(rootPageId + historyId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private long clearHistory() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        long historyId = 0L;
        if (selectRows.length > 0) {
            historyId = this.getModel().getEntryRowEntity("treeentryentity", selectRows[0]).getLong("id");
        }
        this.getModel().deleteEntryData("treeentryentity");
        String cacheIdPrefix = this.getView().getPageId();
        Algo.removeCacheDataSet((String)(cacheIdPrefix + CACHEKEY_PARENT));
        Algo.removeCacheDataSet((String)(cacheIdPrefix + CACHEKEY_CHILD));
        this.getView().setVisible(Boolean.FALSE, new String[]{"panel_totalcount"});
        this.getModel().beginInit();
        this.getModel().setValue("currentpage", (Object)"1");
        this.getModel().endInit();
        this.getView().updateView("currentpage");
        this.setLableText("totalpage", "1");
        this.getView().setEnable(Boolean.FALSE, new String[]{"first", "last", "pageup", "pagedown"});
        this.getPageCache().remove("totalpage");
        return historyId;
    }

    private void refreshHistory() {
        if (this.isMilepost()) {
            this.refreshMeilpostHistory(this.getFilters());
        } else {
            this.refreshHistory(this.getFilters());
        }
    }

    private void refreshHistory(List<QFilter> filters) {
        long historyId = this.clearHistory();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        filters.add(new QFilter("flowdefine", "=", selectedRow.getPrimaryKeyValue()));
        this.queryAndRefresh(historyId, filters);
    }

    private void queryAndRefresh(long historyId, List<QFilter> filters) {
        String orderBy = "createtime desc";
        String selectFields = "id, number, status, createtime, exceptiondesc, parentid , isdelete,flowdefine.id,startype";
        try (DataSet dataSet = ORM.create().queryDataSet("BusinessProcessPlugin.getHistoryData", "phm_process_history", selectFields, filters.toArray(new QFilter[0]), orderBy);){
            CachedDataSet cachedChildDataSet;
            if (!dataSet.hasNext()) {
                return;
            }
            String cacheIdPrefix = this.getView().getPageId();
            try (DataSet copy = dataSet.copy();){
                DataSet childDataSet = copy.filter("parentid != 0 and isdelete != \"delete\"");
                CacheHint cacheHint = new CacheHint();
                cacheHint.setCacheId(cacheIdPrefix + CACHEKEY_CHILD);
                cacheHint.setTimeout(1L, TimeUnit.HOURS);
                cachedChildDataSet = childDataSet.cache(cacheHint);
            }
            DataSet parentDataSet = dataSet.filter("parentid == 0");
            CacheHint cacheHint = new CacheHint();
            cacheHint.setCacheId(cacheIdPrefix + CACHEKEY_PARENT);
            cacheHint.setTimeout(1L, TimeUnit.HOURS);
            CachedDataSet cachedParentDataSet = parentDataSet.cache(cacheHint);
            this.createNewEntryData(cachedParentDataSet, cachedChildDataSet, 1);
            EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                if (dynamicObject.getLong("id") != historyId) continue;
                entryGrid.selectRows(i);
                break;
            }
        }
    }

    private void createNewEntryData(CachedDataSet cachedParentDataSet, CachedDataSet cachedChildDataSet, int currentPage) {
        boolean onlyChild;
        int rowCount = cachedParentDataSet.getRowCount();
        boolean bl = onlyChild = rowCount == 0;
        if (onlyChild) {
            rowCount = cachedChildDataSet.getRowCount();
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"panel_totalcount"});
        this.setLableText("totalcount", String.valueOf(rowCount));
        String pageCountStr = (String)this.getModel().getValue("pagecount");
        int pageCount = Integer.parseInt(pageCountStr);
        int totalPage = (rowCount + pageCount - 1) / pageCount;
        String totalPageStr = String.valueOf(totalPage);
        this.getPageCache().put("totalpage", totalPageStr);
        this.setLableText("totalpage", totalPageStr);
        this.getView().setEnable(Boolean.valueOf(currentPage != totalPage), new String[]{"pagedown", "last"});
        this.getView().setEnable(Boolean.valueOf(currentPage != 1), new String[]{"pageup", "first"});
        List<List<Object>> values = onlyChild ? this.wrapperEntryData(cachedChildDataSet, currentPage, pageCount) : this.wrapperEntryData(cachedParentDataSet, cachedChildDataSet, currentPage, pageCount);
        EntryUtils.batchCreateEntryRow((IFormView)this.getView(), (String)"treeentryentity", (String[])fields, values);
        EntryUtils.setCellStyle((IFormView)this.getView(), (String)"treeentryentity", dynamicObject -> {
            String status = dynamicObject.getString("status");
            String foreColor = RunningState.getForeColor((String)status);
            if (foreColor == null) {
                return null;
            }
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey("status");
            cellStyle.setForeColor(foreColor);
            return cellStyle;
        });
    }

    private List<List<Object>> wrapperEntryData(CachedDataSet cachedChildDataSet, int currentPage, int pageCount) {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)pageCount);
        int startIndex = (currentPage - 1) * pageCount;
        List cachedData = cachedChildDataSet.getList(startIndex, pageCount);
        for (Row row : cachedData) {
            ArrayList value = Lists.newArrayListWithExpectedSize((int)7);
            value.add(row.get(0));
            value.add(row.get(1));
            value.add(row.get(2));
            value.add(row.get(3));
            value.add(row.get(4));
            value.add(row.get(5));
            value.add(row.get(7));
            value.add(row.get(8));
            values.add(value);
        }
        return values;
    }

    private List<List<Object>> wrapperEntryData(CachedDataSet cachedParentDataSet, CachedDataSet cachedChildDataSet, int currentPage, int pageCount) {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)pageCount);
        int startIndex = (currentPage - 1) * pageCount;
        List cachedParentData = cachedParentDataSet.getList(startIndex, pageCount);
        HashSet ids = Sets.newHashSetWithExpectedSize((int)pageCount);
        for (Row row2 : cachedParentData) {
            ArrayList value = Lists.newArrayListWithExpectedSize((int)7);
            Long id = row2.getLong(0);
            ids.add(id);
            value.add(id);
            value.add(row2.get(1));
            value.add(row2.get(2));
            value.add(row2.get(3));
            value.add(row2.get(4));
            value.add(row2.get(5));
            value.add(row2.get(7));
            value.add(row2.get(8));
            values.add(value);
        }
        List cachedChildData = cachedChildDataSet.getList(0, cachedChildDataSet.getRowCount());
        List filteredChildData = cachedChildData.stream().filter(row -> ids.contains(row.getLong("parentid"))).collect(Collectors.toList());
        for (Row row3 : filteredChildData) {
            ArrayList value = Lists.newArrayListWithExpectedSize((int)7);
            value.add(row3.get(0));
            value.add(row3.get(1));
            value.add(row3.get(2));
            value.add(row3.get(3));
            value.add(row3.get(4));
            value.add(row3.get(5));
            value.add(row3.get(7));
            value.add(row3.get(8));
            values.add(value);
        }
        return values;
    }

    private void setLableText(String key, String text) {
        Label label = (Label)this.getControl(key);
        label.setText(text);
    }

    private void finishProcessByHand() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessProcessPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object historyId = this.getModel().getEntryRowEntity("treeentryentity", selectRows[0]).getPkValue();
        this.deleteScdele(historyId);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)OP_FINISH, (String)"phm_process_history", (Object[])new Object[]{historyId}, (OperateOption)OperateOption.create());
        operationResult.setMessage(ResManager.loadKDString((String)"\u624b\u5de5\u7ec8\u6b62\u6210\u529f\u3002", (String)"BusinessProcessPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.getView().showOperationResult(operationResult, ResManager.loadKDString((String)"\u624b\u5de5\u7ec8\u6b62", (String)"BusinessProcessPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.refreshHistory();
    }

    private void deleteScdele(Object historyId) {
        String number;
        DynamicObject query = QueryServiceHelper.queryOne((String)"phm_process_history", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", historyId)});
        if (query != null && (number = query.getString("number")) != null && !number.isEmpty()) {
            ScheduleUtils.deleteSuheduPlanByprocesshistoryNumber((String)number);
            ScheduleUtils.deleteEigenvaluePollingScheduleByFlowHistoryNumber((String)number);
        }
    }

    private void manualUpdateProcess() {
        Object historyId = this.getSelectHistroyId();
        if (historyId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessProcessPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"manualupdate", (String)"phm_process_history", (Object[])new Object[]{historyId}, (OperateOption)OperateOption.create());
        operationResult.setMessage(ResManager.loadKDString((String)"\u624b\u5de5\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7b49\u5f85\u66f4\u65b0\u7ed3\u679c\u3002", (String)"BusinessProcessPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.getView().showOperationResult(operationResult, ResManager.loadKDString((String)"\u624b\u5de5\u66f4\u65b0", (String)"BusinessProcessPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.refreshHistory();
    }

    private Object getSelectHistroyId() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return null;
        }
        Object historyId = this.getModel().getEntryRowEntity("treeentryentity", selectRows[0]).getPkValue();
        return historyId;
    }

    private void copyProcess() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessProcessPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treeentryentity", selectRows[0]);
        long historyId = entryRowEntity.getLong("id");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)OP_PROCESSCOPY, (String)"phm_process_history", (Object[])new Object[]{historyId}, (OperateOption)OperateOption.create());
        operationResult.setMessage(ResManager.loadKDString((String)"\u6d41\u7a0b\u7248\u672c\u62f7\u8d1d\u6210\u529f\u3002", (String)"BusinessProcessPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.getView().showOperationResult(operationResult, ResManager.loadKDString((String)"\u6d41\u7a0b\u7248\u672c\u62f7\u8d1d", (String)"BusinessProcessPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.refreshHistory(this.getFilters());
        int rowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        entryGrid.expand(rowIndex);
    }

    private void deleteProcess() {
        Object historyId = this.getSelectHistroyId();
        if (historyId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessProcessPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)OP_PROCESSDELETE, (String)"phm_process_history", (Object[])new Object[]{historyId}, (OperateOption)OperateOption.create());
        operationResult.setMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BusinessProcessPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.getView().showOperationResult(operationResult, ResManager.loadKDString((String)"\u5220\u9664", (String)"BusinessProcessPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.refreshHistory();
    }

    private void updatePorcessData() {
        Object historyId = this.getSelectHistroyId();
        if (historyId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessProcessPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)DATAUPDATE, (String)"phm_process_history", (Object[])new Object[]{historyId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setMultiSelect(true);
            showParameter.setBillFormId("phm_process_updatediff");
            showParameter.setFormId("bos_listf7");
            OpenStyle openStyle = showParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            openStyle.setInlineStyleCss(css);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getListFilterParameter().setFilter(new QFilter("processhistory", "=", historyId));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATAUPDATE));
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void dataTableUpdate(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        if (returnData == null) {
            return;
        }
        Object historyId = this.getSelectHistroyId();
        if (historyId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessProcessPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Object> diffIds = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        List<Object> upateParams = this.getMainUpdateParam(diffIds);
        if (CollectionUtils.isEmpty(upateParams)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u66f4\u65b0\u7684\u5b57\u6bb5\u3002", (String)"BusinessProcessPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (upateParams != null) {
            upateParams = upateParams.stream().filter(item -> !item.getLatest()).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(upateParams)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u66f4\u65b0\u7684\u5b57\u6bb5\u3002", (String)"BusinessProcessPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        ProcessResourceDataTableUpdate.updateResourceTableData((Long)((Long)historyId), upateParams, (boolean)false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7b49\u5f85\u66f4\u65b0\u7ed3\u679c\u3002", (String)"BusinessProcessPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    private List<MainDataUpateParam> getMainUpdateParam(List<Object> diffIds) {
        QFilter qFilter = new QFilter("id", "in", diffIds);
        DynamicObject[] updateDiffs = BusinessDataServiceHelper.load((String)"phm_process_updatediff", (String)"id,datatable,resourcetype,resource,tablefield,fieldtype,latest", (QFilter[])qFilter.toArray());
        if (updateDiffs == null || updateDiffs.length == 0) {
            return null;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)updateDiffs.length);
        Arrays.stream(updateDiffs).forEach(item -> {
            MainDataUpateParam param = new MainDataUpateParam();
            param.setId(Long.valueOf(item.getLong("id")));
            param.setDataTable(item.getString("datatable.number"));
            param.setResourceType(item.getString("resourcetype"));
            param.setField(item.getString("tablefield"));
            param.setResourceId(Long.valueOf(item.getLong("resource_id")));
            param.setType(item.getString("fieldtype"));
            param.setLatest("1".equals(item.getString("latest")));
            params.add(param);
        });
        return params;
    }
}

