/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.util.FlowUtils;

public class BusinessProcessSelectPlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\u9009\u62e9", (String)"BusinessProcessSelectPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        CustomControl customControl = (CustomControl)this.getControl("process");
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("action", "init");
        params.put("isRunning", Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            params.put("data", data);
        }
        customControl.setData((Object)params);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl("btn_ok");
        button.addClickListener((ClickListener)this);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if ("clickProcessNode".equals(eventName)) {
            Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            String selectedNodeId = (String)nodeInfo.get("id");
            String selectedNodeName = (String)nodeInfo.get("name");
            this.getPageCache().put("selectNodeId", selectedNodeId);
            this.getPageCache().put("selectedNodeName", selectedNodeName);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btn_ok".equals(control.getKey())) {
            String selectNodeId = this.getPageCache().get("selectNodeId");
            if (StringUtils.isBlank((CharSequence)selectNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u8282\u70b9\u3002", (String)"BusinessProcessSelectPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
            String currentNodeId = (String)this.getView().getFormShowParameter().getCustomParam("currentNodeId");
            Map parentRelations = FlowUtils.getParentRelations((String)data);
            boolean isBefore = this.selectNodeIsBefore(parentRelations, selectNodeId, currentNodeId);
            if (!isBefore) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8d77\u4e8b\u4ef6\u8282\u70b9\u524d\u7684\u8282\u70b9\u3002", (String)"BusinessProcessSelectPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long processId = (Long)this.getView().getFormShowParameter().getCustomParam("process");
            boolean hasManualResource = this.hasManualResource(processId, selectNodeId);
            if (!hasManualResource) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8282\u70b9\u8d44\u6e90\"\u5904\u7406\u65b9\u5f0f\"\u5305\u542b\"\u624b\u5de5\"\u7684\u8282\u70b9\u3002", (String)"BusinessProcessSelectPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> returnMap = new HashMap<String, String>(2);
            returnMap.put("selectNodeId", selectNodeId);
            returnMap.put("selectedNodeName", this.getPageCache().get("selectedNodeName"));
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private boolean hasManualResource(Long processId, String selectNodeId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t1.fresourceid from t_phm_flowresource t1 , t_phm_flownode t2 ", new Object[0]);
        sqlBuilder.append("where t1.fresourcetype = ? ", new Object[]{"phm_billtemp"});
        sqlBuilder.append("and t1.fentryid = t2.fentryid and t2.fnodeid = ? and t2.fid = ? ", new Object[]{selectNodeId, processId});
        sqlBuilder.append("and t1.fdealtype = ?", new Object[]{DealTypeEnum.MANUAL.getName()});
        try (DataSet dataSet = DB.queryDataSet((String)"queryNodeRoesource", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            if (dataSet.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean selectNodeIsBefore(Map<String, List<String>> parentRelations, String selectNodeId, String currentNodeId) {
        List<String> preNodeIds = parentRelations.get(currentNodeId);
        if (!CollectionUtils.isEmpty(preNodeIds)) {
            if (preNodeIds.contains(selectNodeId)) {
                return true;
            }
            for (String preNodeId : preNodeIds) {
                boolean isBefore = this.selectNodeIsBefore(parentRelations, selectNodeId, preNodeId);
                if (!isBefore) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

