/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.errorcode.PHMErrorCode;
import kd.mmc.phm.common.info.EventDealProperty;
import kd.mmc.phm.common.serviece.workbench.ProcessResourceService;
import kd.mmc.phm.common.util.basedata.RoleUtils;

public class EventDealPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String ALGO_KEY = "EventDealPlugin.";
    private static final String TREE_VIEW = "treeviewap";
    private static final String ENTITY_PROP = "phm_eventdeal_prop";
    private static final String CACHEKEY_NODEID = "nodeId";
    private static final String CACHEKEY_PROPERTIES = "eventDealProperties";
    private static final String RESOURCE_SELECT_CLOSE = "resource_select_close";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTreeView();
    }

    private void initTreeView() {
        String selectFields = "number, name, parent.number parentNumber, bizobjecttype, filterfield, filtervalue";
        String orderBy = "priority asc";
        QFilter[] filters = new QFilter[]{new QFilter("isshow", "=", (Object)Character.valueOf('1'))};
        try (DataSet dataSet = ORM.create().queryDataSet("EventDealPlugin.getEventDealProp", ENTITY_PROP, selectFields, filters, orderBy);){
            if (!dataSet.hasNext()) {
                return;
            }
            TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EventDealPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            rootNode.setIsOpened(true);
            HashMap<String, TreeNode> id2TreeNode = new HashMap<String, TreeNode>(16);
            HashMap<String, EventDealProperty> workbenchProperties = new HashMap<String, EventDealProperty>(16);
            for (Row row : dataSet) {
                TreeNode treeNode;
                String number = row.getString("number");
                String name = row.getString("name");
                String parentNodeId = row.getString("parentNumber");
                if (StringUtils.isBlank((CharSequence)parentNodeId)) {
                    treeNode = new TreeNode(rootNode.getId(), number, name);
                    id2TreeNode.put(number, treeNode);
                } else {
                    TreeNode parentNode = id2TreeNode.getOrDefault(parentNodeId, rootNode);
                    treeNode = new TreeNode(parentNodeId, number, name);
                    parentNode.addChild(treeNode);
                }
                treeNode.setIsOpened(true);
                EventDealProperty eventDealProperty = new EventDealProperty();
                eventDealProperty.setBizobjecttype(row.getString("bizobjecttype"));
                eventDealProperty.setFilterfield(row.getString("filterfield"));
                eventDealProperty.setFiltervalue(row.getString("filtervalue"));
                workbenchProperties.put(number, eventDealProperty);
            }
            this.getPageCache().put(CACHEKEY_PROPERTIES, SerializationUtils.toJsonString(workbenchProperties));
            rootNode.setChildren((List)Lists.newArrayList(id2TreeNode.values()));
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
            treeView.addNode(rootNode);
            TreeNode defaultNode = rootNode.getTreeNode("001", 15);
            if (defaultNode != null) {
                treeView.focusNode(defaultNode);
                treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
                treeView.treeNodeClick(defaultNode.getParentid(), defaultNode.getId());
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String cacheNodeId;
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.equals((CharSequence)nodeId, (CharSequence)(cacheNodeId = this.getPageCache().get(CACHEKEY_NODEID)))) {
            return;
        }
        this.getPageCache().put(CACHEKEY_NODEID, nodeId);
        if ("0".equals(nodeId)) {
            return;
        }
        this.filterDataAndRefresh(nodeId);
    }

    private void filterDataAndRefresh(String nodeId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map<String, EventDealProperty> eventDealProperties = this.getEventDealProperties();
        EventDealProperty eventDealProperty = eventDealProperties.get(nodeId);
        if (eventDealProperty == null) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        FilterParameter filterParameter = new FilterParameter();
        String resourceType = eventDealProperty.getBizobjecttype();
        filterParameter.getQFilters().add(new QFilter("resource_type", "=", (Object)resourceType));
        Long processNodeId = (Long)formShowParameter.getCustomParam("entry_node");
        filterParameter.getQFilters().add(new QFilter("entry_node", "=", (Object)processNodeId));
        long userID = Long.parseLong(RequestContext.get().getUserId());
        List<Long> resourceIds = null;
        Boolean flowDefineLeader = (Boolean)formShowParameter.getCustomParam("processLeader");
        if (flowDefineLeader != null && flowDefineLeader.booleanValue()) {
            resourceIds = ProcessResourceService.getNodeResources((String)resourceType, (Long)processNodeId);
        }
        if ("phm_billtemp".equals(eventDealProperty.getBizobjecttype())) {
            if (resourceIds != null && !resourceIds.isEmpty()) {
                resourceIds = ProcessResourceService.getDataTempIds((String)eventDealProperty.getFiltervalue(), (List)resourceIds);
            } else {
                List currentUserRoles = RoleUtils.listRoleByUser((long)userID);
                filterParameter.getQFilters().add(new QFilter("resource_role", "in", (Object)currentUserRoles));
                filterParameter.getQFilters().add(new QFilter("resource_org", "=", (Object)RequestContext.get().getOrgId()));
                resourceIds = this.getCurrentUserTemps(eventDealProperty, currentUserRoles);
            }
        }
        filterParameter.getQFilters().add(new QFilter("resource_number", "in", (Object)resourceIds));
        filterParameter.getQFilters().add(new QFilter("resource_dealtype", "=", (Object)DealTypeEnum.MANUAL.getName()));
        billList.setQueryFilterParameter(filterParameter);
        billList.refresh();
    }

    private Map<String, EventDealProperty> getEventDealProperties() {
        String cacheStr = this.getPageCache().get(CACHEKEY_PROPERTIES);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return Collections.emptyMap();
        }
        TypeReference<HashMap<String, EventDealProperty>> typeReference = new TypeReference<HashMap<String, EventDealProperty>>(){};
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (Map)objectMapper.readValue(cacheStr, (TypeReference)typeReference);
        }
        catch (JsonProcessingException e) {
            throw new KDBizException((Throwable)e, PHMErrorCode.serializationFailed, new Object[]{e.getMessage()});
        }
    }

    private List<Long> getCurrentUserTemps(EventDealProperty eventDealProperty, List<Long> currentUserRoles) {
        if (CollectionUtils.isEmpty(currentUserRoles)) {
            return new ArrayList<Long>(1);
        }
        QFilter qFilter = new QFilter("id", "in", currentUserRoles);
        String filterfield = eventDealProperty.getFilterfield();
        String filtervalue = eventDealProperty.getFiltervalue();
        if (StringUtils.isNotBlank((CharSequence)filterfield) && StringUtils.isNotBlank((CharSequence)filtervalue)) {
            qFilter.and(new QFilter("entryentity2.".concat(filterfield), "=", (Object)filtervalue));
        }
        ArrayList<Long> tempIdList = new ArrayList<Long>(16);
        try (DataSet result = ORM.create().queryDataSet("EventDealPlugin.getCurrentUserTemps", "phm_role", "entryentity2.resources_id", qFilter.toArray());){
            for (Row row : result) {
                Long tempId = row.getLong(0);
                if (tempId == null) continue;
                tempIdList.add(tempId);
            }
        }
        return tempIdList;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("affirm".equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selects = billList.getSelectedRows();
            if (selects.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u6e90\u3002", (String)"EventDealPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow listSelectedRow = selects.get(0);
            Long primaryKey = (Long)listSelectedRow.getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)"phm_process_resources");
            String resourceType = dynamicObject.getString("resource_type");
            if ("phm_billtemp".equals(resourceType)) {
                HashMap customParams = Maps.newHashMapWithExpectedSize((int)12);
                customParams.put("isLock", Boolean.FALSE);
                customParams.put("resource", dynamicObject.getLong("resource_number_id"));
                DynamicObject processHistory = dynamicObject.getDynamicObject("resource_processhistory");
                DynamicObject entryNode = dynamicObject.getDynamicObject("entry_node");
                customParams.put("processHistoryId", processHistory.getLong("id"));
                customParams.put("process", processHistory.getLong("process_id"));
                customParams.put("nodeEntryId", entryNode.getLong("id"));
                customParams.put("resourceDataId", dynamicObject.getLong("resource_data_id"));
                customParams.put("processResourceId", dynamicObject.getLong("id"));
                customParams.put("versionNumber", dynamicObject.getString("resource_data.number"));
                customParams.put("role", Lists.newArrayList((Object[])new Object[]{dynamicObject.get("resource_role_id")}));
                customParams.put("nodeOrgStatus", this.getView().getFormShowParameter().getCustomParam("nodeOrgStatus"));
                customParams.put("sourceType", "task");
                this.getView().returnDataToParent((Object)customParams);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u3002", (String)"EventDealPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        } else if ("addnew".equals(itemKey)) {
            FormShowParameter parentFormShowParameter = this.getView().getFormShowParameter();
            Map customParams = parentFormShowParameter.getCustomParams();
            FormShowParameter formShowParameter = new FormShowParameter();
            List resourceId = ProcessResourceService.getNodeResources(null, (Long)((Long)parentFormShowParameter.getCustomParam("entry_node")));
            customParams.put("resourceId", resourceId);
            formShowParameter.setFormId("phm_resourceselect");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParams(customParams);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RESOURCE_SELECT_CLOSE));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && RESOURCE_SELECT_CLOSE.equals(actionId)) {
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

