/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.NodeStatusChangeEnum;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;
import org.apache.commons.lang3.StringUtils;

public class LaunchEventPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ALGO_KEY = "LaunchEventPlugin.";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit activityEdit = (BasedataEdit)this.getView().getControl("subprocess");
        activityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"returnnode"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String nodeStatus = (String)customParams.get("nodestatus");
        Long startNodeId = Long.parseLong(customParams.get("event_startnodeid").toString());
        Object processId = customParams.get("event_processid");
        String nodeOrginStatus = ProcessQueryUtil.getNodeOrginStatus((Long)startNodeId);
        if (StringUtils.isNotBlank((CharSequence)nodeOrginStatus)) {
            nodeStatus = nodeOrginStatus;
        }
        this.getModel().setItemValueByID(this.getModel().getProperty("event_startnodeid"), this.getModel().getDataEntity(), (Object)startNodeId, false);
        this.getModel().setValue("nodestatus", (Object)nodeStatus);
        this.getModel().setItemValueByID("event_processid", processId);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String statusChange = (String)this.getModel().getValue("statuschange");
        ArrayList<Long> subProcessIds = new ArrayList<Long>(8);
        ArrayList<Object> nodeIds = new ArrayList<Object>(8);
        if (NodeStatusChangeEnum.RETURN_BEFROE.getValue().equals(statusChange)) {
            DynamicObject returenNode = (DynamicObject)this.getModel().getValue("entry_node");
            String returenNodeId = returenNode.getString("nodeid");
            nodeIds.add(returenNodeId);
        } else {
            Long processHistoryId = (Long)this.getModel().getValue("event_processid_id");
            QFilter nodeQFilter = new QFilter("id", "=", (Object)processHistoryId);
            try (DataSet dataSet = ORM.create().queryDataSet("LaunchEventPlugin.queryNode", "phm_process_history", "entryentity.nodeid", nodeQFilter.toArray());){
                for (Row row : dataSet) {
                    String nodeId = row.getString(0);
                    if (!StringUtils.isNotBlank((CharSequence)nodeId)) continue;
                    nodeIds.add(nodeId);
                }
            }
        }
        this.querySubProcessIdByNodeId(subProcessIds, nodeIds);
        QFilter qFilter = new QFilter("id", "in", subProcessIds);
        qFilter.and("flowstatus", "=", (Object)"1");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void querySubProcessIdByNodeId(ArrayList<Long> subProcessIds, List<Object> nodeIds) {
        String sql = "select t1.fflowdefineid from t_phm_subflow t1 , t_phm_flownode t2 where  t1.fentryid =t2.fentryid and ";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(sql, new Object[0]);
        sqlBuilder.appendIn("t2.fnodeid", nodeIds);
        try (DataSet dataSet = DB.queryDataSet((String)"LaunchEventPlugin.querySubProcess", (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                subProcessIds.add(row.getLong(0));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("statuschange".equals(propertyName)) {
            this.getModel().setValue("subprocess", null);
        } else if ("returnnode".equals(propertyName)) {
            this.getModel().setValue("subprocess", null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)"returnnode", (CharSequence)source.getKey())) {
            DynamicObject processHistory = (DynamicObject)this.getModel().getValue("event_processid");
            DynamicObject processInit = processHistory.getDynamicObject("process");
            DynamicObject currentNode = (DynamicObject)this.getModel().getValue("event_startnodeid");
            DynamicObject process = BusinessDataServiceHelper.loadSingle((Object)processInit.getPkValue(), (String)"phm_flow_define", (String)"flowconf_tag");
            String processConfig = process.getString("flowconf_tag");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("phm_process_select");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectNodeBack"));
            showParameter.setCustomParam("data", (Object)processConfig);
            showParameter.setCustomParam("currentNodeId", (Object)currentNode.getString("nodeid"));
            showParameter.setCustomParam("process", processInit.getPkValue());
            this.getView().showForm(showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String targetNodeStatus;
        super.beforeDoOperation(args);
        DynamicObject eventStartnode = (DynamicObject)this.getModel().getValue("entry_node");
        if (Objects.isNull(eventStartnode)) {
            eventStartnode = (DynamicObject)this.getModel().getValue("event_startnodeid");
            this.getModel().setValue("entry_node", (Object)eventStartnode);
        }
        if (StringUtils.isBlank((CharSequence)(targetNodeStatus = (String)this.getModel().getValue("targetnodestatus")))) {
            this.getModel().setValue("targetnodestatus", this.getModel().getValue("nodestatus"));
        }
        String roleSql = "select t1.fbasedataid from t_phm_resourecrole t1,t_phm_flowresource t2,t_phm_flownode t3 where t1.FDetailID = t2.FDetailID and t2.fentryid = t3.fentryid and t3.fnodeid = ? ";
        ArrayList<Long> roleIds = new ArrayList<Long>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"phm_queryNodeResourceRole", (DBRoute)CommonConsts.ROUTE_PHM, (String)roleSql, (Object[])new Object[]{eventStartnode.getString("nodeid")});){
            for (Row row : dataSet) {
                roleIds.add(row.getLong(0));
            }
        }
        this.getModel().setValue("event_repositoryrole", (Object)roleIds.toArray());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            String statusChange = (String)this.getModel().getValue("statuschange");
            this.getView().returnDataToParent((Object)statusChange);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "selectNodeBack".equals(closedCallBackEvent.getActionId())) {
            Map returnDataMap = (Map)returnData;
            String selectNodeId = (String)returnDataMap.get("selectNodeId");
            Long processHistoryId = (Long)this.getModel().getValue("event_processid_id");
            QFilter qFilter = new QFilter("nodeid", "=", (Object)selectNodeId);
            qFilter.and(new QFilter("historyid", "=", (Object)processHistoryId));
            DynamicObject selectNodeEntry = QueryServiceHelper.queryOne((String)"phm_process_node", (String)"id,node_status", (QFilter[])qFilter.toArray());
            this.getModel().setValue("entry_node", (Object)selectNodeEntry.getLong("id"));
            String nodeStatus = selectNodeEntry.getString("node_status");
            String nodeOrginStatus = ProcessQueryUtil.getNodeOrginStatus((Long)selectNodeEntry.getLong("id"));
            if (StringUtils.isNotBlank((CharSequence)nodeOrginStatus)) {
                nodeStatus = nodeOrginStatus;
            }
            this.getModel().setValue("targetnodestatus", (Object)nodeStatus);
            this.getModel().setValue("returnnode", returnDataMap.get("selectedNodeName"));
        }
    }
}

