/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.ProcessHistoryInfo;
import kd.mmc.phm.common.domian.process.ProcessNodeInfo;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.NodeStatusChangeEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.enums.WorkbenchSubType;
import kd.mmc.phm.common.util.FlowNode;
import kd.mmc.phm.common.util.FlowUtils;
import kd.mmc.phm.common.util.JsonUtil;
import kd.mmc.phm.common.util.ShowFormUtils;
import kd.mmc.phm.common.util.basedata.RoleUtils;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;
import kd.mmc.phm.common.util.process.TaskProgressUtil;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ProcessInstanceEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String ALGO_KEY = "ProcessInstanceEditPlugin.";
    private static final Log log = LogFactory.getLog(ProcessInstanceEditPlugin.class);
    private static final String DESIGNER = "process";
    private static final String OP_CHANGE = "change";
    private static final String OP_FIREEVENT = "fireevent";
    private static final String OP_COMPLETE = "complete";
    private static final String OP_REFRESH = "refreshall";
    private static final String CACHEKEY_SELECTED_NODEID = "selectedNodeId";
    private static final String CACHEKEY_SELECTED_NODEENTRYID = "selectedNodeEntryId";
    private static final String BILLLIST_EVENT = "billlistap_event";
    private static final String BILLLIST_RESOURCE = "billlistap_resource";
    private static final String BILLLIST_TASK = "billlistap_task";
    private static final BigDecimal ONE_DAY = new BigDecimal(String.valueOf(86400000));
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    private static final String ZERO = "0";
    private static final String ISCOPY = "isCopy";

    public void getEntityType(GetEntityTypeEventArgs e) {
        this.getModel().putContextVariable("MODEL_INIT_LOADHEADONLY", (Object)Boolean.TRUE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long parentId = (Long)this.getModel().getValue("parentid");
        if (parentId != 0L) {
            this.getPageCache().put(ISCOPY, "true");
            this.getView().setVisible(Boolean.FALSE, new String[]{"barevent", "barcomplete", "barrerun", "barfinish"});
        }
    }

    public void afterLoadData(EventObject e) {
        CustomControl customControl = (CustomControl)this.getControl(DESIGNER);
        HashMap params = Maps.newHashMapWithExpectedSize((int)5);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        params.put("action", "init");
        params.put("isRunning", Boolean.TRUE);
        String data = (String)this.getModel().getValue("data_tag");
        Map<String, Object> astrictPosition = this.getAstrictPosition();
        ArrayList milepostList = new ArrayList(8);
        dataMap.put("astrictPosition", astrictPosition);
        dataMap.put("milepostOption", milepostList);
        Map cellMap = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)data)) {
            Map cellMaps = (Map)JsonUtil.fromJsonString((String)data, Map.class);
            cellMap = (Map)cellMaps.get("graphData");
            dataMap.put("graphData", cellMap);
            dataMap.put("locked", Boolean.TRUE);
            dataMap.put("processInfo", this.getProcessHistoryInfo());
            dataMap.put("nodeState", this.listProcessNodeInfo());
            params.put("data", dataMap);
        }
        customControl.setData((Object)params);
        this.showAllBillData(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList taskList = (BillList)this.getControl(BILLLIST_TASK);
        taskList.addHyperClickListener((HyperLinkClickListener)this);
        BillList resourceList = (BillList)this.getControl(BILLLIST_RESOURCE);
        resourceList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)evt;
        ListSelectedRow selectedRow = event.getCurrentRow();
        int rowKey = event.getCurrentRow().getRowKey();
        Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
        BillList billList = (BillList)event.getSource();
        String entityId = billList.getEntityId();
        String key = billList.getKey();
        String selectFields = "resource_type, resource_number, resource_datatype, resource_data, resource_role, resource_nodename, entry_node, resource_processhistory,number,resource_modifier,datasource, datasourceid";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)entityId, (String)selectFields);
        if (BILLLIST_RESOURCE.equals(key)) {
            Object resource_number = dynamicObject.getDynamicObject("resource_number").getPkValue();
            String resourceType = dynamicObject.getString("resource_type");
            if (!this.checkDataPermission(dynamicObject).booleanValue()) {
                return;
            }
            if ("phm_billtemp".equals(resourceType)) {
                Map<String, Object> customParams = this.buildWorkbenchBillParams(dynamicObject);
                customParams.put("isLock", Boolean.TRUE);
                FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_workbench_bill", customParams, null, (ShowType)ShowType.MainNewTabPage);
                String uniqueKey = TaskProgressUtil.getUniqueKey((IFormView)this.getView(), (Long)dynamicObject.getLong("resource_number_id"), (Long)dynamicObject.getLong("resource_role_id"), (Long)((Long)customParams.get("processHistoryId")), (Long)((Long)customParams.get("nodeEntryId")));
                formShowParameter.setPageId(uniqueKey);
                formShowParameter.setCustomParam("fromForm", (Object)"process_history");
                this.getView().showForm(formShowParameter);
            } else if ("phm_tasknotice".equals(resourceType)) {
                this.openTasknoticePage(resource_number);
            } else if ("phm_eigenvalue".equals(resourceType)) {
                this.openEigenvaluePage(resource_number);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u3002", (String)"ProcessInstanceEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        } else if (BILLLIST_TASK.equals(key)) {
            String sign = dynamicObject.getString("datasource");
            if ("phm_billtemp".equals(sign)) {
                BillShowParameter billShowParameter = ShowFormUtils.assembleShowBillParam((String)dynamicObject.getString("datasource"), (Object)dynamicObject.get("datasourceid_id"), null, null, (ShowType)ShowType.MainNewTabPage);
                billShowParameter.setStatus(OperationStatus.VIEW);
                billShowParameter.setPageId(this.getView().getMainView().getPageId() + dynamicObject.get("datasourceid_id"));
                billShowParameter.getOpenStyle().setTargetKey("tabap");
                this.getView().showForm((FormShowParameter)billShowParameter);
            } else if ("phm_tasknotice".equals(sign)) {
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setFormId("phm_tasknotice");
                baseShowParameter.setStatus(OperationStatus.VIEW);
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.getShowParameter().setCustomParam("isTemplate", (Object)Boolean.TRUE);
                this.getView().showForm((FormShowParameter)baseShowParameter);
            } else if ("phm_eigenvalue".equals(sign)) {
                this.openEigenvaluePage(dynamicObject.get("datasourceid_id"));
            }
        }
    }

    private Boolean checkDataPermission(DynamicObject dynamicObject) {
        Boolean isNext = true;
        long currUserId = RequestContext.get().getCurrUserId();
        ArrayList<String> list = new ArrayList<String>();
        Object userId = dynamicObject.getDynamicObject("resource_modifier").get("id");
        list.add(String.valueOf(userId));
        Object entry_node = dynamicObject.getDynamicObject("entry_node").getPkValue();
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingle((Object)entry_node, (String)"phm_process_node");
        String abnormalstatus = dynamicObject1.getString("abnormalstatus");
        String node_status = dynamicObject1.getString("node_status");
        if ("3".equals(abnormalstatus) || "completed".equals(node_status)) {
            if (userId != null && !userId.toString().equals(String.valueOf(currUserId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u8be5\u8d44\u6e90\u7684\u8d1f\u8d23\u4eba", (String)"ProcessInstanceEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                isNext = false;
            }
        } else {
            DynamicObject taskDyn = this.getTaskDyn(dynamicObject, list);
            if (taskDyn != null) {
                ArrayList<String> waringlist = new ArrayList<String>();
                ArrayList<String> overduecylist = new ArrayList<String>();
                ArrayList<String> seriousoverduelist = new ArrayList<String>();
                MulBasedataDynamicObjectCollection waringuser = (MulBasedataDynamicObjectCollection)taskDyn.getDynamicObjectCollection("waringuser");
                waringlist.addAll(list);
                overduecylist.addAll(list);
                seriousoverduelist.addAll(list);
                for (Object muDynamicObject : waringuser) {
                    waringlist.add(String.valueOf(muDynamicObject.get(2)));
                }
                MulBasedataDynamicObjectCollection overduecyuser = (MulBasedataDynamicObjectCollection)taskDyn.getDynamicObjectCollection("overduecyuser");
                for (DynamicObject muDynamicObject : overduecyuser) {
                    overduecylist.add(String.valueOf(muDynamicObject.get(2)));
                }
                MulBasedataDynamicObjectCollection seriousoverdueuser = (MulBasedataDynamicObjectCollection)taskDyn.getDynamicObjectCollection("seriousoverdueuser");
                for (DynamicObject muDynamicObject : seriousoverdueuser) {
                    seriousoverduelist.add(String.valueOf(muDynamicObject.get(2)));
                }
                if (ZERO.equals(abnormalstatus)) {
                    if (!waringlist.contains(String.valueOf(currUserId))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u8d44\u6e90", (String)"ProcessInstanceEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        isNext = false;
                    }
                } else if ("1".equals(abnormalstatus)) {
                    overduecylist.addAll(waringlist);
                    if (!overduecylist.contains(String.valueOf(currUserId))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u8d44\u6e90", (String)"ProcessInstanceEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        isNext = false;
                    }
                } else if ("2".equals(abnormalstatus)) {
                    overduecylist.addAll(waringlist);
                    seriousoverduelist.addAll(overduecylist);
                    if (!seriousoverduelist.contains(String.valueOf(currUserId))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u8d44\u6e90", (String)"ProcessInstanceEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        isNext = false;
                    }
                }
            }
        }
        return isNext;
    }

    private DynamicObject getTaskDyn(DynamicObject dynamicObject, List<String> list) {
        Object resource_processhistory = dynamicObject.getDynamicObject("resource_processhistory").getPkValue();
        String number = dynamicObject.getString("number");
        DynamicObject processhistory = BusinessDataServiceHelper.loadSingle((Object)resource_processhistory, (String)"phm_process_history");
        list.add(processhistory.getDynamicObject("milepost").getString("userliable.id"));
        String nodeid = dynamicObject.getDynamicObject("entry_node").getString("nodeid");
        DynamicObjectCollection entryentity = processhistory.getDynamicObjectCollection("entryentity");
        for (DynamicObject node : entryentity) {
            if (!node.getString("nodeid").equals(nodeid)) continue;
            list.add(node.getDynamicObject("personliables").getString("id"));
            DynamicObjectCollection subentryentity_task = node.getDynamicObjectCollection("subentryentity_task");
            for (DynamicObject task : subentryentity_task) {
                if (!task.getString("deliverablesnumber").equals(number)) continue;
                return task;
            }
        }
        return null;
    }

    private void openTasknoticePage(Object id) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId("phm_tasknotice");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u901a\u77e5\u5355", (String)"ProcessInstanceEditPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setPkId(id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void openEigenvaluePage(Object id) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId("phm_eigenvalue");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setPkId(id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if ("clear".equals(eventName)) {
            CustomControl customControl = (CustomControl)this.getControl(DESIGNER);
            customControl.setData(null);
        } else if ("clickProcessNode".equals(eventName)) {
            this.clickNode(eventArgs);
        } else if ("clearSelected".equals(eventName)) {
            this.clearNodeData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String selectedNodeId;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (OP_CHANGE.equals(operateKey)) {
            this.changeDataValidator(args);
        } else if (OP_FIREEVENT.equals(operateKey)) {
            this.fireEventValidator(args);
        } else if (OP_COMPLETE.equals(operateKey) && (selectedNodeId = this.getPageCache().get(CACHEKEY_SELECTED_NODEID)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u8282\u70b9\u3002", (String)"ProcessInstanceEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        if (OP_CHANGE.equals(operateKey)) {
            this.showDataTemplateFillForm();
            return;
        }
        if (OP_FIREEVENT.equals(operateKey)) {
            this.showEventForm();
        } else if (OP_COMPLETE.equals(operateKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8282\u70b9\u624b\u5de5\u5b8c\u6210\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5b8c\u6210\u8be5\u8282\u70b9\u5417\uff1f", (String)"ProcessInstanceEditPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OP_COMPLETE, (IFormPlugin)this));
            return;
        }
        this.refresh();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (result == MessageBoxResult.Yes && OP_COMPLETE.equals(callBackId)) {
            this.finishNodeCallBack();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (OP_CHANGE.equals(actionId)) {
            BillList billList = (BillList)this.getControl(BILLLIST_RESOURCE);
            billList.refresh();
        } else if (OP_FIREEVENT.equals(actionId) && returnData != null) {
            if (NodeStatusChangeEnum.STOP.getValue().equals(returnData)) {
                this.refreshNodeInfo(this.getPageCache().get(CACHEKEY_SELECTED_NODEID));
            } else if (NodeStatusChangeEnum.RETURN_BEFROE.getValue().equals(returnData)) {
                this.refresh();
            } else if (NodeStatusChangeEnum.NO_CHANGE.getValue().equals(returnData)) {
                BillList eventList = (BillList)this.getControl(BILLLIST_EVENT);
                eventList.refresh();
            }
        }
    }

    private void showEventForm() {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("phm_process_event");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = billShowParameter.getCustomParams();
        customParams.putAll(this.getView().getFormShowParameter().getCustomParams());
        customParams.put("event_startnodeid", this.getPageCache().get(CACHEKEY_SELECTED_NODEENTRYID));
        QFilter qFilter = new QFilter("historyid", "=", this.getModel().getDataEntity().getPkValue());
        qFilter.and(new QFilter("id", "=", (Object)Long.parseLong(this.getPageCache().get(CACHEKEY_SELECTED_NODEENTRYID))));
        DynamicObject startNodeEntry = QueryServiceHelper.queryOne((String)"phm_process_node", (String)"node_status", (QFilter[])qFilter.toArray());
        customParams.put("nodestatus", startNodeEntry.getString("node_status"));
        customParams.put("event_processid", this.getModel().getDataEntity().getPkValue());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OP_FIREEVENT);
        billShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private boolean launchEventValidate() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", this.getModel().getValue("flowdefine_id")), new QFilter("flowleader.fbasedataid", "=", (Object)userId)};
        if (QueryServiceHelper.exists((String)"phm_flow_define", (QFilter[])filters)) {
            return true;
        }
        List currentUserRoles = RoleUtils.listRoleByUser((long)userId);
        String selectNodeRole = "select fbasedataid from t_phm_resourecrole where fdetailid in (select fdetailid from t_phm_flowresource where fentryid in (select fentryid from t_phm_flownode where fnodeid = ?))";
        try (DataSet set = DB.queryDataSet((String)"phm_selectNodeRole", (DBRoute)CommonConsts.ROUTE_PHM, (String)selectNodeRole, (Object[])new Object[]{this.getPageCache().get(CACHEKEY_SELECTED_NODEID)});){
            for (Row row : set) {
                if (!currentUserRoles.contains(row.getLong(0))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void fireEventValidator(BeforeDoOperationEventArgs args) {
        String selectedNodeId = this.getPageCache().get(CACHEKEY_SELECTED_NODEID);
        if (selectedNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u8282\u70b9\u3002", (String)"ProcessInstanceEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String nodeStatus = (String)this.getModel().getValue("nodestate");
        if (RunningState.PREPARE.getValue().equals(nodeStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\"\u8282\u70b9\u72b6\u6001\"\u4e3a\"\u672a\u5f00\u59cb\"\u65f6\uff0c\u8282\u70b9\u4e0d\u5141\u8bb8\u53d1\u8d77\u4e8b\u4ef6\u3002", (String)"ProcessInstanceEditPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (RunningState.AUTO.getValue().equals(nodeStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\"\u8282\u70b9\u72b6\u6001\"\u4e3a\"\u81ea\u52a8\u66f4\u65b0\"\u65f6\uff0c\u8282\u70b9\u4e0d\u5141\u8bb8\u53d1\u8d77\u4e8b\u4ef6\u3002", (String)"ProcessInstanceEditPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!this.launchEventValidate()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6d41\u7a0b\u8d1f\u8d23\u4eba\u4e14\u4e0d\u5c5e\u4e8e\u5f53\u524d\u8282\u70b9\uff0c\u4e0d\u80fd\u5bf9\u5f53\u524d\u8282\u70b9\u53d1\u8d77\u4e8b\u4ef6\u3002", (String)"ProcessInstanceEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void changeDataValidator(BeforeDoOperationEventArgs args) {
        BillList resourceList = (BillList)this.getControl(BILLLIST_RESOURCE);
        ListSelectedRow selectedRow = resourceList.getCurrentSelectedRowInfo();
        if (selectedRow == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\"\u6267\u884c\u6570\u636e\"\u4e2d\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ProcessInstanceEditPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!this.commonValidator(args)) {
            return;
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", this.getModel().getValue("flowdefine_id")), new QFilter("flowleader.fbasedataid", "=", (Object)userId)};
        boolean isProcessLead = QueryServiceHelper.exists((String)"phm_flow_define", (QFilter[])filters);
        String isCopy = this.getPageCache().get(ISCOPY);
        if (StringUtils.isNotBlank((CharSequence)isCopy)) {
            if (!isProcessLead) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u975e\u6d41\u7a0b\u8d1f\u8d23\u4eba\u65e0\u8be5\u8d44\u6e90\u7f16\u8f91\u6743\u9650", (String)"ProcessInstanceEditPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            return;
        }
        String selectedNodeEntryId = this.getPageCache().get(CACHEKEY_SELECTED_NODEENTRYID);
        filters = new QFilter[]{new QFilter("entry_node", "=", (Object)Long.parseLong(selectedNodeEntryId)), new QFilter("statuschange", "=", (Object)NodeStatusChangeEnum.RETURN_BEFROE.getValue()), new QFilter("status", "in", (Object)new String[]{WorkbenchSubType.EVENT_UNPROCESSED.getValue(), WorkbenchSubType.EVENT_PROCESSING.getValue()})};
        if (QueryServiceHelper.exists((String)"phm_process_event", (QFilter[])filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5b58\u5728\"\u53d1\u8d77\u8282\u70b9\u72b6\u6001\"\u53d8\u66f4\u4e3a\"\u8fd4\u56de\u524d\u8282\u70b9\"\u3001\"\u4e8b\u4ef6\u72b6\u6001\"\u4e3a\"\u672a\u5904\u7406\"\u6216\"\u5904\u7406\u4e2d\"\u7684\u4e8b\u4ef6\uff0c\u8bf7\u5728\u4e8b\u4ef6\u5217\u8868\u5904\u7406\u4e8b\u4ef6\u3002", (String)"ProcessInstanceEditPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Object processResourceId = selectedRow.getPrimaryKeyValue();
        String selectFields = "resource_role, resource_dealtype, resource_modifier, resource_org";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)processResourceId, (String)"phm_process_resources", (String)selectFields);
        String dealtype = dynamicObject.getString("resource_dealtype");
        if (!DealTypeEnum.MANUAL.getName().equals(dealtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\"\u5904\u7406\u65b9\u5f0f\"\u4e3a\"\u624b\u5de5\"\u65f6\uff0c\u6570\u636e\u624d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ProcessInstanceEditPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!isProcessLead) {
            long orgId = dynamicObject.getLong("resource_org_id");
            long roleId = dynamicObject.getLong("resource_role_id");
            if (RequestContext.get().getOrgId() != orgId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u975e\u8be5\u8d44\u6e90\u586b\u62a5\u90e8\u95e8\u3002", (String)"ProcessInstanceEditPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (0L == roleId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u8d1f\u8d23\u4eba\u586b\u62a5\u6570\u636e\u8d44\u6e90\u89d2\u8272\u65e0\u7f16\u8f91\u6743\u9650\u3002", (String)"ProcessInstanceEditPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (0L != roleId && !RoleUtils.checkRole((long)userId, (long)roleId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u975e\u6d41\u7a0b\u8d1f\u8d23\u4eba\u6216\u6240\u5c5e\u89d2\u8272\u65e0\u8be5\u8d44\u6e90\u7f16\u8f91\u6743\u9650\u3002", (String)"ProcessInstanceEditPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean commonValidator(BeforeDoOperationEventArgs args) {
        String selectedNodeId = this.getPageCache().get(CACHEKEY_SELECTED_NODEID);
        String isCopy = this.getPageCache().get(ISCOPY);
        if (selectedNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u8282\u70b9\u3002", (String)"ProcessInstanceEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String status = (String)this.getModel().getValue("nodestate");
        if (RunningState.AUTO.getValue().equals(status)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8282\u70b9\u81ea\u52a8\u66f4\u65b0\u4e2d\u3002", (String)"ProcessInstanceEditPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)isCopy)) {
            return true;
        }
        if (RunningState.COMPLETED.getValue().equals(status)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8282\u70b9\u5df2\u4e3a\u5df2\u5b8c\u6210\u72b6\u6001\u3002", (String)"ProcessInstanceEditPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String billStatus = (String)this.getModel().getValue("status");
        if (RunningState.SUSPEND.getValue().equals(billStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u7a0b\u5df2\u4e3a\u6682\u505c\u72b6\u6001\u3002", (String)"ProcessInstanceEditPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void showDataTemplateFillForm() {
        BillList resourceList = (BillList)this.getControl(BILLLIST_RESOURCE);
        ListSelectedRow selectedRow = resourceList.getCurrentSelectedRowInfo();
        Object processResourceId = selectedRow.getPrimaryKeyValue();
        String selectFields = "resource_type, resource_number, resource_datatype, resource_data, resource_role, resource_nodename, entry_node, resource_processhistory";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)processResourceId, (String)"phm_process_resources", (String)selectFields);
        Map<String, Object> customParams = this.buildWorkbenchBillParams(dynamicObject);
        customParams.put("isLock", Boolean.FALSE);
        customParams.put("processResourceId", dynamicObject.getPkValue());
        DynamicObject process = (DynamicObject)this.getModel().getValue("flowdefine");
        customParams.put("globalrule", process.getBoolean("globalrule"));
        customParams.put("versionRule", process.get("versionrule_id"));
        customParams.put(ISCOPY, this.getPageCache().get(ISCOPY));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OP_CHANGE);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_workbench_bill", customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.MainNewTabPage);
        long roleId = dynamicObject.getLong("resource_role_id");
        String uniqueKey = TaskProgressUtil.getUniqueKey((IFormView)this.getView(), (Long)dynamicObject.getLong("resource_number_id"), (Long)roleId, (Long)((Long)customParams.get("processHistoryId")), (Long)((Long)customParams.get("nodeEntryId")));
        formShowParameter.setPageId(uniqueKey);
        formShowParameter.setCustomParam("fromForm", (Object)"process_history");
        this.getView().showForm(formShowParameter);
    }

    private void finishNodeCallBack() {
        String nodeEntryId = this.getPageCache().get(CACHEKEY_SELECTED_NODEENTRYID);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("processId", String.valueOf(this.getModel().getValue("flowdefine_id")));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)OP_COMPLETE, (String)"phm_process_node", (Object[])new Object[]{Long.parseLong(nodeEntryId)}, (OperateOption)operateOption);
        operationResult.setMessage(ResManager.loadKDString((String)"\u8282\u70b9\u624b\u5de5\u5b8c\u6210\u6210\u529f\u3002", (String)"ProcessInstanceEditPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        this.getView().showOperationResult(operationResult, ResManager.loadKDString((String)"\u8282\u70b9\u624b\u5de5\u5b8c\u6210", (String)"ProcessInstanceEditPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        if (operationResult.isSuccess()) {
            this.getView().invokeOperation(OP_REFRESH);
        }
    }

    private void clickNode(String nodeJson) {
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)nodeJson, Map.class);
        String selectedNodeId = (String)nodeInfo.get("id");
        this.getPageCache().put(CACHEKEY_SELECTED_NODEID, selectedNodeId);
        this.refreshNodeInfo(selectedNodeId);
    }

    private void refreshNodeInfo(String selectedNodeId) {
        if (StringUtils.isBlank((CharSequence)selectedNodeId)) {
            return;
        }
        Object historyId = this.getModel().getDataEntity().getPkValue();
        BigDecimal taskScale = this.getTaskScale(historyId, selectedNodeId);
        String selectFields = "id, node_name, node_status, node_createtime, node_finishtime, node_period, node_iscontrol, suspendduration,planbegintime,planendtime,personliables,liableorgs,abnormalstatus";
        QFilter[] filters = new QFilter[]{new QFilter("historyid", "=", historyId), new QFilter("nodeid", "=", (Object)selectedNodeId)};
        try (DataSet dataSet = ORM.create().queryDataSet("ProcessInstanceEditPlugin.getNodeInfo", "phm_process_node", selectFields, filters, null, 1);){
            String progressStr;
            BigDecimal runtime;
            if (!dataSet.hasNext()) {
                return;
            }
            Row row = dataSet.next();
            this.getPageCache().put(CACHEKEY_SELECTED_NODEENTRYID, row.getString(0));
            String nodeName = row.getString("node_name");
            this.getModel().setValue("nodename", (Object)nodeName);
            String nodeStatus = row.getString("node_status");
            this.getModel().setValue("nodestate", (Object)nodeStatus);
            this.getModel().setValue("nodecontrol", (Object)row.getBoolean("node_iscontrol"));
            BigDecimal period = row.getBigDecimal("node_period");
            this.getModel().setValue("nodeperiod", (Object)period);
            this.getModel().setValue("planbegintimes", row.get("planbegintime"));
            this.getModel().setValue("planendtimes", row.get("planendtime"));
            this.getModel().setValue("personliable", row.get("personliables"));
            this.getModel().setValue("liableorg", row.get("liableorgs"));
            this.getModel().setValue("actaulbegintime", row.get("node_createtime"));
            this.getModel().setValue("actaulendtime", row.get("node_finishtime"));
            String abnormalstatus = row.getString("abnormalstatus");
            this.getModel().setValue("node_state", (Object)abnormalstatus);
            Date startDate = row.getDate("node_createtime");
            String processStatus = (String)this.getModel().getValue("status");
            boolean useFinishTime = RunningState.COMPLETED.getValue().equals(nodeStatus) || RunningState.SUSPEND.getValue().equals(processStatus);
            Date endDate = useFinishTime ? row.getDate("node_finishtime") : new Date();
            BigDecimal bigDecimal = runtime = startDate != null && endDate != null ? this.calcRuntime(startDate, endDate) : null;
            if (runtime != null) {
                BigDecimal suspendDuration = row.getBigDecimal("suspendduration");
                runtime = runtime.subtract(suspendDuration);
            }
            this.getModel().setValue("noderuntime", (Object)runtime);
            if (RunningState.PREPARE.getValue().equals(nodeStatus) || period.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("noderuntime", (Object)0);
                progressStr = "-1";
            } else if (runtime != null) {
                BigDecimal progress = runtime.divide(period, 2, 4).multiply(ONE_HUNDRED);
                progressStr = progress.stripTrailingZeros().toPlainString();
            } else {
                progressStr = ZERO;
            }
            if ("-1".equals(progressStr)) {
                this.getModel().setValue("noderatio", null);
            } else {
                this.getModel().setValue("noderatio", (Object)(progressStr + "%"));
            }
            if (ZERO.equals(abnormalstatus)) {
                nodeStatus = "earlyWarning";
            } else if ("1".equals(abnormalstatus)) {
                nodeStatus = "overdue";
            } else if ("2".equals(abnormalstatus)) {
                nodeStatus = "seriousOverdue";
            }
            this.updateAllStatus(selectedNodeId, nodeName, nodeStatus, progressStr, taskScale);
            this.refreshBillList(Lists.newArrayList((Object[])new Object[]{row.get(0)}), true);
        }
    }

    private BigDecimal getTaskScale(Object historyId, String selectedNodeId) {
        QFilter qFilter = new QFilter("task_processhistory", "=", historyId);
        QFilter qFilter_node = new QFilter("entry_node.nodeid", "=", (Object)selectedNodeId);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"phm_process_task", (String)"id,task_status,taskprogress", (QFilter[])new QFilter[]{qFilter, qFilter_node});
        int total = dynamicObjectCollection.size();
        int complete = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String[] split;
            Boolean isCom = false;
            String task_status = dynamicObject.getString("task_status");
            String taskprogress = dynamicObject.getString("taskprogress");
            if (taskprogress.contains("/") && (split = taskprogress.split("/"))[0].equals(split[1])) {
                isCom = true;
            }
            if (!"2".equals(task_status) && !isCom.booleanValue()) continue;
            ++complete;
        }
        BigDecimal scale = BigDecimal.ZERO;
        if (complete != 0) {
            scale = BigDecimal.valueOf(complete).divide(BigDecimal.valueOf(total), 2, 4).multiply(new BigDecimal("100"));
        }
        return scale;
    }

    private void clearNodeData() {
        Container nodePanel = (Container)this.getControl("panel_node");
        for (Control item : nodePanel.getItems()) {
            this.getModel().setValue(item.getKey(), null);
        }
        this.getPageCache().remove(CACHEKEY_SELECTED_NODEID);
        this.getPageCache().remove(CACHEKEY_SELECTED_NODEENTRYID);
        this.showAllBillData(true);
    }

    private void updateAllStatus(String id, String name, String status, String progressStr, BigDecimal taskScale) {
        ProcessNodeInfo processNodeInfo = new ProcessNodeInfo();
        processNodeInfo.setId(id);
        processNodeInfo.setName(name);
        processNodeInfo.setStatus(status);
        processNodeInfo.setProgress(progressStr);
        String taskCom = "";
        if (!"prepare".equals(status)) {
            taskCom = ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u7387:", (String)"ProcessInstanceEditPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + taskScale.toString() + "%";
        }
        processNodeInfo.setTaskCompleteScale(taskCom);
        this.updateAllStatus(this.getProcessHistoryInfo(), Lists.newArrayList((Object[])new ProcessNodeInfo[]{processNodeInfo}));
    }

    private void updateAllStatus(ProcessHistoryInfo processHistoryInfo, List<ProcessNodeInfo> processNodeInfoList) {
        CustomControl customControl = (CustomControl)this.getControl(DESIGNER);
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("action", "runningProcessUpdate");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("processInfo", processHistoryInfo);
        dataMap.put("nodeState", processNodeInfoList);
        params.put("data", dataMap);
        customControl.setData((Object)params);
    }

    private ProcessHistoryInfo getProcessHistoryInfo() {
        ProcessHistoryInfo processHistoryInfo = new ProcessHistoryInfo();
        DynamicObject process = (DynamicObject)this.getModel().getValue("flowdefine");
        processHistoryInfo.setNumber(process.getString("number"));
        processHistoryInfo.setName(process.getString("name"));
        processHistoryInfo.setVersion((String)this.getModel().getValue("number"));
        processHistoryInfo.setStartTime(DateFormatUtils.format((Date)((Date)this.getModel().getValue("createtime")), (String)"yyyy-MM-dd HH:mm:ss"));
        processHistoryInfo.setStatus((String)this.getModel().getValue("status"));
        return processHistoryInfo;
    }

    private List<ProcessNodeInfo> listProcessNodeInfo() {
        Object historyId = this.getModel().getDataEntity().getPkValue();
        String selectFields = "nodeid, node_name, node_status, node_createtime, node_finishtime, node_period, suspendduration,abnormalstatus";
        QFilter[] filters = new QFilter[]{new QFilter("historyid", "=", historyId)};
        ArrayList<ProcessNodeInfo> processNodeInfoList = new ArrayList<ProcessNodeInfo>();
        try (DataSet dataSet = ORM.create().queryDataSet("ProcessInstanceEditPlugin.getNodeInfo", "phm_process_node", selectFields, filters);){
            for (Row row : dataSet) {
                ProcessNodeInfo processNodeInfo = new ProcessNodeInfo();
                processNodeInfo.setId(row.getString("nodeid"));
                processNodeInfo.setName(row.getString("node_name"));
                String nodeStatus = row.getString("node_status");
                String abnormalstatus = row.getString("abnormalstatus");
                BigDecimal taskScale = this.getTaskScale(historyId, row.getString("nodeid"));
                String taskCom = "";
                if (!"prepare".equals(nodeStatus)) {
                    taskCom = ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u7387:", (String)"ProcessInstanceEditPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + taskScale.toString() + "%";
                }
                processNodeInfo.setTaskCompleteScale(taskCom);
                if (ZERO.equals(abnormalstatus)) {
                    processNodeInfo.setStatus("earlyWarning");
                } else if ("1".equals(abnormalstatus)) {
                    processNodeInfo.setStatus("overdue");
                } else if ("2".equals(abnormalstatus)) {
                    processNodeInfo.setStatus("seriousOverdue");
                } else {
                    processNodeInfo.setStatus(nodeStatus);
                }
                Date startDate = row.getDate("node_createtime");
                String processStatus = (String)this.getModel().getValue("status");
                boolean useFinishTime = RunningState.COMPLETED.getValue().equals(nodeStatus) || RunningState.SUSPEND.getValue().equals(processStatus);
                Date endDate = useFinishTime ? row.getDate("node_finishtime") : new Date();
                BigDecimal period = row.getBigDecimal("node_period");
                if (RunningState.PREPARE.getValue().equals(nodeStatus) || period.compareTo(BigDecimal.ZERO) == 0) {
                    processNodeInfo.setProgress("-1");
                } else if (startDate != null && endDate != null) {
                    BigDecimal runtime = this.calcRuntime(startDate, endDate);
                    BigDecimal suspendDuration = row.getBigDecimal("suspendduration");
                    runtime = runtime.subtract(suspendDuration);
                    BigDecimal progress = runtime.divide(period, 2, 4).multiply(ONE_HUNDRED);
                    processNodeInfo.setProgress(progress.stripTrailingZeros().toPlainString());
                } else {
                    processNodeInfo.setProgress(ZERO);
                }
                processNodeInfoList.add(processNodeInfo);
            }
        }
        return processNodeInfoList;
    }

    private BigDecimal calcRuntime(Date startDate, Date endDate) {
        return new BigDecimal(String.valueOf(endDate.getTime())).subtract(new BigDecimal(String.valueOf(startDate.getTime()))).divide(ONE_DAY, 4, 1);
    }

    private Map<String, Object> buildWorkbenchBillParams(DynamicObject dynamicObject) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("isHistory", Boolean.TRUE);
        customParams.put("processHistoryId", this.getModel().getDataEntity().getPkValue());
        customParams.put("resource", dynamicObject.get("resource_number_id"));
        customParams.put("versionNumber", dynamicObject.getString("resource_data.number"));
        customParams.put("role", Lists.newArrayList((Object[])new Object[]{dynamicObject.get("resource_role_id")}));
        customParams.put("resourceDataId", dynamicObject.get("resource_data_id"));
        long nodeEntryId = dynamicObject.getLong("entry_node_id");
        customParams.put("nodeEntryId", nodeEntryId);
        customParams.put(DESIGNER, this.getModel().getValue("flowdefine_id"));
        DynamicObject firstEvent = ProcessQueryUtil.queryNodeFirstEvent((Long)nodeEntryId);
        if (firstEvent != null) {
            if (NodeStatusChangeEnum.RETURN_BEFROE.getValue().equals(firstEvent.getString("statuschange"))) {
                customParams.put("nodeOrgStatus", RunningState.COMPLETED.getValue());
            } else {
                customParams.put("nodeOrgStatus", firstEvent.getString("nodestatus"));
            }
        }
        return customParams;
    }

    private Map<String, Object> getAstrictPosition() {
        HashMap<String, Object> astrictPosition = new HashMap<String, Object>();
        astrictPosition.put("startX", 20);
        astrictPosition.put("startY", 300);
        astrictPosition.put("endX", 1020);
        astrictPosition.put("endY", 750);
        return astrictPosition;
    }

    private void refreshBillList(List<Object> entryIds, boolean fouceRefresh) {
        ArrayList<String> childNodeIds = new ArrayList<String>(8);
        ArrayList<Long> nodeEntryIds = new ArrayList<Long>(8);
        ArrayList<Long> roleEntryIds = new ArrayList<Long>(8);
        ArrayList<Long> strEntryIds = new ArrayList<Long>(8);
        String data = (String)this.getModel().getValue("data_tag");
        Map parentRelations = FlowUtils.getParentRelations((String)data);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Object historyId = this.getModel().getDataEntity().getPkValue();
        DynamicObject flowdefine = (DynamicObject)this.getModel().getValue("flowdefine");
        DynamicObject define = BusinessDataServiceHelper.loadSingle((Object)flowdefine.getPkValue(), (String)"phm_flow_define");
        DynamicObjectCollection nodeentrys = define.getDynamicObjectCollection("flownodeentryentity");
        this.removeNoExitNode(entryIds);
        for (Object nodeentry : nodeentrys) {
            if (!nodeentry.getBoolean("nodedataisolation")) continue;
            DynamicObjectCollection subentrys = nodeentry.getDynamicObjectCollection("resourcesubentryentity");
            for (DynamicObject subentry : subentrys) {
                DynamicObjectCollection roles = subentry.getDynamicObjectCollection("role");
                for (DynamicObject role : roles) {
                    long roleId = role.getDynamicObject("fbasedataid").getLong("masterid");
                    if (!RoleUtils.checkRole((long)userId, (long)roleId)) continue;
                    this.getAllChildNode(parentRelations, nodeentry.getString("nodeid"), childNodeIds);
                }
            }
        }
        List disNodeIds = childNodeIds.stream().distinct().collect(Collectors.toList());
        for (DynamicObject[] disNode : disNodeIds) {
            DynamicObject nodedynamicObjects = BusinessDataServiceHelper.loadSingle((String)"phm_process_node", (String)"id", (QFilter[])new QFilter[]{new QFilter("historyid", "=", historyId), new QFilter("nodeid", "=", (Object)disNode)});
            nodeEntryIds.add(nodedynamicObjects.getLong("id"));
        }
        if (nodeEntryIds.size() != 0) {
            DynamicObject[] resdynamicObjects;
            nodeEntryIds.retainAll(entryIds);
            for (DynamicObject resdynamicObject : resdynamicObjects = BusinessDataServiceHelper.load((String)"phm_process_resources", (String)"id", (QFilter[])new QFilter[]{new QFilter("resource_processhistory", "=", historyId), new QFilter("entry_node.id", "in", nodeEntryIds)})) {
                strEntryIds.add(resdynamicObject.getLong("id"));
            }
        }
        for (Object entry : entryIds) {
            DynamicObject resdynamicObjects;
            String resselectFields = "id, entry_node, resource_role, resource_modifier, resource_type, resource_number, resource_org,number";
            for (DynamicObject resdynamicObject : resdynamicObjects = BusinessDataServiceHelper.load((String)"phm_process_resources", (String)resselectFields, (QFilter[])new QFilter[]{new QFilter("resource_processhistory", "=", historyId), new QFilter("entry_node.id", "=", entry)})) {
                DynamicObject resorg;
                DynamicObjectCollection roles = null;
                if (null == resdynamicObject) continue;
                if (null != define) {
                    for (DynamicObject nodeentry : nodeentrys) {
                        DynamicObjectCollection subentrys = nodeentry.getDynamicObjectCollection("resourcesubentryentity");
                        for (DynamicObject subentry : subentrys) {
                            if (!subentry.getString("deliverablesnumber").equals(resdynamicObject.getString("number"))) continue;
                            roles = subentry.getDynamicObjectCollection("role");
                        }
                    }
                }
                if (null != (resorg = resdynamicObject.getDynamicObject("resource_org"))) {
                    if (RequestContext.get().getOrgId() != resorg.getLong("id")) continue;
                    roleEntryIds.add(resdynamicObject.getLong("id"));
                    continue;
                }
                if (null != resorg || null == roles) continue;
                Boolean checktask = false;
                for (DynamicObject taskrole : roles) {
                    long taskroleId = taskrole.getDynamicObject("fbasedataid").getLong("masterid");
                    if (!RoleUtils.checkRole((long)userId, (long)taskroleId)) continue;
                    checktask = true;
                }
                if (!checktask.booleanValue()) continue;
                roleEntryIds.add(resdynamicObject.getLong("id"));
            }
        }
        strEntryIds.addAll(roleEntryIds);
        QFilter[] fzfilter = new QFilter[]{new QFilter("id", "=", this.getModel().getValue("flowdefine_id"))};
        if (QueryServiceHelper.exists((String)"phm_flow_define", (QFilter[])fzfilter)) {
            DynamicObject[] fzdynamicObjects;
            strEntryIds.clear();
            for (DynamicObject fzdynamicObject : fzdynamicObjects = BusinessDataServiceHelper.load((String)"phm_process_resources", (String)"id", (QFilter[])new QFilter[]{new QFilter("resource_processhistory", "=", historyId), new QFilter("entry_node.id", "in", entryIds)})) {
                strEntryIds.add(fzdynamicObject.getLong("id"));
            }
        }
        FilterParameter filterParameter = new FilterParameter(new QFilter("entry_node", "in", entryIds), null);
        FilterParameter resourcefilterParameter = new FilterParameter(new QFilter("id", "in", strEntryIds), null);
        BillList eventList = (BillList)this.getControl(BILLLIST_EVENT);
        eventList.setFilterParameter(filterParameter);
        BillList resourceList = (BillList)this.getControl(BILLLIST_RESOURCE);
        resourceList.setFilterParameter(resourcefilterParameter);
        resourceList.clearSelection();
        BillList taskList = (BillList)this.getControl(BILLLIST_TASK);
        taskList.setFilterParameter(filterParameter);
        if (fouceRefresh) {
            eventList.refresh();
            resourceList.refresh();
            taskList.refresh();
        }
    }

    private void removeNoExitNode(List<Object> entryIds) {
        ArrayList nodeId = new ArrayList(8);
        String data = (String)this.getModel().getValue("data_tag");
        FlowNode flowNode = FlowUtils.resolveFlowTree((String)data);
        FlowUtils.getAllNode((FlowNode)flowNode, nodeId);
        if (entryIds == null || entryIds.size() == 0) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"phm_process_node", (String)"id,nodeid", (QFilter[])new QFilter[]{new QFilter("id", "in", entryIds)});
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            map.put(dynamicObject.getString("nodeid"), dynamicObject.get("id"));
        }
        entryIds.clear();
        log.info("nodeid:" + ((Object)nodeId).toString() + "map:" + ((Object)map).toString());
        log.info("begin:entryIds" + entryIds.toString());
        for (String nodeid : nodeId) {
            if (!map.containsKey(nodeid)) continue;
            entryIds.add(map.get(nodeid));
        }
        log.info("end:entryIds" + entryIds.toString());
    }

    private void refresh() {
        this.getModel().beginInit();
        ((BillModel)this.getModel()).load(this.getModel().getDataEntity().getPkValue());
        this.getModel().endInit();
        this.refreshNodeInfo(this.getPageCache().get(CACHEKEY_SELECTED_NODEID));
        this.updateAllStatus(this.getProcessHistoryInfo(), this.listProcessNodeInfo());
    }

    private void showAllBillData(boolean refresh) {
        QFilter[] filters = new QFilter[]{new QFilter("historyid", "=", this.getModel().getDataEntity().getPkValue())};
        List entryIds = QueryServiceHelper.queryPrimaryKeys((String)"phm_process_node", (QFilter[])filters, null, (int)-1);
        this.refreshBillList(entryIds, refresh);
    }

    private void getAllChildNode(Map<String, List<String>> parentRelations, String selectNodeId, List<String> preNodeIds) {
        if (null != parentRelations.get(selectNodeId)) {
            preNodeIds.addAll((Collection<String>)parentRelations.get(selectNodeId));
            for (String childnode : parentRelations.get(selectNodeId)) {
                this.getAllChildNode(parentRelations, childnode, preNodeIds);
            }
        }
    }
}

