/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessErrorTypeEnum;
import kd.mmc.phm.common.enums.ResourceTypeEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.enums.TaskStatusEnum;
import kd.mmc.phm.common.errorcode.PHMErrorCode;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;
import kd.mmc.phm.common.util.process.ProcessUpdateUtil;
import kd.mmc.phm.formplugin.bizmodel.billtemp.WorkStationMultiBillPlugin;

public class WorkbenchBillPlugin
extends WorkStationMultiBillPlugin {
    private static final Log log = LogFactory.getLog(WorkbenchBillPlugin.class);
    protected static final String ROLEID = "roleId";

    @Override
    public void afterCreateNewData(EventObject e) {
        try {
            this.clearErrorMsg(ProcessErrorTypeEnum.AUTO_LOAD_ERR.getValue());
            super.afterCreateNewData(e);
        }
        catch (Exception exception) {
            this.addErrorMsg(exception, ProcessErrorTypeEnum.AUTO_LOAD_ERR);
            throw exception;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object processResourceId = formShowParameter.getCustomParam("processResourceId");
        if (processResourceId != null) {
            this.getPageCache().put("processResourceId", String.valueOf(processResourceId));
        }
        this.getModel().setValue("processhistory", formShowParameter.getCustomParam("processHistoryId"));
        this.getModel().setValue("node", formShowParameter.getCustomParam("nodeEntryId"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isLock = (Boolean)this.getView().getFormShowParameter().getCustomParam("isLock");
        if (isLock) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save", "submit", "audit"});
            this.getSpreadContainer().lockSheet();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("unaudit".equals(evt.getItemKey())) {
            this.actionUnAudit();
        }
    }

    @Override
    protected DynamicObject getDataTemp() {
        Object resourceId = this.getView().getFormShowParameter().getCustomParam("resource");
        if (resourceId == null) {
            return null;
        }
        DynamicObject dataTemp = BusinessDataServiceHelper.loadSingle((Object)resourceId, (String)"phm_billtemp");
        Long historyId = (Long)this.getView().getFormShowParameter().getCustomParam("resourceDataId");
        if (historyId != null && historyId != 0L) {
            this.getPageCache().put("resourceDataId", Long.toString(historyId));
            DynamicObject tempHistroy = this.getTempHistroy(historyId);
            this.useHistoryDeal(dataTemp, tempHistroy);
        } else {
            this.setStatus("A");
        }
        this.getView().getPageCache().put("realcol", dataTemp.getString("realcol"));
        this.getView().getPageCache().put("realrow", dataTemp.getString("realrow"));
        this.getView().getPageCache().put("rowCount", dataTemp.getString("realrow"));
        String templateType = dataTemp.getString("tempclassify");
        this.getView().getPageCache().put("templateType", templateType);
        this.getView().getPageCache().put("cellConfid", dataTemp.getString("cellconf_id"));
        return dataTemp;
    }

    private void useHistoryDeal(DynamicObject dataTemp, DynamicObject history) {
        this.setStatus(history.getString("status"));
        this.setHistortyId(history.getLong("id"));
        String spreadjson_tag = history.getString("spreadjson_tag");
        dataTemp.set("spreadjson_tag", (Object)spreadjson_tag);
        Map sheetData = SpreadUtils.getSheetData((String)spreadjson_tag);
        Object rowCount = sheetData.get("rowCount");
        if (rowCount != null) {
            dataTemp.set("realrow", sheetData.get("rowCount"));
        }
        this.getView().getPageCache().put("isHistory", "true");
        this.getView().getPageCache().put("creator", history.getString("creator.id"));
        this.getView().getPageCache().put("createtime", SerializationUtils.toJsonString((Object)history.getDate("createtime")));
        this.getView().getPageCache().put("modifier", history.getString("modifier.id"));
        this.getView().getPageCache().put("modifytime", SerializationUtils.toJsonString((Object)history.getString("modifytime")));
    }

    private DynamicObject getTempHistroy(Long tempHistoryId) {
        DynamicObject tempHistroy = BusinessDataServiceHelper.loadSingle((Object)tempHistoryId, (String)"phm_filldata_history", (String)"id,status,spreadjson_tag,createtime,creator.id,modifier.id,modifytime");
        if (tempHistroy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8d44\u6e90\u4e0d\u5b58\u5728\u3002", (String)"WorkbenchBillPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        return tempHistroy;
    }

    @Override
    public void setStatus(String status) {
        this.getModel().setValue("status", (Object)status);
        boolean isLock = (Boolean)this.getView().getFormShowParameter().getCustomParam("isLock");
        if (isLock) {
            return;
        }
        if (StatusEnum.SAVE.getValue().equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"save", "submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"audit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"save", "submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"unsubmit"});
        } else if (StatusEnum.SUBMIT.getValue().equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"submit", "audit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmit", "audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "unaudit"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"audit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"save", "submit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"unaudit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"audit"});
        }
    }

    @Override
    public void actionSave(String spreadJson) {
        String processResourceId = this.getPageCache().get("processResourceId");
        String isCopy = (String)this.getView().getFormShowParameter().getCustomParam("isCopy");
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (StringUtils.isBlank((CharSequence)isCopy)) {
                    this.clearErrorMsg(ProcessErrorTypeEnum.MANUAL_SAVE_ERR.getValue());
                }
                super.actionSave(spreadJson);
                if (StringUtils.isBlank((CharSequence)processResourceId)) {
                    DynamicObject newResourceData = this.newResourceData();
                    newResourceData.set("resource_status", (Object)StatusEnum.SAVE.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newResourceData});
                    this.getPageCache().put("processResourceId", newResourceData.getPkValue().toString());
                } else {
                    SaveServiceHelper.update((DynamicObject)this.getResourceData(Long.parseLong(processResourceId)));
                }
                this.updateTaskStatus();
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)isCopy)) {
                this.addErrorMsg(e, ProcessErrorTypeEnum.MANUAL_SAVE_ERR);
            }
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
            }
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"WorkbenchBillPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    @Override
    public void actionSubmit(String spreadJson) {
        String processResourceId = this.getPageCache().get("processResourceId");
        String isCopy = (String)this.getView().getFormShowParameter().getCustomParam("isCopy");
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (StringUtils.isBlank((CharSequence)isCopy)) {
                    this.clearErrorMsg(ProcessErrorTypeEnum.MANUAL_SUBMIT_ERR.getValue());
                }
                super.actionSubmit(spreadJson);
                if (StringUtils.isBlank((CharSequence)processResourceId)) {
                    DynamicObject newResourceData = this.newResourceData();
                    newResourceData.set("resource_status", (Object)StatusEnum.SUBMIT.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newResourceData});
                    this.getPageCache().put("processResourceId", newResourceData.getPkValue().toString());
                } else {
                    this.updateResourceData(Long.parseLong(processResourceId), StatusEnum.SUBMIT);
                }
                this.updateTaskStatus();
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)isCopy)) {
                this.addErrorMsg(e, ProcessErrorTypeEnum.MANUAL_SUBMIT_ERR);
            }
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
            }
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"WorkbenchBillPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    @Override
    protected void actionUnSubmit() {
        super.actionUnSubmit();
        String processResourceId = this.getPageCache().get("processResourceId");
        this.updateResourceData(Long.parseLong(processResourceId), StatusEnum.SAVE);
    }

    @Override
    public void actionAudit(String spreadJson) {
        int isCheckNodeTaskFinish = 0;
        Long entryId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeEntryId");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String processResourceId = this.getPageCache().get("processResourceId");
        Long processhistoryId = (Long)formShowParameter.getCustomParam("processHistoryId");
        Long nodeResourceId = StringUtils.isBlank((CharSequence)processResourceId) ? null : Long.valueOf(processResourceId);
        String fromForm = (String)formShowParameter.getCustomParam("fromForm");
        String isCopy = (String)this.getView().getFormShowParameter().getCustomParam("isCopy");
        try (TXHandle h2 = TX.requiresNew();){
            long historyId = (Long)this.getModel().getValue("history");
            if (StringUtils.isBlank((CharSequence)isCopy)) {
                if (StringUtils.equals((CharSequence)"task_list", (CharSequence)fromForm) && ProcessCalcLogService.hasErrorLog((Long)processhistoryId, null, (Long)nodeResourceId) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u51fa\u73b0\u5f02\u5e38,\u6682\u4e0d\u80fd\u5ba1\u6838\u3002", (String)"WorkbenchBillPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.clearErrorMsg(null);
                QFilter qFilter = new QFilter("id", "=", (Object)historyId);
                DynamicObject history = QueryServiceHelper.queryOne((String)"phm_filldata_history", (String)"id,status", (QFilter[])qFilter.toArray());
                if (history == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7684\u3002", (String)"WorkbenchBillPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String stauts = history.getString("status");
                if (!StringUtils.equals((CharSequence)"B", (CharSequence)stauts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7684\u3002", (String)"WorkbenchBillPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)historyId, (String)"phm_filldata_history");
            dynamicObject.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("status", (Object)StatusEnum.AUDIT.getValue());
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            this.setStatus(StatusEnum.AUDIT.getValue());
            this.updateResourceData(Long.parseLong(processResourceId), StatusEnum.AUDIT);
            Object nodeOrgStatus = this.getView().getFormShowParameter().getCustomParam("nodeOrgStatus");
            log.info("\u4e1a\u52a1\u5de5\u4f5c\u53f0\u5355\u636e\u754c\u9762\u5ba1\u6838:isCopy: {}, nodeOrgStatus: {}", (Object)isCopy, nodeOrgStatus);
            if (StringUtils.isNotBlank((CharSequence)isCopy)) {
                return;
            }
            try {
                if (!RunningState.COMPLETED.getValue().equals(nodeOrgStatus)) {
                    boolean isFinish;
                    Long resource = (Long)this.getView().getFormShowParameter().getCustomParam("resource");
                    isCheckNodeTaskFinish = ProcessUpdateUtil.updateTaskProgress((Long)entryId, (Long)resource, (int)1, (String)"1");
                    if (nodeOrgStatus == null && isCheckNodeTaskFinish != 0 && (isFinish = ProcessQueryUtil.queryNodeFinish((Long)entryId))) {
                        ProcessUpdateUtil.updateNodeStatusByNodeEntryId((Long)entryId, (String)RunningState.COMPLETED.getValue());
                        Long processHistoryId = (Long)formShowParameter.getCustomParam("processHistoryId");
                        ProcessUpdateUtil.processFinish((Long)processHistoryId);
                    }
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"WorkbenchBillPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getSpreadContainer().rebuildSpread(dynamicObject.getString("spreadjson_tag"));
            }
            catch (Exception e) {
                h2.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)isCopy)) {
                this.addErrorMsg(e, ProcessErrorTypeEnum.MANUAL_AUDIT_ERR);
            }
            if (e instanceof KDBizException) {
                this.getView().showErrorNotification(e.getMessage());
            }
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"WorkbenchBillPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        if (isCheckNodeTaskFinish == 2) {
            boolean fromEvent = StringUtils.equals((CharSequence)"event_list", (CharSequence)fromForm);
            ProcessUpdateUtil.startWaitTask((Long)entryId, (boolean)fromEvent);
        }
    }

    private void actionUnAudit() {
        try (TXHandle txHandle = TX.requiresNew();){
            Object dataTemplateHistoryId = this.getModel().getValue("history");
            QFilter qFilter = new QFilter("id", "=", dataTemplateHistoryId);
            DynamicObject history = QueryServiceHelper.queryOne((String)"phm_filldata_history", (String)"id,status", (QFilter[])qFilter.toArray());
            if (!StatusEnum.AUDIT.getValue().equals(history.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u53cd\u5ba1\u6838\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u3002", (String)"WorkbenchBillPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                DynamicObject dataTemplateHistory = this.getUpdateDynamicObject(null, Long.parseLong(dataTemplateHistoryId.toString()));
                dataTemplateHistory.set("status", (Object)StatusEnum.SAVE.getValue());
                SaveServiceHelper.update((DynamicObject)dataTemplateHistory);
                String processResourceId = this.getPageCache().get("processResourceId");
                this.updateResourceData(Long.parseLong(processResourceId), StatusEnum.SAVE);
                Object nodeOrgStatus = this.getView().getFormShowParameter().getCustomParam("nodeOrgStatus");
                if (nodeOrgStatus == null) {
                    String isCopy = (String)this.getView().getFormShowParameter().getCustomParam("isCopy");
                    if (StringUtils.isBlank((CharSequence)isCopy)) {
                        Long entryId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeEntryId");
                        Long resource = (Long)this.getView().getFormShowParameter().getCustomParam("resource");
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"phm_process_node", (String)"node_status");
                        if (!RunningState.RUNNING.getValue().equals(dynamicObject.getString("node_status"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\"\u8282\u70b9\u72b6\u6001\"\u4e3a\u8fdb\u884c\u4e2d\u6216\u901a\u8fc7\u4e8b\u4ef6\u5904\u7406\u624d\u53ef\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"WorkbenchBillPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        }
                        ProcessUpdateUtil.updateTaskProgress((Long)entryId, (Long)resource, (int)-1, (String)"1");
                    }
                } else {
                    Long entryId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeEntryId");
                    Long resource = (Long)this.getView().getFormShowParameter().getCustomParam("resource");
                    if (!RunningState.COMPLETED.getValue().equals(nodeOrgStatus)) {
                        ProcessUpdateUtil.updateTaskProgress((Long)entryId, (Long)resource, (int)-1, (String)"1");
                    }
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw new KDBizException((Throwable)exception, PHMErrorCode.bizException, new Object[]{exception.getMessage()});
            }
        }
        this.setStatus(StatusEnum.SAVE.getValue());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"WorkbenchBillPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject newResourceData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"phm_process_resources");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt);
        dynamicObject.set("entry_node", formShowParameter.getCustomParam("nodeEntryId"));
        dynamicObject.set("resource_datatype", (Object)"phm_filldata_history");
        dynamicObject.set("resource_data", this.getModel().getValue("history"));
        dynamicObject.set("resource_type", (Object)"phm_billtemp");
        dynamicObject.set("resource_number", formShowParameter.getCustomParam("resource"));
        dynamicObject.set("resource_modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set("resource_modifytime", (Object)new Date());
        dynamicObject.set("resource_processhistory", formShowParameter.getCustomParam("processHistoryId"));
        dynamicObject.set("entry_node", formShowParameter.getCustomParam("nodeEntryId"));
        dynamicObject.set("resource_dealtype", formShowParameter.getCustomParam("dealType"));
        dynamicObject.set("resource_org", (Object)RequestContext.get().getOrgId());
        Object role = this.getView().getFormShowParameter().getCustomParam("role");
        if (role != null) {
            List list = SerializationUtils.fromJsonStringToList((String)role.toString(), Long.class);
            dynamicObject.set("resource_role", list.get(0));
        }
        return dynamicObject;
    }

    private DynamicObject getResourceData(Object processResourceId) {
        Object dataTemplateHistoryId = this.getModel().getValue("history");
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"phm_process_resources");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt, processResourceId);
        dynamicObject.set("resource_data", dataTemplateHistoryId);
        dynamicObject.set("resource_modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set("resource_modifytime", (Object)new Date());
        return dynamicObject;
    }

    private void updateResourceData(Object processResourceId, StatusEnum statusEnum) {
        DynamicObject resourceData = this.getResourceData(processResourceId);
        resourceData.set("resource_status", (Object)statusEnum.getValue());
        SaveServiceHelper.update((DynamicObject)resourceData);
    }

    private void clearErrorMsg(String errorType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object processResourceId = formShowParameter.getCustomParam("processResourceId");
        if (!StringUtils.equals((CharSequence)ProcessErrorTypeEnum.AUTO_AUDIT_ERR.getValue(), (CharSequence)errorType)) {
            processResourceId = null;
        }
        Long historyId = (Long)formShowParameter.getCustomParam("processHistoryId");
        Long nodeId = (Long)formShowParameter.getCustomParam("nodeEntryId");
        Long resourceId = (Long)formShowParameter.getCustomParam("resource");
        if (StringUtils.equals((CharSequence)ProcessErrorTypeEnum.AUTO_LOAD_ERR.getValue(), (CharSequence)errorType)) {
            QFilter qFilter = new QFilter("history", "=", (Object)historyId);
            qFilter.and(new QFilter("errortype", "=", (Object)ProcessErrorTypeEnum.AUTO_LOAD_ERR.getValue()));
            qFilter.and(new QFilter("node", "=", (Object)nodeId));
            qFilter.and(new QFilter("resourcetype", "=", (Object)ResourceTypeEnum.DATETEMP.getValue()));
            qFilter.and(new QFilter("resource", "=", (Object)resourceId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            boolean exists = QueryServiceHelper.exists((String)"phm_process_calclog", (QFilter[])qFilter.toArray());
            if (!exists) {
                return;
            }
        }
        List roleIds = (List)formShowParameter.getCustomParam("role");
        Object roleid = null;
        if (roleIds != null && !roleIds.isEmpty()) {
            roleid = roleIds.get(0);
        }
        Long roleId = roleid instanceof Integer ? Long.valueOf(Long.parseLong(roleid.toString())) : Long.valueOf(0L);
        Long nodeResourceId = processResourceId instanceof Integer ? null : (Long)processResourceId;
        ProcessCalcLogService.clearErrorLog((String)errorType, (Long)historyId, (Long)nodeId, (Long)nodeResourceId, (Long)resourceId, (Long)roleId);
        String isCopy = (String)this.getView().getFormShowParameter().getCustomParam("isCopy");
        if (StringUtils.isEmpty((CharSequence)isCopy)) {
            ProcessCalcLogService.clearProcessError((Long)historyId);
        }
    }

    private void addErrorMsg(Exception execption, ProcessErrorTypeEnum errorType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String processResourceId = this.getPageCache().get("processResourceId");
        Long historyId = (Long)formShowParameter.getCustomParam("processHistoryId");
        Long tempHistoryId = (Long)this.getModel().getValue("history");
        Long nodeId = (Long)formShowParameter.getCustomParam("nodeEntryId");
        Long resourceId = (Long)formShowParameter.getCustomParam("resource");
        List roleIds = (List)formShowParameter.getCustomParam("role");
        List roleIDs = roleIds.stream().map(item -> Long.parseLong(String.valueOf(item))).collect(Collectors.toList());
        Long nodeResourceId = StringUtils.isBlank((CharSequence)processResourceId) ? null : Long.valueOf(processResourceId);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String userName = RequestContext.get().getUserName();
        DynamicObjectCollection roles = (DynamicObjectCollection)this.getModel().getValue("role");
        DynamicObject role = roles == null || roles.isEmpty() ? null : (DynamicObject)roles.get(0);
        String roleName = role == null ? ResManager.loadKDString((String)"\u6d41\u7a0b\u8d1f\u8d23\u4eba", (String)"WorkbenchBillPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : role.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue();
        String nodeName = ProcessCalcLogService.getNodeName((Long)nodeId);
        String resourceName = (String)this.getModel().getValue("resname");
        String resourceNumber = (String)this.getModel().getValue("resnumber");
        ProcessCalcLogService service = new ProcessCalcLogService();
        String resourceVersionNumber = null;
        if (tempHistoryId != null && tempHistoryId != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)tempHistoryId);
            DynamicObject history = QueryServiceHelper.queryOne((String)"phm_filldata_history", (String)"number", (QFilter[])qFilter.toArray());
            resourceVersionNumber = history == null ? null : history.getString("number");
        }
        service.createErrorLog(errorType, DealTypeEnum.MANUAL, historyId, nodeId, nodeName, nodeResourceId, ResourceTypeEnum.DATETEMP.getValue(), resourceId, resourceName, resourceVersionNumber, resourceNumber, roleIDs, roleName, userId, userName, null, ProcessCalcLogService.getExceptionMsg((Exception)execption), null, null);
        service.clearCurrentErrorLog();
        service.insertErrorLog();
    }

    private void updateTaskStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String sourceType = (String)formShowParameter.getCustomParam("sourceType");
        if (!"task".equals(sourceType)) {
            return;
        }
        long nodeEntryId = (Long)formShowParameter.getCustomParam("nodeEntryId");
        long resourceId = (Long)formShowParameter.getCustomParam("resource");
        QFilter[] filters = new QFilter[]{new QFilter("entry_node", "=", (Object)nodeEntryId), new QFilter("datasourceid", "=", (Object)resourceId)};
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"phm_process_task", (String)"task_status", (QFilter[])filters);
        String status = task.getString("task_status");
        if (TaskStatusEnum.UNPROCESS.getValue().equals(status)) {
            task.set("task_status", (Object)TaskStatusEnum.PROCESSING.getValue());
            SaveServiceHelper.update((DynamicObject)task);
        }
    }
}

