/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.mmc.phm.common.enums.WorkbenchSubType;
import kd.mmc.phm.common.serviece.flow.FlowDefineService;
import kd.mmc.phm.common.util.ShowFormUtils;
import kd.mmc.phm.common.util.basedata.RoleUtils;
import kd.mmc.phm.common.util.process.TaskProgressUtil;

public class WorkbenchEventListPlugin
extends AbstractListPlugin {
    private static final String ENVETDEAL = "eventdeal";
    private static final String EVENTCLOSE = "eventclose";
    private static final String EVENTCONFIRM = "eventconfirm";
    private static final String PHM_EVENTDEAL = "phm_eventdeal";
    private static final String EVENTDEALCLOSE = "eventDealClose";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_node"));
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_main"));
        String eventId = this.getView().getParentView().getPageCache().get("eventId");
        this.getView().setVisible(Boolean.TRUE, new String[]{ENVETDEAL, EVENTCLOSE, EVENTCONFIRM});
        if (WorkbenchSubType.EVENT_UNPROCESSED.getValue().equals(eventId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENVETDEAL, EVENTCLOSE});
        } else if (WorkbenchSubType.EVENT_PROCESSING.getValue().equals(eventId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EVENTCONFIRM});
        } else if (WorkbenchSubType.EVENT_PROCESSED.getValue().equals(eventId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENVETDEAL, EVENTCLOSE, EVENTCONFIRM});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qfliters = e.getQFilters();
        qfliters.removeIf(qFilter -> "status".equals(qFilter.getProperty()));
        String eventStatus = this.getView().getParentView().getPageCache().get("eventId");
        if (eventStatus != null && !WorkbenchSubType.EVENT_ALL.getValue().equals(eventStatus)) {
            qfliters.add(new QFilter("status", "=", (Object)eventStatus));
        }
        long userID = Long.parseLong(RequestContext.get().getUserId());
        List currentUserRoles = RoleUtils.listRoleByUser((long)userID);
        QFilter roleQFilter = new QFilter("event_repositoryrole.fbasedataid", "in", (Object)currentUserRoles);
        List flowIds = FlowDefineService.getFlowDefineIdByLeaderId((Long)userID);
        if (flowIds != null && !flowIds.isEmpty()) {
            roleQFilter.or(new QFilter("event_processid.process.id", "in", (Object)flowIds));
        }
        qfliters.add(roleQFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (ENVETDEAL.equals(operateKey) && operationResult.getValidateResult().isSuccess()) {
            TaskInfo taskInfo;
            ListSelectedRowCollection selects = billList.getSelectedRows();
            ListSelectedRow listSelectedRow = selects.get(0);
            Long primaryKey = (Long)listSelectedRow.getPrimaryKeyValue();
            WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            Long currentUserId = RequestContext.get().getCurrUserId();
            String billId = this.getBillId(primaryKey);
            Long taskId = service.getTaskIdByBusinessKeyAndUserId(billId, currentUserId);
            boolean isShowErrorNotification = true;
            if (null != taskId && taskId != 0L && null != (taskInfo = service.findTaskById(taskId))) {
                isShowErrorNotification = false;
                FormShowParameter parameter = new FormShowParameter();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("taskId", taskId);
                customParams.put("type", "toHandle");
                parameter.setCustomParams(customParams);
                parameter.setFormId(taskInfo.getProcessingPage());
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "flowClose"));
                parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                this.getView().showForm(parameter);
            }
            if (isShowErrorNotification) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u5355\u636e\u6ca1\u6709\u4f60\u7684\u5ba1\u6279\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkbenchEventListPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                billList.refresh();
            }
        } else if (EVENTCONFIRM.equals(operateKey) && operationResult.getValidateResult().isSuccess()) {
            billList.refresh();
        } else if (EVENTCLOSE.equals(operateKey) && operationResult.getValidateResult().isSuccess()) {
            billList.refresh();
        }
    }

    private String getBillId(Long primaryKey) {
        DynamicObject query = QueryServiceHelper.queryOne((String)"phm_process_event", (String)"tasknotic", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKey)});
        if (query != null) {
            return query.getString("tasknotic");
        }
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)ENVETDEAL, (CharSequence)formOperate.getOperateKey()) && (listSelectedData = args.getListSelectedData()).size() > 1) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\uff01", (String)"WorkbenchEventListPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\uff01", (String)"WorkbenchEventListPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        Object returnData = callBackEvent.getReturnData();
        if (returnData != null && EVENTDEALCLOSE.equals(actionId)) {
            Map customParams = (Map)returnData;
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_workbench_bill", (Map)customParams, null, (ShowType)ShowType.MainNewTabPage);
            Long resourceId = (Long)customParams.get("resource");
            List roleidList = (List)customParams.get("role");
            Long processHistoryId = (Long)customParams.get("processHistoryId");
            Long nodeEntryId = (Long)customParams.get("nodeEntryId");
            formShowParameter.setCustomParam("fromForm", (Object)"event_list");
            formShowParameter.setPageId(TaskProgressUtil.getUniqueKey((IFormView)this.getView(), (Long)resourceId, (Long)((Long)roleidList.get(0)), (Long)processHistoryId, (Long)nodeEntryId));
            this.getView().showForm(formShowParameter);
        }
    }
}

