/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.workbench;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.phm.common.enums.WorkbenchSubType;
import kd.mmc.phm.common.errorcode.PHMErrorCode;
import kd.mmc.phm.common.info.WorkbenchProperty;

public class WorkbenchPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
TabSelectListener,
TreeNodeClickListener {
    private static final String ALGO_KEY = "WorkbenchPlugin.";
    private static final String TAB = "tabap";
    private static final String LIST_BOX = "listboxap";
    private static final String TREE_VIEW = "treeviewap";
    private static final String PANEL_CONTENT = "panel_content";
    private static final String ENTITY_PROP = "phm_workbench_prop";
    private static final String CACHEKEY_TASKID = "taskId";
    private static final String CACHEKEY_EVENTID = "eventId";
    private static final String CACHEKEY_PROPERTIES = "workbenchProperties";
    private static final String CACHEKEY_EVENTVIEW_PAGEID = "eventViewPageId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
        Listbox listbox = (Listbox)this.getControl(LIST_BOX);
        listbox.addListboxClickListener((ListboxClickListener)this);
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTreeViewAndListbox();
    }

    private void initTreeViewAndListbox() {
        String selectFields = "type, number, name, parent.number parentNumber, bizobject.number bizObjectNumber, bizobject.modeltype bizObjectType, templateobject.number templateObjectNumber";
        String orderBy = "priority asc";
        QFilter[] filters = new QFilter[]{new QFilter("isshow", "=", (Object)Character.valueOf('1'))};
        try (DataSet dataSet = ORM.create().queryDataSet("WorkbenchPlugin.getWorkbenchProp", ENTITY_PROP, selectFields, filters, orderBy);){
            if (!dataSet.hasNext()) {
                return;
            }
            TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"WorkbenchPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            rootNode.setIsOpened(true);
            HashMap<String, TreeNode> id2TreeNode = new HashMap<String, TreeNode>(16);
            HashMap<String, WorkbenchProperty> workbenchProperties = new HashMap<String, WorkbenchProperty>(16);
            ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
            for (Row row : dataSet) {
                String number = row.getString("number");
                String name = row.getString("name");
                if ("task".equals(row.getString("type"))) {
                    TreeNode treeNode;
                    String parentNodeId = row.getString("parentNumber");
                    if (StringUtils.isBlank((CharSequence)parentNodeId)) {
                        treeNode = new TreeNode(rootNode.getId(), number, name);
                        id2TreeNode.put(number, treeNode);
                    } else {
                        TreeNode parentNode = id2TreeNode.getOrDefault(parentNodeId, rootNode);
                        treeNode = new TreeNode(parentNodeId, number, name);
                        parentNode.addChild(treeNode);
                    }
                    treeNode.setIsOpened(true);
                    String bizObjectNumber = row.getString("bizObjectNumber");
                    if (!StringUtils.isNotBlank((CharSequence)bizObjectNumber)) continue;
                    WorkbenchProperty workbenchProperty = new WorkbenchProperty();
                    workbenchProperty.setMainObjectNumber(bizObjectNumber);
                    workbenchProperty.setMainObjectType(row.getString("bizObjectType"));
                    workbenchProperty.setTemplateObjectNumber(row.getString("templateObjectNumber"));
                    workbenchProperties.put(number, workbenchProperty);
                    continue;
                }
                listboxItems.add(new ListboxItem(number, name));
            }
            this.getPageCache().put(CACHEKEY_PROPERTIES, SerializationUtils.toJsonString(workbenchProperties));
            Listbox listbox = (Listbox)this.getControl(LIST_BOX);
            listbox.addItems(listboxItems);
            rootNode.setChildren((List)Lists.newArrayList(id2TreeNode.values()));
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
            treeView.addNode(rootNode);
            TreeNode defaultNode = rootNode.getTreeNode(WorkbenchSubType.TASK_PROCESS.getValue(), 15);
            if (defaultNode != null) {
                treeView.focusNode(defaultNode);
                treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
                treeView.treeNodeClick(defaultNode.getParentid(), defaultNode.getId());
            }
        }
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        this.getPageCache().put(CACHEKEY_EVENTID, itemId);
        ListView eventView = (ListView)this.getView().getView(this.getPageCache().get(CACHEKEY_EVENTVIEW_PAGEID));
        BillList billList = (BillList)eventView.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
        this.getView().sendFormAction((IFormView)eventView);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tab_event".equals(tabKey)) {
            String eventId = this.getPageCache().get(CACHEKEY_EVENTID);
            if (eventId == null) {
                eventId = WorkbenchSubType.EVENT_ALL.getValue();
            }
            Listbox listbox = (Listbox)this.getControl(LIST_BOX);
            listbox.activeItem(eventId);
            this.showEventForm(eventId);
        } else {
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
            treeView.treeNodeClick("fromEventTab", this.getPageCache().get(CACHEKEY_TASKID));
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String cacheNodeId = this.getPageCache().get(CACHEKEY_TASKID);
        if (!"fromEventTab".equals(evt.getParentNodeId().toString()) && StringUtils.equals((CharSequence)nodeId, (CharSequence)cacheNodeId)) {
            return;
        }
        this.getPageCache().put(CACHEKEY_TASKID, nodeId);
        Map<String, WorkbenchProperty> workbenchProperties = this.getWorkbenchProperties();
        WorkbenchProperty workbenchProperty = workbenchProperties.get(nodeId);
        if (workbenchProperty == null) {
            return;
        }
        String mainObjectType = workbenchProperty.getMainObjectType();
        if ("BaseFormModel".equals(mainObjectType) || "BillFormModel".equals(mainObjectType)) {
            this.showBaseOrBillDataForm(workbenchProperty);
        } else if ("DynamicFormModel".equals(mainObjectType)) {
            this.showDynamicForm(workbenchProperty);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u70b9\u51fb\u8282\u70b9\u627e\u4e0d\u5230\u5bf9\u5e94\u754c\u9762, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"WorkbenchPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showDynamicForm(WorkbenchProperty workbenchProperty) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(workbenchProperty.getMainObjectNumber());
        formShowParameter.setShowTitle(true);
        formShowParameter.setHasRight(true);
        formShowParameter.setOpenStyle(this.getOpenStyle());
        this.getView().showForm(formShowParameter);
    }

    private void showBaseOrBillDataForm(WorkbenchProperty workbenchProperty) {
        String formId;
        ListShowParameter listShowParameter = new ListShowParameter();
        String mainObjectNumber = workbenchProperty.getMainObjectNumber();
        String templateObjectNumber = workbenchProperty.getTemplateObjectNumber();
        if (templateObjectNumber == null) {
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)mainObjectNumber);
            formId = formConfig.getListFormId();
        } else {
            formId = templateObjectNumber;
        }
        Control obj = this.getControl(TREE_VIEW);
        listShowParameter.setFormId(formId);
        listShowParameter.setBillFormId(mainObjectNumber);
        listShowParameter.setShowTitle(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setOpenStyle(this.getOpenStyle());
        listShowParameter.setCustomParam("type", (Object)((TreeView)obj).getTreeState().getFocusNodeId());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showEventForm(String eventId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        String billFormId = "phm_process_event";
        listShowParameter.setBillFormId(billFormId);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)billFormId);
        listShowParameter.setFormId(formConfig.getListFormId());
        listShowParameter.setShowTitle(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setOpenStyle(this.getOpenStyle());
        if (!WorkbenchSubType.EVENT_ALL.getValue().equals(eventId)) {
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("status", "=", (Object)eventId));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
        this.getPageCache().put(CACHEKEY_EVENTVIEW_PAGEID, listShowParameter.getPageId());
    }

    private OpenStyle getOpenStyle() {
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(PANEL_CONTENT);
        return openStyle;
    }

    private Map<String, WorkbenchProperty> getWorkbenchProperties() {
        String cacheStr = this.getPageCache().get(CACHEKEY_PROPERTIES);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return Collections.emptyMap();
        }
        TypeReference<HashMap<String, WorkbenchProperty>> typeReference = new TypeReference<HashMap<String, WorkbenchProperty>>(){};
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (Map)objectMapper.readValue(cacheStr, (TypeReference)typeReference);
        }
        catch (JsonProcessingException e) {
            throw new KDBizException((Throwable)e, PHMErrorCode.serializationFailed, new Object[]{e.getMessage()});
        }
    }
}

