/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.webapi;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.bizmodel.DetailStyle;
import kd.mmc.phm.common.bizmodel.DetailTable;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.common.util.TableUtils;

public class ModelApiUtils {
    public static String dealData(Object bizmodeid, Object result) {
        if (result instanceof Map) {
            Map datas = (Map)result;
            HashMap params = Maps.newHashMapWithExpectedSize((int)3);
            params.put("Action", "showAll");
            List<DetailTable> detailTables = ModelApiUtils.getDetailTable(datas, bizmodeid);
            params.put("details", detailTables);
            Map<String, DetailTable> details = detailTables.stream().collect(Collectors.toMap(DetailTable::getId, detailTable -> detailTable));
            Map handledEigenvalue = DesignerUtils.getHandledEigenvalue((Map)datas, (Object)bizmodeid);
            Map formatEigenvalue = DesignerUtils.getFormatEigenvalue((Map)handledEigenvalue);
            params.put("eigenvalues", JSONObject.toJSONString((Object)formatEigenvalue));
            return SerializationUtils.toJsonString((Object)params);
        }
        return null;
    }

    private static List<DetailTable> getDetailTable(Map<String, Serializable> datas, Object bizmodeid) {
        long bizModelId = Long.parseLong(bizmodeid.toString());
        Map componentInfoMap = DesignerUtils.wrapperComponentInfo((long)bizModelId);
        return datas.entrySet().stream().filter(entry -> StringUtils.startsWith((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"detail")).map(entry -> {
            ComponentInfo componentInfo = (ComponentInfo)componentInfoMap.get(entry.getKey());
            return ModelApiUtils.wrapperDetailTable((Serializable)entry.getValue(), componentInfo, false);
        }).collect(Collectors.toList());
    }

    private static DetailTable wrapperDetailTable(Serializable value, ComponentInfo componentInfo, boolean isDrilling) {
        Map properties = componentInfo.getProperties();
        Tuple<Map<String, String>, Set<String>> detailConfiguration = ModelApiUtils.getDetailConfiguration(properties, isDrilling);
        DetailStyle detailStyle = DesignerUtils.wrapperDetailStyle((Map)properties);
        DetailTable detailTable = TableUtils.initDetailTable((int)detailStyle.getPageSize(), (JSONObject)((JSONObject)value), detailConfiguration);
        detailTable.setId(componentInfo.getComponentId());
        detailTable.setRunning(true);
        boolean hide = (Boolean)properties.get("hide_runtime");
        detailTable.setHide(hide);
        detailTable.setStyle(detailStyle);
        return detailTable;
    }

    private static Tuple<Map<String, String>, Set<String>> getDetailConfiguration(Map<String, Object> properties, boolean isDrilling) {
        LinkedHashMap<String, String> fieldNameMap = new LinkedHashMap<String, String>(16);
        HashSet<String> relationFields = new HashSet<String>();
        String dataJson = (String)properties.get("field_set_data_tag");
        if (StringUtils.isNotBlank((CharSequence)dataJson)) {
            String entryentity = "field_entryentity";
            String nameField = "field_name";
            String aliasField = "field_alias";
            if (isDrilling) {
                entryentity = "drilling_entryentity";
                nameField = "drilling_name";
                aliasField = "drilling_alias";
            }
            Object[] fieldSets = DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
            DynamicObject detailFieldSet = (DynamicObject)fieldSets[0];
            DynamicObjectCollection entryColls = detailFieldSet.getDynamicObjectCollection(entryentity);
            for (DynamicObject entryData : entryColls) {
                fieldNameMap.put(entryData.getString(nameField), entryData.getString(aliasField));
            }
            if (!isDrilling) {
                DynamicObjectCollection drillingEntryentity = detailFieldSet.getDynamicObjectCollection("drilling_entryentity");
                for (DynamicObject entry : drillingEntryentity) {
                    String relationField = entry.getString("drilling_relation");
                    if (!StringUtils.isNotBlank((CharSequence)relationField)) continue;
                    relationFields.add(relationField);
                }
            }
        }
        return Tuple.create(fieldNameMap, relationFields);
    }
}

