/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.business.helper;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import org.apache.commons.collections4.MapUtils;

public final class OperationHelper {
    public static void executeOperateWithBusyTip(IFormView formView, Runnable runnable) {
        try {
            formView.showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c...", (String)"OperationHelper_0", (String)"mmc-pmpd-business", (Object[])new Object[0])));
            runnable.run();
        }
        finally {
            formView.hideLoading();
        }
    }

    public static void showOperationResult(IFormView formView, OperationResult operationResult, String entityNumber, String operationKey) {
        Map<String, Object> operationMap = OperationHelper.getOperationMap(entityNumber, operationKey);
        if (operationResult.isSuccess() && operationResult.getAllErrorOrValidateInfo().isEmpty() && StringUtils.isBlank((CharSequence)operationResult.getMessage())) {
            String operationSuccessMsg = OperationHelper.getOperationSuccessMsg(operationMap);
            if (StringUtils.isBlank((CharSequence)operationSuccessMsg)) {
                formView.showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"OperationHelper_1", (String)"mmc-pmpd-business", (Object[])new Object[0]), OperationHelper.getOperationName(operationMap)));
            } else {
                formView.showSuccessNotification(operationSuccessMsg);
            }
        } else {
            formView.showOperationResult(operationResult, OperationHelper.getOperationName(operationMap));
        }
    }

    private static Map<String, Object> getOperationMap(String entityNumber, String operationKey) {
        return EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operationKey);
    }

    private static String getOperationSuccessMsg(Map<String, Object> operationMap) {
        return OperationHelper.getOperationLocaleValue("successMsg", operationMap);
    }

    public static String getOperationName(Map<String, Object> operationMap) {
        return OperationHelper.getOperationLocaleValue("name", operationMap);
    }

    private static String getOperationLocaleValue(String key, Map<String, Object> operationMap) {
        if (MapUtils.isEmpty(operationMap)) {
            return "";
        }
        Object name = operationMap.get(key);
        if (name instanceof Map) {
            Map nameMap = (Map)name;
            return nameMap.getOrDefault(Lang.get().toString(), "");
        }
        return "";
    }

    public static void mergeOperationResultError(OperationResult targetResult, OperationResult sourceResult) {
        targetResult.getSuccessPkIds().clear();
        List allErrorInfo = targetResult.getAllErrorInfo();
        allErrorInfo.addAll(sourceResult.getAllErrorInfo());
        List validateErrors = sourceResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateError : validateErrors) {
            targetResult.getValidateResult().addValidateError(validateError.getValidatorKey(), validateError);
        }
    }

    public static OperateErrorInfo buildSingleErrorInfo(ExtendedDataEntity extendedDataEntity, String errorMsg) {
        ValidationErrorInfo errorInfo = OperationHelper.getValidationErrorInfo(extendedDataEntity, null);
        errorInfo.setMessage(errorMsg);
        return errorInfo;
    }

    public static OperateErrorInfo buildMultiErrorInfo(ExtendedDataEntity extendedDataEntity, String title, String errorMsg) {
        ValidationErrorInfo errorInfo = OperationHelper.getValidationErrorInfo(extendedDataEntity, title);
        errorInfo.setMessage(String.format("%1$s\uff1a  %2$s", extendedDataEntity.getBillNo(), errorMsg));
        return errorInfo;
    }

    private static ValidationErrorInfo getValidationErrorInfo(ExtendedDataEntity extendedDataEntity, String title) {
        ValidationErrorInfo errorInfo = new ValidationErrorInfo();
        errorInfo.setPkValue(extendedDataEntity.getBillPkId());
        errorInfo.setRowIndex(extendedDataEntity.getRowIndex());
        errorInfo.setDataEntityIndex(extendedDataEntity.getDataEntityIndex());
        errorInfo.setErrorCode(extendedDataEntity.getDataEntity().getDataEntityType().getName());
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setTitle(title);
        return errorInfo;
    }
}

