/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.business.workhour;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.pmc.pmpd.business.workhour.WorkHourTemplateHelper;
import kd.pmc.pmpd.common.model.DailySummaryResult;
import kd.pmc.pmpd.common.model.EstimateContext;

public class WorkHourEstimateHelper {
    private static final Log LOG = LogFactory.getLog(WorkHourEstimateHelper.class);

    @Deprecated
    public static void reestimateByResourcePlan(List<String> resourcePlanNos) {
    }

    public static void estimateWorkHour(boolean isEstimate, DynamicObject workHourEstimateBill, BiConsumer<Date, DailySummaryResult> biConsumer) {
        EstimateContext estimateContext = EstimateContext.get();
        DynamicObjectCollection industryEntryEntity = workHourEstimateBill.getDynamicObjectCollection(estimateContext.getIndustryEntryKey());
        if (industryEntryEntity.isEmpty()) {
            return;
        }
        boolean clearData = estimateContext.getStartTime() == null || estimateContext.getTrt() == 0;
        for (DynamicObject industryEntry : industryEntryEntity) {
            DynamicObjectCollection dailyWorkHourCollection = industryEntry.getDynamicObjectCollection(estimateContext.getDailyWorkHourEntryKey());
            dailyWorkHourCollection.clear();
            if (clearData) continue;
            long industryId = industryEntry.getLong(estimateContext.getIndustryIdKey());
            long industryOneId = industryEntry.getLong(estimateContext.getIndustryOneIdKey());
            BigDecimal totalHours = industryEntry.getBigDecimal(estimateContext.getTotalHoursKey());
            WorkHourTemplateHelper.resetContext4Industry(estimateContext, industryOneId, industryId, totalHours);
            DynamicObjectCollection stageCollection = industryEntry.getDynamicObjectCollection(estimateContext.getStageWorkHourEntryKey());
            int maxIndex = stageCollection.size() - 1;
            for (int index = 0; index <= maxIndex; ++index) {
                DynamicObject stageEntry = (DynamicObject)stageCollection.get(index);
                BigDecimal percentage = stageEntry.getBigDecimal(estimateContext.getPercentageKey());
                BigDecimal currentTotalHours = totalHours.multiply(percentage);
                WorkHourTemplateHelper.estimate(index, maxIndex, currentTotalHours, dailyWorkHourCollection, isEstimate);
            }
        }
        DynamicObjectCollection summaryEntryEntity = workHourEstimateBill.getDynamicObjectCollection(estimateContext.getSummaryWorkHourEntryKey());
        summaryEntryEntity.clear();
        if (clearData) {
            return;
        }
        WorkHourEstimateHelper.addDailySummaryWorkHourEntryData(isEstimate, summaryEntryEntity, biConsumer);
    }

    private static void addDailySummaryWorkHourEntryData(boolean isEstimate, DynamicObjectCollection summaryEntryEntity, BiConsumer<Date, DailySummaryResult> biConsumer) {
        Map startDate2DailySummaryResult = EstimateContext.get().getStartDate2DailySummaryResult();
        if (isEstimate) {
            for (Map.Entry entry : startDate2DailySummaryResult.entrySet()) {
                Date date = (Date)entry.getKey();
                DailySummaryResult dailySummaryResult = (DailySummaryResult)entry.getValue();
                WorkHourTemplateHelper.addEstimateSummaryWorkHourEntryData(summaryEntryEntity, date, dailySummaryResult);
                if (biConsumer == null) continue;
                biConsumer.accept(date, dailySummaryResult);
            }
        } else {
            for (Map.Entry entry : startDate2DailySummaryResult.entrySet()) {
                Date date = (Date)entry.getKey();
                DailySummaryResult dailySummaryResult = (DailySummaryResult)entry.getValue();
                WorkHourTemplateHelper.addStandardSummaryWorkHourEntryData(summaryEntryEntity, date, dailySummaryResult);
                if (biConsumer == null) continue;
                biConsumer.accept(date, dailySummaryResult);
            }
        }
        startDate2DailySummaryResult.clear();
    }

    public static Map<Object, DynamicObject> getIndustryFromCache(Set<Long> industryIds) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"mpdm_professiona");
        EntityType subEntityType = dataEntityType.getSubEntityType((Collection)Sets.newHashSet((Object[])new String[]{"number", "seqnumtwo"}));
        return BusinessDataServiceHelper.loadFromCache((Object[])industryIds.toArray(), (DynamicObjectType)subEntityType);
    }

    public static void sortByIndustry(DynamicObjectCollection collection, Function<DynamicObject, DynamicObject> function) {
        collection.sort((o1, o2) -> {
            int nextIndustryTowSeq;
            DynamicObject currentIndustry = (DynamicObject)function.apply((DynamicObject)o1);
            DynamicObject nextIndustry = (DynamicObject)function.apply((DynamicObject)o2);
            if (currentIndustry == null) {
                return -1;
            }
            if (nextIndustry == null) {
                return 1;
            }
            int currentIndustryTowSeq = currentIndustry.getInt("seqnumtwo");
            int result = currentIndustryTowSeq - (nextIndustryTowSeq = nextIndustry.getInt("seqnumtwo"));
            if (result == 0) {
                return currentIndustry.getString("number").compareTo(nextIndustry.getString("number"));
            }
            return result;
        });
    }
}

