/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.business.workhour;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class WorkHourHelper {
    public static DataSet queryReportWorkHour(String resourcePlanNo) {
        List<Object> projectPks = WorkHourHelper.queryResourcePlanProjects(resourcePlanNo);
        if (CollectionUtils.isEmpty(projectPks)) {
            return null;
        }
        DataSet ds = WorkHourHelper.queryProcessReportPerson(projectPks);
        if (ds == null) {
            return null;
        }
        return ds.select("TO_CHAR(reportdate,'yyyy-MM-dd') reportdate,industry,activehours,seqnumtwo,industryno").groupBy(new String[]{"industry", "reportdate", "seqnumtwo", "industryno"}).sum("activehours").finish().orderBy(new String[]{"seqnumtwo", "industryno", "reportdate"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet queryProcessReportPerson(List<Object> projectPks) {
        QFilter qFilter = new QFilter("sumentry.project", "in", projectPks);
        qFilter.and(new QFilter("sumentry.childreportentity.personnelindustry", "!=", (Object)0L));
        qFilter.and("billstatus", "=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryProcessReportSumentryPks", (String)"sfc_processreportbill", (String)"sumentry.project pro,reportdate,sumentry.id sumentryid,sumentry.childreportentity.personnelindustry industry,sumentry.childreportentity.activehours activehours", (QFilter[])qFilter.toArray(), null);
        if (dataSet != null) {
            HashSet<Object> industryPks = new HashSet<Object>(10);
            DataSet copy = dataSet.copy();
            for (Row row : copy) {
                industryPks.add(row.get("industry"));
            }
            DataSet industrySqe = WorkHourHelper.queryIndustrySeq(industryPks);
            if (industrySqe != null) {
                try {
                    DataSet dataSet2 = dataSet.leftJoin(industrySqe).on("industry", "industryid").select(dataSet.getRowMeta().getFieldNames(), industrySqe.getRowMeta().getFieldNames()).finish();
                    return dataSet2;
                }
                finally {
                    industrySqe.close();
                }
            }
        }
        return dataSet;
    }

    public static DataSet queryIndustrySeq(Set<Object> industryPks) {
        QFilter filter = new QFilter("id", "in", industryPks);
        return QueryServiceHelper.queryDataSet((String)"queryIndustrySeq", (String)"mpdm_professiona", (String)"id industryid,number industryno,seqnumtwo", (QFilter[])filter.toArray(), null);
    }

    public static List<Object> queryResourcePlanProjects(String resourcePlanPk) {
        QFilter qFilter = new QFilter("billno", "in", (Object)resourcePlanPk);
        qFilter.and("pulishstatus", "=", (Object)"1");
        DynamicObjectCollection projects = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"entry_project.projcet", (QFilter[])qFilter.toArray());
        return projects.stream().filter(i -> i.getLong(0) != 0L).map(i -> i.get(0)).collect(Collectors.toList());
    }

    public static void updateReportWorkHour() {
        DynamicObjectCollection resourcePlans = WorkHourHelper.queryEnableResourcePlan();
        if (resourcePlans.isEmpty()) {
            return;
        }
        List<Object> hourEstimatePks = resourcePlans.stream().map(i -> i.get("estimatebill")).collect(Collectors.toList());
        WorkHourHelper.updateReportWorkHour(hourEstimatePks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateReportWorkHour(List<Object> workHourEstimateBillIds) {
        DynamicObject[] hourEstimates = WorkHourHelper.queryHourEstimates(workHourEstimateBillIds);
        List<String> resourcePlanNo = Stream.of(hourEstimates).map(i -> i.getString("resourceplan")).collect(Collectors.toList());
        Map<String, List<DynamicObject>> hourEstimateMap = Stream.of(hourEstimates).collect(Collectors.groupingBy(i -> i.getString("resourceplan")));
        DynamicObject[] updateResPlans = WorkHourHelper.queryResourcePlan(resourcePlanNo);
        if (updateResPlans.length == 0) {
            return;
        }
        Map<String, List<DynamicObject>> updateResPlanMap = Stream.of(updateResPlans).collect(Collectors.groupingBy(i -> i.getString("billno")));
        DataSet dataSet = WorkHourHelper.queryReportWorkHour(resourcePlanNo);
        for (DynamicObject hourEstimate : hourEstimates) {
            hourEstimate.getDynamicObjectCollection("r_entryentity").clear();
            hourEstimate.getDynamicObjectCollection("r_entryentity_summary").clear();
        }
        for (DynamicObject updateResPlan : updateResPlans) {
            updateResPlan.getDynamicObjectCollection("entry_report_workhour").clear();
        }
        if (dataSet == null) {
            SaveServiceHelper.save((DynamicObject[])hourEstimates);
            SaveServiceHelper.save((DynamicObject[])updateResPlans);
            return;
        }
        DataSet resSumDs = dataSet.copy().select("billno,reportdate,activehours").groupBy(new String[]{"billno", "reportdate"}).sum("activehours").finish().select("billno,TO_DATE(reportdate,'yyyy-MM-dd') reportdate,activehours").orderBy(new String[]{"reportdate"});
        try {
            String resPlanNo;
            String currentResourcePlanNo = null;
            List<DynamicObject> currentHourEstimate = null;
            long currentIndustry = 0L;
            dataSet = dataSet.select("billno,industry,TO_DATE(reportdate,'yyyy-MM-dd'),activehours");
            for (Row row : dataSet) {
                DynamicObjectCollection currentEntry;
                resPlanNo = row.getString(0);
                Long industry = (Long)row.get(1);
                if (industry == null || industry == 0L) continue;
                if (currentResourcePlanNo == null || !StringUtils.equals((CharSequence)currentResourcePlanNo, (CharSequence)resPlanNo)) {
                    currentResourcePlanNo = resPlanNo;
                    currentHourEstimate = hourEstimateMap.get(resPlanNo);
                    if (currentHourEstimate == null || currentHourEstimate.isEmpty()) continue;
                }
                if (currentHourEstimate == null || currentHourEstimate.isEmpty()) continue;
                if (currentIndustry == 0L || currentIndustry != industry) {
                    currentIndustry = industry;
                    for (DynamicObject currhourEstimate : currentHourEstimate) {
                        currentEntry = currhourEstimate.getDynamicObjectCollection("r_entryentity");
                        DynamicObject currentEntryObj = currentEntry.addNew();
                        currentEntryObj.set("r_industry_id", (Object)industry);
                        DynamicObject obj = currentEntryObj.getDynamicObjectCollection("r_subentryentity_daily").addNew();
                        obj.set("r_daily_industry_id", (Object)industry);
                        obj.set("r_daily_date", row.get(2));
                        obj.set("r_daily_workhour", row.get(3));
                    }
                    continue;
                }
                block7: for (DynamicObject currhourEstimate : currentHourEstimate) {
                    currentEntry = currhourEstimate.getDynamicObjectCollection("r_entryentity");
                    for (DynamicObject entryObj : currentEntry) {
                        long entryInd = entryObj.getLong("r_industry_id");
                        if (currentIndustry != entryInd) continue;
                        DynamicObject obj = entryObj.getDynamicObjectCollection("r_subentryentity_daily").addNew();
                        obj.set("r_daily_industry_id", (Object)industry);
                        obj.set("r_daily_date", row.get(2));
                        obj.set("r_daily_workhour", row.get(3));
                        continue block7;
                    }
                }
            }
            currentResourcePlanNo = null;
            for (Row row : resSumDs) {
                resPlanNo = row.getString(0);
                Object date = row.get(1);
                Object hour = row.get(2);
                List<DynamicObject> currentResPlans = updateResPlanMap.get(resPlanNo);
                if (currentResourcePlanNo == null || !StringUtils.equals((CharSequence)currentResourcePlanNo, (CharSequence)resPlanNo)) {
                    currentResourcePlanNo = resPlanNo;
                    currentHourEstimate = hourEstimateMap.get(resPlanNo);
                    if (currentHourEstimate == null || currentHourEstimate.isEmpty()) continue;
                }
                if (date == null || currentHourEstimate == null || currentHourEstimate.isEmpty()) continue;
                for (DynamicObject hourEstimate : currentHourEstimate) {
                    DynamicObject entry = hourEstimate.getDynamicObjectCollection("r_entryentity_summary").addNew();
                    entry.set("r_summary_date", date);
                    entry.set("r_summary_workhour", hour);
                }
                if (CollectionUtils.isEmpty(currentResPlans)) continue;
                for (DynamicObject currentResPlan : currentResPlans) {
                    DynamicObject rptHour = currentResPlan.getDynamicObjectCollection("entry_report_workhour").addNew();
                    rptHour.set("report_date", row.get(1));
                    rptHour.set("report_workhour", row.get(2));
                }
            }
            SaveServiceHelper.save((DynamicObject[])hourEstimates);
            SaveServiceHelper.save((DynamicObject[])updateResPlans);
        }
        finally {
            dataSet.close();
            resSumDs.close();
        }
    }

    public static DynamicObject[] queryHourEstimates(List<Object> hourEstimatePks) {
        QFilter filter = new QFilter("id", "in", hourEstimatePks);
        filter.and("effectivestatus", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"pmpd_hour_estimate", (String)"id,resourceplanid,resourceplan,r_entryentity.r_industry,r_subentryentity_daily.r_daily_industry,r_subentryentity_daily.r_daily_date,r_subentryentity_daily.r_daily_workhour,r_entryentity_summary.r_summary_date,r_entryentity_summary.r_summary_workhour", (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection queryEnableResourcePlan() {
        QFilter qFilter = new QFilter("executestatus", "=", (Object)"1");
        qFilter.or("executestatus", "=", (Object)"2");
        qFilter.and("pulishstatus", "=", (Object)"0");
        qFilter.and("estimatebill", "!=", (Object)0L);
        return QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id,estimatebill", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] queryResourcePlan(List<String> resourcePlanNo) {
        QFilter qFilter = new QFilter("billno", "in", resourcePlanNo);
        return BusinessDataServiceHelper.load((String)"pmpd_resourceplan", (String)"id,billno,entry_report_workhour.report_date,entry_report_workhour.report_workhour", (QFilter[])qFilter.toArray());
    }

    public static DataSet queryReportWorkHour(Collection<String> resourcePlanNos) {
        DataSet resourcePlanDs = WorkHourHelper.queryResourcePlanProjects(resourcePlanNos);
        if (resourcePlanDs.isEmpty()) {
            return null;
        }
        ArrayList<Object> projectPks = new ArrayList<Object>(10);
        DataSet copyResourcePlanDs = resourcePlanDs.copy();
        for (Row row : copyResourcePlanDs) {
            projectPks.add(row.get(1));
        }
        copyResourcePlanDs.close();
        DataSet ds = WorkHourHelper.queryProcessReportPerson(projectPks);
        if (ds == null) {
            return null;
        }
        return resourcePlanDs.leftJoin(ds).on("project", "pro").select(new String[]{"billno", "TO_CHAR(reportdate,'yyyy-MM-dd') reportdate", "industry", "activehours", "seqnumtwo", "industryno"}).finish().groupBy(new String[]{"billno", "industry", "reportdate", "seqnumtwo", "industryno"}).sum("activehours").finish().orderBy(new String[]{"billno", "seqnumtwo", "industryno", "reportdate"});
    }

    public static DataSet queryResourcePlanProjects(Collection<String> resourcePlanNos) {
        QFilter qFilter = new QFilter("billno", "in", resourcePlanNos);
        qFilter.and("pulishstatus", "=", (Object)"1");
        return QueryServiceHelper.queryDataSet((String)"queryResourcePlanProjects", (String)"pmpd_resourceplan", (String)"billno,entry_project.projcet project", (QFilter[])qFilter.toArray(), null);
    }
}

