/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.business.workhour;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.pmc.pmpd.business.workhour.WorkHourEstimateHelper;
import kd.pmc.pmpd.common.bigtask.JobFormInfoBuilder;
import kd.pmc.pmpd.common.bigtask.JobInfoBuilder;
import kd.pmc.pmpd.common.enums.ShiftSystemEnum;
import kd.pmc.pmpd.common.model.DailySummaryResult;
import kd.pmc.pmpd.common.model.EstimateContext;
import kd.pmc.pmpd.common.model.EstimatedBillChangeInfo;
import kd.pmc.pmpd.common.model.IndustryWorkHourModifiedData;
import kd.pmc.pmpd.common.model.StageTemplateModifiedData;
import kd.pmc.pmpd.common.model.WorkHourTemplateChangeTaskDto;
import org.apache.commons.collections4.CollectionUtils;

public final class WorkHourTemplateHelper {
    private static final String APP_ID = "25UOO50T1AI2";
    private static final String APP_NUMBER = "pmpd";
    private static final int BATCH_SIZE = 100;
    private static final Log LOG = LogFactory.getLog(WorkHourTemplateHelper.class);

    private WorkHourTemplateHelper() {
    }

    public static void afterAudit(AbstractFormPlugin formPlugin, String sourceEntityId, List<Long> workHourTemplateIds, long createOrgId) {
        LOG.info("{}sourceEntityId: {}, workHourTemplateIds: {}", new Object[]{WorkHourTemplateHelper.getTaskName(), sourceEntityId, workHourTemplateIds});
        boolean isEstimatedWorkHourTemplate = "pmpd_estimate_workhour".equals(sourceEntityId);
        Map<Long, List<IndustryWorkHourModifiedData>> templateId2ModifiedData = WorkHourTemplateHelper.getTemplateId2ModifiedData(sourceEntityId, isEstimatedWorkHourTemplate, workHourTemplateIds);
        if (templateId2ModifiedData.isEmpty()) {
            LOG.info("{}No modified data, sourceEntityId: {}, workHourTemplateIds: {}", (Object)WorkHourTemplateHelper.getTaskName(), workHourTemplateIds);
            return;
        }
        List<Object> estimatedBillIds = WorkHourTemplateHelper.getEstimatedBillIds(isEstimatedWorkHourTemplate, templateId2ModifiedData.keySet());
        LOG.info("{}EstimatedBillIds: {} workHourTemplateIds: {}", new Object[]{WorkHourTemplateHelper.getTaskName(), estimatedBillIds, templateId2ModifiedData.keySet()});
        int count = estimatedBillIds.size();
        if (count == 0) {
            return;
        }
        int batchSize = WorkHourTemplateHelper.getBatchSizeFromAppParam();
        LOG.info("{}batchSize: {}, workHourTemplateIds: {}", new Object[]{WorkHourTemplateHelper.getTaskName(), batchSize, templateId2ModifiedData.keySet()});
        if (count > batchSize) {
            WorkHourTemplateChangeTaskDto dto = WorkHourTemplateHelper.convertChangeTaskDto(isEstimatedWorkHourTemplate, createOrgId, templateId2ModifiedData, estimatedBillIds);
            WorkHourTemplateHelper.dispatch(formPlugin, dto);
        } else {
            Table<Long, Long, EstimatedBillChangeInfo> templateId2EstimatedBillTable = WorkHourTemplateHelper.getTemplateId2EstimatedBillTable(isEstimatedWorkHourTemplate, estimatedBillIds);
            try {
                WorkHourTemplateHelper.regenerateEstimatedBill(isEstimatedWorkHourTemplate, templateId2EstimatedBillTable.columnKeySet().toArray(), templateId2EstimatedBillTable);
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
            }
            finally {
                EstimateContext.remove();
            }
            long currUserId = RequestContext.get().getCurrUserId();
            WorkHourTemplateHelper.generateReportFromTemplate(isEstimatedWorkHourTemplate, currUserId, createOrgId, templateId2ModifiedData, templateId2EstimatedBillTable);
        }
    }

    public static void generateReportFromTemplate(boolean isEstimatedWorkHourTemplate, long currUserId, long createOrgId, Map<Long, List<IndustryWorkHourModifiedData>> templateId2ModifiedData, Table<Long, Long, EstimatedBillChangeInfo> templateId2EstimatedBillTable) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmpd_template_report");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)templateId2ModifiedData.size());
        Date now = new Date();
        for (Map.Entry<Long, List<IndustryWorkHourModifiedData>> entry : templateId2ModifiedData.entrySet()) {
            Long workHourTemplateId = entry.getKey();
            DynamicObject report = new DynamicObject((DynamicObjectType)dt);
            if (isEstimatedWorkHourTemplate) {
                report.set("estimate_workhour", (Object)workHourTemplateId);
                report.set("reason", (Object)"estimate_workhour");
            } else {
                report.set("stage_workhour", (Object)workHourTemplateId);
                report.set("reason", (Object)"stage_workhour");
            }
            report.set("date", (Object)now);
            report.set("operator", (Object)currUserId);
            report.set("creator", (Object)currUserId);
            report.set("billstatus", (Object)"A");
            report.set("org", (Object)createOrgId);
            Map rowMap = templateId2EstimatedBillTable.row((Object)workHourTemplateId);
            DynamicObjectCollection resourcePlanEntryEntity = report.getDynamicObjectCollection("resourceplan_entryentity");
            for (Map.Entry row : rowMap.entrySet()) {
                Long estimatedBillId = (Long)row.getKey();
                EstimatedBillChangeInfo estimatedBillChangeInfo = (EstimatedBillChangeInfo)row.getValue();
                DynamicObject reportEntry = resourcePlanEntryEntity.addNew();
                reportEntry.set("seq", (Object)resourcePlanEntryEntity.size());
                reportEntry.set("resourceplan", (Object)estimatedBillChangeInfo.getResourcePlanNo());
                reportEntry.set("resourceplanid", (Object)estimatedBillChangeInfo.getResourcePlanId());
                reportEntry.set("pre_estimatedbill", (Object)estimatedBillChangeInfo.getBillno());
                reportEntry.set("pre_estimatedbillid", (Object)estimatedBillId);
                reportEntry.set("cur_estimatedbill", (Object)estimatedBillChangeInfo.getNewBillno());
                reportEntry.set("cur_estimatedbillid", (Object)estimatedBillChangeInfo.getNewId());
            }
            WorkHourTemplateHelper.addReportEntry(report, entry.getValue());
            result.add(report);
        }
        if (result.isEmpty()) {
            return;
        }
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"pmpd_template_report", (DynamicObject[])result.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            WorkHourTemplateHelper.sendMessage(isEstimatedWorkHourTemplate, currUserId, (DynamicObject)result.get(0));
        }
    }

    private static void sendMessage(boolean isEstimatedWorkHourTemplate, long currUserId, DynamicObject report) {
        DynamicObject workHourTemplate;
        String templateFormId;
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5de5\u65f6\u6a21\u677f\u53d8\u66f4\u63d0\u9192", (String)"WorkHourTemplateHelper_2", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])));
        String domainContextUrl = UrlService.getDomainContextUrl();
        String reportUrl = domainContextUrl + String.format("/index.html?formId=%1$s&pkId=%2$s", "pmpd_template_report", report.getPkValue());
        if (isEstimatedWorkHourTemplate) {
            templateFormId = "pmpd_estimate_workhour";
            workHourTemplate = BusinessDataServiceHelper.loadSingleFromCache((Object)report.getLong("estimate_workhour"), (String)templateFormId, (String)"number");
        } else {
            templateFormId = "pmpd_stage_workhour";
            workHourTemplate = BusinessDataServiceHelper.loadSingleFromCache((Object)report.getLong("stage_workhour"), (String)templateFormId, (String)"number");
        }
        String templateNumber = workHourTemplate.getString("number");
        String templateUrl = domainContextUrl + String.format("/index.html?formId=%1$s&pkId=%2$s", templateFormId, workHourTemplate.getPkValue());
        String reportBillno = report.getString("billno");
        StringBuilder content = new StringBuilder();
        content.append("<p>").append(ResManager.loadKDString((String)"\u56e0", (String)"WorkHourTemplateHelper_3", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])).append("<a href=").append(templateUrl).append(" target='_blank'>").append(templateNumber).append("</a>").append(ResManager.loadKDString((String)"\u6a21\u677f\u53d1\u751f\u53d8\u66f4\uff0c\u4ea7\u751f", (String)"WorkHourTemplateHelper_4", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])).append("<a href=").append(reportUrl).append(" target='_blank'>").append(reportBillno).append("</a>").append(ResManager.loadKDString((String)"\u5f71\u54cd\u62a5\u544a\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"WorkHourTemplateHelper_5", (String)"mmc-pmpd-formplugin", (Object[])new Object[0])).append("</p>");
        messageInfo.setMessageContent((ILocaleString)new LocaleString(content.toString()));
        messageInfo.setUserIds((List)Lists.newArrayList((Object[])new Long[]{currUserId}));
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private static WorkHourTemplateChangeTaskDto convertChangeTaskDto(boolean isEstimatedWorkHourTemplate, long createOrgId, Map<Long, List<IndustryWorkHourModifiedData>> templateId2ModifiedData, List<Object> estimatedBillIds) {
        WorkHourTemplateChangeTaskDto result = new WorkHourTemplateChangeTaskDto();
        result.setUserId(RequestContext.get().getCurrUserId());
        result.setEstimatedWorkHourTemplate(isEstimatedWorkHourTemplate);
        result.setCreageOrgId(createOrgId);
        result.setTemplateId2ModifiedData(templateId2ModifiedData);
        result.setEstimatedBillIds(estimatedBillIds);
        return result;
    }

    public static Table<Long, Long, EstimatedBillChangeInfo> getTemplateId2EstimatedBillTable(boolean isEstimatedWorkHourTemplate, List<Object> estimatedBillIds) {
        String workHourTemplateField = WorkHourTemplateHelper.getWorkHourTemplateField(isEstimatedWorkHourTemplate);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", estimatedBillIds)};
        String selectFields = workHourTemplateField + ", id, billno, resourceplan, resourceplanid";
        HashBasedTable result = HashBasedTable.create((int)estimatedBillIds.size(), (int)16);
        try (DataSet dataSet = ORM.create().queryDataSet("getEstimatedBill", "pmpd_hour_estimate", selectFields, filters, null, -1);){
            if (dataSet.isEmpty()) {
                HashBasedTable hashBasedTable = result;
                return hashBasedTable;
            }
            for (Row row : dataSet) {
                EstimatedBillChangeInfo estimatedBillChangeInfo = new EstimatedBillChangeInfo();
                estimatedBillChangeInfo.setBillno(row.getString(2));
                estimatedBillChangeInfo.setResourcePlanNo(row.getString(3));
                estimatedBillChangeInfo.setResourcePlanId(row.getLong(4).longValue());
                Long templateId = row.getLong(0);
                Long estimatedBillId = row.getLong(1);
                result.put((Object)templateId, (Object)estimatedBillId, (Object)estimatedBillChangeInfo);
            }
            Iterator iterator = result;
            return iterator;
        }
    }

    private static List<Object> getEstimatedBillIds(boolean isEstimatedWorkHourTemplate, Set<Long> workHourTemplateIds) {
        String selectFields = "id, resourceplanid, effectivestatus";
        QFilter[] filters = WorkHourTemplateHelper.getEstimatedBillFilters(workHourTemplateIds, WorkHourTemplateHelper.getWorkHourTemplateField(isEstimatedWorkHourTemplate));
        HashMap<Object, Set> resourcePlanMap = new HashMap<Object, Set>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getEstimatedBillCount", (String)"pmpd_hour_estimate", (String)selectFields, (QFilter[])filters, null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                if ("2".equals(row.getString(2))) continue;
                Set ids = resourcePlanMap.computeIfAbsent(row.get(1), k -> new HashSet(16));
                ids.add(row.get(0));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (resourcePlanMap.isEmpty()) {
            return Collections.emptyList();
        }
        selectFields = "id, executestatus";
        filters = new QFilter[]{new QFilter("id", "in", resourcePlanMap.keySet())};
        dataSet = QueryServiceHelper.queryDataSet((String)"getEstimatedBillCount", (String)"pmpd_resourceplan", (String)selectFields, (QFilter[])filters, null);
        object = null;
        try {
            for (Row row : dataSet) {
                String executeStatus = row.getString(1);
                if (!"3".equals(executeStatus) && !"4".equals(executeStatus)) continue;
                resourcePlanMap.remove(row.get(0));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Object> ids = new ArrayList<Object>(10);
        for (Map.Entry entry : resourcePlanMap.entrySet()) {
            ids.addAll((Collection)entry.getValue());
        }
        return ids;
    }

    private static QFilter[] getEstimatedBillFilters(Set<Long> workHourTemplateIds, String workHourTemplateField) {
        QFilter[] filters = new QFilter[]{new QFilter(workHourTemplateField, "in", workHourTemplateIds), new QFilter("billstatus", "=", (Object)"C")};
        return filters;
    }

    private static String getWorkHourTemplateField(boolean isEstimatedWorkHourTemplate) {
        return isEstimatedWorkHourTemplate ? "estimate_workhour" : "stage_workhour";
    }

    private static Map<Long, List<IndustryWorkHourModifiedData>> getTemplateId2ModifiedData(String sourceEntityId, boolean isEstimatedWorkHourTemplate, List<Long> workHourTemplateIds) {
        Table<Long, Long, DynamicObject> workHourTemplateTable = WorkHourTemplateHelper.getWorkHourTemplateTable(isEstimatedWorkHourTemplate, sourceEntityId, workHourTemplateIds);
        if (workHourTemplateTable.isEmpty()) {
            return Collections.emptyMap();
        }
        return isEstimatedWorkHourTemplate ? WorkHourTemplateHelper.getEstimateTemplateId2ModifiedData(workHourTemplateTable) : WorkHourTemplateHelper.getStageTemplateId2ModifiedData(workHourTemplateTable);
    }

    private static Map<Long, List<IndustryWorkHourModifiedData>> getStageTemplateId2ModifiedData(Table<Long, Long, DynamicObject> workHourTemplateTable) {
        String orderBy;
        String selectFields = "sourcebillid, version, entryentity.industryone_id, entryentity.industry_id, entryentity.totalhours, stage_stage, stage_percentage";
        QFilter[] filters = new QFilter[]{new QFilter("sourcebillid", "in", (Object)workHourTemplateTable.rowKeySet())};
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"pmpd_stage_workhour", (String)selectFields, (QFilter[])filters, (String)(orderBy = "version desc"));
        if (cache.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = workHourTemplateTable.size();
        HashMap verifyUniqueMap = Maps.newHashMapWithExpectedSize((int)size);
        HashMap templateId2Changed = Maps.newHashMapWithExpectedSize((int)size);
        HashMap templateId2ModifiedData = Maps.newHashMapWithExpectedSize((int)size);
        for (Map.Entry entry2 : cache.entrySet()) {
            DynamicObject workHourTemplate = (DynamicObject)entry2.getValue();
            Long sourceBillId = workHourTemplate.getLong("sourcebillid");
            Integer version = workHourTemplate.getInt("version");
            Integer maxVersion = (Integer)verifyUniqueMap.get(sourceBillId);
            if (maxVersion == null) {
                verifyUniqueMap.put(sourceBillId, version);
            } else if (!maxVersion.equals(version)) continue;
            DynamicObjectCollection industryEntryCollection = workHourTemplate.getDynamicObjectCollection("entryentity");
            for (DynamicObject oldIndustryEntry : industryEntryCollection) {
                IndustryWorkHourModifiedData industryWorkHourModifiedData;
                long industryId = oldIndustryEntry.getLong("industry_id");
                DynamicObject currentIndustryEntry = (DynamicObject)workHourTemplateTable.remove((Object)sourceBillId, (Object)industryId);
                if (currentIndustryEntry == null) {
                    industryWorkHourModifiedData = WorkHourTemplateHelper.buildDeletedStageEntryData(oldIndustryEntry, industryId);
                    templateId2Changed.putIfAbsent(sourceBillId, Boolean.TRUE);
                } else {
                    industryWorkHourModifiedData = WorkHourTemplateHelper.buildUpdatedStageEntryData(templateId2Changed, sourceBillId, currentIndustryEntry, oldIndustryEntry, industryId);
                }
                List list = templateId2ModifiedData.computeIfAbsent(sourceBillId, k -> new ArrayList(10));
                list.add(industryWorkHourModifiedData);
            }
        }
        for (Map.Entry entry2 : workHourTemplateTable.rowMap().entrySet()) {
            Long sourceBillId = (Long)entry2.getKey();
            for (Map.Entry industryEntry : ((Map)entry2.getValue()).entrySet()) {
                Long industryId = (Long)industryEntry.getKey();
                DynamicObject industryEntryValue = (DynamicObject)industryEntry.getValue();
                IndustryWorkHourModifiedData industryWorkHourModifiedData = WorkHourTemplateHelper.buildNewStageEntryData(industryId, industryEntryValue);
                List list = templateId2ModifiedData.computeIfAbsent(sourceBillId, k -> new ArrayList(10));
                list.add(industryWorkHourModifiedData);
            }
            templateId2Changed.putIfAbsent(sourceBillId, Boolean.TRUE);
        }
        templateId2ModifiedData.entrySet().removeIf(entry -> templateId2Changed.getOrDefault(entry.getKey(), Boolean.FALSE) == false);
        if (templateId2ModifiedData.isEmpty()) {
            return Collections.emptyMap();
        }
        return templateId2ModifiedData;
    }

    private static IndustryWorkHourModifiedData buildNewStageEntryData(Long industryId, DynamicObject industryEntry) {
        IndustryWorkHourModifiedData industryWorkHourModifiedData = new IndustryWorkHourModifiedData();
        industryWorkHourModifiedData.setIndustryId(industryId.longValue());
        industryWorkHourModifiedData.setIndustryOneId(industryEntry.getLong("industryone_id"));
        industryWorkHourModifiedData.setOldTotalHours(BigDecimal.ZERO);
        industryWorkHourModifiedData.setTotalHours(industryEntry.getBigDecimal("totalhours"));
        DynamicObjectCollection stageEntryCollection = industryEntry.getDynamicObjectCollection("subentryentity");
        ArrayList stageTemplateModifiedDataList = Lists.newArrayListWithExpectedSize((int)stageEntryCollection.size());
        for (DynamicObject stageEntry : stageEntryCollection) {
            StageTemplateModifiedData modifiedData = new StageTemplateModifiedData();
            modifiedData.setStage(stageEntry.getInt("stage_stage"));
            modifiedData.setOldPercentage(BigDecimal.ZERO);
            modifiedData.setPercentage(stageEntry.getBigDecimal("stage_percentage"));
            stageTemplateModifiedDataList.add(modifiedData);
        }
        industryWorkHourModifiedData.setStageTemplateModifiedDataList((List)stageTemplateModifiedDataList);
        return industryWorkHourModifiedData;
    }

    private static IndustryWorkHourModifiedData buildUpdatedStageEntryData(Map<Long, Boolean> templateId2Changed, Long sourceBillId, DynamicObject currentIndustryEntry, DynamicObject oldIndustryEntry, long industryId) {
        IndustryWorkHourModifiedData estimatedTemplateModifiedData = new IndustryWorkHourModifiedData();
        estimatedTemplateModifiedData.setIndustryId(industryId);
        estimatedTemplateModifiedData.setIndustryOneId(currentIndustryEntry.getLong("industryone_id"));
        estimatedTemplateModifiedData.setOldTotalHours(oldIndustryEntry.getBigDecimal("totalhours"));
        estimatedTemplateModifiedData.setTotalHours(currentIndustryEntry.getBigDecimal("totalhours"));
        DynamicObjectCollection currentStageEntryCollection = currentIndustryEntry.getDynamicObjectCollection("subentryentity");
        DynamicObjectCollection oldStageEntryCollection = oldIndustryEntry.getDynamicObjectCollection("subentryentity");
        if (currentStageEntryCollection.size() != oldStageEntryCollection.size()) {
            return estimatedTemplateModifiedData;
        }
        ArrayList stageTemplateModifiedDataList = Lists.newArrayListWithExpectedSize((int)oldStageEntryCollection.size());
        int oldStageEntryCollectionSize = oldStageEntryCollection.size();
        for (int i = 0; i < oldStageEntryCollectionSize; ++i) {
            DynamicObject oldStageEntry = (DynamicObject)oldStageEntryCollection.get(i);
            DynamicObject currentStageEntry = (DynamicObject)currentStageEntryCollection.get(i);
            StageTemplateModifiedData modifiedData = new StageTemplateModifiedData();
            modifiedData.setStage(oldStageEntry.getInt("stage_stage"));
            BigDecimal oldStagePercentage = oldStageEntry.getBigDecimal("stage_percentage");
            BigDecimal currtentStagePercentage = currentStageEntry.getBigDecimal("stage_percentage");
            modifiedData.setOldPercentage(oldStagePercentage);
            modifiedData.setPercentage(currtentStagePercentage);
            stageTemplateModifiedDataList.add(modifiedData);
            Boolean isChanged = templateId2Changed.getOrDefault(sourceBillId, Boolean.FALSE);
            if (isChanged.booleanValue() || currtentStagePercentage.compareTo(oldStagePercentage) == 0) continue;
            templateId2Changed.putIfAbsent(sourceBillId, Boolean.TRUE);
        }
        estimatedTemplateModifiedData.setStageTemplateModifiedDataList((List)stageTemplateModifiedDataList);
        return estimatedTemplateModifiedData;
    }

    private static IndustryWorkHourModifiedData buildDeletedStageEntryData(DynamicObject industryEntry, long industryId) {
        IndustryWorkHourModifiedData industryWorkHourModifiedData = new IndustryWorkHourModifiedData();
        industryWorkHourModifiedData.setIndustryId(industryId);
        industryWorkHourModifiedData.setIndustryOneId(industryEntry.getLong("industryone_id"));
        industryWorkHourModifiedData.setOldTotalHours(industryEntry.getBigDecimal("totalhours"));
        industryWorkHourModifiedData.setTotalHours(BigDecimal.ZERO);
        DynamicObjectCollection stageEntryCollection = industryEntry.getDynamicObjectCollection("subentryentity");
        ArrayList stageTemplateModifiedDataList = Lists.newArrayListWithExpectedSize((int)stageEntryCollection.size());
        for (DynamicObject stageEntry : stageEntryCollection) {
            StageTemplateModifiedData modifiedData = new StageTemplateModifiedData();
            modifiedData.setStage(stageEntry.getInt("stage_stage"));
            modifiedData.setPercentage(BigDecimal.ZERO);
            modifiedData.setOldPercentage(stageEntry.getBigDecimal("stage_percentage"));
            stageTemplateModifiedDataList.add(modifiedData);
        }
        industryWorkHourModifiedData.setStageTemplateModifiedDataList((List)stageTemplateModifiedDataList);
        return industryWorkHourModifiedData;
    }

    private static Map<Long, List<IndustryWorkHourModifiedData>> getEstimateTemplateId2ModifiedData(Table<Long, Long, DynamicObject> workHourTemplateTable) {
        String orderBy;
        String selectFields = "sourcebillid, version, entryentity.industryone_id, entryentity.industry_id, entryentity.routineworkhour, entryentity.nonroutineworkhour, entryentity.totalhours";
        QFilter[] filters = new QFilter[]{new QFilter("sourcebillid", "in", (Object)workHourTemplateTable.rowKeySet())};
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"pmpd_estimate_workhour", (String)selectFields, (QFilter[])filters, (String)(orderBy = "version desc"));
        if (cache.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = workHourTemplateTable.size();
        HashMap verifyUniqueMap = Maps.newHashMapWithExpectedSize((int)size);
        HashMap templateId2Changed = Maps.newHashMapWithExpectedSize((int)size);
        HashMap templateId2ModifiedData = Maps.newHashMapWithExpectedSize((int)size);
        for (Map.Entry entry2 : cache.entrySet()) {
            DynamicObject workHourTemplate = (DynamicObject)entry2.getValue();
            Long sourceBillId = workHourTemplate.getLong("sourcebillid");
            Integer version = workHourTemplate.getInt("version");
            Integer maxVersion = (Integer)verifyUniqueMap.get(sourceBillId);
            if (maxVersion == null) {
                verifyUniqueMap.put(sourceBillId, version);
            } else if (!maxVersion.equals(version)) continue;
            DynamicObjectCollection industryEntryCollection = workHourTemplate.getDynamicObjectCollection("entryentity");
            for (DynamicObject oldIndustryEntry : industryEntryCollection) {
                IndustryWorkHourModifiedData modifiedData;
                long industryId = oldIndustryEntry.getLong("industry_id");
                DynamicObject currentIndustryEntry = (DynamicObject)workHourTemplateTable.remove((Object)sourceBillId, (Object)industryId);
                if (currentIndustryEntry == null) {
                    modifiedData = WorkHourTemplateHelper.buildDeletedIndustryEntryData(oldIndustryEntry, industryId);
                    templateId2Changed.putIfAbsent(sourceBillId, Boolean.TRUE);
                } else {
                    modifiedData = WorkHourTemplateHelper.buildUpdatedIndustryEntryData(templateId2Changed, sourceBillId, currentIndustryEntry, oldIndustryEntry, industryId);
                }
                List list = templateId2ModifiedData.computeIfAbsent(sourceBillId, k -> new ArrayList(10));
                list.add(modifiedData);
            }
        }
        for (Map.Entry entry2 : workHourTemplateTable.rowMap().entrySet()) {
            Long sourceBillId = (Long)entry2.getKey();
            for (Map.Entry industryEntry : ((Map)entry2.getValue()).entrySet()) {
                Long industryId = (Long)industryEntry.getKey();
                DynamicObject industryEntryValue = (DynamicObject)industryEntry.getValue();
                IndustryWorkHourModifiedData modifiedData = WorkHourTemplateHelper.buildNewIndustryEntryData(industryId, industryEntryValue);
                List list = templateId2ModifiedData.computeIfAbsent(sourceBillId, k -> new ArrayList(10));
                list.add(modifiedData);
            }
            templateId2Changed.putIfAbsent(sourceBillId, Boolean.TRUE);
        }
        templateId2ModifiedData.entrySet().removeIf(entry -> templateId2Changed.getOrDefault(entry.getKey(), Boolean.FALSE) == false);
        if (templateId2ModifiedData.isEmpty()) {
            return Collections.emptyMap();
        }
        return templateId2ModifiedData;
    }

    private static IndustryWorkHourModifiedData buildNewIndustryEntryData(Long industryId, DynamicObject industryEntryValue) {
        IndustryWorkHourModifiedData modifiedData = new IndustryWorkHourModifiedData();
        modifiedData.setRoutineWorkHour(industryEntryValue.getBigDecimal("routineworkhour"));
        modifiedData.setOldRoutineWorkHour(BigDecimal.ZERO);
        modifiedData.setNonRoutineWorkHour(industryEntryValue.getBigDecimal("nonroutineworkhour"));
        modifiedData.setOldNonRoutineWorkHour(BigDecimal.ZERO);
        modifiedData.setTotalHours(industryEntryValue.getBigDecimal("totalhours"));
        modifiedData.setOldTotalHours(BigDecimal.ZERO);
        modifiedData.setIndustryId(industryId.longValue());
        modifiedData.setIndustryOneId(industryEntryValue.getLong("industryone_id"));
        return modifiedData;
    }

    private static IndustryWorkHourModifiedData buildUpdatedIndustryEntryData(Map<Long, Boolean> templateId2Changed, Long sourceBillId, DynamicObject currentIndustryEntry, DynamicObject oldIndustryEntry, long industryId) {
        IndustryWorkHourModifiedData modifiedData = new IndustryWorkHourModifiedData();
        BigDecimal routineWorkHour = currentIndustryEntry.getBigDecimal("routineworkhour");
        modifiedData.setRoutineWorkHour(routineWorkHour);
        BigDecimal oldRoutineWorkHour = oldIndustryEntry.getBigDecimal("routineworkhour");
        modifiedData.setOldRoutineWorkHour(oldRoutineWorkHour);
        BigDecimal nonRoutineWorkHour = currentIndustryEntry.getBigDecimal("nonroutineworkhour");
        modifiedData.setNonRoutineWorkHour(nonRoutineWorkHour);
        BigDecimal oldNonRoutineWorkHour = oldIndustryEntry.getBigDecimal("nonroutineworkhour");
        modifiedData.setOldNonRoutineWorkHour(oldNonRoutineWorkHour);
        modifiedData.setTotalHours(currentIndustryEntry.getBigDecimal("totalhours"));
        modifiedData.setOldTotalHours(oldIndustryEntry.getBigDecimal("totalhours"));
        modifiedData.setIndustryId(industryId);
        modifiedData.setIndustryOneId(oldIndustryEntry.getLong("industryone_id"));
        Boolean isChanged = templateId2Changed.getOrDefault(sourceBillId, Boolean.FALSE);
        if (isChanged.booleanValue()) {
            return modifiedData;
        }
        if (routineWorkHour.compareTo(oldRoutineWorkHour) != 0) {
            templateId2Changed.putIfAbsent(sourceBillId, Boolean.TRUE);
            return modifiedData;
        }
        if (nonRoutineWorkHour.compareTo(oldNonRoutineWorkHour) != 0) {
            templateId2Changed.putIfAbsent(sourceBillId, Boolean.TRUE);
            return modifiedData;
        }
        return modifiedData;
    }

    private static IndustryWorkHourModifiedData buildDeletedIndustryEntryData(DynamicObject oldIndustryEntry, long industryId) {
        IndustryWorkHourModifiedData modifiedData = new IndustryWorkHourModifiedData();
        modifiedData.setRoutineWorkHour(BigDecimal.ZERO);
        modifiedData.setOldRoutineWorkHour(oldIndustryEntry.getBigDecimal("routineworkhour"));
        modifiedData.setNonRoutineWorkHour(BigDecimal.ZERO);
        modifiedData.setOldNonRoutineWorkHour(oldIndustryEntry.getBigDecimal("nonroutineworkhour"));
        modifiedData.setTotalHours(BigDecimal.ZERO);
        modifiedData.setOldTotalHours(oldIndustryEntry.getBigDecimal("totalhours"));
        modifiedData.setIndustryId(industryId);
        modifiedData.setIndustryOneId(oldIndustryEntry.getLong("industryone_id"));
        return modifiedData;
    }

    private static Table<Long, Long, DynamicObject> getWorkHourTemplateTable(boolean isEstimatedWorkHourTemplate, String sourceEntityId, List<Long> workHourTemplateIds) {
        Set<String> selectFields = isEstimatedWorkHourTemplate ? WorkHourTemplateHelper.getEstimatedSelectFields() : WorkHourTemplateHelper.getStageSelectFields();
        DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)sourceEntityId, selectFields);
        Map cache = BusinessDataServiceHelper.loadFromCache((Object[])workHourTemplateIds.toArray(), (DynamicObjectType)dt);
        HashBasedTable result = HashBasedTable.create((int)cache.size(), (int)16);
        for (Map.Entry entry : cache.entrySet()) {
            DynamicObject dataEntity = (DynamicObject)entry.getValue();
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : collection) {
                result.put((Object)((Long)entry.getKey()), (Object)dynamicObject.getLong("industry_id"), (Object)dynamicObject);
            }
        }
        return result;
    }

    private static Set<String> getEstimatedSelectFields() {
        return Sets.newHashSet((Object[])new String[]{"entryentity.industryone_id", "entryentity.industry_id", "entryentity.routineworkhour", "entryentity.nonroutineworkhour", "entryentity.totalhours"});
    }

    private static Set<String> getStageSelectFields() {
        return Sets.newHashSet((Object[])new String[]{"entryentity.industryone_id", "entryentity.industry_id", "entryentity.totalhours", "stage_stage", "stage_percentage"});
    }

    public static int getBatchSizeFromAppParam() {
        Object batchSizeObj = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam(APP_ID, Long.valueOf(OrgUnitServiceHelper.getRootOrgId())), (String)"workhour_batchsize");
        return batchSizeObj != null ? (Integer)batchSizeObj : 100;
    }

    private static void dispatch(AbstractFormPlugin formPlugin, WorkHourTemplateChangeTaskDto paramData) {
        HashMap<String, WorkHourTemplateChangeTaskDto> params = new HashMap<String, WorkHourTemplateChangeTaskDto>(2);
        params.put("data", paramData);
        JobInfo jobInfo = JobInfoBuilder.builder().appId(APP_NUMBER).name(WorkHourTemplateHelper.getTaskName()).taskClassName("kd.pmc.pmpd.formplugin.bigtask.WorkHourTemplateChangeTask").params(params).build();
        JobFormInfo jobFormInfo = JobFormInfoBuilder.builder().jobInfo(jobInfo).closeCallBack(new CloseCallBack((IFormPlugin)formPlugin, "change")).clickClassName("kd.pmc.pmpd.formplugin.bigtask.WorkHourTemplateChangeTaskClick").canBackground(true).canStop(false).build();
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formPlugin.getView());
    }

    private static Set<String> getNoQueryFields() {
        HashSet noQueryFields = Sets.newHashSetWithExpectedSize((int)9);
        noQueryFields.add("billno");
        noQueryFields.add("effectivestatus");
        noQueryFields.add("billstatus");
        noQueryFields.add("auditor");
        noQueryFields.add("auditor_id");
        noQueryFields.add("auditdate");
        noQueryFields.add("entryentity");
        noQueryFields.add("entryentity_summary");
        noQueryFields.add("s_entryentity_summary");
        return noQueryFields;
    }

    private static EntityType getQueryType(MainEntityType dataEntityType) {
        Set<String> noQueryFields = WorkHourTemplateHelper.getNoQueryFields();
        Set selectFields = dataEntityType.getProperties().stream().map(IMetadata::getName).filter(name -> !noQueryFields.contains(name)).collect(Collectors.toSet());
        selectFields.addAll(WorkHourTemplateHelper.getEntryFields("s_entryentity", dataEntityType, true));
        selectFields.addAll(WorkHourTemplateHelper.getEntryFields("r_entryentity", dataEntityType, false));
        selectFields.addAll(WorkHourTemplateHelper.getEntryFields("r_subentryentity_daily", dataEntityType, false));
        selectFields.addAll(WorkHourTemplateHelper.getEntryFields("r_entryentity_summary", dataEntityType, false));
        EntityType subEntityType = dataEntityType.getSubEntityType(selectFields);
        try {
            return (EntityType)subEntityType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
    }

    private static List<String> getEntryFields(String entryKey, MainEntityType mainEntityType, boolean ignoreSubEntry) {
        IDataEntityProperty property = mainEntityType.findProperty(entryKey);
        if (property instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)property;
            DataEntityPropertyCollection properties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
            List<String> fileds = properties.stream().skip(2L).filter(dataEntityProperty -> {
                if (dataEntityProperty instanceof EntryProp) {
                    return !ignoreSubEntry;
                }
                return !dataEntityProperty.isDbIgnore();
            }).map(IMetadata::getName).collect(Collectors.toList());
            fileds.add(entryKey + ".seq");
            return fileds;
        }
        return Collections.emptyList();
    }

    private static DynamicObject cloneData(DynamicObjectType dataEntityType, DynamicObject sourceEntity, CloneUtils cloneUtils) throws CloneNotSupportedException {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        List collectionProperties = properties.getCollectionProperties(true);
        HashMap entryEntityMap = Maps.newHashMapWithExpectedSize((int)collectionProperties.size());
        DataEntityPropertyCollection oldProperties = sourceEntity.getDynamicObjectType().getProperties();
        for (ICollectionProperty collectionProperty : collectionProperties) {
            if (!(collectionProperty instanceof EntryProp)) continue;
            String name = collectionProperty.getName();
            if (!oldProperties.containsKey((Object)name)) {
                oldProperties.add((Object)((IDataEntityProperty)collectionProperty.clone()));
                continue;
            }
            DynamicObjectCollection oldCollection = sourceEntity.getDynamicObjectCollection(name);
            if (oldCollection.isEmpty()) continue;
            ArrayList tempList = Lists.newArrayListWithExpectedSize((int)oldCollection.size());
            Iterator iterator = oldCollection.iterator();
            while (iterator.hasNext()) {
                tempList.add(iterator.next());
                iterator.remove();
            }
            EntryProp entryProp = (EntryProp)collectionProperty;
            DynamicObjectType entryEntityType = entryProp.getDynamicCollectionItemPropertyType();
            ArrayList newCollection = Lists.newArrayListWithExpectedSize((int)oldCollection.size());
            for (DynamicObject dynamicObject : tempList) {
                newCollection.add(WorkHourTemplateHelper.cloneData(entryEntityType, dynamicObject, cloneUtils));
            }
            entryEntityMap.put(name, newCollection);
        }
        DynamicObject dataEntity = (DynamicObject)cloneUtils.clone((IDataEntityType)dataEntityType, (Object)sourceEntity);
        for (Map.Entry entry : entryEntityMap.entrySet()) {
            String key = (String)entry.getKey();
            EntryProp entryProp = (EntryProp)properties.get((Object)key);
            entryProp.setValueFast((Object)dataEntity, (Object)new DynamicObjectCollection(entryProp.getDynamicCollectionItemPropertyType(), (Object)dataEntity, (List)entry.getValue()));
        }
        return dataEntity;
    }

    public static void regenerateEstimatedBill(boolean isEstimatedWorkHourTemplate, Object[] estimatedBillIdArray, Table<Long, Long, EstimatedBillChangeInfo> templateId2EstimatedBill) throws CloneNotSupportedException {
        MainEntityType estimatedBillEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_hour_estimate");
        DynamicObject[] estimatedBillDataArray = BusinessDataServiceHelper.load((Object[])estimatedBillIdArray, (DynamicObjectType)WorkHourTemplateHelper.getQueryType(estimatedBillEntityType));
        Set<Long> resoucePlanIdSet = Arrays.stream(estimatedBillDataArray).map(dataEntity -> dataEntity.getLong("resourceplanid")).collect(Collectors.toSet());
        Map<Long, Tuple<Date, BigDecimal>> resourcePlanInfoMap = WorkHourTemplateHelper.getResourcePlanInfo(resoucePlanIdSet);
        String templateIdProperty = WorkHourTemplateHelper.getWorkHourTemplateField(isEstimatedWorkHourTemplate) + "_id";
        int dataLength = estimatedBillDataArray.length;
        ArrayList cloneDatas = Lists.newArrayListWithExpectedSize((int)dataLength);
        HashMap<Long, Map<Long, List<List<Object>>>> stageValuesCache = new HashMap<Long, Map<Long, List<List<Object>>>>(16);
        long[] newIds = ID.genLongIds((int)dataLength);
        String[] codeNumbers = CodeRuleServiceHelper.getBatchNumber((String)"pmpd_hour_estimate", (DynamicObject)estimatedBillDataArray[0], null, (int)dataLength);
        EstimateContext estimateContext = EstimateContext.get();
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (int i = 0; i < dataLength; ++i) {
            DynamicObject estimatedBill = estimatedBillDataArray[i];
            Tuple<Date, BigDecimal> tuple = resourcePlanInfoMap.get(estimatedBill.getLong("resourceplanid"));
            if (tuple == null) {
                LOG.info("{}The query result of the overhaul primary resource plan is empty. estimatedBillId: {}", (Object)WorkHourTemplateHelper.getTaskName(), estimatedBill.getPkValue());
                continue;
            }
            Date startTime = (Date)tuple.item1;
            if (startTime == null) {
                LOG.info("{}startTime is null. estimatedBillId: {}", (Object)WorkHourTemplateHelper.getTaskName(), estimatedBill.getPkValue());
                continue;
            }
            BigDecimal trt = (BigDecimal)tuple.item2;
            if (trt.compareTo(BigDecimal.ZERO) == 0) {
                LOG.info("{}trt = 0. estimatedBillId: {}", (Object)WorkHourTemplateHelper.getTaskName(), estimatedBill.getPkValue());
                continue;
            }
            DynamicObject cloneData = WorkHourTemplateHelper.cloneData((DynamicObjectType)estimatedBillEntityType, estimatedBill, cloneUtils);
            long newId = newIds[i];
            String newBillno = codeNumbers[i];
            WorkHourTemplateHelper.initCloneData(cloneData, newId, newBillno);
            WorkHourTemplateHelper.addChangeInfo(templateId2EstimatedBill, templateIdProperty, estimatedBill, newId, newBillno);
            DynamicObject stageWorkHourTemplate = estimatedBill.getDynamicObject("stage_workhour");
            WorkHourTemplateHelper.resetContext(estimateContext, startTime, trt, stageWorkHourTemplate, estimatedBill);
            Map<Long, List<List<Object>>> industry2StageInfo = WorkHourTemplateHelper.getStageInfo(stageWorkHourTemplate, stageValuesCache);
            WorkHourTemplateHelper.reEstimate4EstimateWorkHour(cloneData, estimatedBill, industry2StageInfo);
            WorkHourTemplateHelper.reEstimate4StandardWorkHour(cloneData, industry2StageInfo);
            cloneDatas.add(cloneData);
        }
        SaveServiceHelper.save((DynamicObject[])cloneDatas.toArray(new DynamicObject[0]));
    }

    private static void reEstimate4StandardWorkHour(DynamicObject cloneData, Map<Long, List<List<Object>>> industry2StageInfo) {
        DynamicObjectCollection industryEntryEntity = cloneData.getDynamicObjectCollection("s_entryentity");
        if (industryEntryEntity.isEmpty()) {
            return;
        }
        EstimateContext estimateContext = EstimateContext.get();
        estimateContext.getStartDate2DailySummaryResult().clear();
        for (DynamicObject cloneEntry : industryEntryEntity) {
            long industryOneId = cloneEntry.getLong("s_industryone_id");
            long industryId = cloneEntry.getLong("s_industry_id");
            BigDecimal totalHours = cloneEntry.getBigDecimal("s_totalhours");
            List<List<Object>> values = industry2StageInfo.get(industryId);
            if (values == null) continue;
            WorkHourTemplateHelper.resetContext4Industry(estimateContext, industryOneId, industryId, totalHours);
            DynamicObjectCollection dailySubEntryEntity = cloneEntry.getDynamicObjectCollection("s_subentryentity_daily");
            DynamicObjectCollection newStageCollection = cloneEntry.getDynamicObjectCollection("s_subentryentity_stage");
            int maxIndex = values.size() - 1;
            for (int index = 0; index <= maxIndex; ++index) {
                List<Object> value = values.get(index);
                DynamicObject newStageSubEntry = newStageCollection.addNew();
                BigDecimal percentage = (BigDecimal)value.get(2);
                newStageSubEntry.set("seq", (Object)newStageCollection.size());
                newStageSubEntry.set("s_stage_stage", value.get(1));
                newStageSubEntry.set("s_stage_percentage", (Object)percentage);
                BigDecimal currentTotalHours = totalHours.multiply(percentage);
                WorkHourTemplateHelper.estimate(index, maxIndex, currentTotalHours, dailySubEntryEntity, false);
            }
        }
        WorkHourTemplateHelper.addDailySummaryEntryData(cloneData, false);
    }

    private static void supplementDailyWorkHourData(DynamicObjectCollection dailySubEntryEntity, boolean isEstimate, int count) {
        EstimateContext estimateContext = EstimateContext.get();
        int trt = estimateContext.getTrt();
        Map startDate2DailySummaryResult = estimateContext.getStartDate2DailySummaryResult();
        for (int currentCount = count; currentCount < trt; ++currentCount) {
            estimateContext.getCalendar().add(5, 1);
            Date startTime = estimateContext.getCalendar().getTime();
            startDate2DailySummaryResult.put(startTime, new DailySummaryResult());
            DynamicObject dailiSubEntry = dailySubEntryEntity.addNew();
            dailiSubEntry.set("seq", (Object)dailySubEntryEntity.size());
            if (isEstimate) {
                dailiSubEntry.set("daily_date", (Object)startTime);
                dailiSubEntry.set("daily_industryone_id", (Object)estimateContext.getIndustryOneId());
                dailiSubEntry.set("daily_industry_id", (Object)estimateContext.getIndustryId());
                continue;
            }
            dailiSubEntry.set("s_daily_date", (Object)startTime);
            dailiSubEntry.set("s_daily_industryone_id", (Object)estimateContext.getIndustryOneId());
            dailiSubEntry.set("s_daily_industry_id", (Object)estimateContext.getIndustryId());
        }
    }

    private static void reEstimate4EstimateWorkHour(DynamicObject cloneData, DynamicObject estimatedBill, Map<Long, List<List<Object>>> industry2StageInfo) {
        DynamicObject estimatedWorkHourTemplate = estimatedBill.getDynamicObject("estimate_workhour");
        DynamicObjectCollection industryEntryEntity = estimatedWorkHourTemplate.getDynamicObjectCollection("entryentity");
        if (industryEntryEntity.isEmpty()) {
            return;
        }
        WorkHourTemplateHelper.sortByIndustry(industryEntryEntity);
        EstimateContext estimateContext = EstimateContext.get();
        estimateContext.getStartDate2DailySummaryResult().clear();
        String workHourType = estimatedBill.getString("workhourtype");
        boolean isReSummaryEstimateWorkHour = "estimate".equals(workHourType);
        BigDecimal totalRoutineWorkHour = BigDecimal.ZERO;
        BigDecimal totalNonRoutineWorkHour = BigDecimal.ZERO;
        DynamicObjectCollection cloneEntryEntity = cloneData.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : industryEntryEntity) {
            DynamicObject cloneEntry = cloneEntryEntity.addNew();
            long industryOneId = entry.getLong("industryone_id");
            long industryId = entry.getLong("industry_id");
            BigDecimal routineWorkHour = entry.getBigDecimal("routineworkhour");
            BigDecimal nonRoutineWorkHour = entry.getBigDecimal("nonroutineworkhour");
            if (isReSummaryEstimateWorkHour) {
                totalRoutineWorkHour = totalRoutineWorkHour.add(routineWorkHour);
                totalNonRoutineWorkHour = totalNonRoutineWorkHour.add(nonRoutineWorkHour);
            }
            BigDecimal totalHours = entry.getBigDecimal("totalhours");
            cloneEntry.set("seq", (Object)cloneEntryEntity.size());
            cloneEntry.set("industryone_id", (Object)industryOneId);
            cloneEntry.set("industry_id", (Object)industryId);
            cloneEntry.set("routinestatisticalhour", entry.get("routinestatisticalhour"));
            cloneEntry.set("nonroutinestatisticalhour", entry.get("nonroutinestatisticalhour"));
            cloneEntry.set("routineworkhour", (Object)routineWorkHour);
            cloneEntry.set("nonroutineworkhour", (Object)nonRoutineWorkHour);
            cloneEntry.set("totalhours", (Object)totalHours);
            List<List<Object>> values = industry2StageInfo.get(industryId);
            if (values == null) continue;
            WorkHourTemplateHelper.resetContext4Industry(estimateContext, industryOneId, industryId, totalHours);
            DynamicObjectCollection dailySubEntryEntity = cloneEntry.getDynamicObjectCollection("subentryentity_daily");
            DynamicObjectCollection newStageCollection = cloneEntry.getDynamicObjectCollection("subentryentity_stage");
            int maxIndex = values.size() - 1;
            for (int index = 0; index <= maxIndex; ++index) {
                List<Object> value = values.get(index);
                DynamicObject newStageSubEntry = newStageCollection.addNew();
                BigDecimal percentage = (BigDecimal)value.get(2);
                newStageSubEntry.set("seq", (Object)newStageCollection.size());
                newStageSubEntry.set("stage_industry", value.get(0));
                newStageSubEntry.set("stage_stage", value.get(1));
                newStageSubEntry.set("stage_percentage", (Object)percentage);
                newStageSubEntry.set("stage_routineworkhour", (Object)routineWorkHour.multiply(percentage));
                newStageSubEntry.set("stage_nonroutineworkhour", (Object)nonRoutineWorkHour.multiply(percentage));
                newStageSubEntry.set("stage_totalhours", (Object)totalHours.multiply(percentage));
                BigDecimal currentTotalHours = totalHours.multiply(percentage);
                WorkHourTemplateHelper.estimate(index, maxIndex, currentTotalHours, dailySubEntryEntity, true);
            }
        }
        if (isReSummaryEstimateWorkHour) {
            cloneData.set("totalroutworkhour", (Object)totalRoutineWorkHour);
            cloneData.set("totalnoroutworkhour", (Object)totalNonRoutineWorkHour);
            cloneData.set("totalestimateworkhour", (Object)totalRoutineWorkHour.add(totalNonRoutineWorkHour));
        }
        WorkHourTemplateHelper.addDailySummaryEntryData(cloneData, true);
    }

    public static void estimate(int index, int maxIndex, BigDecimal currentTotalHours, DynamicObjectCollection dailySubEntryEntity, boolean isEstimate) {
        EstimateContext estimateContext = EstimateContext.get();
        BigDecimal totalWorkHours = estimateContext.getTotalWorkHours();
        BigDecimal stageDays = estimateContext.getStageDays();
        BigDecimal unitHoursPerDay = currentTotalHours.divide(stageDays, 10, RoundingMode.HALF_UP);
        BigDecimal currentDayRemianingDays = BigDecimal.ONE.subtract(estimateContext.getRemainingDays());
        BigDecimal currentWorkHour = estimateContext.getRemainingWorkHour().add(unitHoursPerDay.multiply(currentDayRemianingDays));
        WorkHourTemplateHelper.addDailyEntryData(dailySubEntryEntity, currentWorkHour, isEstimate);
        BigDecimal currentRemainingDays = stageDays.subtract(currentDayRemianingDays);
        BigDecimal tempRemainingDays = WorkHourTemplateHelper.recursiveCalculate(currentRemainingDays, unitHoursPerDay, dailySubEntryEntity, isEstimate);
        if (index == maxIndex) {
            WorkHourTemplateHelper.addDailyEntryData(dailySubEntryEntity, totalWorkHours.subtract(estimateContext.getSummaryWorkHours()), isEstimate);
        } else {
            estimateContext.setRemainingDays(tempRemainingDays);
            estimateContext.setRemainingWorkHour(unitHoursPerDay.multiply(tempRemainingDays));
        }
    }

    public static void resetContext4Industry(EstimateContext estimateContext, long industryOneId, long industryId, BigDecimal totalHours) {
        estimateContext.setRemainingDays(BigDecimal.ZERO);
        estimateContext.setRemainingWorkHour(BigDecimal.ZERO);
        estimateContext.setIndustryOneId(Long.valueOf(industryOneId));
        estimateContext.setIndustryId(Long.valueOf(industryId));
        estimateContext.setTotalWorkHours(totalHours);
        estimateContext.getCalendar().setTime(estimateContext.getStartTime());
        estimateContext.setSummaryWorkHours(BigDecimal.ZERO);
    }

    public static void resetContext(EstimateContext estimateContext, Date startTime, BigDecimal trt, DynamicObject stageWorkHourTemplate, DynamicObject workHourEstimateBill) {
        ShiftSystemEnum shiftSystemEnum;
        BigDecimal stage;
        if (stageWorkHourTemplate == null) {
            stage = workHourEstimateBill.getBigDecimal("stage");
            shiftSystemEnum = ShiftSystemEnum.forValue((String)workHourEstimateBill.getString("shiftsystem"));
        } else {
            stage = stageWorkHourTemplate.getBigDecimal("stage");
            shiftSystemEnum = ShiftSystemEnum.forValue((String)stageWorkHourTemplate.getString("shiftsystem"));
        }
        estimateContext.setShiftSystem(shiftSystemEnum);
        if (startTime != null) {
            WorkHourTemplateHelper.initStartTime(startTime);
        }
        estimateContext.setTrt(trt.intValue());
        estimateContext.setStageDays(trt.divide(stage, 10, EstimateContext.getRoundingMode()));
    }

    private static void addChangeInfo(Table<Long, Long, EstimatedBillChangeInfo> templateId2EstimatedBill, String templateIdProperty, DynamicObject estimatedBill, long newId, String newBillno) {
        Long estimatedBillId;
        Long templateId = estimatedBill.getLong(templateIdProperty);
        EstimatedBillChangeInfo estimatedBillChangeInfo = (EstimatedBillChangeInfo)templateId2EstimatedBill.get((Object)templateId, (Object)(estimatedBillId = (Long)estimatedBill.getPkValue()));
        if (estimatedBillChangeInfo != null) {
            estimatedBillChangeInfo.setNewId(newId);
            estimatedBillChangeInfo.setNewBillno(newBillno);
        }
    }

    private static void initCloneData(DynamicObject cloneData, long newId, String newBillno) {
        cloneData.set("id", (Object)newId);
        cloneData.set("billno", (Object)newBillno);
        cloneData.set("effectivestatus", (Object)"0");
        cloneData.set("billstatus", (Object)"A");
        cloneData.set("isfromtemplate", (Object)"1");
    }

    private static void initStartTime(Date startTime) {
        EstimateContext estimateContext = EstimateContext.get();
        Calendar calendar = estimateContext.getCalendar();
        calendar.setTime(startTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, -1);
        estimateContext.setStartTime(calendar.getTime());
    }

    private static void addReportEntry(DynamicObject report, List<IndustryWorkHourModifiedData> modifiedDatas) {
        DynamicObjectCollection estimatedEntryEntity = report.getDynamicObjectCollection("estimate_entryentity");
        for (IndustryWorkHourModifiedData modifiedData : modifiedDatas) {
            DynamicObject industryEntry = estimatedEntryEntity.addNew();
            industryEntry.set("seq", (Object)estimatedEntryEntity.size());
            industryEntry.set("industryone_id", (Object)modifiedData.getIndustryOneId());
            industryEntry.set("industry_id", (Object)modifiedData.getIndustryId());
            industryEntry.set("pre_routineworkhour", (Object)modifiedData.getOldRoutineWorkHour());
            industryEntry.set("cur_routineworkhour", (Object)modifiedData.getRoutineWorkHour());
            industryEntry.set("pre_nonroutineworkhour", (Object)modifiedData.getOldNonRoutineWorkHour());
            industryEntry.set("cur_nonroutineworkhour", (Object)modifiedData.getNonRoutineWorkHour());
            industryEntry.set("pre_totalhours", (Object)modifiedData.getOldTotalHours());
            industryEntry.set("cur_totalhours", (Object)modifiedData.getTotalHours());
            List stageTemplateModifiedDataList = modifiedData.getStageTemplateModifiedDataList();
            if (CollectionUtils.isEmpty((Collection)stageTemplateModifiedDataList)) continue;
            DynamicObjectCollection stageEntryCollection = industryEntry.getDynamicObjectCollection("subentryentity");
            for (StageTemplateModifiedData stageTemplateModifiedData : stageTemplateModifiedDataList) {
                DynamicObject stageEntry = stageEntryCollection.addNew();
                stageEntry.set("seq", (Object)stageEntryCollection.size());
                stageEntry.set("stage", (Object)stageTemplateModifiedData.getStage());
                stageEntry.set("pre_percentage", (Object)stageTemplateModifiedData.getOldPercentage());
                stageEntry.set("cur_percentage", (Object)stageTemplateModifiedData.getPercentage());
            }
        }
    }

    private static BigDecimal recursiveCalculate(BigDecimal currentRemainingDays, BigDecimal unitHoursPerDay, DynamicObjectCollection dailySubEntryEntity, boolean isEstimate) {
        BigDecimal dValue = currentRemainingDays.subtract(BigDecimal.ONE);
        if (dValue.compareTo(BigDecimal.ZERO) <= 0) {
            return currentRemainingDays;
        }
        WorkHourTemplateHelper.addDailyEntryData(dailySubEntryEntity, unitHoursPerDay, isEstimate);
        return WorkHourTemplateHelper.recursiveCalculate(dValue, unitHoursPerDay, dailySubEntryEntity, isEstimate);
    }

    private static void addDailyEntryData(DynamicObjectCollection dailySubEntryEntity, BigDecimal currentWorkHour, boolean isEstimate) {
        BigDecimal shareResult;
        BigDecimal lateWorkHour;
        BigDecimal midWorkHour;
        BigDecimal earlyWorkHour;
        BigDecimal totalWorkHours;
        EstimateContext estimateContext = EstimateContext.get();
        BigDecimal summaryWorkHours = estimateContext.getSummaryWorkHours();
        if (summaryWorkHours.compareTo(totalWorkHours = estimateContext.getTotalWorkHours()) >= 0) {
            return;
        }
        BigDecimal tempResult = totalWorkHours.subtract(summaryWorkHours);
        int targetRowCount = dailySubEntryEntity.size() + 1;
        boolean needSupplementDailyWorkHourData = currentWorkHour.compareTo(tempResult) >= 0 || targetRowCount == estimateContext.getTrt();
        currentWorkHour = needSupplementDailyWorkHourData ? tempResult : currentWorkHour.setScale(EstimateContext.getScale(), EstimateContext.getRoundingMode());
        estimateContext.getCalendar().add(5, 1);
        Date startTime = estimateContext.getCalendar().getTime();
        DailySummaryResult dailySummaryResult = estimateContext.getStartDate2DailySummaryResult().computeIfAbsent(startTime, k -> new DailySummaryResult());
        ShiftSystemEnum shiftSystem = estimateContext.getShiftSystem();
        if (shiftSystem == ShiftSystemEnum.ONE) {
            earlyWorkHour = currentWorkHour;
            midWorkHour = BigDecimal.ZERO;
            lateWorkHour = BigDecimal.ZERO;
        } else if (shiftSystem == ShiftSystemEnum.TOW) {
            earlyWorkHour = shareResult = currentWorkHour.divide(shiftSystem.getNumberValue(), EstimateContext.getScale(), EstimateContext.getRoundingMode());
            midWorkHour = currentWorkHour.subtract(shareResult);
            lateWorkHour = BigDecimal.ZERO;
        } else {
            earlyWorkHour = shareResult = currentWorkHour.divide(shiftSystem.getNumberValue(), EstimateContext.getScale(), EstimateContext.getRoundingMode());
            midWorkHour = shareResult;
            lateWorkHour = currentWorkHour.subtract(earlyWorkHour.add(midWorkHour));
        }
        DynamicObject dailiSubEntry = dailySubEntryEntity.addNew();
        dailiSubEntry.set("seq", (Object)dailySubEntryEntity.size());
        if (isEstimate) {
            dailiSubEntry.set("daily_date", (Object)startTime);
            dailiSubEntry.set("daily_industryone_id", (Object)estimateContext.getIndustryOneId());
            dailiSubEntry.set("daily_industry_id", (Object)estimateContext.getIndustryId());
            dailiSubEntry.set("daily_workhour", (Object)currentWorkHour);
            dailiSubEntry.set("daily_earlyworkhour", (Object)earlyWorkHour);
            dailiSubEntry.set("daily_midworkhour", (Object)midWorkHour);
            dailiSubEntry.set("daily_lateworkhour", (Object)lateWorkHour);
        } else {
            dailiSubEntry.set("s_daily_date", (Object)startTime);
            dailiSubEntry.set("s_daily_industryone_id", (Object)estimateContext.getIndustryOneId());
            dailiSubEntry.set("s_daily_industry_id", (Object)estimateContext.getIndustryId());
            dailiSubEntry.set("s_daily_workhour", (Object)currentWorkHour);
            dailiSubEntry.set("s_daily_earlyworkhour", (Object)earlyWorkHour);
            dailiSubEntry.set("s_daily_midworkhour", (Object)midWorkHour);
            dailiSubEntry.set("s_daily_lateworkhour", (Object)lateWorkHour);
        }
        dailySummaryResult.addWorkHour(currentWorkHour);
        dailySummaryResult.addEarlyWorkHour(earlyWorkHour);
        dailySummaryResult.addMidWorkHour(midWorkHour);
        dailySummaryResult.addLateWorkHour(lateWorkHour);
        estimateContext.setSummaryWorkHours(summaryWorkHours.add(currentWorkHour));
        if (needSupplementDailyWorkHourData) {
            WorkHourTemplateHelper.supplementDailyWorkHourData(dailySubEntryEntity, isEstimate, targetRowCount);
        }
    }

    private static void addDailySummaryEntryData(DynamicObject cloneData, boolean isEstimate) {
        Map startDate2DailySummaryResult = EstimateContext.get().getStartDate2DailySummaryResult();
        if (isEstimate) {
            DynamicObjectCollection cloneSummaryEntryEntity = cloneData.getDynamicObjectCollection("entryentity_summary");
            for (Map.Entry entry : startDate2DailySummaryResult.entrySet()) {
                Date date = (Date)entry.getKey();
                DailySummaryResult dailySummaryResult = (DailySummaryResult)entry.getValue();
                WorkHourTemplateHelper.addEstimateSummaryWorkHourEntryData(cloneSummaryEntryEntity, date, dailySummaryResult);
            }
        } else {
            DynamicObjectCollection cloneSummaryEntryEntity = cloneData.getDynamicObjectCollection("s_entryentity_summary");
            for (Map.Entry entry : startDate2DailySummaryResult.entrySet()) {
                Date date = (Date)entry.getKey();
                DailySummaryResult dailySummaryResult = (DailySummaryResult)entry.getValue();
                WorkHourTemplateHelper.addStandardSummaryWorkHourEntryData(cloneSummaryEntryEntity, date, dailySummaryResult);
            }
        }
        startDate2DailySummaryResult.clear();
    }

    public static void addStandardSummaryWorkHourEntryData(DynamicObjectCollection summaryEntryEntity, Date date, DailySummaryResult dailySummaryResult) {
        DynamicObject dynamicObject = summaryEntryEntity.addNew();
        dynamicObject.set("seq", (Object)summaryEntryEntity.size());
        dynamicObject.set("s_summary_date", (Object)date);
        dynamicObject.set("s_summary_workhour", (Object)dailySummaryResult.getWorkHour());
        dynamicObject.set("s_summary_earlyworkhour", (Object)dailySummaryResult.getEarlyWorkHour());
        dynamicObject.set("s_summary_midworkhour", (Object)dailySummaryResult.getMidWorkHour());
        dynamicObject.set("s_summary_lateworkhour", (Object)dailySummaryResult.getLateWorkHour());
    }

    public static void addEstimateSummaryWorkHourEntryData(DynamicObjectCollection summaryEntryEntity, Date date, DailySummaryResult dailySummaryResult) {
        DynamicObject dynamicObject = summaryEntryEntity.addNew();
        dynamicObject.set("seq", (Object)summaryEntryEntity.size());
        dynamicObject.set("summary_date", (Object)date);
        dynamicObject.set("summary_workhour", (Object)dailySummaryResult.getWorkHour());
        dynamicObject.set("summary_earlyworkhour", (Object)dailySummaryResult.getEarlyWorkHour());
        dynamicObject.set("summary_midworkhour", (Object)dailySummaryResult.getMidWorkHour());
        dynamicObject.set("summary_lateworkhour", (Object)dailySummaryResult.getLateWorkHour());
    }

    public static Map<Long, Tuple<Date, BigDecimal>> getResourcePlanInfo(Set<Long> resoucePlanIdSet) {
        if (resoucePlanIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", resoucePlanIdSet)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getResourcePlanInfo", (String)"pmpd_resourceplan", (String)"id, preapproachtime, workrepaircycle", (QFilter[])filters, null);){
            if (dataSet.isEmpty()) {
                Map<Long, Tuple<Date, BigDecimal>> map = Collections.emptyMap();
                return map;
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)resoucePlanIdSet.size());
            for (Row row : dataSet) {
                result.put(row.getLong(0), new Tuple((Object)row.getDate(1), (Object)row.getBigDecimal(2)));
            }
            HashMap hashMap = result;
            return hashMap;
        }
    }

    public static Tuple<Date, BigDecimal> getResourcePlanInfo(long resoucePlanId) {
        Map<Long, Tuple<Date, BigDecimal>> resourcePlanInfoMap = WorkHourTemplateHelper.getResourcePlanInfo(Sets.newHashSet((Object[])new Long[]{resoucePlanId}));
        return resourcePlanInfoMap.getOrDefault(resoucePlanId, (Tuple<Date, BigDecimal>)new Tuple(null, (Object)BigDecimal.ZERO));
    }

    private static Map<Long, List<List<Object>>> getStageInfo(DynamicObject stageWorkHourTemplate, Map<Long, Map<Long, List<List<Object>>>> stageValuesCache) {
        if (stageWorkHourTemplate == null) {
            return new HashMap<Long, List<List<Object>>>(0);
        }
        long pkValue = (Long)stageWorkHourTemplate.getPkValue();
        HashMap industry2Values = stageValuesCache.get(pkValue);
        if (industry2Values != null) {
            return industry2Values;
        }
        DynamicObjectCollection collection = stageWorkHourTemplate.getDynamicObjectCollection("entryentity");
        industry2Values = Maps.newHashMapWithExpectedSize((int)collection.size());
        for (DynamicObject dynamicObject : collection) {
            DynamicObjectCollection subCollection = dynamicObject.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntryEntity : subCollection) {
                long industryId = subEntryEntity.getLong("stage_industry_id");
                ArrayList<Object> value = new ArrayList<Object>(10);
                value.add(subEntryEntity.get("stage_industry_id"));
                value.add(subEntryEntity.get("stage_stage"));
                value.add(subEntryEntity.get("stage_percentage"));
                List values = industry2Values.computeIfAbsent(industryId, k -> new ArrayList(10));
                values.add(value);
            }
        }
        stageValuesCache.put(pkValue, industry2Values);
        return industry2Values;
    }

    public static void sortByIndustry(DynamicObjectCollection collection) {
        Set<Long> industryIds = collection.stream().map(dynamicObject -> dynamicObject.getLong("industry_id")).collect(Collectors.toSet());
        Map<Object, DynamicObject> industryCache = WorkHourEstimateHelper.getIndustryFromCache(industryIds);
        WorkHourEstimateHelper.sortByIndustry(collection, dynamicObject -> (DynamicObject)industryCache.get(dynamicObject.get("industry_id")));
    }

    private static String getTaskName() {
        return ResManager.loadKDString((String)"[\u5de5\u65f6\u6a21\u677f\u53d8\u66f4]", (String)"WorkHourTemplateHelper_1", (String)"mmc-pmpd-formplugin", (Object[])new Object[0]);
    }
}

