/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.project.spec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProjectSpecServcieHelper {
    public static Map<Long, Long> getWorkpack(Set<Long> projectIds) {
        QFilter idsFilter = new QFilter("project", "in", projectIds);
        HashMap<Long, Long> workpack = new HashMap<Long, Long>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getWorkpack", (String)"pmpd_exec_workpack", (String)"id,manageid", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                if (row.getLong("id") == 0L) continue;
                workpack.put(row.getLong("id"), row.getLong("manageid"));
            }
        }
        return workpack;
    }

    public static Map<Long, Long> getJobCardToWorkpack(Set<Long> workPacks) {
        QFilter idsFilter = new QFilter("id", "in", workPacks);
        idsFilter.and("entryentity.jobcard.status", "=", (Object)Character.valueOf('C'));
        idsFilter.and("entryentity.jobcard.enable", "=", (Object)true);
        HashMap<Long, Long> jobcardSet = new HashMap<Long, Long>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getJobCardToWorkpack", (String)"pmpd_exec_workpack", (String)"id,entryentity.jobcard.id,entryentity.jobcard.workarea", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                if (row.getLong("entryentity.jobcard.id") == null || row.getLong("entryentity.jobcard.id") == 0L) continue;
                jobcardSet.put(row.getLong("entryentity.jobcard.id"), row.getLong("entryentity.jobcard.workarea"));
            }
        }
        return jobcardSet;
    }

    public static Set<Long> getJobCardToWorkpackByImportWorkMark(Set<Long> workPacks) {
        QFilter idsFilter = new QFilter("id", "in", workPacks);
        idsFilter.and("entryentity.jobcard.status", "=", (Object)Character.valueOf('C'));
        idsFilter.and("entryentity.jobcard.enable", "=", (Object)true);
        HashSet<Long> jobcardSet = new HashSet<Long>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getJobCardToWorkpack", (String)"pmpd_exec_workpack", (String)"id,entryentity.jobcard.id,entryentity.jobcard.workarea,entryentity.majorwork", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                Boolean showBool = row.getBoolean("entryentity.majorwork");
                if (showBool == null || !showBool.booleanValue() || row.getLong("entryentity.jobcard.id") == null || row.getLong("entryentity.jobcard.id") == 0L) continue;
                jobcardSet.add(row.getLong("entryentity.jobcard.id"));
            }
        }
        return jobcardSet;
    }

    public static Map<String, Long> getWorkCategorieForId(Set<Long> workcategories) {
        QFilter idsFilter = new QFilter("id", "in", workcategories);
        HashMap<String, Long> workcategorieMap = new HashMap<String, Long>(workcategories.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getAllWorkCategorie", (String)"mpdm_workcategories", (String)"id,name", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                workcategorieMap.put(row.getString("name"), row.getLong("id"));
            }
        }
        return workcategorieMap;
    }

    public static Set<Long> getWorkCategorieForName(Set<Long> workcategories) {
        QFilter idsFilter = new QFilter("id", "in", workcategories);
        HashSet<String> names = new HashSet<String>(3);
        names.add("RTN");
        names.add("CCP");
        names.add("MPB");
        QFilter nameFilter = new QFilter("name", "in", names);
        HashSet<Long> workcategorieMap = new HashSet<Long>(workcategories.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getAllWorkCategorie", (String)"mpdm_workcategories", (String)"id,name", (QFilter[])new QFilter[]{idsFilter, nameFilter}, null);){
            for (Row row : ds) {
                workcategorieMap.add(row.getLong("id"));
            }
        }
        return workcategorieMap;
    }

    public static List<String> getWorkCategorieShowOrder() {
        ArrayList<String> list = new ArrayList<String>(16);
        list.add("RTN");
        list.add("MPB");
        list.add("CCP");
        list.add("SSI");
        list.add("SSD");
        list.add("S41");
        list.add("ADD");
        list.add("RFB");
        list.add("SPC");
        list.add("MOD");
        list.add("CAB");
        list.add("PNT");
        list.add("BDD");
        list.add("LOG");
        return list;
    }

    public static Map<Long, Map<String, Object>> getMroOrder(Set<Long> jobcards) {
        QFilter idsFilter = new QFilter("treeentryentity.workcard.id", "in", jobcards);
        HashMap<Long, Map<String, Object>> mroOrderMap = new HashMap<Long, Map<String, Object>>(jobcards.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getMroOrder", (String)"pom_mroorder", (String)"id,billno,treeentryentity.workcard.id,treeentryentity.resourcestatus", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                HashMap<String, Object> mroOrder = new HashMap<String, Object>(5);
                mroOrder.put("id", row.getLong("id"));
                mroOrder.put("billno", row.getString("billno"));
                mroOrder.put("entryworkcard", row.getLong("treeentryentity.workcard.id"));
                mroOrder.put("entryresourcestatus", row.getString("treeentryentity.resourcestatus"));
                mroOrderMap.put(row.getLong("treeentryentity.workcard.id"), mroOrder);
            }
        }
        return mroOrderMap;
    }

    public static Map<Long, Long> getPlanningAreaToWorkArea(Set<Long> workAreas) {
        QFilter idsFilter = new QFilter("entryentity.mpdmarea.id", "in", workAreas);
        idsFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')));
        idsFilter.and(new QFilter("enable", "=", (Object)true));
        HashMap<Long, Long> workcategorieMap = new HashMap<Long, Long>(workAreas.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getPlanningAreaToWorkArea", (String)"fmm_planareaworkarea", (String)"id,entryentity.mpdmarea.id,planningarea", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                workcategorieMap.put(row.getLong("entryentity.mpdmarea.id"), row.getLong("planningarea"));
            }
        }
        return workcategorieMap;
    }

    public static List<Long> getProjectToresoucePlan(Long id) {
        QFilter idsFilter = new QFilter("id", "=", (Object)id);
        ArrayList<Long> list = new ArrayList<Long>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getresoucePlan", (String)"pmpd_resourceplan", (String)"id,entry_project.projcet.id,entry_project.projcet.createtime,entry_project.projcet.ismain", (QFilter[])new QFilter[]{idsFilter}, (String)"entry_project.projcet.ismain desc,entry_project.projcet.createtime");){
            for (Row row : ds) {
                if (row.getLong("entry_project.projcet.id") == null || row.getLong("entry_project.projcet.id") == 0L) continue;
                list.add(row.getLong("entry_project.projcet.id"));
            }
        }
        return list;
    }

    public static Set<Long> getresoucePlanToProject(Set<Long> ids) {
        QFilter idsFilter = new QFilter("entry_project.projcet.id", "in", ids);
        idsFilter.and("version", "=", (Object)0L);
        HashSet<Long> set = new HashSet<Long>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getresoucePlan", (String)"pmpd_resourceplan", (String)"id,entry_project.projcet.id", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                set.add(row.getLong("id"));
            }
        }
        return set;
    }

    public static Set<String> getCustomerWorkpackToName(Set<Long> keySet) {
        QFilter idsFilter = new QFilter("id", "in", keySet);
        HashSet<Long> customerIds = new HashSet<Long>(keySet.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getCustomerWorkpackToName", (String)"pmpd_exec_workpack_manage", (String)"id,customer_workpkgmanageid", (QFilter[])new QFilter[]{idsFilter}, null);){
            for (Row row : ds) {
                if (row.getLong("customer_workpkgmanageid") == 0L) continue;
                customerIds.add(row.getLong("customer_workpkgmanageid"));
            }
        }
        HashSet<String> workpackNames = new HashSet<String>(8);
        if (customerIds.isEmpty()) {
            return workpackNames;
        }
        QFilter customerIdsFilter = new QFilter("wkpkgmaid", "in", customerIds);
        QFilter customerTypeFilter = new QFilter("workpkgtype", "=", (Object)"2");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ProjectSpecServcieHelper_getCustomerWorkpackToName2", (String)"pmpd_customer_wkpkg_model", (String)"wkpkgmaid,workpkgtype,workpkgname", (QFilter[])new QFilter[]{customerIdsFilter, customerTypeFilter}, null);){
            for (Row row : ds) {
                if (row.getString("workpkgname") == null) continue;
                workpackNames.add(row.getString("workpkgname"));
            }
        }
        return workpackNames;
    }
}

