/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.resourceplan;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class CalScene {
    private DynamicObjectCollection rses;
    private DynamicObject[] estimates;
    private Date curdate;
    private Date lastdate;
    private int year;
    private String month;
    private String caltype;
    private Set<Long> monthbills;
    private static final Log log = LogFactory.getLog(CalScene.class);

    public CalScene(DynamicObjectCollection rses, DynamicObject[] estimates, Date curdate, String caltype) {
        this.curdate = curdate;
        this.rses = rses;
        this.estimates = estimates;
        Calendar c = Calendar.getInstance();
        c.setTime(curdate);
        this.year = c.get(1);
        this.month = this.getMonthDisplayName(c);
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        this.lastdate = c.getTime();
        this.monthbills = new HashSet<Long>(2);
        this.caltype = caltype;
    }

    public void excuteAllScenes() {
        if (StringUtils.equals((CharSequence)this.caltype, (CharSequence)"notfixed")) {
            this.sceneOne();
            this.sceneTwo();
            this.sceneTrd();
            this.sceneFour();
            this.sceneFive();
            this.sceneSix();
            this.sceneSve();
        } else {
            this.sceneEgt();
        }
        if (CollectionUtils.isNotEmpty(this.monthbills)) {
            DynamicObject[] monthhourbills = BusinessDataServiceHelper.load((Object[])this.monthbills.toArray(new Object[this.monthbills.size()]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_monthhourbill"));
            this.staticMonthTotalHours(monthhourbills);
        }
    }

    private void sceneEgt() {
        Set<Long> ids = this.rses.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            Map<DynamicObject, List<DynamicObject>> filterData = this.getFilterData(ids);
            Set<Long> r2 = filterData.keySet().stream().map(h -> h.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bills = this.getAllMonthBills(r2);
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
            for (Map.Entry<DynamicObject, List<DynamicObject>> data : filterData.entrySet()) {
                if (CollectionUtils.isEmpty((Collection)data.getValue())) continue;
                DynamicObject estobj = data.getValue().get(0);
                String[] fields = Lists.newArrayList((Object[])new String[]{"entryentity", "industry.id", "subentryentity_daily", "daily_workhour", "daily_date"}).toArray(new String[0]);
                DynamicObject bill = this.getMonthHourBill(data.getKey().getLong("id"), bills);
                DynamicObjectCollection monthentrys = bill.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection entryentity = estobj.getDynamicObjectCollection(fields[0]);
                Map<Long, List<DynamicObject>> proMaps = entryentity.stream().collect(Collectors.groupingBy(e -> e.getLong(fields[1])));
                for (Map.Entry<Long, List<DynamicObject>> proMap : proMaps.entrySet()) {
                    ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                    DynamicObjectCollection dynamicObjectCollection = proMap.getValue().get(0).getDynamicObjectCollection(fields[2]);
                    Map<String, Double> hourMaps = dynamicObjectCollection.stream().collect(Collectors.groupingBy(e -> {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                        return sdf.format(e.getDate(fields[4]));
                    }, Collectors.summingDouble(entry -> entry.getBigDecimal(fields[3]).doubleValue())));
                    for (Map.Entry<String, Double> hourMap : hourMaps.entrySet()) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                        Calendar nc = Calendar.getInstance();
                        try {
                            nc.setTime(sdf.parse(hourMap.getKey()));
                            if (nc.getTime().compareTo(this.curdate) < 0) continue;
                            DynamicObject tempentry = this.getNextMonthEntry(proMap.getKey(), monthentrys, entrys, nc);
                            tempentry.set(this.getMonthDisplayName(nc), (Object)BigDecimal.valueOf(hourMap.getValue()).setScale(0, RoundingMode.HALF_UP));
                        }
                        catch (ParseException e2) {
                            log.error(e2.getMessage(), (Throwable)e2);
                        }
                    }
                }
                objs.add(bill);
            }
            DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
    }

    private void staticMonthTotalHours(DynamicObject[] allmonthbills) {
        for (DynamicObject bill2 : allmonthbills) {
            DynamicObject rsplan = this.rses.stream().filter(rs -> rs.getLong("id") == bill2.getDynamicObject("resourceplan").getLong("id")).findFirst().get();
            bill2.set("overdevice", rsplan.get("overdevice"));
            bill2.set("estiapproachtime", rsplan.get("estiapproachtime"));
            bill2.set("estideparttime", rsplan.get("estideparttime"));
            bill2.set("workscope", rsplan.get("workscope"));
            DynamicObjectCollection entryentity = bill2.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryentity_total = bill2.getDynamicObjectCollection("entryentity_total");
            for (DynamicObject entry : entryentity) {
                BigDecimal total = BigDecimal.ZERO;
                for (int i = 0; i < Month.values().length; ++i) {
                    total = total.add(entry.getBigDecimal(Month.of(i + 1).getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase()));
                }
                entry.set("total", (Object)total);
            }
            Map<Integer, List<DynamicObject>> ymap = entryentity.stream().collect(Collectors.groupingBy(e -> e.getInt("year")));
            ArrayList<DynamicObject> temptentrys = new ArrayList<DynamicObject>(2);
            for (Map.Entry<Integer, List<DynamicObject>> me : ymap.entrySet()) {
                List tentrys = entryentity_total.stream().filter(t -> t.getInt("tyear") == ((Integer)me.getKey()).intValue()).collect(Collectors.toList());
                DynamicObject tentry = null;
                if (CollectionUtils.isNotEmpty(tentrys)) {
                    tentry = (DynamicObject)tentrys.get(0);
                } else {
                    List ttentrys = temptentrys.stream().filter(t -> t.getInt("tyear") == ((Integer)me.getKey()).intValue()).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(tentrys)) {
                        tentry = (DynamicObject)ttentrys.get(0);
                    } else {
                        tentry = entryentity_total.addNew();
                        tentry.set("tyear", (Object)me.getKey());
                        temptentrys.add(tentry);
                    }
                }
                BigDecimal totalmal = BigDecimal.ZERO;
                for (int i = 0; i < Month.values().length; ++i) {
                    String mfield = Month.of(i + 1).getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase();
                    BigDecimal decimal = me.getValue().stream().map(v -> v.getBigDecimal(mfield)).reduce(BigDecimal::add).get();
                    totalmal = totalmal.add(decimal);
                    tentry.set(String.format("t%s", mfield), (Object)decimal);
                }
                tentry.set("ttotal", (Object)totalmal);
            }
        }
        SaveServiceHelper.save((DynamicObject[])allmonthbills);
        Object[] allids = Arrays.stream(allmonthbills).map(bill -> bill.getLong("id")).toArray();
        this.sortBills(allids);
    }

    private void sortBills(Object[] allids) {
        DynamicObject[] allmonthbills;
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"pmpd_monthhourbill");
        for (DynamicObject bill : allmonthbills = BusinessDataServiceHelper.load((Object[])allids, (DynamicObjectType)type)) {
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectType dynamicObjectType = entryentity.getDynamicObjectType();
            DynamicObjectCollection entrys = new DynamicObjectCollection();
            CloneUtils utils = new CloneUtils(true, true);
            Map<Integer, List<DynamicObject>> grpcoll = entryentity.stream().collect(Collectors.groupingBy(e -> {
                DynamicObject h1 = e.getDynamicObject("industry");
                int i = 0;
                if (Objects.nonNull(h1)) {
                    i = h1.getInt("seqnumtwo");
                }
                return i;
            }));
            entryentity.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            List collect = grpcoll.keySet().stream().map(Integer::intValue).collect(Collectors.toList());
            collect.sort((k1, k2) -> k1 - k2);
            ArrayList ls = Lists.newArrayList((Object[])new Integer[]{1});
            Iterator iterator = collect.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                List<DynamicObject> hdyos = grpcoll.get(i);
                Map<Long, List<DynamicObject>> hmap = hdyos.stream().collect(Collectors.groupingBy(hdyo -> {
                    DynamicObject h1 = hdyo.getDynamicObject("industry");
                    long h1id = 0L;
                    if (Objects.nonNull(h1)) {
                        h1id = h1.getLong("id");
                    }
                    return h1id;
                }));
                hmap.forEach((hk, hv) -> {
                    if (hk > 0L) {
                        hv.sort((hv1, hv2) -> {
                            int y1 = hv1.getInt("year");
                            int y2 = hv2.getInt("year");
                            return y1 - y2;
                        });
                        for (DynamicObject hvalue : hv) {
                            DynamicObject clone = (DynamicObject)utils.clone((IDataEntityType)dynamicObjectType, (Object)hvalue);
                            entrys.add(ls.size() - 1, clone);
                            ls.add(1);
                        }
                    }
                });
            }
            bill.set("entryentity", (Object)entrys);
        }
        SaveServiceHelper.save((DynamicObject[])allmonthbills);
    }

    private void sceneSve() {
        Set ids = this.rses.stream().filter(rs -> this.compareDate(this.getApDate((DynamicObject)rs), this.lastdate) > 0).collect(Collectors.toList()).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            Set<Long> npids;
            Set nos = this.rses.stream().filter(rs -> ids.contains(rs.getLong("id"))).collect(Collectors.toList()).stream().map(r -> r.getString("billno")).collect(Collectors.toSet());
            QFilter filter = new QFilter("billno", "in", nos);
            filter.and(new QFilter("pulishstatus", "=", (Object)"1"));
            filter.and(new QFilter("version", "=", (Object)0L));
            DynamicObjectCollection exrsp = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"billno,entry_project.projcet as project", (QFilter[])filter.toArray());
            Map<String, Long> collect = exrsp.stream().collect(Collectors.groupingBy(exrs -> exrs.getString("billno"), Collectors.summingLong(ers -> {
                if (Objects.isNull(ers.getLong("project"))) {
                    return 0L;
                }
                return ers.getLong("project");
            })));
            HashSet<Long> pids = new HashSet<Long>(2);
            for (Map.Entry<String, Long> c : collect.entrySet()) {
                if (c.getValue() <= 0L) continue;
                DynamicObject rsobj = this.rses.stream().filter(rs -> StringUtils.equals((CharSequence)rs.getString("billno"), (CharSequence)((CharSequence)c.getKey()))).findFirst().get();
                pids.add(rsobj.getLong("id"));
            }
            if (CollectionUtils.isNotEmpty(pids)) {
                this.sceneSveOne(pids);
            }
            if (CollectionUtils.isNotEmpty(npids = ids.stream().filter(id -> !pids.contains(id)).collect(Collectors.toSet()))) {
                this.sceneSveTwo(npids);
            }
        }
    }

    private void sceneSveTwo(Set<Long> npids) {
        Map<DynamicObject, List<DynamicObject>> filterData = this.getFilterData(npids);
        Set<Long> r = filterData.keySet().stream().map(h -> h.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] bills = this.getAllMonthBills(r);
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
        for (Map.Entry<DynamicObject, List<DynamicObject>> data : filterData.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)data.getValue())) continue;
            DynamicObject estobj = data.getValue().get(0);
            String[] fields = Lists.newArrayList((Object[])new String[]{"entryentity", "industry.id", "subentryentity_daily", "daily_workhour", "daily_date"}).toArray(new String[0]);
            DynamicObject bill = this.getMonthHourBill(data.getKey().getLong("id"), bills);
            DynamicObjectCollection monthentrys = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryentity = estobj.getDynamicObjectCollection(fields[0]);
            Map<Long, List<DynamicObject>> proMaps = entryentity.stream().collect(Collectors.groupingBy(e -> e.getLong(fields[1])));
            for (Map.Entry<Long, List<DynamicObject>> proMap : proMaps.entrySet()) {
                ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                DynamicObjectCollection dynamicObjectCollection = proMap.getValue().get(0).getDynamicObjectCollection(fields[2]);
                Map<String, Double> hourMaps = dynamicObjectCollection.stream().collect(Collectors.groupingBy(e -> {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                    return sdf.format(e.getDate(fields[4]));
                }, Collectors.summingDouble(entry -> entry.getBigDecimal(fields[3]).doubleValue())));
                for (Map.Entry<String, Double> hourMap : hourMaps.entrySet()) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                    Calendar nc = Calendar.getInstance();
                    try {
                        nc.setTime(sdf.parse(hourMap.getKey()));
                        DynamicObject tempentry = this.getNextMonthEntry(proMap.getKey(), monthentrys, entrys, nc);
                        tempentry.set(this.getMonthDisplayName(nc), (Object)BigDecimal.valueOf(hourMap.getValue()).setScale(0, RoundingMode.HALF_UP));
                    }
                    catch (ParseException e2) {
                        log.error(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            objs.add(bill);
        }
        DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
        this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
    }

    private void sceneSveOne(Set<Long> pids) {
        Map<DynamicObject, List<DynamicObject>> filterData = this.getFilterData(pids);
        Set<Long> r = filterData.keySet().stream().map(h -> h.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] bills = this.getAllMonthBills(r);
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
        for (Map.Entry<DynamicObject, List<DynamicObject>> data : filterData.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)data.getValue())) continue;
            DynamicObject estobj = data.getValue().get(0);
            boolean isestimate = StringUtils.equals((CharSequence)estobj.getString("workhourtype"), (CharSequence)"estimate");
            boolean isnotfixed = StringUtils.equals((CharSequence)this.caltype, (CharSequence)"notfixed");
            String[] fields = Lists.newArrayList((Object[])new String[]{"entryentity", "industry.id", "subentryentity_daily", "daily_workhour", "daily_date"}).toArray(new String[0]);
            if (isnotfixed && !isestimate) {
                fields[0] = "s_entryentity";
                fields[1] = "s_industry.id";
                fields[2] = "s_subentryentity_daily";
                fields[3] = "s_daily_workhour";
                fields[4] = "s_daily_date";
            }
            DynamicObject bill = this.getMonthHourBill(data.getKey().getLong("id"), bills);
            DynamicObjectCollection monthentrys = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryentity = estobj.getDynamicObjectCollection(fields[0]);
            Map<Long, List<DynamicObject>> proMaps = entryentity.stream().collect(Collectors.groupingBy(e -> e.getLong(fields[1])));
            for (Map.Entry<Long, List<DynamicObject>> proMap : proMaps.entrySet()) {
                ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                DynamicObjectCollection dynamicObjectCollection = proMap.getValue().get(0).getDynamicObjectCollection(fields[2]);
                Map<String, Double> hourMaps = dynamicObjectCollection.stream().collect(Collectors.groupingBy(e -> {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                    return sdf.format(e.getDate(fields[4]));
                }, Collectors.summingDouble(entry -> entry.getBigDecimal(fields[3]).doubleValue())));
                for (Map.Entry<String, Double> hourMap : hourMaps.entrySet()) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                    Calendar nc = Calendar.getInstance();
                    try {
                        nc.setTime(sdf.parse(hourMap.getKey()));
                        DynamicObject tempentry = this.getNextMonthEntry(proMap.getKey(), monthentrys, entrys, nc);
                        tempentry.set(this.getMonthDisplayName(nc), (Object)BigDecimal.valueOf(hourMap.getValue()).setScale(0, RoundingMode.HALF_UP));
                    }
                    catch (ParseException e2) {
                        log.error(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            objs.add(bill);
        }
        DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
        this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
    }

    private void sceneSix() {
        Set<Long> ids = this.rses.stream().filter(rs -> this.compareDate(this.getApDate((DynamicObject)rs), this.curdate) < 0 && this.compareDate(this.getDpDate((DynamicObject)rs), this.lastdate) > 0 && this.inSameMonth(this.getPdDate((DynamicObject)rs), this.curdate) != false).collect(Collectors.toList()).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            HashMap<DynamicObject, List<Map>> hourMaps = this.getWorkHours(ids);
            Set<Long> r2 = hourMaps.entrySet().stream().map(h -> ((DynamicObject)h.getKey()).getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bills = this.getAllMonthBills(r2);
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
            for (Map.Entry<DynamicObject, List<Map>> hmap : hourMaps.entrySet()) {
                DynamicObject bill = this.getMonthHourBill(hmap.getKey().getLong("id"), bills);
                DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                List<Map> maps = hmap.getValue();
                Iterator<Map> iterator = maps.iterator();
                while (iterator.hasNext()) {
                    Map m;
                    Map promaps = m = iterator.next();
                    for (Map.Entry promap : promaps.entrySet()) {
                        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                        DynamicObject mentry = this.getCurYearEntry((Long)promap.getKey(), entryentity, entrys);
                        BigDecimal pretotalhour = this.getPreTotalHour((Long)promap.getKey(), entryentity).setScale(0, RoundingMode.HALF_UP);
                        mentry.set(this.month, (Object)((BigDecimal)((Map)promap.getValue()).get("dtotalhour")).subtract(pretotalhour));
                    }
                }
                objs.add(bill);
            }
            DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
    }

    private void sceneFive() {
        Set<Long> ids = this.rses.stream().filter(rs -> this.compareDate(this.getApDate((DynamicObject)rs), this.curdate) < 0 && this.compareDate(this.getDpDate((DynamicObject)rs), this.lastdate) > 0 && this.inSameMonth(this.getPdDate((DynamicObject)rs), this.curdate) == false).collect(Collectors.toList()).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            HashMap<DynamicObject, List<Map>> hourMaps = this.getWorkHours(ids);
            Set<Long> r2 = hourMaps.entrySet().stream().map(h -> ((DynamicObject)h.getKey()).getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bills = this.getAllMonthBills(r2);
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
            for (Map.Entry<DynamicObject, List<Map>> hmap : hourMaps.entrySet()) {
                DynamicObject bill = this.getMonthHourBill(hmap.getKey().getLong("id"), bills);
                DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                List<Map> maps = hmap.getValue();
                Iterator<Map> iterator = maps.iterator();
                while (iterator.hasNext()) {
                    Map m;
                    Map promaps = m = iterator.next();
                    block2: for (Map.Entry promap : promaps.entrySet()) {
                        BigDecimal rhour;
                        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                        DynamicObject mentry = this.getCurYearEntry((Long)promap.getKey(), entryentity, entrys);
                        BigDecimal remandtrt = (BigDecimal)((Map)promap.getValue()).get("remandtrt");
                        if (remandtrt.compareTo(BigDecimal.ZERO) <= 0) continue;
                        BigDecimal dhour = (BigDecimal)((Map)promap.getValue()).get("dhour");
                        BigDecimal curmonthhour = dhour.compareTo(rhour = (BigDecimal)((Map)promap.getValue()).get("rhour")) > 0 ? dhour : rhour;
                        mentry.set(this.month, (Object)curmonthhour);
                        BigDecimal pretotalhour = this.getPreTotalHour((Long)promap.getKey(), entryentity).setScale(0, RoundingMode.HALF_UP);
                        pretotalhour = pretotalhour.add(curmonthhour);
                        int months = this.monthsBetween(this.lastdate, this.getDpDate(hmap.getKey()));
                        int temptrt = remandtrt.intValue();
                        Date tempdate = this.curdate;
                        for (int i = 0; i < months; ++i) {
                            BigDecimal nexthour;
                            Calendar nc = this.getNextCalendar(tempdate);
                            int mdays = nc.getActualMaximum(5);
                            DynamicObject tempentry = this.getNextMonthEntry((Long)promap.getKey(), entryentity, entrys, nc);
                            BigDecimal remandhours = ((BigDecimal)((Map)promap.getValue()).get("dtotalhour")).subtract(pretotalhour);
                            if (mdays < temptrt) {
                                BigDecimal rate = new BigDecimal(mdays).divide(new BigDecimal(temptrt), 2, RoundingMode.HALF_UP);
                                nexthour = remandhours.multiply(rate).setScale(0, RoundingMode.HALF_UP);
                                tempentry.set(this.getMonthDisplayName(nc), (Object)nexthour);
                                temptrt -= mdays;
                            } else {
                                tempentry.set(this.getMonthDisplayName(nc), (Object)remandhours);
                                continue block2;
                            }
                            tempdate = nc.getTime();
                            pretotalhour = pretotalhour.add(nexthour);
                        }
                    }
                }
                objs.add(bill);
            }
            DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
    }

    private void sceneFour() {
        Set<Long> ids = this.rses.stream().filter(rs -> this.inSameMonth(this.getApDate((DynamicObject)rs), this.curdate) != false && this.compareDate(this.getDpDate((DynamicObject)rs), this.lastdate) > 0 && this.inSameMonth(this.getPdDate((DynamicObject)rs), this.curdate) != false).collect(Collectors.toList()).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            HashMap<DynamicObject, List<Map>> hourMaps = this.getWorkHours(ids);
            Set<Long> r2 = hourMaps.entrySet().stream().map(h -> ((DynamicObject)h.getKey()).getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bills = this.getAllMonthBills(r2);
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
            for (Map.Entry<DynamicObject, List<Map>> hmap : hourMaps.entrySet()) {
                DynamicObject bill = this.getMonthHourBill(hmap.getKey().getLong("id"), bills);
                DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                List<Map> maps = hmap.getValue();
                Iterator<Map> iterator = maps.iterator();
                while (iterator.hasNext()) {
                    Map m;
                    Map promaps = m = iterator.next();
                    for (Map.Entry promap : promaps.entrySet()) {
                        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                        DynamicObject mentry = this.getCurYearEntry((Long)promap.getKey(), entryentity, entrys);
                        BigDecimal pretotalhour = this.getPreTotalHour((Long)promap.getKey(), entryentity).setScale(0, RoundingMode.HALF_UP);
                        mentry.set(this.month, (Object)((BigDecimal)((Map)promap.getValue()).get("dtotalhour")).subtract(pretotalhour));
                    }
                }
                objs.add(bill);
            }
            DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
    }

    private void sceneTrd() {
        Set<Long> ids = this.rses.stream().filter(rs -> this.inSameMonth(this.getApDate((DynamicObject)rs), this.curdate) != false && this.compareDate(this.getDpDate((DynamicObject)rs), this.lastdate) > 0 && this.inSameMonth(this.getPdDate((DynamicObject)rs), this.curdate) == false).collect(Collectors.toList()).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            HashMap<DynamicObject, List<Map>> hourMaps = this.getWorkHours(ids);
            Set<Long> r2 = hourMaps.entrySet().stream().map(h -> ((DynamicObject)h.getKey()).getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bills = this.getAllMonthBills(r2);
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
            for (Map.Entry<DynamicObject, List<Map>> hmap : hourMaps.entrySet()) {
                DynamicObject bill = this.getMonthHourBill(hmap.getKey().getLong("id"), bills);
                DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                List<Map> maps = hmap.getValue();
                Iterator<Map> iterator = maps.iterator();
                while (iterator.hasNext()) {
                    Map m;
                    Map promaps = m = iterator.next();
                    block2: for (Map.Entry promap : promaps.entrySet()) {
                        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                        DynamicObject mentry = this.getCurYearEntry((Long)promap.getKey(), entryentity, entrys);
                        BigDecimal remandtrt = (BigDecimal)((Map)promap.getValue()).get("remandtrt");
                        if (remandtrt.compareTo(BigDecimal.ZERO) <= 0) continue;
                        ArrayList ls = new ArrayList(2);
                        ls.add(((Map)promap.getValue()).get("dhour"));
                        ls.add(((Map)promap.getValue()).get("rhour"));
                        ls.add(((Map)promap.getValue()).get("dtotalhour"));
                        ls.sort((l1, l2) -> l1.compareTo((BigDecimal)l2));
                        BigDecimal curmonthhour = (BigDecimal)ls.get(1);
                        mentry.set(this.month, (Object)curmonthhour);
                        BigDecimal pretotalhour = this.getPreTotalHour((Long)promap.getKey(), entryentity).setScale(0, RoundingMode.HALF_UP);
                        pretotalhour = pretotalhour.add(curmonthhour);
                        int months = this.monthsBetween(this.lastdate, this.getDpDate(hmap.getKey()));
                        int temptrt = remandtrt.intValue();
                        Date tempdate = this.curdate;
                        for (int i = 0; i < months; ++i) {
                            BigDecimal nexthour;
                            Calendar nc = this.getNextCalendar(tempdate);
                            int mdays = nc.getActualMaximum(5);
                            DynamicObject tempentry = this.getNextMonthEntry((Long)promap.getKey(), entryentity, entrys, nc);
                            BigDecimal remandhours = ((BigDecimal)((Map)promap.getValue()).get("dtotalhour")).subtract(pretotalhour);
                            if (mdays < temptrt) {
                                BigDecimal rate = new BigDecimal(mdays).divide(new BigDecimal(temptrt), 2, RoundingMode.HALF_UP);
                                nexthour = remandhours.multiply(rate).setScale(0, RoundingMode.HALF_UP);
                                tempentry.set(this.getMonthDisplayName(nc), (Object)nexthour);
                                temptrt -= mdays;
                            } else {
                                tempentry.set(this.getMonthDisplayName(nc), (Object)remandhours);
                                continue block2;
                            }
                            tempdate = nc.getTime();
                            pretotalhour = pretotalhour.add(nexthour);
                        }
                    }
                }
                objs.add(bill);
            }
            DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
    }

    private void sceneTwo() {
        Set<Long> ids = this.rses.stream().filter(rs -> this.inSameMonth(this.getApDate((DynamicObject)rs), this.curdate) != false && this.inSameMonth(this.getDpDate((DynamicObject)rs), this.curdate) != false).collect(Collectors.toList()).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            HashMap<DynamicObject, List<Map>> hourMaps = this.getWorkHours(ids);
            Set<Long> r2 = hourMaps.entrySet().stream().map(h -> ((DynamicObject)h.getKey()).getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bills = this.getAllMonthBills(r2);
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
            for (Map.Entry<DynamicObject, List<Map>> hmap : hourMaps.entrySet()) {
                DynamicObject bill = this.getMonthHourBill(hmap.getKey().getLong("id"), bills);
                DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                List<Map> maps = hmap.getValue();
                Iterator<Map> iterator = maps.iterator();
                while (iterator.hasNext()) {
                    Map m;
                    Map promaps = m = iterator.next();
                    for (Map.Entry promap : promaps.entrySet()) {
                        BigDecimal rp_workhour;
                        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                        DynamicObject mentry = this.getCurYearEntry((Long)promap.getKey(), entryentity, entrys);
                        BigDecimal remandtrt = (BigDecimal)((Map)promap.getValue()).get("remandtrt");
                        if (remandtrt.compareTo(BigDecimal.ZERO) > 0) continue;
                        BigDecimal es_workhour = (BigDecimal)((Map)promap.getValue()).get("dhour");
                        mentry.set(this.month, (Object)(es_workhour.compareTo(rp_workhour = (BigDecimal)((Map)promap.getValue()).get("rhour")) > 0 ? rp_workhour : es_workhour));
                    }
                }
                objs.add(bill);
            }
            DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
    }

    private void sceneOne() {
        Set<Long> ids = this.rses.stream().filter(rs -> this.compareDate(this.getApDate((DynamicObject)rs), this.curdate) < 0 && this.inSameMonth(this.getDpDate((DynamicObject)rs), this.curdate) != false).collect(Collectors.toList()).stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            HashMap<DynamicObject, List<Map>> hourMaps = this.getWorkHours(ids);
            Set<Long> r2 = hourMaps.entrySet().stream().map(h -> ((DynamicObject)h.getKey()).getLong("id")).collect(Collectors.toSet());
            DynamicObject[] bills = this.getAllMonthBills(r2);
            ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(2);
            for (Map.Entry<DynamicObject, List<Map>> hmap : hourMaps.entrySet()) {
                DynamicObject bill = this.getMonthHourBill(hmap.getKey().getLong("id"), bills);
                DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
                List<Map> maps = hmap.getValue();
                Iterator<Map> iterator = maps.iterator();
                while (iterator.hasNext()) {
                    Map m;
                    Map promaps = m = iterator.next();
                    for (Map.Entry promap : promaps.entrySet()) {
                        BigDecimal rp_workhour;
                        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(2);
                        DynamicObject mentry = this.getCurYearEntry((Long)promap.getKey(), entryentity, entrys);
                        BigDecimal remandtrt = (BigDecimal)((Map)promap.getValue()).get("remandtrt");
                        if (remandtrt.compareTo(BigDecimal.ZERO) > 0) continue;
                        BigDecimal es_workhour = (BigDecimal)((Map)promap.getValue()).get("dhour");
                        mentry.set(this.month, (Object)(es_workhour.compareTo(rp_workhour = (BigDecimal)((Map)promap.getValue()).get("rhour")) > 0 ? rp_workhour : es_workhour));
                    }
                }
                objs.add(bill);
            }
            DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.monthbills.addAll(Arrays.stream(saves).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
    }

    private DynamicObject[] getAllMonthBills(Set<Long> r) {
        DynamicObject[] bills;
        QFilter filter = new QFilter("resourceplan.id", "in", r);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"pmpd_monthhourbill", (String)"id", (QFilter[])filter.toArray());
        Object[] objects = colls.stream().map(co -> co.getLong("id")).toArray();
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])objects, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_monthhourbill"))) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection tentrys = bill.getDynamicObjectCollection("entryentity_total");
            tentrys.clear();
            DynamicObjectCollection tempentrys = new DynamicObjectCollection();
            tempentrys.addAll((Collection)entrys);
            for (DynamicObject entry : tempentrys) {
                Calendar instance = Calendar.getInstance();
                instance.setTime(this.curdate);
                if (entry.getInt("year") == this.year) {
                    for (int i = instance.get(2); i < Month.values().length; ++i) {
                        entry.set(Month.of(i + 1).getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase(), (Object)0);
                    }
                }
                if (entry.getInt("year") <= this.year) continue;
                entrys.remove((Object)entry);
            }
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        return bills;
    }

    private DynamicObject getMonthHourBill(long id, DynamicObject[] bills) {
        if (ArrayUtils.isNotEmpty((Object[])bills)) {
            List collect = Arrays.stream(bills).filter(bill -> bill.getLong("resourceplan.id") == id).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                return (DynamicObject)collect.get(0);
            }
            DynamicObject bill2 = this.createNewBill(id);
            return bill2;
        }
        DynamicObject bill3 = this.createNewBill(id);
        return bill3;
    }

    private DynamicObject createNewBill(long id) {
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"pmpd_monthhourbill");
        DynamicObject rsplan = this.rses.stream().filter(rs -> rs.getLong("id") == id).findFirst().get();
        DynamicObject rsobj = this.rses.stream().filter(rs -> rs.getLong("id") == id).findFirst().get();
        bill.set("resourceplan", (Object)id);
        bill.set("overdevice", rsplan.get("overdevice"));
        bill.set("estiapproachtime", rsplan.get("estiapproachtime"));
        bill.set("estideparttime", rsplan.get("estideparttime"));
        bill.set("workscope", rsplan.get("workscope"));
        bill.set("billstatus", (Object)"C");
        bill.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)"pmpd_monthhourbill", (DynamicObject)bill, (String)rsobj.getString("projectorg")));
        RequestContext rc = RequestContext.get();
        long currUserId = rc.getCurrUserId();
        Date date = new Date();
        bill.set("creator", (Object)currUserId);
        bill.set("modifier", (Object)currUserId);
        bill.set("auditor", (Object)currUserId);
        bill.set("createtime", (Object)date);
        bill.set("modifytime", (Object)date);
        bill.set("auditdate", (Object)date);
        bill.set("org", (Object)rsobj.getLong("projectorg"));
        return bill;
    }

    private HashMap<DynamicObject, List<Map>> getWorkHours(Set<Long> ids) {
        Map<DynamicObject, List<DynamicObject>> estms = this.getFilterData(ids);
        HashMap collect = estms.entrySet().stream().collect(HashMap::new, (m1, e1) -> {
            DynamicObject estobj = (DynamicObject)((List)e1.getValue()).get(0);
            ArrayList values = new ArrayList(2);
            boolean isestimate = StringUtils.equals((CharSequence)estobj.getString("workhourtype"), (CharSequence)"estimate");
            boolean isnotfixed = StringUtils.equals((CharSequence)this.caltype, (CharSequence)"notfixed");
            String[] fields = Lists.newArrayList((Object[])new String[]{"entryentity", "industry.id", "subentryentity_daily", "daily_workhour", "daily_date"}).toArray(new String[0]);
            if (isnotfixed && !isestimate) {
                fields[0] = "s_entryentity";
                fields[1] = "s_industry.id";
                fields[2] = "s_subentryentity_daily";
                fields[3] = "s_daily_workhour";
                fields[4] = "s_daily_date";
            }
            DynamicObjectCollection entryentity = estobj.getDynamicObjectCollection(fields[0]);
            DynamicObjectCollection rentryentity = estobj.getDynamicObjectCollection("r_entryentity");
            Set h1 = entryentity.stream().map(entry -> entry.getLong(fields[1])).collect(Collectors.toSet());
            h1.addAll(rentryentity.stream().map(entry -> entry.getLong("r_industry.id")).collect(Collectors.toSet()));
            Iterator iterator = h1.iterator();
            while (iterator.hasNext()) {
                List lists;
                DynamicObjectCollection sentrys;
                List rcoll;
                List dcoll;
                long h = (Long)iterator.next();
                HashMap promap = new HashMap(2);
                HashMap<String, BigDecimal> hmap = new HashMap<String, BigDecimal>(2);
                BigDecimal dhour = BigDecimal.ZERO;
                BigDecimal rhour = BigDecimal.ZERO;
                BigDecimal dtotalhour = BigDecimal.ZERO;
                BigDecimal remandtrt = BigDecimal.ZERO;
                if (this.compareDate(this.getDpDate((DynamicObject)e1.getKey()), this.lastdate) > 0) {
                    remandtrt = new BigDecimal(this.daysBetween(this.lastdate, this.getDpDate((DynamicObject)e1.getKey())));
                }
                if (CollectionUtils.isNotEmpty(dcoll = entryentity.stream().filter(entry -> entry.getLong(fields[1]) == h).collect(Collectors.toList()))) {
                    List lists2;
                    DynamicObjectCollection sentrys2 = ((DynamicObject)dcoll.get(0)).getDynamicObjectCollection(fields[2]);
                    if (CollectionUtils.isNotEmpty((Collection)sentrys2)) {
                        dtotalhour = sentrys2.stream().map(se -> {
                            if (Objects.isNull(se.get(fields[3]))) {
                                return BigDecimal.ZERO;
                            }
                            return se.getBigDecimal(fields[3]);
                        }).reduce(BigDecimal::add).get();
                    }
                    if (CollectionUtils.isNotEmpty(lists2 = sentrys2.stream().filter(co -> this.inSameMonth(co.getDate(fields[4]), this.curdate)).collect(Collectors.toList()))) {
                        dhour = lists2.stream().map(l -> {
                            if (Objects.isNull(l.get(fields[3]))) {
                                return BigDecimal.ZERO;
                            }
                            return l.getBigDecimal(fields[3]);
                        }).reduce(BigDecimal::add).get();
                    }
                }
                if (CollectionUtils.isNotEmpty(rcoll = rentryentity.stream().filter(entry -> entry.getLong("r_industry.id") == h).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(sentrys = ((DynamicObject)rcoll.get(0)).getDynamicObjectCollection("r_subentryentity_daily"))) && CollectionUtils.isNotEmpty(lists = sentrys.stream().filter(co -> this.inSameMonth(co.getDate("r_daily_date"), this.curdate)).collect(Collectors.toList()))) {
                    rhour = lists.stream().map(l -> {
                        if (Objects.isNull(l.get("r_daily_workhour"))) {
                            return BigDecimal.ZERO;
                        }
                        return l.getBigDecimal("r_daily_workhour");
                    }).reduce(BigDecimal::add).get();
                }
                hmap.put("dhour", dhour.setScale(0, RoundingMode.HALF_UP));
                hmap.put("rhour", rhour.setScale(0, RoundingMode.HALF_UP));
                hmap.put("dtotalhour", dtotalhour.setScale(0, RoundingMode.HALF_UP));
                hmap.put("remandtrt", remandtrt);
                promap.put(h, hmap);
                values.add(promap);
            }
            m1.put(e1.getKey(), values);
        }, (m2, m1) -> m2.putAll(m1));
        return collect;
    }

    private Date getApDate(DynamicObject rs) {
        return rs.getDate("estiapproachtime");
    }

    private Date getDpDate(DynamicObject rs) {
        return rs.getDate("estideparttime");
    }

    private Date getPdDate(DynamicObject rs) {
        return rs.getDate("predeparttime");
    }

    private int compareDate(Date d1, Date d2) {
        return d1.compareTo(d2);
    }

    private Boolean inSameMonth(Date d1, Date d2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(d1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(d2);
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2);
    }

    private Map<DynamicObject, List<DynamicObject>> getFilterData(Set<Long> ids) {
        Map<DynamicObject, List<DynamicObject>> collect = Arrays.stream(this.estimates).filter(es -> ids.contains(es.getLong("resourceplanid"))).collect(Collectors.groupingBy(e -> {
            long resourceplanid = e.getLong("resourceplanid");
            return (DynamicObject)this.rses.stream().filter(rs -> rs.getLong("id") == resourceplanid).collect(Collectors.toList()).get(0);
        }));
        return collect;
    }

    public int daysBetween(Date startdate, Date enddate) {
        long etime = enddate.getTime();
        long stime = startdate.getTime();
        int days = new BigDecimal((etime - stime) / 86400000L).setScale(0, RoundingMode.HALF_EVEN).intValue() + 1;
        return days;
    }

    public int monthsBetween(Date startdate, Date enddate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startdate);
        end.setTime(enddate);
        int result = end.get(2) - start.get(2);
        int month = (end.get(1) - start.get(1)) * 12;
        return Math.abs(month + result);
    }

    public Calendar getNextCalendar(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(2, 1);
        return instance;
    }

    public final String getMonthDisplayName(Calendar c) {
        return Month.of(c.get(2) + 1).getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase();
    }

    private DynamicObject getCurYearEntry(Long pkey, DynamicObjectCollection entryentity, ArrayList<DynamicObject> entrys) {
        List collect = entryentity.stream().filter(d -> d.getLong("industry.id") == pkey.longValue() && d.getInt("year") == this.year).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            DynamicObject mentry = (DynamicObject)collect.get(0);
            return mentry;
        }
        List templs = entrys.stream().filter(d -> {
            long inid = d.get("industry") instanceof DynamicObject ? d.getLong("industry.id") : d.getLong("industry");
            return inid == pkey && d.getInt("year") == this.year;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(templs)) {
            DynamicObject tempentry = (DynamicObject)templs.get(0);
            return tempentry;
        }
        DynamicObject tempentry = entryentity.addNew();
        tempentry.set("industry", (Object)pkey);
        tempentry.set("year", (Object)this.year);
        entrys.add(tempentry);
        return tempentry;
    }

    private DynamicObject getNextMonthEntry(Long pkey, DynamicObjectCollection entryentity, ArrayList<DynamicObject> entrys, Calendar nc) {
        List tcoll = entryentity.stream().filter(d -> d.getLong("industry.id") == pkey.longValue() && d.getInt("year") == nc.get(1)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tcoll)) {
            DynamicObject tempentry = (DynamicObject)tcoll.get(0);
            return tempentry;
        }
        List templs = entrys.stream().filter(d -> {
            long inid = d.get("industry") instanceof DynamicObject ? d.getLong("industry.id") : d.getLong("industry");
            return inid == pkey && d.getInt("year") == nc.get(1);
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(templs)) {
            DynamicObject tempentry = (DynamicObject)templs.get(0);
            return tempentry;
        }
        DynamicObject tempentry = entryentity.addNew();
        tempentry.set("industry", (Object)pkey);
        tempentry.set("year", (Object)nc.get(1));
        entrys.add(tempentry);
        return tempentry;
    }

    private BigDecimal getPreTotalHour(Long propk, DynamicObjectCollection entryentity) {
        BigDecimal pretotalhour = BigDecimal.ZERO;
        List precoll = entryentity.stream().filter(d -> d.getLong("industry.id") == propk.longValue() && d.getInt("year") <= this.year).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(precoll)) {
            block0: for (DynamicObject preobj : precoll) {
                for (int i = 0; i < Month.values().length; ++i) {
                    String tempmonth = Month.of(i + 1).getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase();
                    if (preobj.getInt("year") == this.year && StringUtils.equals((CharSequence)this.month, (CharSequence)tempmonth)) continue block0;
                    pretotalhour = pretotalhour.add(preobj.getBigDecimal(tempmonth));
                }
            }
        }
        return pretotalhour;
    }
}

