/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.resourceplan.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmpd.resourceplan.CalScene;

public class AutoCalMonthHourTaskHelper {
    private static final Long JOBPARAMID = 1541306945527403520L;
    private static final String taskplanEntity = "pmpd_schjobparams";
    private static final String FILTERSTR = "filterstr";
    private static final String ISCURMONTH = "iscurmonth";
    private static final String FIXED = "fixed";
    private static final String NOTFIXED = "notfixed";
    private static Log log = LogFactory.getLog(AutoCalMonthHourTaskHelper.class);

    public static void calMonthHour(Map map) {
        FilterBuilder builder;
        FilterCondition condition;
        Boolean iscurmonth = Boolean.parseBoolean(map.get(ISCURMONTH).toString());
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        if (iscurmonth.booleanValue()) {
            c.set(5, 1);
        } else {
            c.add(2, -1);
            c.set(5, 1);
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date curdate = c.getTime();
        QFilter filter = AutoCalMonthHourTaskHelper.getRspFilter();
        filter.and(new QFilter("estideparttime", ">=", (Object)curdate));
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pmpd_resourceplan");
        if (StringUtils.isNotBlank(map.get(FILTERSTR)) && Objects.nonNull(condition = (FilterCondition)SerializationUtils.fromJsonString((String)map.get(FILTERSTR).toString(), FilterCondition.class))) {
            DynamicObjectCollection excoll;
            Set esids;
            builder = new FilterBuilder(dataEntityType, condition);
            builder.buildFilter();
            if (Objects.nonNull(builder.getQFilter()) && CollectionUtils.isNotEmpty(esids = (excoll = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id", (QFilter[])builder.getQFilter().and(filter).toArray())).stream().map(ex -> ex.getLong("id")).collect(Collectors.toSet()))) {
                filter.and(new QFilter("id", "not in", esids));
            }
        }
        if (StringUtils.isNotBlank(map.get(FIXED)) && Objects.nonNull(condition = (FilterCondition)SerializationUtils.fromJsonString((String)map.get(FIXED).toString(), FilterCondition.class))) {
            builder = new FilterBuilder(dataEntityType, condition);
            builder.buildFilter();
            if (Objects.nonNull(builder.getQFilter())) {
                DynamicObjectCollection rses = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id,billno,estiapproachtime,estideparttime,predeparttime,projectorg,overdevice,workscope", (QFilter[])builder.getQFilter().and(filter).toArray());
                Set rsids = rses.stream().map(ex -> ex.getLong("id")).collect(Collectors.toSet());
                QFilter esfilter = new QFilter("resourceplanid", "in", rsids);
                esfilter.and(new QFilter("effectivestatus", "=", (Object)"1"));
                DynamicObjectCollection ests = QueryServiceHelper.query((String)"pmpd_hour_estimate", (String)"id,resourceplan", (QFilter[])esfilter.toArray());
                Object[] ids = ests.stream().map(est -> est.getLong("id")).toArray();
                List<String> billnos = ests.stream().map(est -> est.getString("resourceplan")).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty((Collection)rses) && ArrayUtils.isNotEmpty((Object[])ids)) {
                    AutoCalMonthHourTaskHelper.reCalEstimates(billnos);
                    DynamicObject[] estimates = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_hour_estimate"));
                    CalScene calScene = new CalScene(rses, estimates, curdate, FIXED);
                    calScene.excuteAllScenes();
                }
                if (CollectionUtils.isNotEmpty(rsids)) {
                    filter.and(new QFilter("id", "not in", rsids));
                }
            }
        }
        if (StringUtils.isNotBlank(map.get(NOTFIXED)) && Objects.nonNull(condition = (FilterCondition)SerializationUtils.fromJsonString((String)map.get(NOTFIXED).toString(), FilterCondition.class))) {
            builder = new FilterBuilder(dataEntityType, condition);
            builder.buildFilter();
            if (Objects.nonNull(builder.getQFilter())) {
                filter.and(builder.getQFilter());
            }
        }
        DynamicObjectCollection rses = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)"id,billno,estiapproachtime,estideparttime,predeparttime,projectorg,overdevice,workscope", (QFilter[])filter.toArray());
        Set rsids = rses.stream().map(rs -> rs.getLong("id")).collect(Collectors.toSet());
        QFilter esfilter = new QFilter("resourceplanid", "in", rsids);
        esfilter.and(new QFilter("effectivestatus", "=", (Object)"1"));
        DynamicObjectCollection ests = QueryServiceHelper.query((String)"pmpd_hour_estimate", (String)"id,resourceplan", (QFilter[])esfilter.toArray());
        Object[] ids = ests.stream().map(est -> est.getLong("id")).toArray();
        List<String> billnos = ests.stream().map(est -> est.getString("resourceplan")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)rses) && ArrayUtils.isNotEmpty((Object[])ids)) {
            AutoCalMonthHourTaskHelper.reCalEstimates(billnos);
            DynamicObject[] estimates = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_hour_estimate"));
            CalScene calScene = new CalScene(rses, estimates, curdate, NOTFIXED);
            calScene.excuteAllScenes();
        }
        QFilter mfilter = new QFilter("id", ">", (Object)0L);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"pmpd_monthhourbill", (String)"resourceplan.id as rsid", (QFilter[])mfilter.toArray());
        Set rsid = bills.stream().map(bill -> bill.getLong("rsid")).collect(Collectors.toSet());
        QFilter rspFilter = AutoCalMonthHourTaskHelper.getRspFilter();
        rspFilter.and(new QFilter("id", "not in", rsid));
        DynamicObject[] rsobjs = BusinessDataServiceHelper.load((String)"pmpd_resourceplan", (String)"id,billno,overdevice,estiapproachtime,estideparttime,workscope,projectorg", (QFilter[])rspFilter.toArray());
        List<String> allbillnos = Arrays.stream(rsobjs).map(rsobj -> rsobj.getString("billno")).collect(Collectors.toList());
        AutoCalMonthHourTaskHelper.reCalEstimates(allbillnos);
        ArrayList<DynamicObject> billls = new ArrayList<DynamicObject>(2);
        for (DynamicObject rsplan : rsobjs) {
            DynamicObject bill2 = BusinessDataServiceHelper.newDynamicObject((String)"pmpd_monthhourbill");
            bill2.set("resourceplan", (Object)rsplan);
            bill2.set("overdevice", rsplan.get("overdevice"));
            bill2.set("estiapproachtime", rsplan.get("estiapproachtime"));
            bill2.set("estideparttime", rsplan.get("estideparttime"));
            bill2.set("workscope", rsplan.get("workscope"));
            bill2.set("billstatus", (Object)"C");
            bill2.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)"pmpd_monthhourbill", (DynamicObject)bill2, (String)rsplan.getString("projectorg.id")));
            RequestContext rc = RequestContext.get();
            long currUserId = rc.getCurrUserId();
            Date date = new Date();
            bill2.set("creator", (Object)currUserId);
            bill2.set("modifier", (Object)currUserId);
            bill2.set("auditor", (Object)currUserId);
            bill2.set("createtime", (Object)date);
            bill2.set("modifytime", (Object)date);
            bill2.set("auditdate", (Object)date);
            bill2.set("org", (Object)rsplan.getLong("projectorg.id"));
            billls.add(bill2);
        }
        if (CollectionUtils.isNotEmpty(billls)) {
            SaveServiceHelper.save((DynamicObject[])billls.toArray(new DynamicObject[1]));
        }
    }

    private static QFilter getRspFilter() {
        QFilter filter = new QFilter("pulishstatus", "=", (Object)"0");
        filter.and(new QFilter("estiapproachtime", "is not null", null)).and(new QFilter("predeparttime", "is not null", null));
        filter.and(new QFilter("projectorg", "is not null", null));
        filter.and(new QFilter("version", "=", (Object)0L));
        return filter;
    }

    public static void calMonthHour(Boolean iscurmonth, AbstractFormPlugin plugin) {
        Map<String, String> map = AutoCalMonthHourTaskHelper.getJobParams();
        map.put(ISCURMONTH, iscurmonth != false ? "true" : "false");
        AutoCalMonthHourTaskHelper.calMonthHour(map);
        plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"AutoCalMonthHourTaskHelper_0", (String)"mmc-pmpd-business", (Object[])new Object[0]));
        plugin.getView().invokeOperation("refresh");
    }

    private static Map<String, String> getJobParams() {
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)JOBPARAMID, (String)taskplanEntity);
        HashMap<String, String> rsMap = new HashMap<String, String>(2);
        rsMap.put(ISCURMONTH, Boolean.toString(taskObj.getBoolean(ISCURMONTH)));
        rsMap.put(FILTERSTR, taskObj.getString("filterstr_tag"));
        rsMap.put(FIXED, taskObj.getString("fixed_tag"));
        rsMap.put(NOTFIXED, taskObj.getString("notfixed_tag"));
        return rsMap;
    }

    private static void reCalEstimates(List<String> billnos) {
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(16);
        customParams.put("updateStandardWorkHour", Boolean.TRUE);
        customParams.put("updateReportWorkHour", Boolean.TRUE);
        customParams.put("calculateEstimateWorkHour", Boolean.TRUE);
        customParams.put("calculateStandardWorkHour", Boolean.TRUE);
        customParams.put("writebackToResourcePlan", Boolean.TRUE);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"WorkingHourService", (String)"reestimate", (Object[])new Object[]{billnos, customParams});
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            log.info(resultMap.get("msg").toString());
        }
    }
}

