/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.gantt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.enums.ExecuteStatusEnum;
import kd.pmc.pmpd.common.helper.ResourcePlanHelper;
import kd.pmc.pmpd.common.model.DragResourcePlanModel;
import kd.pmc.pmpd.common.util.NoseToTailUtil;
import org.apache.commons.lang3.time.DateUtils;

public class DragResourcePlanHelper {
    private static String ITEM = "item";
    private static String TARGETGANTTTYPE = "targetGanttType";
    private static String TARGETGROUPID = "targetGroupId";
    private static String TARGETROW = "targetRow";

    public static void getDragModel(GanttCommandContext ctx, DragResourcePlanModel dragModel) {
        String taskObjId;
        JSONObject jsonObj = JSON.parseObject((String)ctx.geteArgs());
        GanttTaskModel taskModel = (GanttTaskModel)JSON.parseObject((String)jsonObj.getString(ITEM), GanttTaskModel.class);
        GanttRowDataModel rowDataModel = (GanttRowDataModel)JSON.parseObject((String)jsonObj.getString(TARGETROW), GanttRowDataModel.class);
        String dataModelType = taskModel.getDataModelType();
        String targetDataModelType = rowDataModel.getDataModelType();
        String ganttType = taskModel.getGanttType();
        String targetGanttType = jsonObj.getString(TARGETGANTTTYPE);
        String targetGroupId = jsonObj.getString(TARGETGROUPID);
        Long startTime = taskModel.getStartDate();
        Long endTime = taskModel.getEndDate();
        GanttBuildContext context = (GanttBuildContext)GanttCacheUtils.getCacheBigObjectWithDataModel((IPageCache)ctx.getView().getPageCache(), (String)targetDataModelType, (String)"ganttBuildContext");
        String groupToField = GanttUtils.getTaskUpFlag((GanttBuildContext)context);
        dragModel.setTaskModel(taskModel);
        dragModel.setRowDataModel(rowDataModel);
        dragModel.setDataModelType(dataModelType);
        dragModel.setTargetDataModelType(targetDataModelType);
        dragModel.setGanttType(ganttType);
        dragModel.setTargetGanttType(targetGanttType);
        dragModel.setTargetGroupId(targetGroupId);
        dragModel.setStartTime(startTime);
        dragModel.setEndTime(endTime);
        dragModel.setContext(context);
        String taskId = taskModel.getTaskEntryId();
        String startTimeToField = taskModel.getStarttimeToField();
        String endTimeToField = taskModel.getEndtimeToField();
        ListView view = (ListView)ctx.getView();
        String metaKey = view.getListModel().getEntityId();
        long mainId = Long.parseLong(taskId);
        String entryTag = GanttCacheUtils.getCacheWithDataModel((IPageCache)ctx.getPageCache(), (String)dataModelType, (String)"entryTag");
        boolean entryGroup = false;
        if (StringUtils.isNotBlank((CharSequence)entryTag)) {
            QFilter qFilter = new QFilter(entryTag.concat(".id"), "=", (Object)mainId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)metaKey, (String)"id", (QFilter[])qFilter.toArray());
            if (Objects.nonNull(dynamicObject)) {
                mainId = dynamicObject.getLong("id");
            }
            int tagLength = entryTag.length() + 1;
            startTimeToField = startTimeToField.substring(tagLength);
            endTimeToField = endTimeToField.substring(tagLength);
            if (groupToField.contains(entryTag)) {
                entryGroup = true;
                groupToField = groupToField.substring(entryTag.length() + 1);
            }
        }
        dragModel.setGroupToField(groupToField);
        boolean isSectionTimeField = StringUtils.equals((CharSequence)"sectionstarttime", (CharSequence)startTimeToField) && StringUtils.equals((CharSequence)"sectionendtime", (CharSequence)endTimeToField);
        DynamicObject resourcePlanDyn = BusinessDataServiceHelper.loadSingle((Object)mainId, (String)metaKey);
        dragModel.setTaskId(taskId);
        dragModel.setStartTimeToField(startTimeToField);
        dragModel.setEndTimeToField(endTimeToField);
        dragModel.setMetaKey(metaKey);
        dragModel.setMainId(mainId);
        dragModel.setEntryTag(entryTag);
        dragModel.setEntryGroup(entryGroup);
        dragModel.setResourcePlanDyn(resourcePlanDyn);
        dragModel.setIsSectionTimeField(isSectionTimeField);
        dragModel.getResourcePlanList().add(resourcePlanDyn.getString("billno"));
        String number = GanttCommandUtils.getBillNo((DynamicObject)resourcePlanDyn);
        dragModel.getGanttLogModel().setBusinessObj(taskModel.getMetaKey());
        dragModel.getGanttLogModel().setBillNo(number);
        String requestId = GanttCacheUtils.getCacheWithDataModel((IPageCache)ctx.getPageCache(), (String)taskModel.getDataModelType(), (String)"requestId");
        String taskEntityIds = GanttCacheUtils.getCache((IPageCache)ctx.getPageCache(), (String)"taskEntityIds");
        String groupId = targetGroupId;
        groupId = taskObjId = groupId.substring(requestId.length());
        dragModel.setGroupId(groupId);
        DynamicObject mGanttSourceObj = (DynamicObject)GanttCacheUtils.getCacheBigObject((String)ctx.getView().getPageId(), (String)"datasource");
        String taskUpEntityNumber = GanttCommandUtils.getTaskUpEntityNumber((DynamicObject)mGanttSourceObj, (String)taskEntityIds, (String)rowDataModel.getDataModelType());
        DynamicObject groupObj = null;
        if (StringUtils.isNotBlank((CharSequence)groupId) && !StringUtils.equals((CharSequence)groupId, (CharSequence)"0")) {
            groupObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(groupId), (String)taskUpEntityNumber);
        }
        dragModel.setGroupObj(groupObj);
        if (StringUtils.isNotBlank((CharSequence)entryTag)) {
            DynamicObjectCollection coll = resourcePlanDyn.getDynamicObjectCollection(entryTag);
            for (DynamicObject dynamicObject : coll) {
                if (!taskId.equals(dynamicObject.getPkValue().toString())) continue;
                Date beforeStartTime = dynamicObject.getDate(startTimeToField);
                dragModel.setMoveTime(startTime - beforeStartTime.getTime());
                dragModel.setMoveDay(NoseToTailUtil.getDiffDay((Date)beforeStartTime, (Date)new Date(startTime)));
                break;
            }
        }
        if (resourcePlanDyn.getBoolean("isnosetotail") && resourcePlanDyn.getLong("nosetotail.id") != 0L) {
            DynamicObject noseToTailDyn = BusinessDataServiceHelper.loadSingle((Object)resourcePlanDyn.getLong("nosetotail.id"), (String)"pmpd_nosetotail");
            dragModel.setNoseToTailDyn(noseToTailDyn);
            DynamicObjectCollection query = noseToTailDyn.getDynamicObjectCollection("entryentity");
            Set collect = query.stream().filter(x -> x.getLong("resourceplan.id") != resourcePlanDyn.getLong("id") && x.getLong("resourceplan.id") != 0L && ExecuteStatusEnum.NOENTRANCE.getValue().equals(x.getString("resourceplan.executestatus"))).map(x -> x.getLong("resourceplan.id")).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(collect)) {
                DynamicObject[] load;
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pmpd_resourceplan");
                for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)dataEntityType)) {
                    dragModel.getResourcePlanList().add(dynamicObject.getString("billno"));
                    dragModel.getRelatedResourcePlanList().add(dynamicObject);
                }
            }
        }
    }

    public static void judgeCanDrag(GanttCommandContext ctx, DragResourcePlanModel dragModel) {
        String cammandName = ResManager.loadKDString((String)"\u4e0a\u4e0b\u79fb\u52a8", (String)"DragResourcePlanHelper_0", (String)"mmc-pmpd-business", (Object[])new Object[0]);
        dragModel.getGanttLogModel().setName(cammandName);
        if ("pageData".equals(dragModel.getGanttType()) && !"pageData".equals(dragModel.getTargetGanttType())) {
            String verifyResult = ResManager.loadKDString((String)"\u8ba1\u5212\u533a\u6a2a\u9053\u4e0d\u53ef\u62d6\u62fd\u81f3\u5176\u4ed6\u533a\u3002", (String)"DragResourcePlanHelper_3", (String)"mmc-pmpd-business", (Object[])new Object[0]);
            throw new KDBizException(verifyResult);
        }
        String filterStartTimeStr = GanttCacheUtils.getCache((IPageCache)ctx.getPageCache(), (String)"filterStartTime");
        String filterEndTimeStr = GanttCacheUtils.getCache((IPageCache)ctx.getPageCache(), (String)"filterEndTime");
        if (StringUtils.isNotBlank((CharSequence)filterStartTimeStr) && StringUtils.isNotBlank((CharSequence)filterEndTimeStr)) {
            long filterStartTime = Long.parseLong(filterStartTimeStr);
            long filterEndTime = Long.parseLong(filterEndTimeStr);
            if (filterStartTime > dragModel.getEndTime() || filterEndTime <= dragModel.getStartTime()) {
                String verifyResult = ResManager.loadKDString((String)"\u6a2a\u9053\u4e0d\u53ef\u62d6\u62fd\u81f3\u65f6\u95f4\u8303\u56f4\u5916\u3002", (String)"DragResourcePlanHelper_11", (String)"mmc-pmpd-business", (Object[])new Object[0]);
                throw new KDBizException(verifyResult);
            }
        }
    }

    public static void verifyFixModel(DragResourcePlanModel dragModel) {
        DynamicObject dynObj = dragModel.getResourcePlanDyn();
        DynamicObject groupObj = dragModel.getGroupObj();
        DynamicObject fixModel = dynObj.getDynamicObject("fixmodel");
        if (fixModel != null) {
            long modelGroupId = fixModel.getLong("group.id");
            long optypeId = dynObj.getLong("optype.id");
            if (groupObj != null && Arrays.asList(1539703538169428992L, 1539703862640785408L).contains(modelGroupId)) {
                DynamicObjectCollection modelColl;
                long modelId = fixModel.getLong("id");
                if (modelGroupId == 1539703862640785408L) {
                    Map upModelMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMrTypeConfigModelService", (String)"getParentTypeById", (Object[])new Object[]{modelId});
                    Long modelTwo = null;
                    if (upModelMap.size() != 0) {
                        modelTwo = (Long)upModelMap.get("modeltwo");
                    }
                    if (modelTwo == null) {
                        String infoMsg = String.format(ResManager.loadKDString((String)"\u901a\u8fc7L3\uff08%d) \u672a\u627e\u5230L2\u3002", (String)"DragResourcePlanHelper_7", (String)"mmc-pmpd-business", (Object[])new Object[0]), modelId);
                        throw new KDBizException(infoMsg);
                    }
                    modelId = modelTwo;
                }
                if (!CollectionUtils.isEmpty((Collection)(modelColl = groupObj.getDynamicObjectCollection("modelentryentity")))) {
                    for (DynamicObject model : modelColl) {
                        long sourceOptypeId = model.getLong("optype.id");
                        long sourceModelId = model.getLong("model.id");
                        if (optypeId != sourceOptypeId || modelId != sourceModelId) continue;
                        String infoMsg = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u4f5c\u4e2d\u5fc3\uff08%s\uff09\u4e0d\u652f\u6301\u5f53\u524d\u68c0\u4fee\u578b\u53f7\uff0c\u8bf7\u91cd\u65b0\u5206\u914d\u3002", (String)"DragResourcePlanHelper_8", (String)"mmc-pmpd-business", (Object[])new Object[0]), groupObj.getLocaleString("name"));
                        throw new KDBizException(infoMsg);
                    }
                }
            }
        }
    }

    public static void verifyBeforeToday(DragResourcePlanModel dragModel) {
        ArrayList<String> errorBillNoList = new ArrayList<String>();
        DynamicObject resourcePlanDyn = dragModel.getResourcePlanDyn();
        Timestamp timestamp = new Timestamp(resourcePlanDyn.getDate("estiapproachtime").getTime() + dragModel.getMoveTime());
        if (timestamp.getTime() < NoseToTailUtil.getTodayEnd().getTime()) {
            errorBillNoList.add(resourcePlanDyn.getString("billno"));
        }
        for (DynamicObject dynamicObject : dragModel.getRelatedResourcePlanList()) {
            Timestamp startTimeStamp = new Timestamp(DateUtils.addDays((Date)dynamicObject.getDate("estiapproachtime"), (int)dragModel.getMoveDay()).getTime());
            if (startTimeStamp.getTime() >= NoseToTailUtil.getTodayEnd().getTime()) continue;
            errorBillNoList.add(dynamicObject.getString("billno"));
        }
        if (errorBillNoList.size() > 0) {
            String msg = String.join((CharSequence)",", errorBillNoList).concat(ResManager.loadKDString((String)"\u79fb\u52a8\u7684\u65f6\u95f4\u5df2\u81f3\u4eca\u5929\u4e4b\u524d\uff0c\u4e0d\u7b26\u5408\u79fb\u52a8\u89c4\u5219\uff0c\u79fb\u52a8\u64cd\u4f5c\u4e2d\u6b62\u3002", (String)"DragResourcePlanHelper_9", (String)"mmc-pmpd-business", (Object[])new Object[0]));
            throw new KDBizException(msg);
        }
    }

    public static void updateTime(DragResourcePlanModel dragModel) {
        String cammandName = ResManager.loadKDString((String)"\u4e0a\u4e0b\u79fb\u52a8", (String)"DragResourcePlanHelper_0", (String)"mmc-pmpd-business", (Object[])new Object[0]);
        String entryTag = dragModel.getEntryTag();
        DynamicObject dynObj = dragModel.getResourcePlanDyn();
        String taskId = dragModel.getTaskId();
        boolean entryGroup = dragModel.getEntryGroup();
        String groupToField = dragModel.getGroupToField();
        DynamicObject groupObj = dragModel.getGroupObj();
        String startTimeToField = dragModel.getStartTimeToField();
        String endTimeToField = dragModel.getEndTimeToField();
        Long startTime = dragModel.getStartTime();
        Long endTime = dragModel.getEndTime();
        long moveTime = dragModel.getMoveTime();
        boolean isSectionTimeField = dragModel.getIsSectionTimeField();
        String groupId = dragModel.getGroupId();
        StringBuilder beforeContent = new StringBuilder(ResManager.loadKDString((String)"\u6240\u5c5e\u8d44\u6e90\u540d\u79f0\uff1a", (String)"DragResourcePlanHelper_1", (String)"mmc-pmpd-business", (Object[])new Object[0]));
        StringBuilder afterContent = new StringBuilder(ResManager.loadKDString((String)"\u6240\u5c5e\u8d44\u6e90\u540d\u79f0\uff1a", (String)"DragResourcePlanHelper_1", (String)"mmc-pmpd-business", (Object[])new Object[0]));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        if (StringUtils.isNotBlank((CharSequence)entryTag)) {
            DynamicObjectCollection coll = dynObj.getDynamicObjectCollection(entryTag);
            for (DynamicObject dynamicObject : coll) {
                if (!taskId.equals(dynamicObject.getPkValue().toString())) continue;
                DynamicObject up = null;
                up = entryGroup ? dynamicObject.getDynamicObject(groupToField) : dynObj.getDynamicObject(groupToField);
                if (GanttCommandUtils.getIdJundeNull((DynamicObject)groupObj) == GanttCommandUtils.getIdJundeNull((DynamicObject)up)) {
                    beforeContent.setLength(0);
                    beforeContent.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragResourcePlanHelper_2", (String)"mmc-pmpd-business", (Object[])new Object[0]));
                    afterContent.setLength(0);
                    afterContent.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragResourcePlanHelper_2", (String)"mmc-pmpd-business", (Object[])new Object[0]));
                    cammandName = ResManager.loadKDString((String)"\u5de6\u53f3\u79fb\u52a8", (String)"DragResourcePlanHelper_13", (String)"mmc-pmpd-business", (Object[])new Object[0]);
                } else {
                    beforeContent.append(up == null ? " " : GanttCommandUtils.getBillName((DynamicObject)up));
                    beforeContent.append(String.format(ResManager.loadKDString((String)"%s\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragResourcePlanHelper_14", (String)"mmc-pmpd-business", (Object[])new Object[0]), ", "));
                    afterContent.append(groupObj == null ? " " : GanttCommandUtils.getBillName((DynamicObject)groupObj));
                    afterContent.append(String.format(ResManager.loadKDString((String)"%s\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragResourcePlanHelper_14", (String)"mmc-pmpd-business", (Object[])new Object[0]), ", "));
                }
                Date beforeStartTime = dynamicObject.getDate(startTimeToField);
                beforeContent.append(Objects.isNull(beforeStartTime) ? "_" : sdf.format(beforeStartTime));
                beforeContent.append(String.format(ResManager.loadKDString((String)"%s\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"DragResourcePlanHelper_15", (String)"mmc-pmpd-business", (Object[])new Object[0]), ", "));
                Date beforeEndTime = dynamicObject.getDate(endTimeToField);
                beforeContent.append(Objects.isNull(beforeEndTime) ? "_" : sdf.format(beforeEndTime));
                if (entryGroup) {
                    dynamicObject.set(groupToField, (Object)groupId);
                    if (StringUtils.equals((CharSequence)groupToField, (CharSequence)"sectionresource")) {
                        boolean mainWorkCenter;
                        if (groupObj == null) {
                            mainWorkCenter = dynamicObject.getBoolean("mianworkcenter");
                            if (mainWorkCenter) {
                                dynObj.set("workcenter", (Object)0L);
                            }
                            dynamicObject.set("profitworkcenter", (Object)false);
                        } else {
                            mainWorkCenter = dynamicObject.getBoolean("mianworkcenter");
                            if (mainWorkCenter) {
                                dynObj.set("workcenter", (Object)groupId);
                            } else {
                                long count = coll.stream().filter(x -> x.getBoolean("mianworkcenter")).count();
                                if (count == 0L) {
                                    dynamicObject.set("mianworkcenter", (Object)true);
                                    dynObj.set("workcenter", (Object)groupId);
                                }
                            }
                            dynamicObject.set("profitworkcenter", (Object)groupObj.getBoolean("profitworkcenter"));
                        }
                    }
                } else {
                    dynObj.set(groupToField, (Object)groupId);
                }
                dynamicObject.set(startTimeToField, (Object)new Timestamp(startTime));
                dynamicObject.set(endTimeToField, (Object)new Timestamp(endTime));
                afterContent.append(sdf.format(new Date(startTime)));
                afterContent.append(String.format(ResManager.loadKDString((String)"%s\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"DragResourcePlanHelper_15", (String)"mmc-pmpd-business", (Object[])new Object[0]), ", "));
                afterContent.append(sdf.format(new Date(endTime)));
                break;
            }
            if (isSectionTimeField) {
                for (DynamicObject dynamicObject : coll) {
                    if (taskId.equals(dynamicObject.getPkValue().toString())) continue;
                    Date beforeStartTime = dynamicObject.getDate(startTimeToField);
                    Date beforeEndTime = dynamicObject.getDate(endTimeToField);
                    dynamicObject.set(startTimeToField, (Object)new Timestamp(beforeStartTime.getTime() + moveTime));
                    dynamicObject.set(endTimeToField, (Object)new Timestamp(beforeEndTime.getTime() + moveTime));
                }
                Timestamp timestamp = new Timestamp(dynObj.getDate("estiapproachtime").getTime() + moveTime);
                dynObj.set("estiapproachtime", (Object)timestamp);
                dynObj.set("estideparttime", (Object)new Timestamp(dynObj.getDate("estideparttime").getTime() + moveTime));
            }
            dragModel.getGanttLogModel().setBeforeContent(beforeContent.toString());
            dragModel.getGanttLogModel().setAfterContent(afterContent.toString());
            dragModel.getGanttLogModel().setName(cammandName);
            int moveDay = dragModel.getMoveDay();
            List relatedResourcePlanList = dragModel.getRelatedResourcePlanList();
            for (DynamicObject dynamicObject : relatedResourcePlanList) {
                Timestamp startTimeStamp = new Timestamp(DateUtils.addDays((Date)dynamicObject.getDate("estiapproachtime"), (int)moveDay).getTime());
                dynamicObject.set("estiapproachtime", (Object)startTimeStamp);
                dynamicObject.set("estideparttime", (Object)new Timestamp(DateUtils.addDays((Date)dynamicObject.getDate("estideparttime"), (int)moveDay).getTime()));
                ResourcePlanHelper.recalWorkHour((DynamicObject)dynamicObject);
                DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection(entryTag);
                for (DynamicObject object : entryColl) {
                    Date beforeStartTime = object.getDate(startTimeToField);
                    Date beforeEndTime = object.getDate(endTimeToField);
                    object.set(startTimeToField, (Object)DateUtils.addDays((Date)beforeStartTime, (int)moveDay).getTime());
                    object.set(endTimeToField, (Object)DateUtils.addDays((Date)beforeEndTime, (int)moveDay).getTime());
                }
            }
        }
    }

    public static void updateMileStone(DragResourcePlanModel dragModel) {
        DynamicObject resourcePlanDyn = dragModel.getResourcePlanDyn();
        List relatedResourcePlanList = dragModel.getRelatedResourcePlanList();
        NoseToTailUtil.updateMileStone((DynamicObject)resourcePlanDyn);
        for (DynamicObject dynamicObject : relatedResourcePlanList) {
            NoseToTailUtil.updateMileStone((DynamicObject)dynamicObject);
        }
    }

    public static void updateWorkHour(DragResourcePlanModel dragModel) {
        List resourcePlanList = dragModel.getResourcePlanList();
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(16);
        customParams.put("calculateEstimateWorkHour", Boolean.TRUE);
        customParams.put("calculateStandardWorkHour", Boolean.TRUE);
        customParams.put("writebackToResourcePlan", Boolean.TRUE);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"WorkingHourService", (String)"reestimate", (Object[])new Object[]{resourcePlanList, customParams});
    }

    public static void saveDate(DragResourcePlanModel dragModel) {
        DynamicObject resourcePlanDyn = dragModel.getResourcePlanDyn();
        List relatedResourcePlanList = dragModel.getRelatedResourcePlanList();
        DynamicObject[] dynamicObjects = new DynamicObject[relatedResourcePlanList.size() + 1];
        int index = 0;
        dynamicObjects[index++] = resourcePlanDyn;
        for (DynamicObject dynamicObject : relatedResourcePlanList) {
            dynamicObjects[index++] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public static void saveNoseToTail(DragResourcePlanModel dragModel) {
        DynamicObject noseToTailDyn = dragModel.getNoseToTailDyn();
        if (noseToTailDyn != null) {
            noseToTailDyn = BusinessDataServiceHelper.loadSingle((Object)noseToTailDyn.getPkValue(), (String)"pmpd_nosetotail");
            NoseToTailUtil.sortEntity((DynamicObjectCollection)noseToTailDyn.getDynamicObjectCollection("entryentity"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noseToTailDyn});
        }
    }
}

