/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.gantt;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.service.GanttSummaryDataService;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttReturnUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.pmc.pmpd.common.util.WorkBenchUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ResourceSummaryDataServiceImpl
implements GanttSummaryDataService {
    public Map<String, Object> assemSummaryData(GanttBuildContext context) {
        Map groupData = GanttReturnUtils.getSummaryNullResult();
        IFormView view = SessionManager.getCurrent().getView(context.getPageId());
        boolean hasPermiss = WorkBenchUtil.checkPermission((IFormView)view, (String)"2XZ3ENAGHMK=");
        view.setVisible(Boolean.TRUE, new String[]{"summaryshow"});
        if (!hasPermiss) {
            context.getmGanttViewSchemModel().setSummaryShow(Boolean.FALSE);
            view.setVisible(Boolean.FALSE, new String[]{"summaryshow"});
            return groupData;
        }
        HashMap fieldMap = new HashMap(1);
        HashMap<String, String> textMap = new HashMap<String, String>(1);
        String langTag = Lang.get().getLocale().toString();
        textMap.put(langTag, ResManager.loadKDString((String)"\u751f\u4ea7\u529b\u5e73\u8861\u663e\u793a", (String)"ResourceSummaryDataServiceImpl_0", (String)"mmc-pmpd-business", (Object[])new Object[0]));
        fieldMap.put("caption", textMap);
        view.updateControlMetadata("summaryshow", fieldMap);
        Long start = context.getmGanttViewSchemModel().getStart();
        Long end = context.getmGanttViewSchemModel().getEnd();
        Map<Date, BigDecimal> dayHourMap = this.getWorkHourMap(context);
        HashMap productHourMap = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmtm", (String)"IndustryProdivityService", (String)"getIndustryProdivityAmount", (Object[])new Object[]{start, end});
        if (productHourMap == null) {
            productHourMap = new HashMap(16);
        }
        String cellUnitType = context.getPreModel().getCellUnitType();
        boolean ismMonth = StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"month");
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTimeInMillis(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTimeInMillis(end);
        this.dealTime(cellUnitType, startCalendar, endCalendar);
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.setTimeInMillis(startCalendar.getTimeInMillis());
        ArrayList<ArrayList> dataList = new ArrayList<ArrayList>(3);
        ArrayList workHourList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList productList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList balanceList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList rateList = Lists.newArrayListWithExpectedSize((int)16);
        int divisor = 1;
        if (StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"week")) {
            divisor = 604800000;
        } else if (StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"day")) {
            divisor = 86400000;
        } else if (StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"hour")) {
            divisor = 3600000;
        }
        while (endCalendar.after(tempCalendar)) {
            Date endDate;
            Date startDate;
            if (ismMonth) {
                startDate = tempCalendar.getTime();
                tempCalendar.set(5, 1);
                tempCalendar.add(2, 1);
                endDate = tempCalendar.getTime();
            } else {
                startDate = tempCalendar.getTime();
                tempCalendar.set(7, 1);
                tempCalendar.add(3, 1);
                endDate = tempCalendar.getTime();
            }
            long interval = endDate.getTime() - startDate.getTime();
            if (tempCalendar.after(endCalendar)) {
                interval = endCalendar.getTimeInMillis() - startDate.getTime();
            }
            int rate = 1;
            if (!StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"month")) {
                rate = (int)interval / divisor;
            }
            rateList.add(rate);
            BigDecimal workHour = BigDecimal.ZERO;
            BigDecimal productHour = BigDecimal.ZERO;
            while (endDate.after(startDate)) {
                BigDecimal hour = dayHourMap.getOrDefault(startDate, BigDecimal.ZERO);
                workHour = workHour.add(hour);
                BigDecimal hour1 = productHourMap.getOrDefault(startDate, BigDecimal.ZERO);
                productHour = productHour.add(hour1);
                startDate = DateUtils.addDays((Date)startDate, (int)1);
            }
            workHour = workHour.setScale(0, 4);
            productHour = productHour.setScale(0, 4);
            workHourList.add(workHour);
            productList.add(productHour);
            balanceList.add(productHour.subtract(workHour));
        }
        dataList.add(workHourList);
        dataList.add(productList);
        dataList.add(balanceList);
        HashMap<String, ArrayList> bodyMap = new HashMap<String, ArrayList>(2);
        bodyMap.put("data", dataList);
        bodyMap.put("rate", rateList);
        groupData.put("body", bodyMap);
        return groupData;
    }

    private Map<Date, BigDecimal> getWorkHourMap(GanttBuildContext context) {
        Map resourceDynMap;
        QFilter qFilter = (QFilter)GanttCacheUtils.getCacheBigObject((String)context.getPageId(), (String)context.getEntityId());
        HashMap<Date, BigDecimal> dayHourMap = new HashMap<Date, BigDecimal>(16);
        if (qFilter != null && (resourceDynMap = BusinessDataServiceHelper.loadFromCache((String)"pmpd_resourceplan", (String)"entry_workhour, entry_workhour.summary_date , entry_workhour.summary_workhour , entry_report_workhour , entry_report_workhour.report_date , entry_report_workhour.report_workhour ", (QFilter[])qFilter.toArray())) != null && resourceDynMap.size() > 0) {
            Collection resourceDyns = resourceDynMap.values();
            Calendar instance = Calendar.getInstance();
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            Date today = instance.getTime();
            for (DynamicObject resourceDyn : resourceDyns) {
                DynamicObjectCollection rSummaryColl;
                DynamicObjectCollection summaryColl = resourceDyn.getDynamicObjectCollection("entry_workhour");
                if (!CollectionUtils.isEmpty((Collection)summaryColl)) {
                    List summaryList = summaryColl.stream().filter(x -> x.getDate("summary_date") != null && !x.getDate("summary_date").before(today)).collect(Collectors.toList());
                    for (DynamicObject summaryDyn : summaryList) {
                        Date date = summaryDyn.getDate("summary_date");
                        Date shortDate = this.getShortDate(date);
                        BigDecimal bigDecimal = dayHourMap.getOrDefault(shortDate, BigDecimal.ZERO);
                        bigDecimal = bigDecimal.add(summaryDyn.getBigDecimal("summary_workhour"));
                        dayHourMap.put(shortDate, bigDecimal);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)(rSummaryColl = resourceDyn.getDynamicObjectCollection("entry_report_workhour")))) continue;
                List rSummaryList = rSummaryColl.stream().filter(x -> x.getDate("report_date") != null && x.getDate("report_date").before(today)).collect(Collectors.toList());
                for (DynamicObject summaryDyn : rSummaryList) {
                    Date date = summaryDyn.getDate("report_date");
                    Date shortDate = this.getShortDate(date);
                    BigDecimal bigDecimal = dayHourMap.getOrDefault(shortDate, BigDecimal.ZERO);
                    bigDecimal = bigDecimal.add(summaryDyn.getBigDecimal("report_workhour"));
                    dayHourMap.put(shortDate, bigDecimal);
                }
            }
        }
        return dayHourMap;
    }

    private Date getShortDate(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return instance.getTime();
    }

    private void dealTime(String cellUnitType, Calendar startCalendar, Calendar endCalendar) {
        if (StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"month")) {
            startCalendar.set(5, 1);
            startCalendar.set(11, 0);
            startCalendar.set(12, 0);
            startCalendar.set(13, 0);
            startCalendar.set(14, 0);
            endCalendar.set(5, 1);
            endCalendar.set(11, 0);
            endCalendar.set(12, 0);
            endCalendar.set(13, 0);
            endCalendar.set(14, 0);
            endCalendar.add(2, 1);
        } else if (StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"week")) {
            startCalendar.set(7, 1);
            startCalendar.set(11, 0);
            startCalendar.set(12, 0);
            startCalendar.set(13, 0);
            startCalendar.set(14, 0);
            endCalendar.set(7, 1);
            endCalendar.set(11, 0);
            endCalendar.set(12, 0);
            endCalendar.set(13, 0);
            endCalendar.set(14, 0);
            endCalendar.add(3, 1);
        } else if (StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"day")) {
            startCalendar.set(11, 0);
            startCalendar.set(12, 0);
            startCalendar.set(13, 0);
            startCalendar.set(14, 0);
            endCalendar.set(11, 0);
            endCalendar.set(12, 0);
            endCalendar.set(13, 0);
            endCalendar.set(14, 0);
            endCalendar.add(5, 1);
        } else if (StringUtils.equals((CharSequence)cellUnitType, (CharSequence)"hour")) {
            startCalendar.set(12, 0);
            startCalendar.set(13, 0);
            startCalendar.set(14, 0);
            endCalendar.set(12, 0);
            endCalendar.set(13, 0);
            endCalendar.set(14, 0);
            endCalendar.add(10, 1);
        }
    }
}

