/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.standplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ApproachApplicationHelper {
    public static final String PMPD_APPDISTINCTCONF = "pmpd_appdistinctconf";
    public static final String PMPD_APPROACHAPPLICATION = "pmpd_approachapplication";
    private static final Set<String> HEAD_FIELDS = Sets.newHashSet((Object[])new String[]{"fcustomerid", "fapplicantid", "fcreatorid", "fapplydate", "fcreatetime"});
    private static final List<String> MODEL_FIELD = Lists.newArrayList((Object[])new String[]{"modelone", "modelmpdone", "modeltwo", "modeltrd"});

    public static DynamicObject getDistinctConf() {
        QFilter qFilter = new QFilter("id", "is not null", (Object)"");
        return BusinessDataServiceHelper.loadSingle((String)PMPD_APPDISTINCTCONF, (String)"id,entryentity.orgs,entryentity.selectfields", (QFilter[])qFilter.toArray());
    }

    public static DataSet queryDistinctData(Set<Object> repeatPks) {
        QFilter qFilter = new QFilter("entryentity.id", "in", repeatPks);
        return QueryServiceHelper.queryDataSet((String)"queryDistinctData", (String)PMPD_APPROACHAPPLICATION, (String)"id pk,billno,customer,applicant,applydate,creator,createtime,entryentity.id entryid,entryentity.seq seq,entryentity.equipment equipment,entryentity.fixmodel fixmodel,entryentity.fixlevel fixlevel,entryentity.starttime starttime,entryentity.endtime endtime,entryentity.workcenter workcenter,entryentity.duration duration,entryentity.resourceplanno resourceplanno", (QFilter[])qFilter.toArray(), (String)"entryentity.starttime");
    }

    public static Set<Object> getSameDataPks(DynamicObject conf, DynamicObject item, Set<Object> entryIds) {
        Date startTime = (Date)conf.get("startdate");
        Date endTime = (Date)conf.get("enddate");
        DynamicObjectCollection entry = conf.getDynamicObjectCollection("entryentity");
        SqlBuilder sqlBuilder = new SqlBuilder();
        Iterator it = entry.iterator();
        while (it.hasNext()) {
            DynamicObject object = (DynamicObject)it.next();
            String selectfields = object.getString("selectfields");
            String[] feilds = selectfields.split(",");
            DynamicObjectCollection orgs = object.getDynamicObjectCollection("orgs");
            List orgIds = orgs.stream().map(i -> i.get("fbasedataid_id")).collect(Collectors.toList());
            sqlBuilder.append("select b.fentryid from t_pmpd_approachapply a left join t_pmpd_approachentry b on a.fid = b.fid where ", new Object[0]);
            sqlBuilder.append("b.fstarttime >= ?", new Object[]{startTime});
            if (endTime != null) {
                sqlBuilder.append("and b.fstarttime <= ?", new Object[]{endTime});
            }
            String fix = "b.";
            for (String feild : feilds) {
                if (MODEL_FIELD.contains(feild) || "fmodelid".equals(feild)) continue;
                sqlBuilder.append(" and ", new Object[0]);
                fix = "b.";
                if (HEAD_FIELDS.contains(feild)) {
                    fix = "a.";
                }
                sqlBuilder.append(fix + feild + " = ?", new Object[]{item.get(feild)});
            }
            if (!CollectionUtils.isEmpty(orgIds)) {
                sqlBuilder.append(" and ", new Object[0]);
                sqlBuilder.appendIn("a.forgid", orgIds);
            }
            if (!it.hasNext()) continue;
            sqlBuilder.append(" union all ", new Object[0]);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)PMPD_APPROACHAPPLICATION);
        HashSet<Object> entryPks = new HashSet<Object>();
        try (DataSet ds = DB.queryDataSet((String)"getDistinctData", (DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                Object entryPk = row.get(0);
                if (entryIds.contains(entryPk)) continue;
                entryPks.add(entryPk);
            }
        }
        return entryPks;
    }

    private static List<Object> getDistinctModelPk(String[] feilds, long modelId) {
        return null;
    }
}

