/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.standplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PlanRoomHelper {
    public static final String PMPD_PLANROOMUSE = "pmpd_planroomuse";

    public static void setPlanRoomResource(DynamicObject planRoomMuse) {
        DynamicObject planroom = planRoomMuse.getDynamicObject("planroom");
        DynamicObjectCollection entryentity = planRoomMuse.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        if (planroom == null) {
            return;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)planroom.getPkValue(), (String)planroom.getDataEntityType().getName(), (String)"entryentity.resource");
        DynamicObjectCollection planRoomRes = dy.getDynamicObjectCollection("entryentity");
        Set<Long> exclusiveResource = planRoomRes.stream().filter(i -> {
            DynamicObject resource = i.getDynamicObject("resource");
            if (resource == null) {
                return false;
            }
            return StringUtils.equals((CharSequence)resource.getString("conftype"), (CharSequence)"A");
        }).map(i -> i.getLong("resource_id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(exclusiveResource)) {
            Date startTime = planRoomMuse.getDate("occstarttime");
            Date endTime = planRoomMuse.getDate("occendtime");
            Set<Long> usedResources = PlanRoomHelper.queryPlanRoomResource(planRoomMuse.getLong("id"), planroom.getPkValue(), exclusiveResource, startTime, endTime);
            exclusiveResource.removeAll(usedResources);
        }
        for (DynamicObject planRoomRe : planRoomRes) {
            DynamicObject resource = planRoomRe.getDynamicObject("resource");
            if (resource == null) continue;
            String confType = resource.getString("conftype");
            long resourceId = (Long)resource.getPkValue();
            boolean flag = StringUtils.equals((CharSequence)"B", (CharSequence)confType) || exclusiveResource.contains(resourceId);
            if (!flag) continue;
            DynamicObject entry = entryentity.addNew();
            entry.set("resource", (Object)resource);
            entry.set("resource_id", (Object)resourceId);
        }
    }

    public static Set<Long> queryPlanRoomResource(long pkValue, Object planRoomPk, Set<Long> resourcePks, Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return new HashSet<Long>(0);
        }
        QFilter filter = new QFilter("planroom", "=", planRoomPk);
        if (pkValue != 0L) {
            filter.and("id", "!=", (Object)pkValue);
        }
        filter.and("entryentity.resource", "in", resourcePks);
        filter.and("occendtime", ">=", (Object)startTime);
        filter.and("occstarttime", "<=", (Object)endTime);
        DynamicObjectCollection res = QueryServiceHelper.query((String)PMPD_PLANROOMUSE, (String)"entryentity.resource", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)res)) {
            return new HashSet<Long>(0);
        }
        return res.stream().map(i -> i.getLong(0)).collect(Collectors.toSet());
    }

    public static Map<Long, List<Long>> getPorjectPlanRoomPrinter(Set<Long> projectPks, String entityName) {
        if (CollectionUtils.isEmpty(projectPks) || StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "in", projectPks);
        qFilter.and("entryentity1.sourcebilltype", "=", (Object)"pmpd_resourceplan");
        DynamicObjectCollection projectResourePlans = QueryServiceHelper.query((String)"pmpd_project", (String)"id,entryentity1.sourcebillid", (QFilter[])qFilter.toArray());
        Map<Long, Long> projectResourePlansMap = projectResourePlans.stream().collect(Collectors.toMap(i -> i.getLong(0), i -> Long.valueOf(i.getString(1))));
        DynamicObjectCollection printerResource = PlanRoomHelper.queryPrinterResource(entityName);
        if (printerResource == null || printerResource.isEmpty()) {
            return null;
        }
        Map<Object, Long> printerMap = printerResource.stream().collect(Collectors.toMap(i -> i.get(0), i -> i.getLong(1)));
        DynamicObjectCollection reourcePlanRoomResource = PlanRoomHelper.getResourcePlanRoomPrinter(projectPks, projectResourePlansMap, printerMap.keySet());
        if (reourcePlanRoomResource == null || reourcePlanRoomResource.isEmpty()) {
            return null;
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(projectResourePlansMap.size());
        for (Long projectPk : projectPks) {
            Long resourcePlanPk = projectResourePlansMap.get(projectPk);
            List printerPks = result.computeIfAbsent(projectPk, key -> new ArrayList(2));
            for (DynamicObject dynamicObject : reourcePlanRoomResource) {
                long resPlanPk = dynamicObject.getLong("resplan");
                long proPk = dynamicObject.getLong("project");
                Object resourcePk = dynamicObject.get(2);
                Long printerPk = printerMap.get(resourcePk);
                if (printerPk == null || printerPk == 0L) continue;
                if (resPlanPk == 0L && proPk == projectPk) {
                    printerPks.add(printerPk);
                    continue;
                }
                if (resPlanPk == 0L || resourcePlanPk == null || resPlanPk != resourcePlanPk) continue;
                printerPks.add(printerPk);
            }
        }
        return result;
    }

    public static DynamicObjectCollection getResourcePlanRoomPrinter(Set<Long> projectPks, Map<Long, Long> projectResourcePalnMap, Set<Object> printerResource) {
        if (CollectionUtils.isEmpty(printerResource)) {
            return null;
        }
        List resourcePlanPks = projectResourcePalnMap.values().stream().filter(i -> i != 0L).collect(Collectors.toList());
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter qFilter1 = new QFilter("projects.fbasedataid", "in", projectPks);
        if (!resourcePlanPks.isEmpty()) {
            qFilter1.or("resplan", "in", resourcePlanPks);
        }
        qFilter.and(qFilter1);
        qFilter.and("entryentity.resource", "in", printerResource);
        return QueryServiceHelper.query((String)PMPD_PLANROOMUSE, (String)"resplan,projects.fbasedataid project,entryentity.resource", (QFilter[])qFilter.toArray());
    }

    public static DynamicObjectCollection queryPrinterResource(String entityName) {
        QFilter resourceFilter = new QFilter("resourcetype.number", "=", (Object)"PRINTER_S");
        if (StringUtils.isNotEmpty((CharSequence)entityName)) {
            resourceFilter.and("printbills.fbasedataid", "in", (Object)entityName);
        }
        return QueryServiceHelper.query((String)"mpdm_planroom_resource", (String)"id,printer", (QFilter[])resourceFilter.toArray());
    }
}

