/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.standplan;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ResourcePlanHelper {
    public static DynamicObject[] queryResourcePlan(Date statTime, Date endTime) {
        QFilter qFilter = new QFilter("estiapproachtime", ">=", (Object)statTime);
        QFilter qFilter1 = new QFilter("estiapproachtime", "<", (Object)endTime);
        QFilter qFilter3 = new QFilter("version", "=", (Object)0L);
        QFilter qFilter4 = new QFilter("pulishstatus", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"pmpd_resourceplan", (String)"id,customer,totalnum,custtotalnum,entry_repair.sectionresource", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter3, qFilter4}, (String)"estiapproachtime asc");
    }

    public static int getMaxTotalNum(Date statTime, Date endTime) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"pmpd_resourceplan");
        String estiapproachtime = entityType.getProperty("estiapproachtime").getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select max(", new Object[0]).append("a." + entityType.getProperty("totalnum").getAlias(), new Object[0]).append(" ) from ", new Object[0]).append(entityType.getAlias(), new Object[0]).append(" a left join t_pmpd_resourceplan_a b on a.fid = b.fid ", new Object[0]).append(" where a.fversionid = 0 and b.fpulishstatus = '1' ", new Object[0]);
        if (statTime != null) {
            sqlBuilder.append(" and ", new Object[0]).append("a." + estiapproachtime, new Object[0]).append(" >= ?", new Object[]{statTime});
        }
        if (endTime != null) {
            sqlBuilder.append(" and ", new Object[0]).append("a." + estiapproachtime, new Object[0]).append(" < ?", new Object[]{endTime});
        }
        int num = 0;
        try (DataSet data = DB.queryDataSet((String)ResourcePlanHelper.class.getName(), (DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (SqlBuilder)sqlBuilder);){
            for (Row row : data) {
                num = row.getInteger(0);
            }
        }
        return num;
    }

    public static Map<Object, Integer> getMaxTotalNumGroupByCustomer(Date statTime, Date endTime, List<Object> custemerIds) {
        if (CollectionUtils.isEmpty(custemerIds)) {
            return new HashMap<Object, Integer>(0);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"pmpd_resourceplan");
        String estiapproachtime = entityType.getProperty("estiapproachtime").getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        String customerField = entityType.getProperty("customer").getAlias();
        sqlBuilder.append("select max(", new Object[0]).append("a." + entityType.getProperty("custtotalnum").getAlias(), new Object[0]).append(" )", new Object[0]).append(",", new Object[0]).append(customerField, new Object[0]).append(" from ", new Object[0]).append(entityType.getAlias(), new Object[0]).append(" a left join t_pmpd_resourceplan_a b on a.fid = b.fid ", new Object[0]).append(" where ", new Object[0]).appendIn(customerField, custemerIds);
        sqlBuilder.append(" and a.fversionid = 0 and b.fpulishstatus = '1'", new Object[0]);
        if (statTime != null) {
            sqlBuilder.append(" and ", new Object[0]).append("a." + estiapproachtime, new Object[0]).append(" >= ?", new Object[]{statTime});
        }
        if (endTime != null) {
            sqlBuilder.append(" and ", new Object[0]).append("a." + estiapproachtime, new Object[0]).append(" < ?", new Object[]{endTime});
        }
        sqlBuilder.append(" group by ", new Object[0]).append("a." + customerField, new Object[0]);
        HashMap<Object, Integer> custTotalNum = new HashMap<Object, Integer>(custemerIds.size());
        try (DataSet data = DB.queryDataSet((String)ResourcePlanHelper.class.getName(), (DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (SqlBuilder)sqlBuilder);){
            for (Row row : data) {
                Object custId = row.get(1);
                Integer num = row.getInteger(0);
                custTotalNum.put(custId, num == null ? Integer.valueOf(0) : num);
            }
        }
        return custTotalNum;
    }

    public static void updateEnterTotalNumber() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(14, 0);
        Date now = calendar.getTime();
        calendar.add(2, -1);
        Date beforeTime = calendar.getTime();
        calendar.add(2, 2);
        Date afterTime = calendar.getTime();
        int maxTotalNum = ResourcePlanHelper.getMaxTotalNum(beforeTime, now);
        DynamicObject[] resourcePlans = ResourcePlanHelper.queryResourcePlan(now, afterTime);
        if (resourcePlans == null) {
            return;
        }
        List<DynamicObject> resPlans = Stream.of(resourcePlans).filter(i -> {
            DynamicObjectCollection repairs = i.getDynamicObjectCollection("entry_repair");
            if (CollectionUtils.isEmpty((Collection)repairs)) {
                return false;
            }
            boolean flag = false;
            for (DynamicObject repair : repairs) {
                DynamicObject sectionresource = repair.getDynamicObject("sectionresource");
                if (sectionresource == null) continue;
                flag = true;
                break;
            }
            return flag;
        }).collect(Collectors.toList());
        for (DynamicObject resPlan : resPlans) {
            resPlan.set("totalnum", (Object)(++maxTotalNum));
        }
        Map<Object, List<DynamicObject>> resPlasMap = resPlans.stream().filter(i -> i.getDynamicObject("customer") != null).collect(Collectors.groupingBy(i -> i.getDynamicObject("customer").get("id")));
        ArrayList<Object> customerIds = new ArrayList<Object>(resPlasMap.size());
        customerIds.addAll(resPlasMap.keySet());
        Map<Object, Integer> maxTotalNumMap = ResourcePlanHelper.getMaxTotalNumGroupByCustomer(beforeTime, now, customerIds);
        resPlasMap.forEach((customerId, plans) -> {
            int num = maxTotalNumMap.get(customerId) == null ? 0 : (Integer)maxTotalNumMap.get(customerId);
            for (DynamicObject plan : plans) {
                plan.set("custtotalnum", (Object)(++num));
            }
        });
        SaveServiceHelper.save((DynamicObject[])resPlans.toArray(new DynamicObject[0]));
    }

    public static DynamicObject queryMaterialMaintenanceType(Object pk) {
        QFilter qFilter = new QFilter("id", "=", pk);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_mrtype", (String)"modelonef7,modelmpdonef7,modeltwof7,modeltrdf7", (QFilter[])qFilter.toArray());
    }

    public static Set<Object> queryMaterialMaintenanceTypeModel(String targetModel, String sourceModel, Object modelTwoPk) {
        QFilter qFilter = new QFilter(sourceModel, "=", modelTwoPk);
        String props = targetModel + "," + sourceModel;
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"mpdm_mrtype", (String)props, (QFilter[])qFilter.toArray());
        return dynamicObjects.stream().map(i -> i.get(targetModel)).collect(Collectors.toSet());
    }
}

