/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.standplan;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.model.ResourcePlanDifData;
import kd.pmc.pmpd.common.model.ResourcePlanDifDataCollect;

public class ResourcePlanReleaseHelper {
    private static final String VERSION = "version";
    private static final String BILLNO = "billno";
    private static final String PULISHSTATUS = "pulishstatus";

    public static List generateDifResult(List<QFilter> qFilterList) {
        Set compareFields = (Set)ResourcePlanReleaseHelper.produceCompareFields();
        Map<Object, DynamicObject> adColls = ResourcePlanReleaseHelper.produceAdData(compareFields, qFilterList);
        HashSet adbillnos = adColls.entrySet().stream().collect(HashSet::new, (s1, ad) -> s1.add(((DynamicObject)ad.getValue()).getString(BILLNO)), (s1, s2) -> s2.addAll(s1));
        Map<Object, DynamicObject> exColls = ResourcePlanReleaseHelper.produceExData(compareFields, adbillnos);
        HashSet exbillnos = adColls.entrySet().stream().collect(HashSet::new, (s1, ad) -> s1.add(((DynamicObject)ad.getValue()).getString(BILLNO)), (s1, s2) -> s2.addAll(s1));
        ArrayList addObjs = adColls.entrySet().stream().collect(ArrayList::new, (s1, ad) -> {
            String billno = ((DynamicObject)ad.getValue()).getString(BILLNO);
            if (!exbillnos.contains(billno)) {
                s1.add(ad.getValue());
            }
        }, (s1, s2) -> s2.addAll(s1));
        addObjs.forEach(dy -> {
            Object id = dy.get("id");
            adColls.remove(id);
        });
        List list = ResourcePlanReleaseHelper.compareData(adColls, exColls, compareFields);
        return list;
    }

    private static List compareData(Map<Object, DynamicObject> adColls, Map<Object, DynamicObject> exColls, Set<String> compareFields) {
        ResourcePlanDifDataCollect rspColl = new ResourcePlanDifDataCollect();
        ResourcePlanDifDataCollect[] rsArr = new ResourcePlanDifDataCollect[]{rspColl};
        adColls.forEach((ado, addy) -> {
            String adbillno = addy.getString(BILLNO);
            List billnos = exColls.entrySet().stream().filter(me -> {
                String exbillno = ((DynamicObject)me.getValue()).getString(BILLNO);
                return adbillno.equals(exbillno);
            }).collect(Collectors.toList());
            if (!billnos.isEmpty()) {
                DynamicObject exdy = (DynamicObject)((Map.Entry)billnos.get(0)).getValue();
                if (Objects.nonNull(exdy)) {
                    ResourcePlanReleaseHelper.compareDif(addy, exdy, rsArr[0], compareFields);
                }
            } else {
                ResourcePlanReleaseHelper.compareDif(addy, null, rsArr[0], compareFields);
            }
        });
        List collect = rspColl.getRspCollect().entrySet().stream().filter(e -> {
            boolean match = ((Map)e.getValue()).entrySet().stream().anyMatch(m -> !((List)m.getValue()).isEmpty());
            return match;
        }).collect(Collectors.toList());
        return collect;
    }

    private static void compareDif(DynamicObject addy, DynamicObject exdy, ResourcePlanDifDataCollect rspColl, Set<String> compareFields) {
        HashMap difcollects = new HashMap();
        DataEntityPropertyCollection properties = addy.getDynamicObjectType().getProperties();
        ArrayList<ResourcePlanDifData> headdifs = new ArrayList<ResourcePlanDifData>(2);
        String dpt = addy.getDynamicObjectType().getName();
        rspColl.getRspCollect().put(addy.getLong("id"), difcollects);
        if (Objects.isNull(exdy)) {
            headdifs.add(new ResourcePlanDifData("add", dpt, ""));
        } else {
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty p = (IDataEntityProperty)properties.get(i);
                String fieldName = p.getName();
                if (!compareFields.contains(fieldName) || StringUtils.isBlank((Object)p.getDisplayName()) || StringUtils.equals((CharSequence)fieldName, (CharSequence)PULISHSTATUS)) continue;
                boolean dpisnull = StringUtils.isBlank((Object)p.getDisplayName());
                String dspname = p.getDisplayName().getLocaleValue();
                if (addy.get(fieldName) instanceof DynamicObjectCollection && !(addy.get(fieldName) instanceof MulBasedataDynamicObjectCollection)) {
                    DynamicObjectCollection ades = addy.getDynamicObjectCollection(fieldName);
                    DynamicObjectCollection exes = exdy.getDynamicObjectCollection(fieldName);
                    if (null == ades || ades.isEmpty()) continue;
                    ades.forEach(ade -> {
                        int seq = Objects.isNull(ade.get("seq")) ? 0 : ade.getInt("seq");
                        ArrayList<ResourcePlanDifData> entrydifs = new ArrayList<ResourcePlanDifData>(2);
                        String parenttype = ades.getDynamicObjectType().getName() + "~" + ade.getPkValue();
                        difcollects.put(parenttype, entrydifs);
                        List ls = exes.stream().filter(ex -> ex.getInt("seq") == seq).collect(Collectors.toList());
                        if (ls.isEmpty()) {
                            entrydifs.add(new ResourcePlanDifData("addentry", ades.getDynamicObjectType().getName(), "" + seq));
                        } else {
                            DynamicObject exe = (DynamicObject)ls.get(0);
                            DataEntityPropertyCollection adeprops = ades.getDynamicObjectType().getProperties();
                            for (int j = 0; j < adeprops.size(); ++j) {
                                IDataEntityProperty adep = (IDataEntityProperty)adeprops.get(j);
                                String adefieldName = adep.getName();
                                if (adefieldName.equals("id") || adep.getDisplayName() == null) continue;
                                String adedspname = adep.getDisplayName().getLocaleValue();
                                if (StringUtils.equals((CharSequence)adefieldName, (CharSequence)"workscopedetail")) {
                                    Set exee;
                                    MulBasedataDynamicObjectCollection adecoll = (MulBasedataDynamicObjectCollection)ade.get(adefieldName);
                                    MulBasedataDynamicObjectCollection execoll = (MulBasedataDynamicObjectCollection)exe.get(adefieldName);
                                    Set adee = adecoll.stream().map(o -> o.get("Fbasedataid")).collect(Collectors.toSet());
                                    if (Objects.equals(adee, exee = execoll.stream().map(o -> o.get("Fbasedataid")).collect(Collectors.toSet()))) continue;
                                    entrydifs.add(new ResourcePlanDifData(adefieldName, parenttype, "change", adedspname, ade.get(adefieldName), exe.get(adefieldName), "" + seq));
                                    continue;
                                }
                                if (Objects.equals(ade.get(adefieldName), exe.get(adefieldName))) continue;
                                entrydifs.add(new ResourcePlanDifData(adefieldName, parenttype, "change", adedspname, ade.get(adefieldName), exe.get(adefieldName), "" + seq));
                            }
                        }
                    });
                    continue;
                }
                if (addy.get(fieldName) instanceof MulBasedataDynamicObjectCollection) {
                    Set exee;
                    MulBasedataDynamicObjectCollection adecoll = (MulBasedataDynamicObjectCollection)addy.get(fieldName);
                    MulBasedataDynamicObjectCollection execoll = (MulBasedataDynamicObjectCollection)exdy.get(fieldName);
                    Set adee = adecoll.stream().map(o -> o.get("Fbasedataid")).collect(Collectors.toSet());
                    if (Objects.equals(adee, exee = execoll.stream().map(o -> o.get("Fbasedataid")).collect(Collectors.toSet()))) continue;
                    headdifs.add(new ResourcePlanDifData(fieldName, dpt, "change", dspname, addy.get(fieldName), exdy.get(fieldName), ""));
                    continue;
                }
                if (Objects.equals(addy.get(fieldName), exdy.get(fieldName))) continue;
                if (addy.get(fieldName) instanceof BigDecimal && exdy.get(fieldName) instanceof BigDecimal) {
                    if (addy.getBigDecimal(fieldName).compareTo(exdy.getBigDecimal(fieldName)) == 0) continue;
                    headdifs.add(new ResourcePlanDifData(fieldName, dpt, "change", dspname, addy.get(fieldName), exdy.get(fieldName), ""));
                    continue;
                }
                headdifs.add(new ResourcePlanDifData(fieldName, dpt, "change", dspname, addy.get(fieldName), exdy.get(fieldName), ""));
            }
        }
        if (!headdifs.isEmpty()) {
            difcollects.put(dpt, headdifs);
        }
    }

    private static Map<Object, DynamicObject> produceExData(Set<String> compareFields, Set<String> billnos) {
        QFilter curFilter = new QFilter(VERSION, "=", (Object)0L);
        QFilter stFilter = new QFilter(PULISHSTATUS, "=", (Object)Character.valueOf('1'));
        QFilter noFilter = new QFilter(BILLNO, "in", billnos);
        Map pmpd_resourceplan = BusinessDataServiceHelper.loadFromCache((String)"pmpd_resourceplan", (String)Joiner.on((String)",").join(compareFields), (QFilter[])new QFilter[]{curFilter, stFilter, noFilter});
        return pmpd_resourceplan;
    }

    private static Map<Object, DynamicObject> produceAdData(Set compareFields, List<QFilter> qFilterList) {
        QFilter curFilter = new QFilter(VERSION, "=", (Object)0L);
        QFilter stFilter = new QFilter(PULISHSTATUS, "=", (Object)Character.valueOf('0'));
        qFilterList.add(curFilter);
        qFilterList.add(stFilter);
        Map pmpd_resourceplan = BusinessDataServiceHelper.loadFromCache((String)"pmpd_resourceplan", (String)Joiner.on((String)",").join((Iterable)compareFields), (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        return pmpd_resourceplan;
    }

    private static Collection<String> produceCompareFields() {
        Map rsList = FormMetadataCache.getListMeta((String)"pmpd_resourcerelease");
        Map billList = (Map)SerializationUtils.fromJsonString((String)rsList.get("BillList").toString(), Map.class);
        ArrayList ls = (ArrayList)billList.get("Items");
        ArrayList lgcollect = ls.stream().collect(ArrayList::new, (l1, m) -> {
            if (m.get("_Type_").equals("ListGridView")) {
                ArrayList lgs = (ArrayList)m.get("Items");
                l1.addAll(lgs);
            }
        }, (l1, l2) -> l1.addAll(l2));
        LinkedHashSet fcollect = lgcollect.stream().collect(LinkedHashSet::new, (l1, m) -> {
            String listfieldkey;
            if (!m.get("_Type_").equals("DynamicTextListColumn") && !(listfieldkey = m.get("ListFieldKey").toString()).equals("fseq")) {
                l1.add(listfieldkey);
            }
        }, (l1, l2) -> l2.addAll(l1));
        QFilter nofilter = new QFilter("number", "=", (Object)"FieldSetting_0000001");
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"pmpd_releasefieldsetting", (String)"id", (QFilter[])new QFilter[]{nofilter});
        DynamicObject setObj = BusinessDataServiceHelper.loadSingle((Object)dyo.get("id"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmpd_releasefieldsetting"));
        DynamicObjectCollection entrys = setObj.getDynamicObjectCollection("entryentity");
        Set fields = entrys.stream().map(e -> e.getString("field")).collect(Collectors.toSet());
        ArrayList lists = (ArrayList)ResourcePlanReleaseHelper.loadMetaData();
        for (List list : lists) {
            ArrayList templs = (ArrayList)list;
            if (fields.contains(templs.get(0))) continue;
            DynamicObject dynamicObject = entrys.addNew();
            dynamicObject.set("field", templs.get(0));
            dynamicObject.set("fieldname", templs.get(1));
            dynamicObject.set("entity", templs.get(2));
            dynamicObject.set("entityname", templs.get(3));
            dynamicObject.set("isrelease", (Object)false);
        }
        SaveServiceHelper.update((DynamicObject)setObj);
        if (Objects.nonNull(setObj)) {
            HashSet newcoll = fcollect.stream().collect(HashSet::new, (l1, s) -> {
                if (s.contains("\\.")) {
                    l1.add(s.split("\\.")[0]);
                } else {
                    l1.add(s);
                }
            }, (l1, l2) -> l2.addAll(l1));
            HashSet addSet = new HashSet();
            entrys.forEach(e -> {
                if (e.getBoolean("isrelease")) {
                    String field = e.getString("field");
                    if (!newcoll.contains(field)) {
                        addSet.add(field);
                    }
                } else {
                    String field = e.getString("field");
                    fcollect.removeIf(s -> s.contains(field) && !s.equals(BILLNO));
                }
            });
            if (!addSet.isEmpty()) {
                fcollect.addAll(addSet);
            }
        }
        return fcollect;
    }

    private static List loadMetaData() {
        ArrayList ls = Lists.newArrayList();
        MainEntityType mdt = MetadataServiceHelper.getDataEntityType((String)"pmpd_resourceplan");
        if (mdt instanceof BillEntityType) {
            BillEntityType bet = (BillEntityType)mdt;
            ArrayList result = bet.getProperties().stream().collect(ArrayList::new, (l1, p) -> {
                if (ResourcePlanReleaseHelper.isMatch(p)) {
                    ArrayList<String> tempLs = new ArrayList<String>(4);
                    tempLs.add(0, p.getName());
                    tempLs.add(1, p.getDisplayName().getLocaleValue());
                    tempLs.add(2, bet.getName());
                    tempLs.add(3, bet.getDisplayName().getLocaleValue());
                    l1.add(tempLs);
                }
            }, (l1, l2) -> l2.add(l1));
            ls.addAll(result);
            ArrayList eresult = bet.getProperties().stream().collect(ArrayList::new, (l1, p) -> {
                if (ResourcePlanReleaseHelper.isMatchEntry(p)) {
                    ArrayList<String> tempLs = new ArrayList<String>(4);
                    tempLs.add(0, p.getName());
                    tempLs.add(1, p.getDisplayName().getLocaleValue());
                    tempLs.add(2, bet.getName());
                    tempLs.add(3, bet.getDisplayName().getLocaleValue());
                    l1.add(tempLs);
                }
            }, (l1, l2) -> l2.add(l1));
            ls.addAll(eresult);
        }
        return ls;
    }

    private static boolean isMatch(IDataEntityProperty p) {
        boolean dbField = !StringUtils.isBlank((CharSequence)p.getAlias());
        boolean isBaseID = !p.getName().contains("_id");
        boolean isID = !StringUtils.equals((CharSequence)p.getName(), (CharSequence)"id");
        boolean isst = !StringUtils.equals((CharSequence)p.getName(), (CharSequence)PULISHSTATUS);
        boolean isshowdata = !StringUtils.equals((CharSequence)p.getName(), (CharSequence)"isshowex");
        boolean isenty = !(p instanceof EntryProp);
        boolean isdif = !p.getName().contains("_dif");
        boolean isentity = !StringUtils.equals((CharSequence)p.getName(), (CharSequence)"changeentity");
        return dbField && isID & isst && isBaseID && isenty && isdif && isentity && isshowdata;
    }

    private static boolean isMatchEntry(IDataEntityProperty p) {
        boolean isenty = p instanceof EntryProp;
        boolean islk = !p.getName().contains("_lk");
        return isenty && islk;
    }
}

