/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.task.helper;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.dao.dbImpl.TaskCache;
import kd.bos.schedule.zk.ZkConfig;

public class ScheduleDao {
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final Log log = LogFactory.getLog(ScheduleDao.class);

    public boolean updateStatus(String taskId, String status) {
        return this.updateStatus(taskId, status, null);
    }

    public boolean updateStatus(String taskId, String status, String statusDesc) {
        boolean ret;
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("UPDATE T_SCH_TASK SET FSTATUS = ? ");
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(":FSTATUS", 12, (Object)status));
        taskMap.put("status", status);
        if ("READY".equals(status)) {
            sqlBuffer.append(",FRUNAT = ?, FINSTANCEID = ? ");
            paraList.add(new SqlParameter(":FRUNAT", 12, (Object)ZkConfig.getExecutorServerName()));
            paraList.add(new SqlParameter(":FINSTANCEID", 12, (Object)Instance.getInstanceId()));
        }
        if (status.equals("COMPLETED")) {
            sqlBuffer.append(",FPROGRESS = ? ");
            paraList.add(new SqlParameter(":FPROGRESS", 4, (Object)100));
            taskMap.put("progress", 100);
        }
        if (status.equals("BEGIN")) {
            sqlBuffer.append(",FRUNTIME = ? ");
            Timestamp runtime = new Timestamp(System.currentTimeMillis());
            paraList.add(new SqlParameter(":FRUNTIME", 93, (Object)runtime));
            taskMap.put("runTime", runtime.getTime());
        } else if ("SKIP".equals(status) || "ABORTED".equals(status)) {
            sqlBuffer.append(",FSTATUSDESC = ? ");
            paraList.add(new SqlParameter(":FSTATUSDESC", 12, (Object)statusDesc));
        }
        TaskInfo endTaskInfo = null;
        if (TaskStatusConstant.isEnd((String)status) && (endTaskInfo = this.get(taskId)).getRunTime() != 0L) {
            sqlBuffer.append(",FENDTIME = ? ");
            Object endTime = new Timestamp(System.currentTimeMillis());
            paraList.add(new SqlParameter(":FENDTIME", 91, endTime));
            taskMap.put("endTime", endTime);
        }
        sqlBuffer.append(" WHERE FID = ? ");
        paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
        switch (status) {
            case "READY": {
                sqlBuffer.append(" and FSTATUS in (?,?)");
                paraList.add(new SqlParameter(":FSTATUS", 12, (Object)"SCHEDULED"));
                paraList.add(new SqlParameter(":FSTATUS", 12, (Object)"ABORTED"));
                break;
            }
            case "BEGIN": {
                sqlBuffer.append(" and FSTATUS in (?, ?, ?)");
                paraList.add(new SqlParameter(":FSTATUS", 12, (Object)"READY"));
                paraList.add(new SqlParameter(":FSTATUS", 12, (Object)"SCHEDULED"));
                paraList.add(new SqlParameter(":FSTATUS", 12, (Object)"ABORTED"));
            }
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                ret = DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray((Object[])new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                log.error("Schedule***DbTaskDAO.updateStatus error, taskid : {}", (Object)taskId, (Object)e);
                handle.markRollback();
                throw e;
            }
        }
        if (ret) {
            this.RetryJobStatusUpdate(taskId, status);
            if (TaskStatusConstant.isEnd((String)status)) {
                TaskInfo taskInfo = endTaskInfo;
                TaskCache.clearCache((String)taskId);
            } else {
                TaskCache.putTaskMap((String)taskId, taskMap);
                TaskInfo taskInfo = this.get(taskId);
            }
        }
        return ret;
    }

    public void updateProgress(String taskId, int progress) {
        this.updateProgress(taskId, progress, null, null);
    }

    public void updateProgress(String taskId, int progress, String desc, Map<String, Object> customData) {
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put("status", "BEGIN");
        taskMap.put("progress", progress);
        taskMap.put("desc", desc);
        if (customData != null) {
            String data = SerializationUtils.toJsonString(customData);
            taskMap.put("data", data);
        }
        TaskCache.putTaskMap((String)taskId, taskMap);
        if (progress >= 100) {
            StringBuilder sqlBuffer = new StringBuilder();
            sqlBuffer.append("UPDATE T_SCH_TASK SET FSTATUS = ? ");
            ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
            paraList.add(new SqlParameter(":FSTATUS", 12, (Object)"BEGIN"));
            sqlBuffer.append(",FPROGRESS = ? ");
            paraList.add(new SqlParameter(":FPROGRESS", 4, (Object)progress));
            sqlBuffer.append(" WHERE FID = ? ");
            paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
            try (TXHandle handle = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray((Object[])new SqlParameter[paraList.size()]));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    handle.markRollback();
                }
            }
        }
    }

    public TaskInfo get(String taskId) {
        TaskInfo cacheTaskInfo = TaskCache.getTaskInfo((String)taskId);
        if (cacheTaskInfo != null) {
            return cacheTaskInfo;
        }
        String strSQL = "SELECT t1.FJOBID,t1.FENDTIME,t1.FRUNTIME,t1.FDISPATCHTIME,t1.FJOBTYPE,t1.FSTATUSDESC, t1.FDATA,t1.FSTATUS,t1.FPROGRESS,t1.FRUNAT,t1.FID,t1.FSCHEDULEID,t2.FERRORREASON,t1.FINSTANCEID,t1.FTRACEID,t1.FAPPID,t1.FGROUPID FROM T_SCH_TASK t1 LEFT JOIN T_SCH_ERRORJOB t2 on t1.FID=t2.FTASKID  WHERE t1.FID= ? ";
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)taskId)};
        return (TaskInfo)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            TaskInfo taskInfo = new TaskInfo();
            if (rs.next()) {
                taskInfo.setId(rs.getString("FID"));
                taskInfo.setData(rs.getString("FDATA"));
                if (rs.getTimestamp("FDISPATCHTIME") != null) {
                    taskInfo.setDispachTime(rs.getTimestamp("FDISPATCHTIME").getTime());
                }
                if (rs.getTimestamp("FENDTIME") != null) {
                    taskInfo.setEndTime(rs.getTimestamp("FENDTIME").getTime());
                }
                if (rs.getTimestamp("FRUNTIME") != null) {
                    taskInfo.setRunTime(rs.getTimestamp("FRUNTIME").getTime());
                }
                if (rs.getString("FJOBID") != null) {
                    taskInfo.setJobId(rs.getString("FJOBID"));
                }
                if (rs.getString("FSCHEDULEID") != null) {
                    taskInfo.setScheduleId(rs.getString("FSCHEDULEID"));
                }
                taskInfo.setProgress(rs.getInt("FPROGRESS"));
                taskInfo.setRunAt(rs.getString("FRUNAT"));
                taskInfo.setStatus(rs.getString("FSTATUS"));
                if (rs.getString("FERRORREASON") != null) {
                    taskInfo.setFailureReason(rs.getString("FERRORREASON"));
                }
                taskInfo.setInstanceId(rs.getString("FINSTANCEID"));
                taskInfo.setTraceId(rs.getString("FTRACEID"));
                taskInfo.setGroupId(rs.getLong("FGROUPID"));
            }
            return taskInfo;
        });
    }

    public void RetryJobStatusUpdate(String taskId, String status) {
        if (!(status.equals("FAILED") || status.equals("COMPLETED") || status.equals("BEGIN"))) {
            status = "FAILED";
        }
        HashMap groupDate = new HashMap();
        HashMap taskDate = new HashMap();
        ArrayList beforeStatus = new ArrayList();
        SqlParameter[] taskPrams = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)taskId)};
        String taskSqlTemp = "SELECT FSCHEDULEID,FNUMBER,FGROUPID,FSTATUS FROM T_SCH_TASK WHERE FID = ?";
        DB.query((DBRoute)DBRoute.basedata, (String)taskSqlTemp, (Object[])taskPrams, rs -> {
            while (rs.next()) {
                taskDate.put("number", rs.getString("FNUMBER"));
                taskDate.put("scheduleId", rs.getString("FSCHEDULEID"));
                taskDate.put("groupId", rs.getLong("FGROUPID"));
            }
            return taskDate;
        });
        String scheduleId = String.valueOf(taskDate.get("scheduleId"));
        String jobId = String.valueOf(taskDate.get("number"));
        if ((Long)taskDate.get("groupId") == 0L) {
            SqlParameter[] params = new SqlParameter[4];
            params[1] = new SqlParameter(":FLATESTEXECUTIONTIME", 93, (Object)new Timestamp(System.currentTimeMillis()));
            params[2] = new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId);
            params[3] = new SqlParameter(":FJOBID", 12, (Object)jobId);
            String taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = ?,FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
            params[0] = status.equals("COMPLETED") ? new SqlParameter(":FSTATUS", 12, (Object)"2") : (status.equals("BEGIN") ? new SqlParameter(":FSTATUS", 12, (Object)"0") : new SqlParameter(":FSTATUS", 12, (Object)"1"));
            DB.update((DBRoute)DBRoute.basedata, (String)taskSql, (Object[])params);
            return;
        }
        SqlParameter[] statusPrams = new SqlParameter[]{new SqlParameter(":FSCHEDULEID", 12, taskDate.get("scheduleId")), new SqlParameter(":FGROUPID", 12, taskDate.get("groupId"))};
        String statusSqlTemp = "SELECT FSCHEDULEID,FNUMBER,FGROUPID,FSTATUS FROM T_SCH_TASK WHERE FSCHEDULEID = ? AND FGROUPID = ?";
        DB.query((DBRoute)DBRoute.basedata, (String)statusSqlTemp, (Object[])statusPrams, rs -> {
            while (rs.next()) {
                beforeStatus.add(rs.getString("FSTATUS"));
            }
            return beforeStatus;
        });
        SqlParameter[] paramsTemp = new SqlParameter[]{new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId), new SqlParameter(":FJOBID", 12, (Object)jobId)};
        String sql = "SELECT FBATCHTIME,FGROUPID ,FRETRYTIME ,FRUNMODE,FTASKINFO FROM T_SCH_RETRYJOB  WHERE FSCHEDULEID = ? AND FJOBID = ?";
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])paramsTemp, rs -> {
            while (rs.next()) {
                groupDate.put("batchtime", rs.getInt("FBATCHTIME"));
                groupDate.put("groupid", rs.getLong("FGROUPID"));
                groupDate.put("retrytime", rs.getInt("FRETRYTIME"));
                groupDate.put("routemode", rs.getString("FRUNMODE"));
                groupDate.put("jobinfo", rs.getString("FTASKINFO"));
            }
            return groupDate;
        });
        if (groupDate.size() != 0) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FLATESTEXECUTIONTIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId), new SqlParameter(":FJOBID", 12, (Object)jobId)};
            if (status.equals("BEGIN") && (Integer)groupDate.get("retrytime") > 0) {
                String taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = '0',FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
                DB.update((DBRoute)DBRoute.basedata, (String)taskSql, (Object[])params);
            } else {
                String taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = '1' ,FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
                if (groupDate.get("routemode").equals("2") || groupDate.get("routemode").equals("1")) {
                    boolean end = true;
                    if (status.equals("COMPLETED")) {
                        if (beforeStatus.size() == ((Integer)groupDate.get("batchtime")).intValue()) {
                            for (int j = 0; j < beforeStatus.size(); ++j) {
                                if (((String)beforeStatus.get(j)).contains("COMPLETED")) continue;
                                end = false;
                                break;
                            }
                        }
                        if (end) {
                            taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = '2',FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
                        }
                    }
                } else if (status.equals("COMPLETED")) {
                    StringBuilder temp = new StringBuilder();
                    int retryTime = ((JobInfo)JSON.parseObject((String)String.valueOf(groupDate.get("jobinfo")), JobInfo.class)).getRetryTime();
                    taskSql = temp.append("UPDATE T_SCH_RETRYJOB SET FSTATUS = '2',FLATESTEXECUTIONTIME = ?").append(", FRETRYTIME = ").append(retryTime).append("  WHERE FSCHEDULEID = ? AND FJOBID = ?").toString();
                }
                DB.update((DBRoute)DBRoute.basedata, (String)taskSql, (Object[])params);
            }
        }
    }

    public void updateRuntime(String taskId, long runTime) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("UPDATE T_SCH_TASK SET FRUNTIME = ? ");
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(":FRUNTIME", 93, (Object)new Timestamp(runTime)));
        sqlBuffer.append(" WHERE FID = ? ");
        paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray((Object[])new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }
}

