/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmps.business.task.helper;

import java.util.HashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmps.business.task.helper.ScheduleDao;
import kd.pmc.pmps.business.task.model.TaskRunTimeInfo;

public class SimilarTaskHelper {
    private static final Log log = LogFactory.getLog(SimilarTaskHelper.class);

    private static ScheduleDao getScheduleDao() {
        return new ScheduleDao();
    }

    public static void hasCompeleteNoResult(TaskRunTimeInfo rInfo, String errorMsg) {
        String taskid = rInfo.getTaskid();
        ScheduleDao taskDao = SimilarTaskHelper.getScheduleDao();
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("msg", errorMsg);
        taskDao.updateProgress(taskid, 100, errorMsg, customData);
        taskDao.updateStatus(taskid, "COMPLETED");
        DB.execute((DBRoute)DBRoute.of((String)"pmc"), (String)"update t_pmpd_calcsplogentry set fcalresultid = '',fcalresult = ? where fid = ? and ftaskid = ?", (Object[])new Object[]{errorMsg, rInfo.getCallogid(), taskid});
        DB.execute((DBRoute)DBRoute.of((String)"pmc"), (String)"update t_pmpd_calcsmlplog set fcalstatus = 'B' where fid = ? ", (Object[])new Object[]{rInfo.getCallogid()});
        DynamicObject detailObject = rInfo.getDetailObject();
        DeleteServiceHelper.delete((IDataEntityType)detailObject.getDataEntityType(), (Object[])new Object[]{detailObject.getPkValue()});
    }

    public static void hasComplete(TaskRunTimeInfo rInfo) {
        String taskId = rInfo.getTaskid();
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"SimilarTaskHelper_0", (String)"mmc-pmpd-business", (Object[])new Object[0]);
        ScheduleDao taskDao = SimilarTaskHelper.getScheduleDao();
        taskDao.updateProgress(taskId, 100, msg, null);
        taskDao.updateStatus(taskId, "COMPLETED");
        DynamicObject detailObject = rInfo.getDetailObject();
        detailObject.set("calendtime", (Object)System.currentTimeMillis());
        DB.execute((DBRoute)DBRoute.of((String)"pmc"), (String)"update t_pmpd_calcsmlplog set fcalstatus = 'B' where fid = ? ", (Object[])new Object[]{rInfo.getCallogid()});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detailObject});
        OperationServiceHelper.executeOperate((String)"submit", (String)"pmpd_smlarprojrecs", (DynamicObject[])new DynamicObject[]{detailObject}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"audit", (String)"pmpd_smlarprojrecs", (DynamicObject[])new DynamicObject[]{detailObject}, (OperateOption)OperateOption.create());
    }

    public static void hasRunning(TaskRunTimeInfo rInfo, String msg) {
        String taskId = rInfo.getTaskid();
        ScheduleDao taskDao = SimilarTaskHelper.getScheduleDao();
        taskDao.updateProgress(taskId, 0, msg, null);
        taskDao.updateRuntime(taskId, System.currentTimeMillis());
    }

    public static void hasBeginning(TaskRunTimeInfo rInfo) {
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u7b97\u5f00\u59cb\u3002", (String)"SimilarTaskHelper_1", (String)"mmc-pmpd-business", (Object[])new Object[0]);
        String taskId = rInfo.getTaskid();
        ScheduleDao taskDao = SimilarTaskHelper.getScheduleDao();
        taskDao.updateStatus(taskId, "BEGIN");
        taskDao.updateProgress(taskId, 0, msg, null);
        DynamicObject detailObject = rInfo.getDetailObject();
        detailObject.set("calbegintime", (Object)System.currentTimeMillis());
    }
}

