/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmpd.report.resourceplan;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MtcQtyQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        HashMap<String, Long> timemap = new HashMap<String, Long>(2);
        List<DynamicObject> colls = this.getMatchRsplan(queryParam, timemap);
        return this.buildResultSet(timemap, queryParam, colls);
    }

    private DataSet buildResultSet(Map<String, Long> timemap, ReportQueryParam queryParam, List<DynamicObject> colls) {
        RowMeta rowMeta = this.createRowMeta(queryParam);
        List<String> fieldNames = Arrays.asList(rowMeta.getFieldNames());
        Map<String, BigDecimal> ratemap = this.getMtcQtySetData();
        DataSetBuilder builder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        for (long i = timemap.get("estiapproachtime").longValue(); i <= timemap.get("estideparttime"); i += 86400000L) {
            Date stdate = new Date(i);
            Date etdate = new Date(i + 86399999L);
            ArrayList values = Lists.newArrayList((Object[])new Object[]{stdate});
            values.addAll(Collections.nCopies(fieldNames.size() - 2, 0));
            List collect = colls.stream().filter(co -> this.hasOverlap(stdate, etdate, co.getDate("estiapproachtime"), co.getDate("estideparttime"))).collect(Collectors.toList());
            values.set(1, collect.size());
            Map<String, List<DynamicObject>> groupmap = collect.stream().collect(Collectors.groupingBy(co -> co.getString("bodytypenumber")));
            BigDecimal balance = BigDecimal.ZERO;
            for (Map.Entry<String, List<DynamicObject>> gme : groupmap.entrySet()) {
                if (StringUtils.equals((CharSequence)gme.getKey(), (CharSequence)"0")) continue;
                int count = gme.getValue().size();
                BigDecimal rate = BigDecimal.ONE;
                if (ratemap.containsKey(gme.getKey())) {
                    rate = ratemap.get(gme.getKey());
                }
                balance = balance.add(new BigDecimal(count).multiply(rate));
                values.set(fieldNames.indexOf(gme.getKey()), count);
            }
            values.add(balance);
            builder.append(values.toArray());
        }
        return builder.build();
    }

    private Map<String, BigDecimal> getMtcQtySetData() {
        Map<String, BigDecimal> ratemap = new HashMap<String, BigDecimal>(2);
        DynamicObject dyobj = BusinessDataServiceHelper.loadSingle((Object)1540705715805541376L, (String)"pmpd_mtcqtysetting");
        if (Objects.nonNull(dyobj)) {
            DynamicObjectCollection entryentity = dyobj.getDynamicObjectCollection("entryentity");
            ratemap = entryentity.stream().collect(Collectors.toMap(e1 -> e1.getString("btnumber"), e1 -> e1.getBigDecimal("coefficient")));
        }
        return ratemap;
    }

    private RowMeta createRowMeta(ReportQueryParam queryParam) {
        ArrayList fields = Lists.newArrayList((Object[])new String[]{"date", "mtcqty"});
        Map<String, String> maps = this.getBodyType(queryParam);
        ArrayList collect = maps.entrySet().stream().collect(ArrayList::new, (l1, me) -> l1.add(me.getKey()), (l1, l2) -> l2.addAll(l1));
        fields.addAll(collect);
        fields.add("balanceqty");
        ArrayList types = Lists.newArrayList((Object[])new DataType[]{DataType.DateType, DataType.IntegerType});
        types.addAll(Collections.nCopies(collect.size(), DataType.IntegerType));
        types.add(DataType.BigDecimalType);
        RowMeta rowMeta = new RowMeta(fields.toArray(new String[fields.size()]), types.toArray(new DataType[types.size()]));
        return rowMeta;
    }

    private List<DynamicObject> getMatchRsplan(ReportQueryParam queryParam, Map<String, Long> timemap) {
        QFilter filter = new QFilter("pulishstatus", "=", (Object)"1");
        filter.and(new QFilter("model.bodytype.id", "is not null", null));
        filter.and(new QFilter("model.bodytype.id", ">", (Object)0L));
        filter.and(new QFilter("version", "=", (Object)0L));
        List filterItems = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            Object value = itemInfo.getValue();
            if (!Objects.nonNull(value)) continue;
            switch (itemInfo.getPropName()) {
                case "projectorg": {
                    DynamicObject values = (DynamicObject)value;
                    filter.and(new QFilter(itemInfo.getPropName(), "=", (Object)values.getLong("id")));
                    break;
                }
                case "estiapproachtime": {
                    timemap.put("estiapproachtime", ((Date)value).getTime());
                    filter.and(new QFilter("estideparttime", ">=", value));
                    break;
                }
                case "estideparttime": {
                    long time = ((Date)value).getTime() + 86399999L;
                    timemap.put("estideparttime", time);
                    filter.and(new QFilter("estiapproachtime", "<=", (Object)new Date(time)));
                }
            }
        }
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)this.getSelects(), (QFilter[])filter.toArray());
        List<DynamicObject> values = colls.stream().filter(co -> !StringUtils.equals((CharSequence)"0", (CharSequence)co.getString("bodytypeid"))).collect(Collectors.toList());
        return values;
    }

    private String getSelects() {
        ArrayList<String> ls = new ArrayList<String>(2);
        ls.add("id");
        ls.add("model.bodytype.id as bodytypeid");
        ls.add("model.bodytype.number as bodytypenumber");
        ls.add("model.bodytype.name as bodytypename");
        ls.add("estiapproachtime");
        ls.add("estideparttime");
        return Joiner.on((String)",").join(ls);
    }

    private Map<String, String> getBodyType(ReportQueryParam queryParam) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_bodytype", (String)"id,number,name", null);
        Map<String, String> map = coll.stream().collect(Collectors.toMap(co -> co.getString("number"), coo -> String.format("%s_%s", coo.getString("number"), coo.getString("name"))));
        return map;
    }

    public boolean hasOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }
}

