/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmpd.report.resourceplan;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MtcQtyReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        Map<String, String> maps = this.getBodyType(queryParam);
        reportList.getColumns().add(this.createDateCol());
        reportList.getColumns().add(this.createQtyCol());
        for (Map.Entry<String, String> mape : maps.entrySet()) {
            reportList.getColumns().add(this.addDynamicCols(mape.getKey(), mape.getValue()));
        }
        reportList.getColumns().add(this.createBalCol());
    }

    public void initialize() {
        super.initialize();
        Toolbar bar = (Toolbar)this.getControl("toolbarap");
        bar.addItemClickListener((ItemClickListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getControl("projectorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ReportList list;
        if (evt.getItemKey().equals("refresh") && (list = (ReportList)this.getControl("reportlistap")).getTotalRecords() == 0 && list.getColumns().size() == 0) {
            evt.setCancel(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        if (StringUtils.equals((CharSequence)args.getProperty().getName(), (CharSequence)"projectorg")) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)this.getOrgIds()));
        }
    }

    private Set getOrgIds() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!structureMap.isEmpty()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)structureMap.size());
            for (Map.Entry entry : structureMap.entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).get("org_id"));
            }
            HashSet<Long> orgIds = new HashSet<Long>(8);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)"pmpd_mtcqtyreport", (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                Iterator iterator = hasPermOrgResult.getHasPermOrgs().iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    if (!ids.contains(orgId)) continue;
                    orgIds.add(orgId);
                }
                if (orgIds.isEmpty()) {
                    return ids;
                }
                return orgIds;
            }
            return ids;
        }
        return new HashSet();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        List filterItems = queryParam.getFilter().getFilterItems();
        String errormsg = ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MtcQtyReportPlugin_0", (String)"mmc-pmpd-report", (Object[])new Object[0]);
        ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
        for (FilterItemInfo itemInfo : filterItems) {
            if (!StringUtils.equals((CharSequence)"estiapproachtime", (CharSequence)itemInfo.getPropName())) continue;
            if (Objects.isNull(itemInfo.getValue())) {
                filter.getView().showErrorNotification(errormsg);
                return false;
            }
            if (!StringUtils.equals((CharSequence)"estideparttime", (CharSequence)itemInfo.getPropName())) continue;
            filter.getView().showErrorNotification(errormsg);
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private ReportColumn createDateCol() {
        ReportColumn col = new ReportColumn();
        col.setFieldKey("date");
        String infomsg = ResManager.loadKDString((String)"\u65e5\u671f", (String)"MtcQtyReportPlugin_1", (String)"mmc-pmpd-report", (Object[])new Object[0]);
        col.setCaption(new LocaleString(infomsg));
        col.setFieldType("date");
        col.setHide(false);
        return col;
    }

    private ReportColumn createQtyCol() {
        ReportColumn col = new ReportColumn();
        col.setFieldKey("mtcqty");
        String infomsg = ResManager.loadKDString((String)"\u5728\u573a\u8bbe\u5907\u6570\u91cf", (String)"MtcQtyReportPlugin_2", (String)"mmc-pmpd-report", (Object[])new Object[0]);
        col.setCaption(new LocaleString(infomsg));
        col.setFieldType("integer");
        col.setHide(false);
        return col;
    }

    private ReportColumn createBalCol() {
        ReportColumn col = new ReportColumn();
        col.setFieldKey("balanceqty");
        String infomsg = ResManager.loadKDString((String)"\u5e73\u8861\u6570\u91cf", (String)"MtcQtyReportPlugin_3", (String)"mmc-pmpd-report", (Object[])new Object[0]);
        col.setCaption(new LocaleString(infomsg));
        col.setFieldType("decimal");
        col.setScale(2);
        col.setHide(false);
        col.setZeroShow(false);
        return col;
    }

    private ReportColumn addDynamicCols(String id, String marks) {
        ReportColumn namecol = new ReportColumn();
        namecol.setFieldKey(id);
        namecol.setFieldType("integer");
        namecol.setCaption(new LocaleString(marks));
        namecol.setZeroShow(false);
        return namecol;
    }

    private Map<String, String> getBodyType(ReportQueryParam queryParam) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_bodytype", (String)"id,number,name", null);
        Map<String, String> map = coll.stream().collect(Collectors.toMap(co -> co.getString("number"), coo -> String.format("%s\uff08%s\uff09", coo.getString("number"), coo.getString("name"))));
        return map;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (StringUtils.equals((CharSequence)evt.getOperateKey(), (CharSequence)"mtcqtyset")) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("pmpd_mtcqtcsetting_view");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setPkId((Object)1540705715805541376L);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

