/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmpd.report.workpackage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.common.helper.ObjectConverterWrapper;

public class TallyListQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String ALGOKEY = "TallyListQueryPlugin";

    public DataSet query(ReportQueryParam reportQueryParam, Object nodeId) {
        DataSet executeWoroPackageDataSet;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject project = filterInfo.getDynamicObject("filter_project");
        ORM orm = ORM.create();
        DataSet resultDataSet = this.queryMroOrder(orm, project);
        Object[] resultFieldNames = resultDataSet.getRowMeta().getFieldNames();
        DataSet nrcDataSet = this.queryNRC(orm);
        if (nrcDataSet != null) {
            JoinDataSet joinDataSet = resultDataSet.leftJoin(nrcDataSet).on("jobid", "sourcejobid");
            resultDataSet = joinDataSet.select((String[])resultFieldNames, new String[]{"defectdescription", "sourcejobno"}).finish();
        }
        if ((executeWoroPackageDataSet = this.queryExecuteWoroPackage(orm)) != null) {
            JoinDataSet joinDataSet = resultDataSet.leftJoin(executeWoroPackageDataSet).on("jobid", "sourcejobid");
            resultFieldNames = resultDataSet.getRowMeta().getFieldNames();
            resultDataSet = joinDataSet.select((String[])resultFieldNames, new String[]{"workpackageid", "sequencenumber"}).finish();
            ArrayList resultSelectFields = Lists.newArrayList((Object[])resultFieldNames);
            resultSelectFields.add("case when sequencenumber is null then 9223372036854775807 else workpackageid end as workpackageid");
            resultSelectFields.add("sequencenumber");
            resultDataSet = resultDataSet.select(resultSelectFields.toArray(new String[0]));
            resultDataSet = resultDataSet.orderBy(new String[]{"workpackageid", "sequencenumber"});
        }
        return resultDataSet;
    }

    private DataSet queryMroOrder(ORM orm, DynamicObject project) {
        String selectFields = this.getMroOrderSelectFields();
        QFilter[] filters = new QFilter[]{new QFilter("treeentryentity.project", "=", project.getPkValue())};
        return orm.queryDataSet(ALGOKEY, "pom_mroorder", selectFields, filters);
    }

    private DataSet queryExecuteWoroPackage(ORM orm) {
        String selectFields = "id workpackageid, entryentity.jobid sourcejobid, entryentity.sequencenumber sequencenumber";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity.jobid", "<>", (Object)0L)};
        return orm.queryDataSet(ALGOKEY, "pmpd_exec_workpack", selectFields, filters);
    }

    private DataSet queryNRC(ORM orm) {
        String selectFields = "sbillid, tbillid";
        QFilter[] filters = new QFilter[]{new QFilter("stableid", "=", (Object)this.getTableId("pom_mroorder")), new QFilter("ttableid", "=", (Object)this.getTableId("pom_mronrc"))};
        HashMap<Long, Long> nrcId2OrderId = new HashMap<Long, Long>(16);
        try (DataSet dataSet = orm.queryDataSet(ALGOKEY, "botp_billtracker", selectFields, filters);){
            if (dataSet.isEmpty()) {
                DataSet dataSet2 = null;
                return dataSet2;
            }
            for (Row row : dataSet) {
                nrcId2OrderId.put(row.getLong(0), row.getLong(1));
            }
        }
        selectFields = "id, treeentryentity.defectdesc, treeentryentity.sorderno";
        filters = new QFilter[]{new QFilter("id", "in", nrcId2OrderId.keySet())};
        dataSet = orm.queryDataSet(ALGOKEY, "pom_mronrc", selectFields, filters);
        var6_6 = null;
        try {
            if (dataSet.isEmpty()) {
                Iterator iterator = null;
                return iterator;
            }
            Algo algo = Algo.create((String)ALGOKEY);
            RowMeta rowMeta = new RowMeta(new Field[]{new Field("sourcejobid", (DataType)DataType.LongType), new Field("defectdescription", (DataType)DataType.StringType), new Field("sourcejobno", (DataType)DataType.StringType)});
            DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
            for (Row row : dataSet) {
                Long nrcId = row.getLong(0);
                dataSetBuilder.append(new Object[]{nrcId2OrderId.get(nrcId), ObjectConverterWrapper.getString((Object)row.get(1)), ObjectConverterWrapper.getString((Object)row.get(2))});
            }
            Iterator iterator = dataSetBuilder.build();
            return iterator;
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var6_6 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        var6_6.addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    private long getTableId(String entityNumber) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityNumber);
        return tableDefine == null ? 0L : tableDefine.getTableId();
    }

    private String getMroOrderSelectFields() {
        return "id jobid, billno jobno, transactiontype transactiontype, treeentryentity.workcard jobcard, treeentryentity.pageseq pagination, treeentryentity.workstage workcategory, treeentryentity.zone zone, treeentryentity.area area, treeentryentity.maintrade industry, billstatus, treeentryentity.bizstatus bizstatus, treeentryentity.planstatus planstatus, treeentryentity.taskstatus taskstatus, treeentryentity.modifystatustime updatedate";
    }
}

