/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.validator.humanresources;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.pmc.pmbd.common.util.ProjectHumanResourcePlanningUtil;

public class ProjectHumanResourcePlanningAuthorityValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject dyncObj = extend.getDataEntity();
            DynamicObject creator = dyncObj.getDynamicObject("creator");
            DynamicObjectCollection administrators = dyncObj.getDynamicObjectCollection("administrators");
            this.isAuthority(extend, creator, administrators);
        }
    }

    private void isAuthority(ExtendedDataEntity extend, DynamicObject creator, DynamicObjectCollection administrators) {
        String userId = RequestContext.get().getUserId();
        if (!ProjectHumanResourcePlanningUtil.isAuthority((String)userId, (DynamicObject)creator) && !ProjectHumanResourcePlanningUtil.isAuthority((String)userId, (DynamicObjectCollection)administrators)) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7528\u6237\u3010%1$s\u3011\u4e0d\u662f\u8d1f\u8d23\u4eba,\u4e0d\u5141\u8bb8%2$s\u3002", (String)"ProjectHumanResourcePlanningAuthorityValidator_0", (String)"mmc-pmpd-opplugin", (Object[])new Object[0]), RequestContext.get().getUserName(), this.getOperationName()));
            this.addErrorMessage(extend, errorMsg.toString());
        }
    }
}

