/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.opplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.pmc.pmpd.common.enums.ConstructionUnitEnum;

public class ApproachApplicationToResourcePlanConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] resourcePlans;
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity resourcePlan : resourcePlans = targetExtDataEntitySet.FindByEntityKey("pmpd_resourceplan")) {
            DynamicObject dataEntity = resourcePlan.getDataEntity();
            BigDecimal duration = dataEntity.getBigDecimal("repaircycle");
            int scale = dataEntity.getInt("unitlength");
            DynamicObject durationUnit = dataEntity.getDynamicObject("constructionunit");
            ConstructionUnitEnum unitEnum = ConstructionUnitEnum.forValue((String)durationUnit.getString("number"));
            BigDecimal dayValue = unitEnum == ConstructionUnitEnum.DAY ? duration : duration.multiply(unitEnum.getValue()).divide(ConstructionUnitEnum.DAY.getValue(), scale, RoundingMode.HALF_UP);
            dataEntity.set("repaircycleroundup", (Object)duration.setScale(0, 0).intValue());
            dataEntity.set("repaircycleday", (Object)dayValue);
            DynamicObject workscope = dataEntity.getDynamicObject("workscope");
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry_repair");
            if (CollectionUtils.isEmpty((Collection)entry)) continue;
            DynamicObject entryData = (DynamicObject)entry.get(0);
            Object workcenter = entryData.get("sectionresource");
            if (workcenter != null) {
                entryData.set("mianworkcenter", (Object)Boolean.TRUE);
            }
            if (workscope == null) continue;
            DynamicObjectCollection workcatedetails = workscope.getDynamicObjectCollection("workcatedetails");
            if (workcatedetails.isEmpty()) {
                return;
            }
            String symble = workscope.getString("combosymbol");
            DynamicObjectCollection wkdtls = entryData.getDynamicObjectCollection("workscopedetail");
            StringJoiner details = new StringJoiner(symble);
            for (DynamicObject workcatedetail : workcatedetails) {
                DynamicObject detail = workcatedetail.getDynamicObject("fbasedataid");
                details.add(detail.getString("name"));
                DynamicObject wkdtl = wkdtls.addNew();
                wkdtl.set("fbasedataid", (Object)detail);
                wkdtl.set("fbasedataid_id", workcatedetail.get("fbasedataid_id"));
            }
            entryData.set("workspdetails", (Object)details.toString());
        }
    }

    public static BigDecimal calculateDurationValue(Date startDateTime, Date endDateTime, int scale, ConstructionUnitEnum unit) {
        if (startDateTime == null || endDateTime == null) {
            return null;
        }
        long dValue = endDateTime.getTime() - startDateTime.getTime();
        return BigDecimal.valueOf(dValue).divide(unit.getValue(), scale, RoundingMode.HALF_UP);
    }
}

